/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeMetadata;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;

public abstract class Type
extends AnnoConstruct
implements TypeMirror,
PoolConstant {
    protected final List<TypeMetadata> metadata;
    public static final JCNoType noType = new JCNoType(){

        @Override
        public String toString() {
            return "none";
        }
    };
    public static final JCNoType recoveryType = new JCNoType(){

        @Override
        public String toString() {
            return "recovery";
        }
    };
    public static final JCNoType stuckType = new JCNoType(){

        @Override
        public String toString() {
            return "stuck";
        }
    };
    public static boolean moreInfo = false;
    public Symbol.TypeSymbol tsym;
    private static final Types.TypeMapping<Void> stripMetadata = new StructuralTypeMapping<Void>(){

        @Override
        public Type visitClassType(ClassType classType, Void void_) {
            return super.visitClassType((ClassType)4.dropMetadata(classType), void_);
        }

        @Override
        public Type visitArrayType(ArrayType arrayType, Void void_) {
            return super.visitArrayType((ArrayType)4.dropMetadata(arrayType), void_);
        }

        @Override
        public Type visitWildcardType(WildcardType wildcardType, Void void_) {
            return super.visitWildcardType((WildcardType)4.dropMetadata(wildcardType), void_);
        }

        @Override
        public Type visitType(Type type, Void void_) {
            return 4.dropMetadata(type);
        }

        private static Type dropMetadata(Type type) {
            if (type.getMetadata().isEmpty()) {
                return type;
            }
            Type type2 = type.baseType();
            if (type2.getMetadata().isEmpty()) {
                return type2;
            }
            return type2.cloneWithMetadata(List.nil());
        }
    };

    @Override
    public int poolTag() {
        throw new AssertionError((Object)"Invalid pool entry");
    }

    @Override
    public Object poolKey(Types types) {
        return new Types.UniqueType(this, types);
    }

    public boolean hasTag(TypeTag typeTag) {
        return typeTag == this.getTag();
    }

    public abstract TypeTag getTag();

    public boolean isNumeric() {
        return false;
    }

    public boolean isIntegral() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isPrimitiveOrVoid() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isNullOrReference() {
        return false;
    }

    public boolean isPartial() {
        return false;
    }

    public Object constValue() {
        return this.getMetadata(TypeMetadata.ConstantValue.class, TypeMetadata.ConstantValue::value, null);
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public Type getModelType() {
        return this;
    }

    public static List<Type> getModelTypes(List<Type> list) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : list) {
            listBuffer.append(type.getModelType());
        }
        return listBuffer.toList();
    }

    public Type getOriginalType() {
        return this;
    }

    public <R, S> R accept(Visitor<R, S> visitor, S s) {
        return visitor.visitType(this, s);
    }

    public Type(Symbol.TypeSymbol typeSymbol, List<TypeMetadata> list) {
        Assert.checkNonNull(list);
        this.tsym = typeSymbol;
        this.metadata = list;
    }

    public <Z> Type map(Types.TypeMapping<Z> typeMapping, Z z) {
        return (Type)typeMapping.visit(this, z);
    }

    public <Z> Type map(Types.TypeMapping<Z> typeMapping) {
        return (Type)typeMapping.visit(this, null);
    }

    public Type constType(Object object) {
        throw new AssertionError();
    }

    public Type baseType() {
        return this;
    }

    protected Type typeNoMetadata() {
        return this.metadata.isEmpty() ? this : this.stripMetadata();
    }

    protected Type cloneWithMetadata(List<TypeMetadata> list) {
        throw new AssertionError((Object)("Cannot add metadata to this type: " + String.valueOf((Object)this.getTag())));
    }

    public List<TypeMetadata> getMetadata() {
        return this.metadata;
    }

    public <M extends TypeMetadata> M getMetadata(Class<M> clazz) {
        return (M)((TypeMetadata)this.getMetadata(clazz, Function.identity(), null));
    }

    public <M extends TypeMetadata, Z> Z getMetadata(Class<M> clazz, Function<M, Z> function, Z z) {
        for (TypeMetadata typeMetadata : this.metadata) {
            if (typeMetadata.getClass() != clazz) continue;
            return function.apply(typeMetadata);
        }
        return z;
    }

    public Type addMetadata(TypeMetadata typeMetadata) {
        Assert.check(this.getMetadata(typeMetadata.getClass()) == null);
        return this.cloneWithMetadata(this.metadata.prepend(typeMetadata));
    }

    public Type dropMetadata(Class<? extends TypeMetadata> clazz) {
        List<TypeMetadata> list = List.nil();
        for (TypeMetadata typeMetadata : this.metadata) {
            if (typeMetadata.getClass() == clazz) continue;
            list = list.prepend(typeMetadata);
        }
        return this.cloneWithMetadata(list);
    }

    protected boolean needsStripping() {
        return false;
    }

    public Type stripMetadataIfNeeded() {
        return this.needsStripping() ? (Type)this.accept(stripMetadata, null) : this;
    }

    public Type stripMetadata() {
        return (Type)this.accept(stripMetadata, null);
    }

    public Type preannotatedType() {
        return this.addMetadata(new TypeMetadata.Annotations());
    }

    public Type annotatedType(List<Attribute.TypeCompound> list) {
        return this.addMetadata(new TypeMetadata.Annotations(list));
    }

    public boolean isAnnotated() {
        return this.getMetadata(TypeMetadata.Annotations.class) != null;
    }

    @Override
    public List<Attribute.TypeCompound> getAnnotationMirrors() {
        return this.getMetadata(TypeMetadata.Annotations.class, TypeMetadata.Annotations::annotations, List.nil());
    }

    public static List<Type> baseTypes(List<Type> list) {
        if (list.nonEmpty()) {
            Type type = ((Type)list.head).baseType();
            List<Type> list2 = Type.baseTypes(list.tail);
            if (type != list.head || list2 != list.tail) {
                return list2.prepend(type);
            }
        }
        return list;
    }

    protected void appendAnnotationsString(StringBuilder stringBuilder, boolean bl) {
        if (this.isAnnotated()) {
            if (bl) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(((List)this.getAnnotationMirrors()).toString(" "));
            stringBuilder.append(" ");
        }
    }

    protected void appendAnnotationsString(StringBuilder stringBuilder) {
        this.appendAnnotationsString(stringBuilder, false);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendAnnotationsString(stringBuilder);
        if (this.tsym == null || this.tsym.name == null) {
            stringBuilder.append("<none>");
        } else {
            stringBuilder.append(this.tsym.name.toString());
        }
        if (moreInfo && this.hasTag(TypeTag.TYPEVAR)) {
            stringBuilder.append(this.hashCode());
        }
        return stringBuilder.toString();
    }

    public static String toString(List<Type> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((Type)list.head).toString());
        List list2 = list.tail;
        while (list2.nonEmpty()) {
            stringBuilder.append(",").append(((Type)list2.head).toString());
            list2 = list2.tail;
        }
        return stringBuilder.toString();
    }

    public String stringValue() {
        Object object = Assert.checkNonNull(this.constValue());
        return object.toString();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    public boolean equalsIgnoreMetadata(Type type) {
        return this.typeNoMetadata().equals(type.typeNoMetadata());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String argtypes(boolean bl) {
        List<Type> list = this.getParameterTypes();
        if (!bl) {
            return list.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (list.tail.nonEmpty()) {
            stringBuilder.append(list.head);
            list = list.tail;
            stringBuilder.append(',');
        }
        if (((Type)list.head).hasTag(TypeTag.ARRAY)) {
            stringBuilder.append(((ArrayType)list.head).elemtype);
            if (((List)((Type)list.head).getAnnotationMirrors()).nonEmpty()) {
                stringBuilder.append(((Type)list.head).getAnnotationMirrors());
            }
            stringBuilder.append("...");
        } else {
            stringBuilder.append(list.head);
        }
        return stringBuilder.toString();
    }

    public List<Type> getTypeArguments() {
        return List.nil();
    }

    public Type getEnclosingType() {
        return null;
    }

    public List<Type> getParameterTypes() {
        return List.nil();
    }

    public Type getReturnType() {
        return null;
    }

    public Type getReceiverType() {
        return null;
    }

    public List<Type> getThrownTypes() {
        return List.nil();
    }

    public Type getUpperBound() {
        return null;
    }

    public Type getLowerBound() {
        return null;
    }

    public List<Type> allparams() {
        return List.nil();
    }

    public boolean isErroneous() {
        return false;
    }

    public static boolean isErroneous(List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (((Type)list2.head).isErroneous()) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean isRaw() {
        return false;
    }

    public boolean isCompound() {
        return false;
    }

    public boolean isIntersection() {
        return false;
    }

    public boolean isUnion() {
        return false;
    }

    public boolean isInterface() {
        return (this.tsym.flags() & 0x200L) != 0L;
    }

    public boolean isFinal() {
        return (this.tsym.flags() & 0x10L) != 0L;
    }

    public boolean isValueBased() {
        return this.tsym != null && (this.tsym.flags_field & 0x20000000000000L) != 0L;
    }

    public boolean contains(Type type) {
        return type.equalsIgnoreMetadata(this);
    }

    public static boolean contains(List<Type> list, Type type) {
        List<Type> list2 = list;
        while (list2.tail != null) {
            if (((Type)list2.head).contains(type)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    public boolean containsAny(List<Type> list) {
        for (Type type : list) {
            if (!this.contains(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(List<Type> list, List<Type> list2) {
        for (Type type : list) {
            if (!type.containsAny(list2)) continue;
            return true;
        }
        return false;
    }

    public static List<Type> filter(List<Type> list, Predicate<Type> predicate) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : list) {
            if (!predicate.test(type)) continue;
            listBuffer.append(type);
        }
        return listBuffer.toList();
    }

    public boolean isSuperBound() {
        return false;
    }

    public boolean isExtendsBound() {
        return false;
    }

    public boolean isUnbound() {
        return false;
    }

    public Type withTypeVar(Type type) {
        return this;
    }

    public MethodType asMethodType() {
        throw new AssertionError();
    }

    public void complete() {
    }

    public Symbol.TypeSymbol asElement() {
        return this.tsym;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.OTHER;
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
        throw new AssertionError();
    }

    public static interface Visitor<R, S> {
        public R visitClassType(ClassType var1, S var2);

        public R visitWildcardType(WildcardType var1, S var2);

        public R visitArrayType(ArrayType var1, S var2);

        public R visitMethodType(MethodType var1, S var2);

        public R visitPackageType(PackageType var1, S var2);

        public R visitModuleType(ModuleType var1, S var2);

        public R visitTypeVar(TypeVar var1, S var2);

        public R visitCapturedType(CapturedType var1, S var2);

        public R visitForAll(ForAll var1, S var2);

        public R visitUndetVar(UndetVar var1, S var2);

        public R visitErrorType(ErrorType var1, S var2);

        public R visitType(Type var1, S var2);
    }

    public static class ArrayType
    extends Type
    implements PoolConstant.LoadableConstant,
    javax.lang.model.type.ArrayType {
        public Type elemtype;

        public ArrayType(Type type, Symbol.TypeSymbol typeSymbol) {
            this(type, typeSymbol, List.nil());
        }

        public ArrayType(Type type, Symbol.TypeSymbol typeSymbol, List<TypeMetadata> list) {
            super(typeSymbol, list);
            this.elemtype = type;
        }

        public ArrayType(ArrayType arrayType) {
            this(arrayType.elemtype, arrayType.tsym, arrayType.getMetadata());
        }

        @Override
        public int poolTag() {
            return 7;
        }

        @Override
        protected ArrayType cloneWithMetadata(List<TypeMetadata> list) {
            return new ArrayType(this.elemtype, this.tsym, list){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.ARRAY;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitArrayType(this, s);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Type type = this.elemtype;
            while (type.getKind() == TypeKind.ARRAY) {
                type = ((ArrayType)type).getComponentType();
            }
            stringBuilder.append(type);
            type = this;
            do {
                type.appendAnnotationsString(stringBuilder, true);
                stringBuilder.append("[]");
            } while ((type = ((ArrayType)type).getComponentType()).getKind() == TypeKind.ARRAY);
            return stringBuilder.toString();
        }

        @Override
        public boolean equals(Object object) {
            ArrayType arrayType;
            return object instanceof ArrayType && (this == (arrayType = (ArrayType)object) || this.elemtype.equals(arrayType.elemtype));
        }

        @Override
        public int hashCode() {
            return (TypeTag.ARRAY.ordinal() << 5) + this.elemtype.hashCode();
        }

        public boolean isVarargs() {
            return false;
        }

        @Override
        public List<Type> allparams() {
            return this.elemtype.allparams();
        }

        @Override
        public boolean isErroneous() {
            return this.elemtype.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.elemtype.isParameterized();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public boolean isRaw() {
            return this.elemtype.isRaw();
        }

        public ArrayType makeVarargs() {
            return new ArrayType(this.elemtype, this.tsym, this.metadata){

                @Override
                public boolean isVarargs() {
                    return true;
                }
            };
        }

        @Override
        public boolean contains(Type type) {
            return type.equalsIgnoreMetadata(this) || this.elemtype.contains(type);
        }

        @Override
        public void complete() {
            this.elemtype.complete();
        }

        @Override
        public Type getComponentType() {
            return this.elemtype;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ARRAY;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitArray(this, p);
        }
    }

    public static class JCNoType
    extends Type
    implements NoType {
        public JCNoType() {
            super(null, List.nil());
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.NONE;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NONE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNoType(this, p);
        }

        @Override
        public boolean isCompound() {
            return false;
        }
    }

    public static class ErrorType
    extends ClassType
    implements javax.lang.model.type.ErrorType {
        private Type originalType = null;

        public ErrorType(Symbol.ClassSymbol classSymbol, Type type) {
            this(type, classSymbol);
            classSymbol.type = this;
            classSymbol.kind = Kinds.Kind.ERR;
            classSymbol.members_field = new Scope.ErrorScope(classSymbol);
        }

        public ErrorType(Type type, Symbol.TypeSymbol typeSymbol) {
            super(noType, List.nil(), null);
            this.tsym = typeSymbol;
            this.originalType = type == null ? noType : type;
        }

        public ErrorType(Type type, Symbol.TypeSymbol typeSymbol, List<TypeMetadata> list) {
            super(noType, List.nil(), null, list);
            this.tsym = typeSymbol;
            this.originalType = type == null ? noType : type;
        }

        @Override
        protected ErrorType cloneWithMetadata(List<TypeMetadata> list) {
            return new ErrorType(this.originalType, this.tsym, list){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.ERROR;
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        public ErrorType(Name name, Symbol.TypeSymbol typeSymbol, Type type) {
            this(new Symbol.ClassSymbol(0x40000009L, name, null, typeSymbol), type);
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitErrorType(this, s);
        }

        @Override
        public Type constType(Object object) {
            return this;
        }

        @Override
        public Type getEnclosingType() {
            return noType;
        }

        @Override
        public Type getReturnType() {
            return this;
        }

        public Type asSub(Symbol symbol) {
            return this;
        }

        public boolean isGenType(Type type) {
            return true;
        }

        @Override
        public boolean isErroneous() {
            return true;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public boolean isInterface() {
            return false;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ERROR;
        }

        @Override
        public Type getOriginalType() {
            return this.originalType;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitError(this, p);
        }
    }

    static class BottomType
    extends Type
    implements NullType {
        public BottomType() {
            super(null, List.nil());
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.BOT;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NULL;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNull(this, p);
        }

        @Override
        public Type constType(Object object) {
            return this;
        }

        @Override
        public String stringValue() {
            return "null";
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }
    }

    public static class JCVoidType
    extends Type
    implements NoType {
        public JCVoidType() {
            super(null, List.nil());
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.VOID;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.VOID;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNoType(this, p);
        }

        @Override
        public boolean isPrimitiveOrVoid() {
            return true;
        }
    }

    public static class UndetVar
    extends DelegatedType {
        public ArrayDeque<Infer.IncorporationAction> incorporationActions = new ArrayDeque();
        protected Map<InferenceBound, List<Type>> bounds;
        private Type inst = null;
        public int declaredCount;
        public UndetVarListener listener = null;
        Kind kind;
        Types.TypeMapping<Void> toTypeVarMap = new StructuralTypeMapping<Void>(){

            @Override
            public Type visitUndetVar(UndetVar undetVar, Void void_) {
                return undetVar.inst != null ? undetVar.inst : undetVar.qtype;
            }
        };

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitUndetVar(this, s);
        }

        public UndetVar(TypeVar typeVar, UndetVarListener undetVarListener, Types types) {
            super(TypeTag.UNDETVAR, typeVar);
            this.kind = typeVar.isCaptured() ? Kind.CAPTURED : Kind.NORMAL;
            this.listener = undetVarListener;
            this.bounds = new EnumMap<InferenceBound, List<Type>>(InferenceBound.class);
            List<Type> list = types.getBounds(typeVar);
            this.declaredCount = list.length();
            this.bounds.put(InferenceBound.UPPER, List.nil());
            this.bounds.put(InferenceBound.LOWER, List.nil());
            this.bounds.put(InferenceBound.EQ, List.nil());
            for (Type type : list.reverse()) {
                this.addBound(InferenceBound.UPPER, type, types, true);
            }
            if (typeVar.isCaptured() && !typeVar.lower.hasTag(TypeTag.BOT)) {
                this.addBound(InferenceBound.LOWER, typeVar.lower, types, true);
            }
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendAnnotationsString(stringBuilder);
            if (this.inst == null) {
                stringBuilder.append(this.qtype);
                stringBuilder.append('?');
            } else {
                stringBuilder.append(this.inst);
            }
            return stringBuilder.toString();
        }

        public String debugString() {
            String string = "inference var = " + String.valueOf(this.qtype) + "\n";
            if (this.inst != null) {
                string = string + "inst = " + String.valueOf(this.inst) + "\n";
            }
            for (InferenceBound inferenceBound : InferenceBound.values()) {
                List<Type> list = this.bounds.get((Object)inferenceBound);
                if (list == null || list.size() <= 0) continue;
                string = string + String.valueOf((Object)inferenceBound) + " = " + String.valueOf(list) + "\n";
            }
            return string;
        }

        public void setThrow() {
            if (this.kind == Kind.CAPTURED) {
                throw new IllegalStateException();
            }
            this.kind = Kind.THROWS;
        }

        public void setNormal() {
            Assert.check(this.kind == Kind.CAPTURED);
            this.kind = Kind.NORMAL;
        }

        public UndetVar dup(Types types) {
            UndetVar undetVar = new UndetVar((TypeVar)this.qtype, this.listener, types);
            this.dupTo(undetVar, types);
            return undetVar;
        }

        public void dupTo(UndetVar undetVar, Types types) {
            undetVar.listener = null;
            undetVar.bounds.clear();
            for (InferenceBound inferenceBound : InferenceBound.values()) {
                undetVar.bounds.put(inferenceBound, List.nil());
                for (Type type : this.getBounds(inferenceBound)) {
                    undetVar.addBound(inferenceBound, type, types, true);
                }
            }
            undetVar.inst = this.inst;
            undetVar.listener = this.listener;
            undetVar.incorporationActions = new ArrayDeque();
            for (Infer.IncorporationAction incorporationAction : this.incorporationActions) {
                undetVar.incorporationActions.add(incorporationAction.dup(undetVar));
            }
            undetVar.kind = this.kind;
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        @Override
        public Type baseType() {
            return this.inst == null ? this : this.inst.baseType();
        }

        public Type getInst() {
            return this.inst;
        }

        public void setInst(Type type) {
            this.inst = type;
            if (this.listener != null) {
                this.listener.varInstantiated(this);
            }
        }

        public List<Type> getBounds(InferenceBound ... inferenceBoundArray) {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (InferenceBound inferenceBound : inferenceBoundArray) {
                listBuffer.appendList(this.bounds.get((Object)inferenceBound));
            }
            return listBuffer.toList();
        }

        public List<Type> getDeclaredBounds() {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            int n = 0;
            for (Type type : this.getBounds(InferenceBound.UPPER)) {
                if (n++ == this.declaredCount) break;
                listBuffer.append(type);
            }
            return listBuffer.toList();
        }

        public void setBounds(InferenceBound inferenceBound, List<Type> list) {
            this.bounds.put(inferenceBound, list);
        }

        public final void addBound(InferenceBound inferenceBound, Type type, Types types) {
            this.addBound(inferenceBound, type, types, false);
        }

        private void addBound(InferenceBound inferenceBound, Type type, Types types, boolean bl) {
            if (this.kind == Kind.CAPTURED && !bl) {
                if (type.hasTag(TypeTag.UNDETVAR) && !((UndetVar)type).isCaptured()) {
                    ((UndetVar)type).addBound(inferenceBound.complement(), this, types, false);
                }
            } else {
                Type type2 = type.map(this.toTypeVarMap).baseType();
                List<Type> list = this.bounds.get((Object)inferenceBound);
                if (type == this.qtype) {
                    return;
                }
                for (Type type3 : list) {
                    if (!types.isSameType(type3, type2)) continue;
                    return;
                }
                this.bounds.put(inferenceBound, list.prepend(type2));
                this.notifyBoundChange(inferenceBound, type2, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void substBounds(List<Type> list, List<Type> list2, Types types) {
            ListBuffer listBuffer = new ListBuffer();
            UndetVarListener undetVarListener = this.listener;
            try {
                this.listener = (undetVar, inferenceBound, type, bl) -> {
                    Assert.check(undetVar == this);
                    listBuffer.add(new Pair<InferenceBound, Type>(inferenceBound, type));
                };
                for (Map.Entry<InferenceBound, List<Type>> object : this.bounds.entrySet()) {
                    InferenceBound inferenceBound2 = object.getKey();
                    List<Type> list3 = object.getValue();
                    ListBuffer<Type> listBuffer2 = new ListBuffer<Type>();
                    ListBuffer<Type> listBuffer3 = new ListBuffer<Type>();
                    for (Type type2 : list3) {
                        if (!type2.containsAny(list)) {
                            listBuffer2.append(type2);
                            continue;
                        }
                        listBuffer3.append(type2);
                    }
                    this.bounds.put(inferenceBound2, listBuffer2.toList());
                    for (Type type2 : listBuffer3) {
                        this.addBound(inferenceBound2, types.subst(type2, list, list2), types, true);
                    }
                }
                this.listener = undetVarListener;
            }
            catch (Throwable throwable) {
                this.listener = undetVarListener;
                for (Pair pair : listBuffer) {
                    this.notifyBoundChange((InferenceBound)((Object)pair.fst), (Type)pair.snd, true);
                }
                throw throwable;
            }
            for (Pair pair : listBuffer) {
                this.notifyBoundChange((InferenceBound)((Object)pair.fst), (Type)pair.snd, true);
            }
        }

        private void notifyBoundChange(InferenceBound inferenceBound, Type type, boolean bl) {
            if (this.listener != null) {
                this.listener.varBoundChanged(this, inferenceBound, type, bl);
            }
        }

        public final boolean isCaptured() {
            return this.kind == Kind.CAPTURED;
        }

        public final boolean isThrows() {
            return this.kind == Kind.THROWS;
        }

        public static interface UndetVarListener {
            public void varBoundChanged(UndetVar var1, InferenceBound var2, Type var3, boolean var4);

            default public void varInstantiated(UndetVar undetVar) {
                Assert.error();
            }
        }

        static enum Kind {
            NORMAL,
            CAPTURED,
            THROWS;

        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum InferenceBound {
            LOWER{

                @Override
                public InferenceBound complement() {
                    return UPPER;
                }
            }
            ,
            EQ{

                @Override
                public InferenceBound complement() {
                    return EQ;
                }
            }
            ,
            UPPER{

                @Override
                public InferenceBound complement() {
                    return LOWER;
                }
            };


            public abstract InferenceBound complement();

            public boolean lessThan(InferenceBound inferenceBound) {
                if (inferenceBound == this) {
                    return false;
                }
                switch (inferenceBound.ordinal()) {
                    case 2: {
                        return true;
                    }
                    case 0: {
                        return false;
                    }
                    case 1: {
                        return this != UPPER;
                    }
                }
                Assert.error("Cannot get here!");
                return false;
            }
        }
    }

    public static class ForAll
    extends DelegatedType
    implements ExecutableType {
        public List<Type> tvars;

        public ForAll(List<Type> list, Type type) {
            super(TypeTag.FORALL, (MethodType)type);
            this.tvars = list;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitForAll(this, s);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendAnnotationsString(stringBuilder);
            stringBuilder.append('<');
            stringBuilder.append(this.tvars);
            stringBuilder.append('>');
            stringBuilder.append(this.qtype);
            return stringBuilder.toString();
        }

        @Override
        public List<Type> getTypeArguments() {
            return this.tvars;
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }

        @Override
        public boolean contains(Type type) {
            return this.qtype.contains(type);
        }

        @Override
        public MethodType asMethodType() {
            return (MethodType)this.qtype;
        }

        @Override
        public void complete() {
            List<Type> list = this.tvars;
            while (list.nonEmpty()) {
                ((TypeVar)list.head).getUpperBound().complete();
                list = list.tail;
            }
            this.qtype.complete();
        }

        public List<TypeVar> getTypeVariables() {
            return List.convert(TypeVar.class, this.getTypeArguments());
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitExecutable(this, p);
        }
    }

    public static abstract class DelegatedType
    extends Type {
        public Type qtype;
        public TypeTag tag;

        public DelegatedType(TypeTag typeTag, Type type) {
            this(typeTag, type, List.nil());
        }

        public DelegatedType(TypeTag typeTag, Type type, List<TypeMetadata> list) {
            super(type.tsym, list);
            this.tag = typeTag;
            this.qtype = type;
        }

        @Override
        public TypeTag getTag() {
            return this.tag;
        }

        @Override
        public String toString() {
            return this.qtype.toString();
        }

        @Override
        public List<Type> getTypeArguments() {
            return this.qtype.getTypeArguments();
        }

        @Override
        public Type getEnclosingType() {
            return this.qtype.getEnclosingType();
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.qtype.getParameterTypes();
        }

        @Override
        public Type getReturnType() {
            return this.qtype.getReturnType();
        }

        @Override
        public Type getReceiverType() {
            return this.qtype.getReceiverType();
        }

        @Override
        public List<Type> getThrownTypes() {
            return this.qtype.getThrownTypes();
        }

        @Override
        public List<Type> allparams() {
            return this.qtype.allparams();
        }

        @Override
        public Type getUpperBound() {
            return this.qtype.getUpperBound();
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }
    }

    public static class CapturedType
    extends TypeVar {
        public WildcardType wildcard;

        public CapturedType(Name name, Symbol symbol, Type type, Type type2, WildcardType wildcardType) {
            super(name, symbol, type2);
            this.lower = Assert.checkNonNull(type2);
            this.setUpperBound(type);
            this.wildcard = wildcardType;
        }

        public CapturedType(Symbol.TypeSymbol typeSymbol, Type type, Type type2, Type type3, WildcardType wildcardType, List<TypeMetadata> list) {
            super(typeSymbol, type, type3, list);
            this.wildcard = wildcardType;
        }

        @Override
        protected CapturedType cloneWithMetadata(List<TypeMetadata> list) {
            return new CapturedType(this.tsym, this.getUpperBound(), this.getUpperBound(), this.lower, this.wildcard, list){

                @Override
                public Type baseType() {
                    return this.baseType();
                }

                @Override
                public Type getUpperBound() {
                    return this.getUpperBound();
                }

                @Override
                public void setUpperBound(Type type) {
                    this.setUpperBound(type);
                }
            };
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitCapturedType(this, s);
        }

        @Override
        public boolean isCaptured() {
            return true;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendAnnotationsString(stringBuilder);
            stringBuilder.append("capture#");
            stringBuilder.append(((long)this.hashCode() & 0xFFFFFFFFL) % 997L);
            stringBuilder.append(" of ");
            stringBuilder.append(this.wildcard);
            return stringBuilder.toString();
        }
    }

    public static class TypeVar
    extends Type
    implements TypeVariable {
        private Type _bound = null;
        public Type lower;
        int rank_field = -1;

        public TypeVar(Name name, Symbol symbol, Type type) {
            super(null, List.nil());
            Assert.checkNonNull(type);
            this.tsym = new Symbol.TypeVariableSymbol(0L, name, this, symbol);
            this.setUpperBound(null);
            this.lower = type;
        }

        public TypeVar(Symbol.TypeSymbol typeSymbol, Type type, Type type2) {
            this(typeSymbol, type, type2, List.nil());
        }

        public TypeVar(Symbol.TypeSymbol typeSymbol, Type type, Type type2, List<TypeMetadata> list) {
            super(typeSymbol, list);
            Assert.checkNonNull(type2);
            this.setUpperBound(type);
            this.lower = type2;
        }

        @Override
        protected TypeVar cloneWithMetadata(List<TypeMetadata> list) {
            return new TypeVar(this.tsym, this.getUpperBound(), this.lower, list){

                @Override
                public Type baseType() {
                    return this.baseType();
                }

                @Override
                public Type getUpperBound() {
                    return this.getUpperBound();
                }

                @Override
                public void setUpperBound(Type type) {
                    this.setUpperBound(type);
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.TYPEVAR;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitTypeVar(this, s);
        }

        @Override
        public Type getUpperBound() {
            return this._bound;
        }

        public void setUpperBound(Type type) {
            this._bound = type;
        }

        @Override
        public Type getLowerBound() {
            return this.lower;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.TYPEVAR;
        }

        public boolean isCaptured() {
            return false;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitTypeVariable(this, p);
        }
    }

    public static class ModuleType
    extends Type
    implements NoType {
        ModuleType(Symbol.ModuleSymbol moduleSymbol) {
            super(moduleSymbol, List.nil());
        }

        @Override
        public ModuleType annotatedType(List<Attribute.TypeCompound> list) {
            throw new AssertionError((Object)"Cannot annotate a module type");
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.MODULE;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitModuleType(this, s);
        }

        @Override
        public String toString() {
            return this.tsym.getQualifiedName().toString();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.MODULE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNoType(this, p);
        }
    }

    public static class PackageType
    extends Type
    implements NoType {
        PackageType(Symbol.PackageSymbol packageSymbol) {
            super(packageSymbol, List.nil());
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.PACKAGE;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitPackageType(this, s);
        }

        @Override
        public String toString() {
            return this.tsym.getQualifiedName().toString();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.PACKAGE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNoType(this, p);
        }
    }

    public static class MethodType
    extends Type
    implements ExecutableType,
    PoolConstant.LoadableConstant {
        public List<Type> argtypes;
        public Type restype;
        public List<Type> thrown;
        public Type recvtype;

        public MethodType(List<Type> list, Type type, List<Type> list2, Symbol.TypeSymbol typeSymbol) {
            super(typeSymbol, List.nil());
            this.argtypes = list;
            this.restype = type;
            this.thrown = list2;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.METHOD;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitMethodType(this, s);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendAnnotationsString(stringBuilder);
            stringBuilder.append('(');
            stringBuilder.append(this.argtypes);
            stringBuilder.append(')');
            stringBuilder.append(this.restype);
            return stringBuilder.toString();
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.argtypes;
        }

        @Override
        public Type getReturnType() {
            return this.restype;
        }

        @Override
        public Type getReceiverType() {
            return this.recvtype == null ? noType : this.recvtype;
        }

        @Override
        public List<Type> getThrownTypes() {
            return this.thrown;
        }

        @Override
        public boolean isErroneous() {
            return MethodType.isErroneous(this.argtypes) || this.restype != null && this.restype.isErroneous();
        }

        @Override
        public int poolTag() {
            return 16;
        }

        @Override
        public boolean contains(Type type) {
            return type.equalsIgnoreMetadata(this) || MethodType.contains(this.argtypes, type) || this.restype.contains(type) || MethodType.contains(this.thrown, type);
        }

        @Override
        public MethodType asMethodType() {
            return this;
        }

        @Override
        public void complete() {
            List<Type> list = this.argtypes;
            while (list.nonEmpty()) {
                ((Type)list.head).complete();
                list = list.tail;
            }
            this.restype.complete();
            this.recvtype.complete();
            list = this.thrown;
            while (list.nonEmpty()) {
                ((Type)list.head).complete();
                list = list.tail;
            }
        }

        public List<TypeVar> getTypeVariables() {
            return List.nil();
        }

        @Override
        public Symbol.TypeSymbol asElement() {
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitExecutable(this, p);
        }
    }

    public static class IntersectionClassType
    extends ClassType
    implements IntersectionType {
        public boolean allInterfaces;

        public IntersectionClassType(List<Type> list, Symbol.ClassSymbol classSymbol, boolean bl) {
            super(noType, List.nil(), classSymbol);
            this.allInterfaces = bl;
            Assert.check((classSymbol.flags() & 0x1000000L) != 0L);
            this.supertype_field = (Type)list.head;
            this.interfaces_field = list.tail;
            Assert.check(!this.supertype_field.tsym.isCompleted() || !this.supertype_field.isInterface(), this.supertype_field);
        }

        @Override
        public java.util.List<? extends TypeMirror> getBounds() {
            return Collections.unmodifiableList(this.getExplicitComponents());
        }

        @Override
        public boolean isCompound() {
            return true;
        }

        public List<Type> getComponents() {
            return this.interfaces_field.prepend(this.supertype_field);
        }

        @Override
        public boolean isIntersection() {
            return true;
        }

        public List<Type> getExplicitComponents() {
            return this.allInterfaces ? this.interfaces_field : this.getComponents();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.INTERSECTION;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitIntersection(this, p);
        }
    }

    public static class UnionClassType
    extends ClassType
    implements UnionType {
        final List<? extends Type> alternatives_field;

        public UnionClassType(ClassType classType, List<? extends Type> list) {
            super(classType.outer_field, classType.typarams_field, classType.tsym);
            this.allparams_field = classType.allparams_field;
            this.supertype_field = classType.supertype_field;
            this.interfaces_field = classType.interfaces_field;
            this.all_interfaces_field = classType.interfaces_field;
            this.alternatives_field = list;
        }

        public Type getLub() {
            return this.tsym.type;
        }

        @Override
        public java.util.List<? extends TypeMirror> getAlternatives() {
            return Collections.unmodifiableList(this.alternatives_field);
        }

        @Override
        public boolean isUnion() {
            return true;
        }

        @Override
        public boolean isCompound() {
            return this.getLub().isCompound();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.UNION;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitUnion(this, p);
        }

        public Iterable<? extends Type> getAlternativeTypes() {
            return this.alternatives_field;
        }
    }

    public static class ErasedClassType
    extends ClassType {
        public ErasedClassType(Type type, Symbol.TypeSymbol typeSymbol, List<TypeMetadata> list) {
            super(type, List.nil(), typeSymbol, list);
        }

        @Override
        public boolean hasErasedSupertypes() {
            return true;
        }
    }

    public static class ClassType
    extends Type
    implements DeclaredType,
    PoolConstant.LoadableConstant,
    javax.lang.model.type.ErrorType {
        private Type outer_field;
        public List<Type> typarams_field;
        public List<Type> allparams_field;
        public Type supertype_field;
        public List<Type> interfaces_field;
        public List<Type> all_interfaces_field;
        int rank_field = -1;

        public ClassType(Type type, List<Type> list, Symbol.TypeSymbol typeSymbol) {
            this(type, list, typeSymbol, List.nil());
        }

        public ClassType(Type type, List<Type> list, Symbol.TypeSymbol typeSymbol, List<TypeMetadata> list2) {
            super(typeSymbol, list2);
            this.outer_field = type;
            this.typarams_field = list;
            this.allparams_field = null;
            this.supertype_field = null;
            this.interfaces_field = null;
        }

        @Override
        public int poolTag() {
            return 7;
        }

        @Override
        protected ClassType cloneWithMetadata(List<TypeMetadata> list) {
            return new ClassType(this.outer_field, this.typarams_field, this.tsym, list){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.CLASS;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitClassType(this, s);
        }

        @Override
        public Type constType(Object object) {
            return this.addMetadata(new TypeMetadata.ConstantValue(object));
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getEnclosingType().hasTag(TypeTag.CLASS) && this.tsym.owner.kind == Kinds.Kind.TYP) {
                stringBuilder.append(this.getEnclosingType().toString());
                stringBuilder.append(".");
                this.appendAnnotationsString(stringBuilder);
                stringBuilder.append(this.className(this.tsym, false));
            } else if (this.isAnnotated()) {
                if (!this.tsym.packge().isUnnamed()) {
                    stringBuilder.append(this.tsym.packge());
                    stringBuilder.append(".");
                }
                ListBuffer<Name> listBuffer = new ListBuffer<Name>();
                Object object = this.tsym.owner;
                while (object != null && ((Symbol)object).kind == Kinds.Kind.TYP) {
                    listBuffer.prepend(((Symbol)object).name);
                    object = ((Symbol)object).owner;
                }
                for (Name name : listBuffer) {
                    stringBuilder.append(name);
                    stringBuilder.append(".");
                }
                this.appendAnnotationsString(stringBuilder);
                stringBuilder.append(this.tsym.name);
            } else {
                stringBuilder.append(this.className(this.tsym, true));
            }
            if (((List)this.getTypeArguments()).nonEmpty()) {
                stringBuilder.append('<');
                stringBuilder.append(((List)this.getTypeArguments()).toString());
                stringBuilder.append(">");
            }
            return stringBuilder.toString();
        }

        private String className(Symbol symbol, boolean bl) {
            if (symbol.name.length() == 0 && (symbol.flags() & 0x1000000L) != 0L) {
                StringBuilder stringBuilder = new StringBuilder(this.supertype_field.toString());
                List<Type> list = this.interfaces_field;
                while (list.nonEmpty()) {
                    stringBuilder.append("&");
                    stringBuilder.append(((Type)list.head).toString());
                    list = list.tail;
                }
                return stringBuilder.toString();
            }
            if (symbol.name.length() == 0) {
                ClassType classType = (ClassType)this.tsym.type;
                Object object = classType == null ? Log.getLocalizedString("anonymous.class", new Object[]{null}) : (classType.interfaces_field != null && classType.interfaces_field.nonEmpty() ? Log.getLocalizedString("anonymous.class", classType.interfaces_field.head) : Log.getLocalizedString("anonymous.class", classType.supertype_field));
                if (moreInfo) {
                    object = (String)object + String.valueOf(symbol.hashCode());
                }
                return object;
            }
            if (bl) {
                symbol.apiComplete();
                return symbol.getQualifiedName().toString();
            }
            return symbol.name.toString();
        }

        @Override
        public List<Type> getTypeArguments() {
            if (this.typarams_field == null) {
                this.complete();
                if (this.typarams_field == null) {
                    this.typarams_field = List.nil();
                }
            }
            return this.typarams_field;
        }

        public boolean hasErasedSupertypes() {
            return this.isRaw();
        }

        @Override
        public Type getEnclosingType() {
            return this.outer_field;
        }

        public void setEnclosingType(Type type) {
            this.outer_field = type;
        }

        @Override
        public List<Type> allparams() {
            if (this.allparams_field == null) {
                this.allparams_field = ((List)this.getTypeArguments()).prependList(this.getEnclosingType().allparams());
            }
            return this.allparams_field;
        }

        @Override
        public boolean isErroneous() {
            return this.getEnclosingType().isErroneous() || ClassType.isErroneous((List<Type>)this.getTypeArguments()) || this != this.tsym.type && this.tsym.type.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.allparams().tail != null;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public boolean isRaw() {
            return this != this.tsym.type && this.tsym.type.allparams().nonEmpty() && this.allparams().isEmpty();
        }

        @Override
        public boolean contains(Type type) {
            return type.equalsIgnoreMetadata(this) || this.isParameterized() && (this.getEnclosingType().contains(type) || ClassType.contains((List<Type>)this.getTypeArguments(), type)) || this.isCompound() && (this.supertype_field.contains(type) || ClassType.contains(this.interfaces_field, type));
        }

        @Override
        public void complete() {
            this.tsym.complete();
        }

        @Override
        public TypeKind getKind() {
            this.tsym.apiComplete();
            return this.tsym.kind == Kinds.Kind.TYP ? TypeKind.DECLARED : TypeKind.ERROR;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitDeclared(this, p);
        }
    }

    public static class WildcardType
    extends Type
    implements javax.lang.model.type.WildcardType {
        public Type type;
        public BoundKind kind;
        public TypeVar bound;
        boolean isPrintingBound = false;

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitWildcardType(this, s);
        }

        public WildcardType(Type type, BoundKind boundKind, Symbol.TypeSymbol typeSymbol) {
            this(type, boundKind, typeSymbol, null, List.nil());
        }

        public WildcardType(Type type, BoundKind boundKind, Symbol.TypeSymbol typeSymbol, List<TypeMetadata> list) {
            this(type, boundKind, typeSymbol, null, list);
        }

        public WildcardType(Type type, BoundKind boundKind, Symbol.TypeSymbol typeSymbol, TypeVar typeVar) {
            this(type, boundKind, typeSymbol, typeVar, List.nil());
        }

        public WildcardType(Type type, BoundKind boundKind, Symbol.TypeSymbol typeSymbol, TypeVar typeVar, List<TypeMetadata> list) {
            super(typeSymbol, list);
            this.type = Assert.checkNonNull(type);
            this.kind = boundKind;
            this.bound = typeVar;
        }

        @Override
        protected WildcardType cloneWithMetadata(List<TypeMetadata> list) {
            return new WildcardType(this.type, this.kind, this.tsym, this.bound, list){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.WILDCARD;
        }

        @Override
        public boolean contains(Type type) {
            return this.kind != BoundKind.UNBOUND && this.type.contains(type);
        }

        @Override
        public boolean isSuperBound() {
            return this.kind == BoundKind.SUPER || this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isExtendsBound() {
            return this.kind == BoundKind.EXTENDS || this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isUnbound() {
            return this.kind == BoundKind.UNBOUND || this.kind == BoundKind.EXTENDS && this.type.tsym.flatName() == this.type.tsym.name.table.names.java_lang_Object;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public Type withTypeVar(Type type) {
            if (this.bound == type) {
                return this;
            }
            this.bound = (TypeVar)type;
            return this;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendAnnotationsString(stringBuilder);
            stringBuilder.append(this.kind.toString());
            if (this.kind != BoundKind.UNBOUND) {
                stringBuilder.append(this.type);
            }
            if (moreInfo && this.bound != null && !this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    stringBuilder.append("{:").append(this.bound.getUpperBound()).append(":}");
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public Type getExtendsBound() {
            if (this.kind == BoundKind.EXTENDS) {
                return this.type;
            }
            return null;
        }

        @Override
        public Type getSuperBound() {
            if (this.kind == BoundKind.SUPER) {
                return this.type;
            }
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.WILDCARD;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitWildcard(this, p);
        }
    }

    public static class JCPrimitiveType
    extends Type
    implements PrimitiveType {
        TypeTag tag;

        public JCPrimitiveType(TypeTag typeTag, Symbol.TypeSymbol typeSymbol) {
            this(typeTag, typeSymbol, List.nil());
        }

        private JCPrimitiveType(TypeTag typeTag, Symbol.TypeSymbol typeSymbol, List<TypeMetadata> list) {
            super(typeSymbol, list);
            this.tag = typeTag;
            Assert.check(typeTag.isPrimitive);
        }

        @Override
        protected JCPrimitiveType cloneWithMetadata(List<TypeMetadata> list) {
            return new JCPrimitiveType(this.tag, this.tsym, list){

                @Override
                public Type baseType() {
                    return this.baseType();
                }
            };
        }

        @Override
        public boolean isNumeric() {
            return this.tag != TypeTag.BOOLEAN;
        }

        @Override
        public boolean isIntegral() {
            switch (this.tag) {
                case CHAR: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public TypeTag getTag() {
            return this.tag;
        }

        @Override
        public boolean isPrimitiveOrVoid() {
            return true;
        }

        @Override
        public Type constType(Object object) {
            return this.addMetadata(new TypeMetadata.ConstantValue(object));
        }

        @Override
        public String stringValue() {
            Object object = Assert.checkNonNull(this.constValue());
            if (this.tag == TypeTag.BOOLEAN) {
                return (Integer)object == 0 ? "false" : "true";
            }
            if (this.tag == TypeTag.CHAR) {
                return String.valueOf((char)((Integer)object).intValue());
            }
            return object.toString();
        }

        @Override
        public boolean isFalse() {
            return this.tag == TypeTag.BOOLEAN && this.constValue() != null && (Integer)this.constValue() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.tag == TypeTag.BOOLEAN && this.constValue() != null && (Integer)this.constValue() != 0;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitPrimitive(this, p);
        }

        @Override
        public TypeKind getKind() {
            switch (this.tag) {
                case BYTE: {
                    return TypeKind.BYTE;
                }
                case CHAR: {
                    return TypeKind.CHAR;
                }
                case SHORT: {
                    return TypeKind.SHORT;
                }
                case INT: {
                    return TypeKind.INT;
                }
                case LONG: {
                    return TypeKind.LONG;
                }
                case FLOAT: {
                    return TypeKind.FLOAT;
                }
                case DOUBLE: {
                    return TypeKind.DOUBLE;
                }
                case BOOLEAN: {
                    return TypeKind.BOOLEAN;
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class StructuralTypeMapping<S>
    extends Types.TypeMapping<S> {
        @Override
        public Type visitClassType(ClassType classType, S s) {
            Type type = classType.getEnclosingType();
            Type type2 = (Type)this.visit(type, s);
            java.util.List list = classType.getTypeArguments();
            List<Type> list2 = this.visit((List<Type>)list, s);
            if (type2 == type && list2 == list) {
                return classType;
            }
            return new ClassType(type2, list2, classType.tsym, classType.metadata){

                @Override
                protected boolean needsStripping() {
                    return true;
                }
            };
        }

        @Override
        public Type visitWildcardType(WildcardType wildcardType, S s) {
            Type type = wildcardType.type;
            if (type != null) {
                type = (Type)this.visit(type, s);
            }
            if (type == wildcardType.type) {
                return wildcardType;
            }
            return new WildcardType(type, wildcardType.kind, wildcardType.tsym, wildcardType.bound, wildcardType.metadata){

                @Override
                protected boolean needsStripping() {
                    return true;
                }
            };
        }

        @Override
        public Type visitArrayType(ArrayType arrayType, S s) {
            Type type = arrayType.elemtype;
            Type type2 = (Type)this.visit(type, s);
            if (type2 == type) {
                return arrayType;
            }
            return new ArrayType(type2, arrayType.tsym, arrayType.metadata){

                @Override
                protected boolean needsStripping() {
                    return true;
                }
            };
        }

        @Override
        public Type visitMethodType(MethodType methodType, S s) {
            List<Type> list = methodType.argtypes;
            Type type = methodType.restype;
            List<Type> list2 = methodType.thrown;
            List<Type> list3 = this.visit(list, s);
            Type type2 = (Type)this.visit(type, s);
            List<Type> list4 = this.visit(list2, s);
            if (list3 == list && type2 == type && list4 == list2) {
                return methodType;
            }
            return new MethodType(list3, type2, list4, methodType.tsym){

                @Override
                protected boolean needsStripping() {
                    return true;
                }
            };
        }

        @Override
        public Type visitForAll(ForAll forAll, S s) {
            return (Type)this.visit(forAll.qtype, s);
        }
    }
}

