/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class JCDiagnostic
implements Diagnostic<JavaFileObject> {
    private final DiagnosticSource source;
    private final DiagnosticPosition position;
    private final DiagnosticInfo diagnosticInfo;
    private final Set<DiagnosticFlag> flags;
    private SourcePosition sourcePosition;
    private final UnaryOperator<JCDiagnostic> rewriter;
    private DiagnosticFormatter<JCDiagnostic> defaultFormatter;
    @Deprecated
    private static DiagnosticFormatter<JCDiagnostic> fragmentFormatter;

    @Deprecated
    public static JCDiagnostic fragment(String key, Object ... args) {
        return new JCDiagnostic(JCDiagnostic.getFragmentFormatter(), DiagnosticInfo.of(DiagnosticType.FRAGMENT, null, null, "compiler", key, args), EnumSet.noneOf(DiagnosticFlag.class), null, null);
    }

    @Deprecated
    public static DiagnosticFormatter<JCDiagnostic> getFragmentFormatter() {
        if (fragmentFormatter == null) {
            fragmentFormatter = new BasicDiagnosticFormatter(JavacMessages.getDefaultMessages());
        }
        return fragmentFormatter;
    }

    protected JCDiagnostic(DiagnosticFormatter<JCDiagnostic> formatter, DiagnosticInfo diagnosticInfo, Set<DiagnosticFlag> flags, DiagnosticSource source, DiagnosticPosition pos) {
        this(formatter, diagnosticInfo, flags, source, pos, null);
    }

    protected JCDiagnostic(DiagnosticFormatter<JCDiagnostic> formatter, DiagnosticInfo diagnosticInfo, Set<DiagnosticFlag> flags, DiagnosticSource source, DiagnosticPosition pos, UnaryOperator<JCDiagnostic> rewriter) {
        if (source == null && pos != null && pos.getPreferredPosition() != -1) {
            throw new IllegalArgumentException();
        }
        this.defaultFormatter = formatter;
        this.diagnosticInfo = diagnosticInfo;
        this.flags = flags;
        this.source = source;
        this.position = pos;
        this.rewriter = rewriter;
        this.flags.addAll(diagnosticInfo.flags);
    }

    public DiagnosticType getType() {
        return this.diagnosticInfo.type;
    }

    public List<JCDiagnostic> getSubdiagnostics() {
        return List.nil();
    }

    public boolean isMultiline() {
        return false;
    }

    public boolean isMandatory() {
        return this.flags.contains((Object)DiagnosticFlag.MANDATORY);
    }

    public boolean hasLintCategory() {
        return this.getLintCategory() != null;
    }

    public Lint.LintCategory getLintCategory() {
        Lint.LintCategory lintCategory;
        DiagnosticInfo diagnosticInfo = this.diagnosticInfo;
        if (diagnosticInfo instanceof LintWarning) {
            LintWarning lintWarning = (LintWarning)diagnosticInfo;
            lintCategory = lintWarning.category;
        } else {
            lintCategory = null;
        }
        return lintCategory;
    }

    @Override
    public JavaFileObject getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.getFile();
    }

    public DiagnosticSource getDiagnosticSource() {
        return this.source;
    }

    protected int getIntStartPosition() {
        return this.position == null ? -1 : this.position.getStartPosition();
    }

    protected int getIntPosition() {
        return this.position == null ? -1 : this.position.getPreferredPosition();
    }

    protected int getIntEndPosition() {
        return this.position == null ? -1 : this.position.getEndPosition(this.source.getEndPosTable());
    }

    @Override
    public long getStartPosition() {
        return this.getIntStartPosition();
    }

    @Override
    public long getPosition() {
        return this.getIntPosition();
    }

    @Override
    public long getEndPosition() {
        return this.getIntEndPosition();
    }

    public DiagnosticPosition getDiagnosticPosition() {
        return this.position;
    }

    @Override
    public long getLineNumber() {
        if (this.sourcePosition == null) {
            this.sourcePosition = new SourcePosition();
        }
        return this.sourcePosition.getLineNumber();
    }

    @Override
    public long getColumnNumber() {
        if (this.sourcePosition == null) {
            this.sourcePosition = new SourcePosition();
        }
        return this.sourcePosition.getColumnNumber();
    }

    public Object[] getArgs() {
        return this.diagnosticInfo.args;
    }

    public String getPrefix() {
        return this.getPrefix(this.diagnosticInfo.type);
    }

    public String getPrefix(DiagnosticType dt) {
        return this.defaultFormatter.formatKind(this, Locale.getDefault());
    }

    public String toString() {
        return this.defaultFormatter.format(this, Locale.getDefault());
    }

    @Override
    public Diagnostic.Kind getKind() {
        switch (this.diagnosticInfo.type.ordinal()) {
            case 1: {
                return Diagnostic.Kind.NOTE;
            }
            case 2: {
                return this.flags.contains((Object)DiagnosticFlag.MANDATORY) ? Diagnostic.Kind.MANDATORY_WARNING : Diagnostic.Kind.WARNING;
            }
            case 3: {
                return Diagnostic.Kind.ERROR;
            }
        }
        return Diagnostic.Kind.OTHER;
    }

    @Override
    public String getCode() {
        return this.diagnosticInfo.key();
    }

    @Override
    public String getMessage(Locale locale) {
        return this.defaultFormatter.formatMessage(this, locale);
    }

    public void setFlag(DiagnosticFlag flag) {
        this.flags.add(flag);
        if (this.diagnosticInfo.type == DiagnosticType.ERROR) {
            switch (flag.ordinal()) {
                case 2: {
                    this.flags.remove((Object)DiagnosticFlag.RECOVERABLE);
                    break;
                }
                case 1: {
                    this.flags.add(DiagnosticFlag.RECOVERABLE);
                }
            }
        }
    }

    public boolean isFlagSet(DiagnosticFlag flag) {
        return this.flags.contains((Object)flag);
    }

    boolean hasRewriter() {
        return this.rewriter != null;
    }

    JCDiagnostic rewrite() {
        return (JCDiagnostic)this.rewriter.apply(this);
    }

    public static enum DiagnosticType {
        FRAGMENT("misc"),
        NOTE("note"),
        WARNING("warn"),
        ERROR("err");

        final String key;

        private DiagnosticType(String key) {
            this.key = key;
        }
    }

    public static abstract class DiagnosticInfo {
        DiagnosticType type;
        Set<DiagnosticFlag> flags;
        String prefix;
        String code;
        Object[] args;

        private DiagnosticInfo(DiagnosticType type, Set<DiagnosticFlag> flags, String prefix, String code, Object ... args) {
            this.type = type;
            this.flags = flags != null ? flags : EnumSet.noneOf(DiagnosticFlag.class);
            this.prefix = prefix;
            this.code = code;
            this.args = args;
        }

        public String key() {
            return this.prefix + "." + this.type.key + "." + this.code;
        }

        public static DiagnosticInfo of(DiagnosticType type, Set<DiagnosticFlag> flags, String prefix, String code, Object ... args) {
            return DiagnosticInfo.of(type, flags, null, prefix, code, args);
        }

        public static DiagnosticInfo of(DiagnosticType type, Set<DiagnosticFlag> flags, Lint.LintCategory lc, String prefix, String code, Object ... args) {
            switch (type.ordinal()) {
                case 3: {
                    return new Error(flags, prefix, code, args);
                }
                case 2: {
                    return lc == null ? new Warning(flags, prefix, code, args) : new LintWarning(flags, lc, prefix, code, args);
                }
                case 1: {
                    return new Note(flags, prefix, code, args);
                }
                case 0: {
                    return new Fragment(flags, prefix, code, args);
                }
            }
            Assert.error("Wrong diagnostic type: " + String.valueOf((Object)type));
            return null;
        }

        public String getCode() {
            return this.code;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public void setArgs(Object[] args) {
            this.args = args;
        }

        public boolean hasFlag(DiagnosticFlag flag) {
            return this.flags.contains((Object)flag);
        }
    }

    public static enum DiagnosticFlag {
        MANDATORY,
        RESOLVE_ERROR,
        SYNTAX,
        RECOVERABLE,
        NON_DEFERRABLE,
        COMPRESSED,
        DEFAULT_ENABLED,
        AGGREGATE,
        API,
        SOURCE_LEVEL,
        STRICT;

    }

    public static interface DiagnosticPosition {
        public JCTree getTree();

        public int getStartPosition();

        public int getPreferredPosition();

        public int getEndPosition(EndPosTable var1);

        default public int getLintPosition() {
            return this.getStartPosition();
        }

        default public DiagnosticPosition withLintPosition(final int lintPos) {
            final DiagnosticPosition orig = this;
            return new DiagnosticPosition(){

                @Override
                public JCTree getTree() {
                    return orig.getTree();
                }

                @Override
                public int getStartPosition() {
                    return orig.getStartPosition();
                }

                @Override
                public int getPreferredPosition() {
                    return orig.getPreferredPosition();
                }

                @Override
                public int getEndPosition(EndPosTable endPosTable) {
                    return orig.getEndPosition(endPosTable);
                }

                @Override
                public int getLintPosition() {
                    return lintPos;
                }
            };
        }
    }

    public static final class LintWarning
    extends Warning {
        final Lint.LintCategory category;

        public LintWarning(Set<DiagnosticFlag> flags, Lint.LintCategory category, String prefix, String key, Object ... args) {
            super(flags, prefix, key, args);
            this.category = category;
        }

        public Lint.LintCategory getLintCategory() {
            return this.category;
        }
    }

    class SourcePosition {
        private final int line;
        private final int column;

        SourcePosition() {
            int n;
            int n2 = n = JCDiagnostic.this.position == null ? -1 : JCDiagnostic.this.position.getPreferredPosition();
            if (n == -1 || JCDiagnostic.this.source == null) {
                this.column = -1;
                this.line = -1;
            } else {
                this.line = JCDiagnostic.this.source.getLineNumber(n);
                this.column = JCDiagnostic.this.source.getColumnNumber(n, true);
            }
        }

        public int getLineNumber() {
            return this.line;
        }

        public int getColumnNumber() {
            return this.column;
        }
    }

    public static class MultilineDiagnostic
    extends JCDiagnostic {
        private final List<JCDiagnostic> subdiagnostics;

        public MultilineDiagnostic(JCDiagnostic other, List<JCDiagnostic> subdiagnostics) {
            super(other.defaultFormatter, other.diagnosticInfo, other.flags, other.getDiagnosticSource(), other.position);
            this.subdiagnostics = subdiagnostics;
        }

        @Override
        public List<JCDiagnostic> getSubdiagnostics() {
            return this.subdiagnostics;
        }

        @Override
        public boolean isMultiline() {
            return true;
        }
    }

    public record AnnotatedType(Type type) {
    }

    public static final class Fragment
    extends DiagnosticInfo {
        public Fragment(Set<DiagnosticFlag> flags, String prefix, String key, Object ... args) {
            super(DiagnosticType.FRAGMENT, flags, prefix, key, args);
        }
    }

    public static final class Note
    extends DiagnosticInfo {
        public Note(Set<DiagnosticFlag> flags, String prefix, String key, Object ... args) {
            super(DiagnosticType.NOTE, flags, prefix, key, args);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static class Warning
    extends DiagnosticInfo {
        public Warning(Set<DiagnosticFlag> flags, String prefix, String key, Object ... args) {
            super(DiagnosticType.WARNING, flags, prefix, key, args);
        }
    }

    public static final class Error
    extends DiagnosticInfo {
        public Error(Set<DiagnosticFlag> flags, String prefix, String key, Object ... args) {
            super(DiagnosticType.ERROR, flags, prefix, key, args);
        }
    }

    public static class SimpleDiagnosticPosition
    implements DiagnosticPosition {
        private final int pos;

        public SimpleDiagnosticPosition(int pos) {
            this.pos = pos;
        }

        @Override
        public JCTree getTree() {
            return null;
        }

        @Override
        public int getStartPosition() {
            return this.pos;
        }

        @Override
        public int getPreferredPosition() {
            return this.pos;
        }

        @Override
        public int getEndPosition(EndPosTable endPosTable) {
            return this.pos;
        }
    }

    public static class Factory {
        protected static final Context.Key<Factory> diagnosticFactoryKey = new Context.Key();
        DiagnosticFormatter<JCDiagnostic> formatter;
        final String prefix;
        final Set<DiagnosticFlag> defaultErrorFlags;

        public static Factory instance(Context context) {
            Factory instance = context.get(diagnosticFactoryKey);
            if (instance == null) {
                instance = new Factory(context);
            }
            return instance;
        }

        protected Factory(Context context) {
            this(JavacMessages.instance(context), "compiler");
            context.put(diagnosticFactoryKey, this);
            Options.instance(context).whenReady(this::initOptions);
        }

        private void initOptions(Options options) {
            if (options.isSet("onlySyntaxErrorsUnrecoverable")) {
                this.defaultErrorFlags.add(DiagnosticFlag.RECOVERABLE);
            }
        }

        public Factory(JavacMessages messages, String prefix) {
            this.prefix = prefix;
            this.formatter = new BasicDiagnosticFormatter(messages);
            this.defaultErrorFlags = EnumSet.of(DiagnosticFlag.MANDATORY);
        }

        public JCDiagnostic error(DiagnosticFlag flag, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.error(flag, source, pos, this.errorKey(key, args));
        }

        public JCDiagnostic error(DiagnosticFlag flag, DiagnosticSource source, DiagnosticPosition pos, Error errorKey) {
            JCDiagnostic diag = this.create(EnumSet.copyOf(this.defaultErrorFlags), source, pos, errorKey);
            if (flag != null) {
                diag.setFlag(flag);
            }
            return diag;
        }

        public JCDiagnostic warning(Lint.LintCategory lc, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.warning(null, source, pos, this.warningKey(lc, key, args));
        }

        public JCDiagnostic warning(DiagnosticFlag flag, DiagnosticSource source, DiagnosticPosition pos, Warning warningKey) {
            return this.create(flag != null ? EnumSet.of(flag) : EnumSet.noneOf(DiagnosticFlag.class), source, pos, warningKey);
        }

        public JCDiagnostic note(DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.note(null, source, pos, this.noteKey(key, args));
        }

        public JCDiagnostic note(DiagnosticFlag flag, DiagnosticSource source, DiagnosticPosition pos, Note noteKey) {
            return this.create(flag != null ? EnumSet.of(flag) : EnumSet.noneOf(DiagnosticFlag.class), source, pos, noteKey);
        }

        public JCDiagnostic fragment(String key, Object ... args) {
            return this.fragment(this.fragmentKey(key, args));
        }

        public JCDiagnostic fragment(Fragment fragmentKey) {
            return this.create(EnumSet.noneOf(DiagnosticFlag.class), null, null, fragmentKey);
        }

        public JCDiagnostic create(DiagnosticType kind, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.create(EnumSet.noneOf(DiagnosticFlag.class), source, pos, DiagnosticInfo.of(kind, null, this.prefix, key, args));
        }

        public JCDiagnostic create(DiagnosticType kind, DiagnosticSource source, DiagnosticPosition pos, String key, UnaryOperator<JCDiagnostic> rewriter, Object ... args) {
            return this.create(EnumSet.noneOf(DiagnosticFlag.class), source, pos, DiagnosticInfo.of(kind, null, this.prefix, key, args), rewriter);
        }

        public JCDiagnostic create(DiagnosticSource source, DiagnosticPosition pos, DiagnosticInfo diagnosticInfo) {
            return this.create(EnumSet.noneOf(DiagnosticFlag.class), source, pos, diagnosticInfo);
        }

        public JCDiagnostic create(DiagnosticType kind, Lint.LintCategory lc, Set<DiagnosticFlag> flags, DiagnosticSource source, DiagnosticPosition pos, String key, Object ... args) {
            return this.create(flags, source, pos, DiagnosticInfo.of(kind, null, lc, this.prefix, key, args));
        }

        public JCDiagnostic create(Set<DiagnosticFlag> flags, DiagnosticSource source, DiagnosticPosition pos, DiagnosticInfo diagnosticInfo) {
            return new JCDiagnostic(this.formatter, this.normalize(diagnosticInfo), flags, source, pos);
        }

        public JCDiagnostic create(Set<DiagnosticFlag> flags, DiagnosticSource source, DiagnosticPosition pos, DiagnosticInfo diagnosticInfo, UnaryOperator<JCDiagnostic> rewriter) {
            return new JCDiagnostic(this.formatter, this.normalize(diagnosticInfo), flags, source, pos, rewriter);
        }

        DiagnosticInfo normalize(DiagnosticInfo diagnosticInfo) {
            Lint.LintCategory lintCategory;
            if (diagnosticInfo instanceof LintWarning) {
                LintWarning lintWarning = (LintWarning)diagnosticInfo;
                lintCategory = lintWarning.category;
            } else {
                lintCategory = null;
            }
            Lint.LintCategory category = lintCategory;
            return DiagnosticInfo.of(diagnosticInfo.type, diagnosticInfo.flags, category, diagnosticInfo.prefix, diagnosticInfo.code, Stream.of(diagnosticInfo.args).map(o -> {
                Object object;
                if (o instanceof Fragment) {
                    Fragment frag = (Fragment)o;
                    object = this.fragment(frag);
                } else {
                    object = o;
                }
                return object;
            }).toArray());
        }

        public Error errorKey(String code, Object ... args) {
            return (Error)DiagnosticInfo.of(DiagnosticType.ERROR, null, this.prefix, code, args);
        }

        Warning warningKey(Lint.LintCategory lintCategory, String code, Object ... args) {
            return (Warning)DiagnosticInfo.of(DiagnosticType.WARNING, null, lintCategory, this.prefix, code, args);
        }

        public Note noteKey(String code, Object ... args) {
            return (Note)DiagnosticInfo.of(DiagnosticType.NOTE, null, this.prefix, code, args);
        }

        Fragment fragmentKey(String code, Object ... args) {
            return (Fragment)DiagnosticInfo.of(DiagnosticType.FRAGMENT, null, this.prefix, code, args);
        }
    }
}

