/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.platform;

import com.sun.source.util.Plugin;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.platform.PlatformProvider;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.Processor;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import nbjavac.VMWrapper;

public class JDKPlatformProvider
implements PlatformProvider {
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};
    private static final Map<String, ?> CT_SYM_ZIP_ENV = Map.of("accessMode", "readOnly", "zipinfo-time", "false");
    private static final Set<String> SUPPORTED_JAVA_PLATFORM_VERSIONS;
    public static final Comparator<String> NUMERICAL_COMPARATOR;

    @Override
    public Iterable<String> getSupportedPlatformNames() {
        return SUPPORTED_JAVA_PLATFORM_VERSIONS;
    }

    @Override
    public PlatformDescription getPlatform(String platformName, String options) throws PlatformProvider.PlatformNotSupported {
        if (!SUPPORTED_JAVA_PLATFORM_VERSIONS.contains(platformName)) {
            throw new PlatformProvider.PlatformNotSupported();
        }
        return this.getPlatformTrusted(platformName);
    }

    public PlatformDescription getPlatformTrusted(String platformName) {
        return new PlatformDescriptionImpl(platformName);
    }

    private static String targetNumericVersion(Target target) {
        return Integer.toString(target.ordinal() - Target.JDK1_1.ordinal() + 1);
    }

    static Path findCtSym() {
        return VMWrapper.findCtSym();
    }

    static {
        NUMERICAL_COMPARATOR = (s1, s2) -> {
            int i2;
            int i1;
            try {
                i1 = Integer.parseInt(s1);
            }
            catch (NumberFormatException ex) {
                i1 = Integer.MAX_VALUE;
            }
            try {
                i2 = Integer.parseInt(s2);
            }
            catch (NumberFormatException ex) {
                i2 = Integer.MAX_VALUE;
            }
            return i1 != i2 ? i1 - i2 : s1.compareTo((String)s2);
        };
        SUPPORTED_JAVA_PLATFORM_VERSIONS = new TreeSet<String>(NUMERICAL_COMPARATOR);
        Path ctSymFile = JDKPlatformProvider.findCtSym();
        if (Files.exists(ctSymFile, new LinkOption[0])) {
            try (FileSystem fs = VMWrapper.pathFs(ctSymFile);
                 DirectoryStream<Path> dir = Files.newDirectoryStream(fs.getRootDirectories().iterator().next());){
                for (Path section : dir) {
                    if (section.getFileName().toString().contains("-")) continue;
                    for (char ver : section.getFileName().toString().toCharArray()) {
                        String verString = Character.toString(ver);
                        Target t = Target.lookup("" + Integer.parseInt(verString, 36));
                        if (t == null) continue;
                        SUPPORTED_JAVA_PLATFORM_VERSIONS.add(JDKPlatformProvider.targetNumericVersion(t));
                    }
                }
            }
            catch (IOException | ProviderNotFoundException exception) {
                // empty catch block
            }
        }
    }

    static class PlatformDescriptionImpl
    implements PlatformDescription {
        private final Map<Path, FileSystem> ctSym2FileSystem = new HashMap<Path, FileSystem>();
        private final String sourceVersion;
        private final String ctSymVersion;

        PlatformDescriptionImpl(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            this.ctSymVersion = StringUtils.toUpperCase(Integer.toString(Integer.parseInt(sourceVersion), 36));
        }

        @Override
        public JavaFileManager getFileManager() {
            Context context = new Context();
            PrintWriter pw = new PrintWriter(System.err, true);
            context.put(Log.errKey, pw);
            CacheFSInfo.preRegister(context);
            JavacFileManager fm = new JavacFileManager(context, true, null){

                @Override
                public boolean hasLocation(JavaFileManager.Location location) {
                    return super.hasExplicitLocation(location);
                }

                @Override
                public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
                    String fileName;
                    JavaFileObject result;
                    if (kind == JavaFileObject.Kind.CLASS && (result = (JavaFileObject)this.getFileForInput(location, "", (fileName = className.replace('.', '/')) + ".sig")) != null) {
                        return new SigJavaFileObject(result);
                    }
                    return super.getJavaFileForInput(location, className, kind);
                }

                @Override
                public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, final Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
                    EnumSet<JavaFileObject.Kind> enhancedKinds = EnumSet.copyOf(kinds);
                    enhancedKinds.add(JavaFileObject.Kind.OTHER);
                    final Iterable<JavaFileObject> listed = super.list(location, packageName, enhancedKinds, recurse);
                    return () -> new Iterator<JavaFileObject>(){
                        private final Iterator<JavaFileObject> original;
                        private JavaFileObject next;
                        {
                            this.original = listed.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next == null) {
                                while (this.original.hasNext()) {
                                    JavaFileObject fo = this.original.next();
                                    if (fo.getKind() == JavaFileObject.Kind.OTHER && fo.getName().endsWith(".sig")) {
                                        this.next = new SigJavaFileObject(fo);
                                        break;
                                    }
                                    if (!kinds.contains((Object)fo.getKind())) continue;
                                    this.next = fo;
                                    break;
                                }
                            }
                            return this.next != null;
                        }

                        @Override
                        public JavaFileObject next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            JavaFileObject result = this.next;
                            this.next = null;
                            return result;
                        }
                    };
                }

                @Override
                public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
                    if (file instanceof SigJavaFileObject) {
                        SigJavaFileObject sigJavaFileObject = (SigJavaFileObject)file;
                        file = sigJavaFileObject.getDelegate();
                    }
                    return super.inferBinaryName(location, file);
                }
            };
            fm.handleOption(Option.MULTIRELEASE, this.sourceVersion);
            Path file = JDKPlatformProvider.findCtSym();
            if (Files.exists(file, new LinkOption[0])) {
                try {
                    FileSystem fs = this.ctSym2FileSystem.get(file);
                    if (fs == null) {
                        fs = VMWrapper.pathFs(file);
                        this.ctSym2FileSystem.put(file, fs);
                    }
                    Path root = fs.getRootDirectories().iterator().next();
                    boolean hasModules = Source.Feature.MODULES.allowedInSource(Source.lookup(this.sourceVersion));
                    if (!hasModules) {
                        ArrayList<Path> paths = new ArrayList<Path>();
                        try (DirectoryStream<Path> dir = Files.newDirectoryStream(root);){
                            for (Path section : dir) {
                                if (!section.getFileName().toString().contains(this.ctSymVersion) || section.getFileName().toString().contains("-")) continue;
                                DirectoryStream<Path> modules = Files.newDirectoryStream(section);
                                try {
                                    for (Path module : modules) {
                                        paths.add(module);
                                    }
                                }
                                finally {
                                    if (modules == null) continue;
                                    modules.close();
                                }
                            }
                        }
                        fm.setLocationFromPaths(StandardLocation.PLATFORM_CLASS_PATH, paths);
                    } else {
                        HashMap<String, List> module2Paths = new HashMap<String, List>();
                        try (DirectoryStream<Path> dir = Files.newDirectoryStream(root);){
                            for (Path section : dir) {
                                if (!section.getFileName().toString().contains(this.ctSymVersion) || section.getFileName().toString().contains("-")) continue;
                                DirectoryStream<Path> modules = Files.newDirectoryStream(section);
                                try {
                                    for (Path module : modules) {
                                        module2Paths.computeIfAbsent(module.getFileName().toString(), dummy -> new ArrayList()).add(module);
                                    }
                                }
                                finally {
                                    if (modules == null) continue;
                                    modules.close();
                                }
                            }
                        }
                        fm.handleOption("--system", Arrays.asList("none").iterator());
                        for (Map.Entry e : module2Paths.entrySet()) {
                            fm.setLocationForModule(StandardLocation.SYSTEM_MODULES, (String)e.getKey(), (Collection)e.getValue());
                        }
                    }
                    return fm;
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            throw new IllegalStateException("Cannot find ct.sym!");
        }

        @Override
        public String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public String getTargetVersion() {
            return this.sourceVersion;
        }

        @Override
        public List<PlatformDescription.PluginInfo<Processor>> getAnnotationProcessors() {
            return Collections.emptyList();
        }

        @Override
        public List<PlatformDescription.PluginInfo<Plugin>> getPlugins() {
            return Collections.emptyList();
        }

        @Override
        public List<String> getAdditionalOptions() {
            return Collections.emptyList();
        }

        @Override
        public void close() throws IOException {
            for (FileSystem fs : this.ctSym2FileSystem.values()) {
                fs.close();
            }
            this.ctSym2FileSystem.clear();
        }

        private static class SigJavaFileObject
        extends ForwardingJavaFileObject<JavaFileObject> {
            public SigJavaFileObject(JavaFileObject fileObject) {
                super(fileObject);
            }

            @Override
            public JavaFileObject.Kind getKind() {
                return JavaFileObject.Kind.CLASS;
            }

            @Override
            public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
                return super.isNameCompatible(simpleName + ".sig", JavaFileObject.Kind.OTHER);
            }

            public JavaFileObject getDelegate() {
                return (JavaFileObject)this.fileObject;
            }
        }
    }
}

