/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.ModuleTree;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.parser.LazyDocCommentTable;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.parser.VirtualParser;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.IntHashTable;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;

public class JavacParser
implements Parser {
    private static final int infixPrecedenceLevels = 10;
    private final boolean parseModuleInfo;
    protected Lexer S;
    protected TreeMaker F;
    private Log log;
    private Source source;
    private Preview preview;
    private Names names;
    protected final AbstractEndPosTable endPosTable;
    protected Map<Tokens.Comment, List<Tokens.Comment>> danglingComments = new HashMap<Tokens.Comment, List<Tokens.Comment>>();
    private List<JCTree.JCAnnotation> typeAnnotationsPushedBack = List.nil();
    private boolean permitTypeAnnotationsPushBack = false;
    private JCDiagnostic.Error unexpectedTopLevelDefinitionStartError;
    boolean allowStringFolding;
    boolean keepDocComments;
    boolean keepLineMap;
    boolean allowThisIdent;
    boolean allowYieldStatement;
    boolean allowRecords;
    boolean allowValueClasses;
    boolean allowSealedTypes;
    JCTree.JCVariableDecl receiverParam;
    protected static final int EXPR = 1;
    protected static final int TYPE = 2;
    protected static final int NOPARAMS = 4;
    protected static final int TYPEARG = 8;
    protected static final int DIAMOND = 16;
    protected static final int NOLAMBDA = 32;
    protected int mode = 0;
    protected int lastmode = 0;
    protected Tokens.Token token;
    private JCTree.JCErroneous errorTree;
    private static final int RECOVERY_THRESHOLD = 50;
    private int errorPos = -1;
    private int count = 0;
    private final DocCommentTable docComments;
    ArrayList<JCTree.JCExpression[]> odStackSupply = new ArrayList();
    ArrayList<Tokens.Token[]> opStackSupply = new ArrayList();
    protected Predicate<Tokens.TokenKind> LAX_IDENTIFIER = t -> t == Tokens.TokenKind.IDENTIFIER || t == Tokens.TokenKind.UNDERSCORE || t == Tokens.TokenKind.ASSERT || t == Tokens.TokenKind.ENUM;
    private static final JCDiagnostic.Fragment[][] decisionTable = new JCDiagnostic.Fragment[][]{{null, CompilerProperties.Fragments.VarAndExplicitNotAllowed, CompilerProperties.Fragments.VarAndImplicitNotAllowed}, {CompilerProperties.Fragments.VarAndExplicitNotAllowed, null, CompilerProperties.Fragments.ImplicitAndExplicitNotAllowed}, {CompilerProperties.Fragments.VarAndImplicitNotAllowed, CompilerProperties.Fragments.ImplicitAndExplicitNotAllowed, null}};

    protected JavacParser(ParserFactory fac, Lexer S, boolean keepDocComments, boolean keepLineMap, boolean keepEndPositions) {
        this(fac, S, keepDocComments, keepLineMap, keepEndPositions, false);
    }

    protected JavacParser(ParserFactory fac, Lexer S, boolean keepDocComments, boolean keepLineMap, boolean keepEndPositions, boolean parseModuleInfo) {
        this.S = S;
        this.nextToken();
        this.F = fac.F;
        this.log = fac.log;
        this.names = fac.names;
        this.source = fac.source;
        this.preview = fac.preview;
        this.allowStringFolding = fac.options.getBoolean("allowStringFolding", true);
        this.keepDocComments = keepDocComments;
        this.parseModuleInfo = parseModuleInfo;
        this.docComments = this.newDocCommentTable(keepDocComments, fac);
        this.keepLineMap = keepLineMap;
        this.errorTree = this.F.Erroneous();
        this.endPosTable = this.newEndPosTable(keepEndPositions);
        this.allowYieldStatement = Source.Feature.SWITCH_EXPRESSION.allowedInSource(this.source);
        this.allowRecords = Source.Feature.RECORDS.allowedInSource(this.source);
        this.allowSealedTypes = Source.Feature.SEALED_CLASSES.allowedInSource(this.source);
        this.allowValueClasses = (!this.preview.isPreview(Source.Feature.VALUE_CLASSES) || this.preview.isEnabled()) && Source.Feature.VALUE_CLASSES.allowedInSource(this.source);
        this.updateUnexpectedTopLevelDefinitionStartError(false);
    }

    protected JavacParser(JavacParser parser, Lexer S) {
        this.S = S;
        this.token = parser.token;
        this.F = parser.F;
        this.log = parser.log;
        this.names = parser.names;
        this.source = parser.source;
        this.preview = parser.preview;
        this.allowStringFolding = parser.allowStringFolding;
        this.keepDocComments = parser.keepDocComments;
        this.parseModuleInfo = false;
        this.docComments = parser.docComments;
        this.errorTree = this.F.Erroneous();
        this.endPosTable = this.newEndPosTable(false);
        this.allowYieldStatement = Source.Feature.SWITCH_EXPRESSION.allowedInSource(this.source);
        this.allowRecords = Source.Feature.RECORDS.allowedInSource(this.source);
        this.allowSealedTypes = Source.Feature.SEALED_CLASSES.allowedInSource(this.source);
        this.allowValueClasses = (!this.preview.isPreview(Source.Feature.VALUE_CLASSES) || this.preview.isEnabled()) && Source.Feature.VALUE_CLASSES.allowedInSource(this.source);
        this.updateUnexpectedTopLevelDefinitionStartError(false);
    }

    protected AbstractEndPosTable newEndPosTable(boolean keepEndPositions) {
        return keepEndPositions ? new SimpleEndPosTable() : new MinimalEndPosTable();
    }

    protected DocCommentTable newDocCommentTable(boolean keepDocComments, ParserFactory fac) {
        return keepDocComments ? new LazyDocCommentTable(fac) : null;
    }

    protected void setMode(int mode) {
        this.mode = mode;
    }

    protected void setLastMode(int mode) {
        this.lastmode = mode;
    }

    protected boolean isMode(int mode) {
        return (this.mode & mode) != 0;
    }

    protected boolean wasTypeMode() {
        return (this.lastmode & 2) != 0;
    }

    protected void selectExprMode() {
        this.setMode(this.mode & 0x20 | 1);
    }

    protected void selectTypeMode() {
        this.setMode(this.mode & 0x20 | 2);
    }

    public Tokens.Token token() {
        return this.token;
    }

    public void nextToken() {
        this.S.nextToken();
        this.token = this.S.token();
    }

    protected boolean peekToken(Predicate<Tokens.TokenKind> tk) {
        return this.peekToken(0, tk);
    }

    protected boolean peekToken(int lookahead, Predicate<Tokens.TokenKind> tk) {
        return tk.test(this.S.token((int)(lookahead + 1)).kind);
    }

    protected boolean peekToken(Predicate<Tokens.TokenKind> tk1, Predicate<Tokens.TokenKind> tk2) {
        return this.peekToken(0, tk1, tk2);
    }

    protected boolean peekToken(int lookahead, Predicate<Tokens.TokenKind> tk1, Predicate<Tokens.TokenKind> tk2) {
        return tk1.test(this.S.token((int)(lookahead + 1)).kind) && tk2.test(this.S.token((int)(lookahead + 2)).kind);
    }

    protected boolean peekToken(Predicate<Tokens.TokenKind> tk1, Predicate<Tokens.TokenKind> tk2, Predicate<Tokens.TokenKind> tk3) {
        return this.peekToken(0, tk1, tk2, tk3);
    }

    protected boolean peekToken(int lookahead, Predicate<Tokens.TokenKind> tk1, Predicate<Tokens.TokenKind> tk2, Predicate<Tokens.TokenKind> tk3) {
        return tk1.test(this.S.token((int)(lookahead + 1)).kind) && tk2.test(this.S.token((int)(lookahead + 2)).kind) && tk3.test(this.S.token((int)(lookahead + 3)).kind);
    }

    protected boolean peekToken(Predicate<Tokens.TokenKind> ... kinds) {
        return this.peekToken(0, kinds);
    }

    protected boolean peekToken(int lookahead, Predicate<Tokens.TokenKind> ... kinds) {
        for (Predicate<Tokens.TokenKind> kind : kinds) {
            if (kind.test(this.S.token((int)(++lookahead)).kind)) continue;
            return false;
        }
        return true;
    }

    protected void skip(boolean stopAtImport, boolean stopAtMemberDecl, boolean stopAtIdentifier, boolean stopAtStatement) {
        while (true) {
            switch (this.token.kind) {
                case SEMI: {
                    this.nextToken();
                    return;
                }
                case PUBLIC: 
                case FINAL: 
                case ABSTRACT: 
                case MONKEYS_AT: 
                case EOF: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: {
                    return;
                }
                case IMPORT: {
                    if (!stopAtImport) break;
                    return;
                }
                case LBRACE: 
                case RBRACE: 
                case PRIVATE: 
                case PROTECTED: 
                case STATIC: 
                case TRANSIENT: 
                case NATIVE: 
                case VOLATILE: 
                case SYNCHRONIZED: 
                case STRICTFP: 
                case LT: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: {
                    if (!stopAtMemberDecl) break;
                    return;
                }
                case UNDERSCORE: 
                case IDENTIFIER: {
                    if (!stopAtIdentifier) break;
                    return;
                }
                case CASE: 
                case DEFAULT: 
                case IF: 
                case FOR: 
                case WHILE: 
                case DO: 
                case TRY: 
                case SWITCH: 
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: 
                case ELSE: 
                case FINALLY: 
                case CATCH: 
                case THIS: 
                case SUPER: 
                case NEW: {
                    if (!stopAtStatement) break;
                    return;
                }
                case ASSERT: {
                    if (!stopAtStatement) break;
                    return;
                }
            }
            this.nextToken();
        }
    }

    protected JCTree.JCErroneous syntaxError(int pos, JCDiagnostic.Error errorKey) {
        return this.syntaxError(pos, List.nil(), errorKey);
    }

    protected JCTree.JCErroneous syntaxError(int pos, List<? extends JCTree> errs, JCDiagnostic.Error errorKey) {
        return this.syntaxError(pos, errs, errorKey, false);
    }

    private JCTree.JCErroneous syntaxError(int pos, List<? extends JCTree> errs, JCDiagnostic.Error errorKey, boolean noEofError) {
        JCTree last;
        this.setErrorEndPos(pos);
        JCTree.JCErroneous err = this.F.at(pos).Erroneous(errs);
        this.reportSyntaxError(err, errorKey, noEofError);
        if (errs != null && (last = errs.last()) != null) {
            this.storeEnd(last, pos);
        }
        return this.toP(err);
    }

    protected void reportSyntaxError(int pos, JCDiagnostic.Error errorKey) {
        JCDiagnostic.SimpleDiagnosticPosition diag = new JCDiagnostic.SimpleDiagnosticPosition(pos);
        this.reportSyntaxError(diag, errorKey);
    }

    protected void reportSyntaxError(JCDiagnostic.DiagnosticPosition diagPos, JCDiagnostic.Error errorKey) {
        this.reportSyntaxError(diagPos, errorKey, false);
    }

    private void reportSyntaxError(JCDiagnostic.DiagnosticPosition diagPos, JCDiagnostic.Error errorKey, boolean noEofError) {
        int pos = diagPos.getPreferredPosition();
        if (pos > this.S.errPos() || pos == -1) {
            if (this.token.kind == Tokens.TokenKind.EOF && !noEofError) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, diagPos, CompilerProperties.Errors.PrematureEof);
            } else {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, diagPos, errorKey);
            }
        }
        this.S.errPos(pos);
        if (this.token.pos == this.errorPos && this.token.kind != Tokens.TokenKind.EOF) {
            Assert.check(this.count++ < 50);
        } else {
            this.count = 0;
            this.errorPos = this.token.pos;
        }
    }

    public void accept(Tokens.TokenKind tk) {
        this.accept(tk, CompilerProperties.Errors::Expected);
    }

    public void accept(Tokens.TokenKind tk, Function<Tokens.TokenKind, JCDiagnostic.Error> errorProvider) {
        if (this.token.kind == tk) {
            this.nextToken();
        } else {
            this.setErrorEndPos(this.token.pos);
            this.reportSyntaxError(this.S.prevToken().endPos, errorProvider.apply(tk));
        }
    }

    JCTree.JCExpression illegal(int pos) {
        this.setErrorEndPos(pos);
        if (this.isMode(1)) {
            return this.syntaxError(pos, CompilerProperties.Errors.IllegalStartOfExpr);
        }
        return this.syntaxError(pos, CompilerProperties.Errors.IllegalStartOfType);
    }

    JCTree.JCExpression illegal() {
        return this.illegal(this.token.pos);
    }

    protected void checkNoMods(long mods) {
        this.checkNoMods(this.token.pos, mods);
    }

    protected void checkNoMods(int pos, long mods) {
        if (mods != 0L) {
            long lowestMod = mods & -mods;
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, pos, CompilerProperties.Errors.ModNotAllowedHere(Flags.asFlagSet(lowestMod)));
        }
    }

    private void saveDanglingDocComments(Tokens.Comment dc) {
        Queue<Tokens.Comment> recentComments = this.S.getDocComments();
        switch (recentComments.size()) {
            case 0: {
                return;
            }
            case 1: {
                if (recentComments.peek() != dc) break;
                recentComments.remove();
                return;
            }
        }
        ListBuffer<Tokens.Comment> lb = new ListBuffer<Tokens.Comment>();
        while (!recentComments.isEmpty()) {
            Tokens.Comment c = recentComments.remove();
            if (c == dc) continue;
            lb.add(c);
        }
        this.danglingComments.put(dc, lb.toList());
    }

    protected <T extends JCTree> T attach(T tree, Tokens.Comment dc) {
        if (this.keepDocComments && dc != null) {
            this.docComments.putComment(tree, dc);
        }
        this.reportDanglingComments(tree, dc);
        return tree;
    }

    void reportDanglingComments(JCTree tree, Tokens.Comment dc) {
        List<Tokens.Comment> list = this.danglingComments.remove(dc);
        if (list != null) {
            list.forEach(c -> this.reportDanglingDocComment(tree, (Tokens.Comment)c));
        }
    }

    void reportDanglingDocComment(JCTree tree, Tokens.Comment c) {
        JCDiagnostic.DiagnosticPosition pos = c.getPos();
        if (pos != null && !this.shebang(c, pos)) {
            pos = pos.withLintPosition(tree.getStartPosition());
            this.S.lintWarning(pos, CompilerProperties.LintWarnings.DanglingDocComment);
        }
    }

    private boolean shebang(Tokens.Comment c, JCDiagnostic.DiagnosticPosition pos) {
        DiagnosticSource src = this.log.currentSource();
        return c.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE && c.getPos().getStartPosition() == 0 && src.getLineNumber(pos.getEndPosition(src.getEndPosTable())) == 1;
    }

    private void ignoreDanglingComments() {
        this.S.getDocComments().clear();
    }

    protected void setErrorEndPos(int errPos) {
        this.endPosTable.setErrorEndPos(errPos);
    }

    protected <T extends JCTree> T storeEnd(T tree, int endpos) {
        return this.endPosTable.storeEnd(tree, endpos);
    }

    protected <T extends JCTree> T to(T tree) {
        return this.storeEnd(tree, this.token.endPos);
    }

    protected <T extends JCTree> T toP(T tree) {
        return this.storeEnd(tree, this.S.prevToken().endPos);
    }

    public int getStartPos(JCTree tree) {
        return TreeInfo.getStartPos(tree);
    }

    public int getEndPos(JCTree tree) {
        return this.endPosTable.getEndPos(tree);
    }

    public Name ident() {
        return this.ident(false);
    }

    protected Name ident(boolean allowClass) {
        return this.ident(allowClass, false);
    }

    public Name identOrUnderscore() {
        return this.ident(false, true);
    }

    protected Name ident(boolean allowClass, boolean asVariable) {
        if (this.token.kind == Tokens.TokenKind.IDENTIFIER) {
            Name name = this.token.name();
            this.nextToken();
            return name;
        }
        if (this.token.kind == Tokens.TokenKind.ASSERT) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.AssertAsIdentifier);
            this.nextToken();
            return this.names.error;
        }
        if (this.token.kind == Tokens.TokenKind.ENUM) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.EnumAsIdentifier);
            this.nextToken();
            return this.names.error;
        }
        if (this.token.kind == Tokens.TokenKind.THIS) {
            if (this.allowThisIdent) {
                Name name = this.token.name();
                this.nextToken();
                return name;
            }
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.ThisAsIdentifier);
            this.nextToken();
            return this.names.error;
        }
        if (this.token.kind == Tokens.TokenKind.UNDERSCORE) {
            if (Source.Feature.UNDERSCORE_IDENTIFIER.allowedInSource(this.source)) {
                this.log.warning(this.token.pos, CompilerProperties.Warnings.UnderscoreAsIdentifier);
            } else if (asVariable) {
                this.checkSourceLevel(Source.Feature.UNNAMED_VARIABLES);
                if (this.peekToken((Predicate<Tokens.TokenKind>)Tokens.TokenKind.LBRACKET)) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.UseOfUnderscoreNotAllowedWithBrackets);
                }
            } else if (Source.Feature.UNNAMED_VARIABLES.allowedInSource(this.source)) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.UseOfUnderscoreNotAllowedNonVariable);
            } else {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.UnderscoreAsIdentifier);
            }
            Name name = this.token.name();
            this.nextToken();
            return name;
        }
        this.accept(Tokens.TokenKind.IDENTIFIER);
        if (allowClass && this.token.kind == Tokens.TokenKind.CLASS) {
            this.nextToken();
            return this.names._class;
        }
        return this.names.error;
    }

    public JCTree.JCExpression qualident(boolean allowAnnos) {
        JCTree.JCExpression t = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
        while (this.token.kind == Tokens.TokenKind.DOT) {
            int pos = this.token.pos;
            this.nextToken();
            List<JCTree.JCAnnotation> tyannos = null;
            if (allowAnnos) {
                tyannos = this.typeAnnotationsOpt();
            }
            t = this.toP(this.F.at(pos).Select(t, this.ident()));
            if (tyannos == null || !tyannos.nonEmpty()) continue;
            t = this.toP(this.F.at(((JCTree.JCAnnotation)tyannos.head).pos).AnnotatedType(tyannos, t));
        }
        return t;
    }

    JCTree.JCExpression literal(Name prefix) {
        return this.literal(prefix, this.token.pos);
    }

    JCTree.JCExpression literal(Name prefix, int pos) {
        JCTree.JCExpression t = this.errorTree;
        switch (this.token.kind) {
            case INTLITERAL: {
                try {
                    t = this.F.at(pos).Literal(TypeTag.INT, Convert.string2int(this.strval(prefix), this.token.radix()));
                }
                catch (NumberFormatException ex) {
                    this.reportIntegralLiteralError(prefix, pos);
                }
                break;
            }
            case LONGLITERAL: {
                try {
                    t = this.F.at(pos).Literal(TypeTag.LONG, Convert.string2long(this.strval(prefix), this.token.radix()));
                }
                catch (NumberFormatException ex) {
                    this.reportIntegralLiteralError(prefix, pos);
                }
                break;
            }
            case FLOATLITERAL: {
                Float n;
                Object proper = this.token.radix() == 16 ? "0x" + this.token.stringVal() : this.token.stringVal();
                try {
                    n = Float.valueOf((String)proper);
                }
                catch (NumberFormatException ex) {
                    n = Float.valueOf(Float.NaN);
                }
                if (n.floatValue() == 0.0f && !this.isZero((String)proper)) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.FpNumberTooSmall);
                    break;
                }
                if (n.floatValue() == Float.POSITIVE_INFINITY) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.FpNumberTooLarge);
                    break;
                }
                t = this.F.at(pos).Literal(TypeTag.FLOAT, n);
                break;
            }
            case DOUBLELITERAL: {
                Double n;
                Object proper = this.token.radix() == 16 ? "0x" + this.token.stringVal() : this.token.stringVal();
                try {
                    n = Double.valueOf((String)proper);
                }
                catch (NumberFormatException ex) {
                    n = Double.NaN;
                }
                if (n == 0.0 && !this.isZero((String)proper)) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.FpNumberTooSmall);
                    break;
                }
                if (n == Double.POSITIVE_INFINITY) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.FpNumberTooLarge);
                    break;
                }
                t = this.F.at(pos).Literal(TypeTag.DOUBLE, n);
                break;
            }
            case CHARLITERAL: {
                t = this.F.at(pos).Literal(TypeTag.CHAR, this.token.stringVal().charAt(0) + '\u0000');
                break;
            }
            case STRINGLITERAL: {
                t = this.F.at(pos).Literal(TypeTag.CLASS, this.token.stringVal());
                break;
            }
            case TRUE: 
            case FALSE: {
                t = this.F.at(pos).Literal(TypeTag.BOOLEAN, this.token.kind == Tokens.TokenKind.TRUE ? 1 : 0);
                break;
            }
            case NULL: {
                t = this.F.at(pos).Literal(TypeTag.BOT, null);
                break;
            }
            default: {
                Assert.error();
            }
        }
        if (t == this.errorTree) {
            t = this.F.at(pos).Erroneous();
        }
        this.storeEnd(t, this.token.endPos);
        this.nextToken();
        return t;
    }

    boolean isZero(String s) {
        int i;
        char[] cs = s.toCharArray();
        int base = cs.length > 1 && Character.toLowerCase(cs[1]) == 'x' ? 16 : 10;
        int n = i = base == 16 ? 2 : 0;
        while (i < cs.length && (cs[i] == '0' || cs[i] == '.')) {
            ++i;
        }
        return i >= cs.length || Character.digit(cs[i], base) <= 0;
    }

    String strval(Name prefix) {
        String s = this.token.stringVal();
        return prefix.isEmpty() ? s : String.valueOf(prefix) + s;
    }

    void reportIntegralLiteralError(Name prefix, int pos) {
        int radix = this.token.radix();
        if (radix == 2 || radix == 8) {
            String value = this.strval(prefix);
            char[] cs = value.toCharArray();
            for (int i = 0; i < cs.length; ++i) {
                char c = cs[i];
                int d = Character.digit(c, radix);
                if (d != -1) continue;
                JCDiagnostic.Error err = radix == 2 ? CompilerProperties.Errors.IllegalDigitInBinaryLiteral : CompilerProperties.Errors.IllegalDigitInOctalLiteral;
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos + i, err);
                return;
            }
        }
        this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.IntNumberTooLarge(this.strval(prefix)));
    }

    @Override
    public JCTree.JCExpression parseExpression() {
        return this.term(1);
    }

    public JCTree.JCPattern parsePattern(int pos, JCTree.JCModifiers mods, JCTree.JCExpression parsedType, boolean allowVar, boolean checkGuard) {
        JCTree.JCPattern pattern;
        JCTree.JCModifiers jCModifiers = mods = mods != null ? mods : this.optFinal(0L);
        if (this.token.kind == Tokens.TokenKind.UNDERSCORE && parsedType == null) {
            this.nextToken();
            this.checkSourceLevel(Source.Feature.UNNAMED_VARIABLES);
            pattern = this.toP(this.F.at(this.token.pos).AnyPattern());
        } else {
            JCTree.JCExpression e;
            if (parsedType == null) {
                boolean var = this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.var;
                e = this.unannotatedType(allowVar, 34);
                if (var) {
                    e = null;
                }
            } else {
                e = parsedType;
            }
            if (this.token.kind == Tokens.TokenKind.LPAREN) {
                this.checkSourceLevel(Source.Feature.RECORD_PATTERNS);
                ListBuffer<JCTree.JCPattern> nested = new ListBuffer<JCTree.JCPattern>();
                if (!this.peekToken((Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN)) {
                    do {
                        this.nextToken();
                        JCTree.JCPattern nestedPattern = this.parsePattern(this.token.pos, null, null, true, false);
                        nested.append(nestedPattern);
                    } while (this.token.kind == Tokens.TokenKind.COMMA);
                } else {
                    this.nextToken();
                }
                this.accept(Tokens.TokenKind.RPAREN);
                pattern = this.toP(this.F.at(pos).RecordPattern(e, nested.toList()));
                if (mods.annotations.nonEmpty()) {
                    this.log.error(((JCTree.JCAnnotation)mods.annotations.head).pos(), CompilerProperties.Errors.RecordPatternsAnnotationsNotAllowed);
                }
                this.checkNoMods(pos, mods.flags & 0x10L);
                new TreeScanner(){

                    @Override
                    public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
                        JavacParser.this.log.error(tree.pos(), CompilerProperties.Errors.RecordPatternsAnnotationsNotAllowed);
                    }
                }.scan(e);
            } else {
                int varPos = this.token.pos;
                Name name = this.identOrUnderscore();
                if (Source.Feature.UNNAMED_VARIABLES.allowedInSource(this.source) && name == this.names.underscore) {
                    name = this.names.empty;
                }
                JCTree.JCVariableDecl var = this.toP(this.F.at(varPos).VarDef(mods, name, e, null));
                if (e == null) {
                    var.startPos = pos;
                    if (var.name == this.names.underscore && !allowVar) {
                        this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, varPos, CompilerProperties.Errors.UseOfUnderscoreNotAllowed);
                    }
                }
                pattern = this.toP(this.F.at(pos).BindingPattern(var));
            }
        }
        return pattern;
    }

    @Override
    public JCTree.JCExpression parseType() {
        return this.parseType(false);
    }

    public JCTree.JCExpression parseType(boolean allowVar) {
        List<JCTree.JCAnnotation> annotations = this.typeAnnotationsOpt();
        return this.parseType(allowVar, annotations);
    }

    public JCTree.JCExpression parseType(boolean allowVar, List<JCTree.JCAnnotation> annotations) {
        JCTree.JCExpression result = this.unannotatedType(allowVar);
        if (annotations.nonEmpty()) {
            result = this.insertAnnotationsToMostInner(result, annotations, false);
        }
        return result;
    }

    protected JCTree.JCExpression parseIntersectionType(int pos, JCTree.JCExpression firstType) {
        JCTree.JCExpression t = firstType;
        int pos1 = pos;
        List<JCTree.JCExpression> targets = List.of(t);
        while (this.token.kind == Tokens.TokenKind.AMP) {
            this.accept(Tokens.TokenKind.AMP);
            targets = targets.prepend(this.parseType());
        }
        if (targets.length() > 1) {
            t = this.toP(this.F.at(pos1).TypeIntersection(targets.reverse()));
        }
        return t;
    }

    public JCTree.JCExpression unannotatedType(boolean allowVar) {
        return this.unannotatedType(allowVar, 2);
    }

    public JCTree.JCExpression unannotatedType(boolean allowVar, int newmode) {
        JCTree.JCExpression result = this.term(newmode);
        Name restrictedTypeName = this.restrictedTypeName(result, !allowVar);
        if (!(restrictedTypeName == null || allowVar && restrictedTypeName == this.names.var)) {
            this.syntaxError(result.pos, CompilerProperties.Errors.RestrictedTypeNotAllowedHere(restrictedTypeName));
        }
        return result;
    }

    protected JCTree.JCExpression term(int newmode) {
        int prevmode = this.mode;
        this.setMode(newmode);
        JCTree.JCExpression t = this.term();
        this.setLastMode(this.mode);
        this.setMode(prevmode);
        return t;
    }

    JCTree.JCExpression term() {
        JCTree.JCExpression t = this.term1();
        if (this.isMode(1) && (this.token.kind == Tokens.TokenKind.EQ || Tokens.TokenKind.PLUSEQ.compareTo(this.token.kind) <= 0 && this.token.kind.compareTo(Tokens.TokenKind.GTGTGTEQ) <= 0)) {
            return this.termRest(t);
        }
        return t;
    }

    JCTree.JCExpression termRest(JCTree.JCExpression t) {
        switch (this.token.kind) {
            case EQ: {
                int pos = this.token.pos;
                this.nextToken();
                this.selectExprMode();
                JCTree.JCExpression t1 = this.term();
                return this.toP(this.F.at(pos).Assign(t, t1));
            }
            case PLUSEQ: 
            case SUBEQ: 
            case STAREQ: 
            case SLASHEQ: 
            case PERCENTEQ: 
            case AMPEQ: 
            case BAREQ: 
            case CARETEQ: 
            case LTLTEQ: 
            case GTGTEQ: 
            case GTGTGTEQ: {
                int pos = this.token.pos;
                Tokens.TokenKind tk = this.token.kind;
                this.nextToken();
                this.selectExprMode();
                JCTree.JCExpression t1 = this.term();
                return this.F.at(pos).Assignop(JavacParser.optag(tk), t, t1);
            }
        }
        return t;
    }

    JCTree.JCExpression term1() {
        JCTree.JCExpression t = this.term2();
        if (this.isMode(1) && this.token.kind == Tokens.TokenKind.QUES) {
            this.selectExprMode();
            return this.term1Rest(t);
        }
        return t;
    }

    JCTree.JCExpression term1Rest(JCTree.JCExpression t) {
        if (this.token.kind == Tokens.TokenKind.QUES) {
            int pos = this.token.pos;
            this.nextToken();
            JCTree.JCExpression t1 = this.term();
            this.accept(Tokens.TokenKind.COLON);
            JCTree.JCExpression t2 = this.term1();
            return this.F.at(pos).Conditional(t, t1, t2);
        }
        return t;
    }

    JCTree.JCExpression term2() {
        JCTree.JCExpression t = this.term3();
        if (this.isMode(1) && JavacParser.prec(this.token.kind) >= 4) {
            this.selectExprMode();
            return this.term2Rest(t, 4);
        }
        return t;
    }

    JCTree.JCExpression term2Rest(JCTree.JCExpression t, int minprec) {
        JCTree.JCExpression[] odStack = this.newOdStack();
        Tokens.Token[] opStack = this.newOpStack();
        int top = 0;
        odStack[0] = t;
        int startPos = this.token.pos;
        Tokens.Token topOp = Tokens.DUMMY;
        while (JavacParser.prec(this.token.kind) >= minprec) {
            opStack[top] = topOp;
            if (this.token.kind == Tokens.TokenKind.INSTANCEOF) {
                JCTree pattern;
                int pos = this.token.pos;
                this.nextToken();
                if (this.token.kind == Tokens.TokenKind.LPAREN) {
                    this.checkSourceLevel(this.token.pos, Source.Feature.PATTERN_SWITCH);
                    pattern = this.parsePattern(this.token.pos, null, null, false, false);
                } else {
                    int patternPos = this.token.pos;
                    JCTree.JCModifiers mods = this.optFinal(0L);
                    int typePos = this.token.pos;
                    JCTree.JCExpression type = this.unannotatedType(false);
                    if (this.token.kind == Tokens.TokenKind.IDENTIFIER) {
                        this.checkSourceLevel(this.token.pos, Source.Feature.PATTERN_MATCHING_IN_INSTANCEOF);
                        pattern = this.parsePattern(patternPos, mods, type, false, false);
                    } else if (this.token.kind == Tokens.TokenKind.LPAREN) {
                        pattern = this.parsePattern(patternPos, mods, type, false, false);
                    } else if (this.token.kind == Tokens.TokenKind.UNDERSCORE) {
                        this.checkSourceLevel(this.token.pos, Source.Feature.UNNAMED_VARIABLES);
                        pattern = this.parsePattern(patternPos, mods, type, false, false);
                    } else {
                        this.checkNoMods(typePos, mods.flags & 0xFFFFFFFFFFFDFFFFL);
                        if (mods.annotations.nonEmpty()) {
                            List<JCTree.JCAnnotation> typeAnnos = mods.annotations.map(decl -> {
                                JCTree.JCAnnotation typeAnno = this.F.at(decl.pos).TypeAnnotation(decl.annotationType, decl.args);
                                this.endPosTable.replaceTree((JCTree)decl, typeAnno);
                                return typeAnno;
                            });
                            type = this.insertAnnotationsToMostInner(type, typeAnnos, false);
                        }
                        pattern = type;
                    }
                }
                odStack[top] = this.F.at(pos).TypeTest(odStack[top], pattern);
            } else {
                topOp = this.token;
                this.nextToken();
                odStack[++top] = this.term3();
            }
            while (top > 0 && JavacParser.prec(topOp.kind) >= JavacParser.prec(this.token.kind)) {
                odStack[top - 1] = this.F.at(topOp.pos).Binary(JavacParser.optag(topOp.kind), odStack[top - 1], odStack[top]);
                topOp = opStack[--top];
            }
        }
        Assert.check(top == 0);
        t = odStack[0];
        if (t.hasTag(JCTree.Tag.PLUS)) {
            t = this.foldStrings(t);
        }
        this.odStackSupply.add(odStack);
        this.opStackSupply.add(opStack);
        return t;
    }

    protected JCTree.JCExpression foldStrings(JCTree.JCExpression tree) {
        if (!this.allowStringFolding) {
            return tree;
        }
        ListBuffer<JCTree.JCExpression> opStack = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<JCTree.JCLiteral> litBuf = new ListBuffer<JCTree.JCLiteral>();
        boolean needsFolding = false;
        JCTree.JCExpression curr = tree;
        while (curr.hasTag(JCTree.Tag.PLUS)) {
            JCTree.JCBinary op = (JCTree.JCBinary)curr;
            needsFolding |= this.foldIfNeeded(op.rhs, litBuf, opStack, false);
            curr = op.lhs;
        }
        if (needsFolding |= this.foldIfNeeded(curr, litBuf, opStack, true)) {
            List<JCTree.JCExpression> ops = opStack.toList();
            JCTree.JCExpression res = (JCTree.JCExpression)ops.head;
            for (JCTree.JCExpression op : ops.tail) {
                res = this.F.at(op.getStartPosition()).Binary(JavacParser.optag(Tokens.TokenKind.PLUS), res, op);
                this.storeEnd(res, this.getEndPos(op));
            }
            return res;
        }
        return tree;
    }

    private boolean foldIfNeeded(JCTree.JCExpression tree, ListBuffer<JCTree.JCLiteral> litBuf, ListBuffer<JCTree.JCExpression> opStack, boolean last) {
        JCTree.JCLiteral str = this.stringLiteral(tree);
        if (str != null) {
            litBuf.prepend(str);
            return last && this.merge(litBuf, opStack);
        }
        boolean res = this.merge(litBuf, opStack);
        litBuf.clear();
        opStack.prepend(tree);
        return res;
    }

    boolean merge(ListBuffer<JCTree.JCLiteral> litBuf, ListBuffer<JCTree.JCExpression> opStack) {
        if (litBuf.isEmpty()) {
            return false;
        }
        if (litBuf.size() == 1) {
            opStack.prepend(litBuf.first());
            return false;
        }
        JCTree.JCLiteral t = this.F.at(litBuf.first().getStartPosition()).Literal(TypeTag.CLASS, litBuf.stream().map(lit -> (String)lit.getValue()).collect(Collectors.joining()));
        this.storeEnd(t, litBuf.last().getEndPosition(this.endPosTable));
        opStack.prepend(t);
        return true;
    }

    private JCTree.JCLiteral stringLiteral(JCTree tree) {
        if (tree.hasTag(JCTree.Tag.LITERAL)) {
            JCTree.JCLiteral lit = (JCTree.JCLiteral)tree;
            if (lit.typetag == TypeTag.CLASS) {
                return lit;
            }
        }
        return null;
    }

    private JCTree.JCExpression[] newOdStack() {
        if (this.odStackSupply.isEmpty()) {
            return new JCTree.JCExpression[11];
        }
        return this.odStackSupply.remove(this.odStackSupply.size() - 1);
    }

    private Tokens.Token[] newOpStack() {
        if (this.opStackSupply.isEmpty()) {
            return new Tokens.Token[11];
        }
        return this.opStackSupply.remove(this.opStackSupply.size() - 1);
    }

    protected JCTree.JCExpression term3() {
        JCTree.JCExpression t;
        int pos = this.token.pos;
        List<JCTree.JCExpression> typeArgs = this.typeArgumentsOpt(1);
        block0 : switch (this.token.kind) {
            case QUES: {
                if (this.isMode(2) && this.isMode(8) && !this.isMode(4)) {
                    this.selectTypeMode();
                    return this.typeArgument();
                }
                return this.illegal();
            }
            case PLUSPLUS: 
            case SUBSUB: 
            case BANG: 
            case TILDE: 
            case PLUS: 
            case SUB: {
                if (typeArgs == null && this.isMode(1)) {
                    Tokens.TokenKind tk = this.token.kind;
                    this.nextToken();
                    this.selectExprMode();
                    if (tk == Tokens.TokenKind.SUB && (this.token.kind == Tokens.TokenKind.INTLITERAL || this.token.kind == Tokens.TokenKind.LONGLITERAL) && this.token.radix() == 10) {
                        this.selectExprMode();
                        t = this.literal(this.names.hyphen, pos);
                        break;
                    }
                    JCTree.JCExpression t2 = this.term3();
                    return this.F.at(pos).Unary(JavacParser.unoptag(tk), t2);
                }
                return this.illegal();
            }
            case LPAREN: {
                if (typeArgs == null && this.isMode(1)) {
                    ParensResult pres = this.analyzeParens();
                    switch (pres.ordinal()) {
                        case 0: {
                            this.accept(Tokens.TokenKind.LPAREN);
                            this.selectTypeMode();
                            JCTree.JCExpression t3 = this.parseIntersectionType(pos, this.parseType());
                            this.accept(Tokens.TokenKind.RPAREN);
                            this.selectExprMode();
                            JCTree.JCExpression t1 = this.term3();
                            return this.F.at(pos).TypeCast(t3, t1);
                        }
                        case 1: 
                        case 2: {
                            t = this.lambdaExpressionOrStatement(true, pres == ParensResult.EXPLICIT_LAMBDA, pos);
                            break block0;
                        }
                    }
                    this.accept(Tokens.TokenKind.LPAREN);
                    this.selectExprMode();
                    t = this.termRest(this.term1Rest(this.term2Rest(this.term3(), 4)));
                    this.accept(Tokens.TokenKind.RPAREN);
                    t = this.toP(this.F.at(pos).Parens(t));
                    break;
                }
                return this.illegal();
            }
            case THIS: {
                if (this.isMode(1)) {
                    this.selectExprMode();
                    t = this.to(this.F.at(pos).Ident(this.names._this));
                    this.nextToken();
                    t = typeArgs == null ? this.argumentsOpt(null, t) : this.arguments(typeArgs, t);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case SUPER: {
                if (this.isMode(1)) {
                    this.selectExprMode();
                    t = this.to(this.F.at(pos).Ident(this.names._super));
                    t = this.superSuffix(typeArgs, t);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case INTLITERAL: 
            case LONGLITERAL: 
            case FLOATLITERAL: 
            case DOUBLELITERAL: 
            case CHARLITERAL: 
            case STRINGLITERAL: 
            case TRUE: 
            case FALSE: 
            case NULL: {
                if (typeArgs == null && this.isMode(1)) {
                    this.selectExprMode();
                    t = this.literal(this.names.empty);
                    break;
                }
                return this.illegal();
            }
            case NEW: {
                if (typeArgs != null) {
                    return this.illegal();
                }
                if (this.isMode(1)) {
                    this.selectExprMode();
                    this.nextToken();
                    if (this.token.kind == Tokens.TokenKind.LT) {
                        typeArgs = this.typeArguments(false);
                    }
                    t = this.creator(pos, typeArgs);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case MONKEYS_AT: {
                List<JCTree.JCAnnotation> typeAnnos = this.typeAnnotationsOpt();
                if (typeAnnos.isEmpty()) {
                    throw new AssertionError((Object)"Expected type annotations, but found none!");
                }
                JCTree.JCExpression expr = this.term3();
                if (!this.isMode(2)) {
                    switch (expr.getTag()) {
                        case REFERENCE: {
                            JCTree.JCMemberReference mref = (JCTree.JCMemberReference)expr;
                            mref.expr = this.toP(this.F.at(pos).AnnotatedType(typeAnnos, mref.expr));
                            t = mref;
                            break block0;
                        }
                        case SELECT: {
                            JCTree.JCFieldAccess sel = (JCTree.JCFieldAccess)expr;
                            if (sel.name != this.names._class) {
                                return this.illegal();
                            }
                            this.log.error(this.token.pos, CompilerProperties.Errors.NoAnnotationsOnDotClass);
                            return expr;
                        }
                    }
                    return this.illegal(((JCTree.JCAnnotation)typeAnnos.head).pos);
                }
                t = this.insertAnnotationsToMostInner(expr, typeAnnos, false);
                break;
            }
            case ENUM: 
            case UNDERSCORE: 
            case IDENTIFIER: 
            case ASSERT: {
                if (typeArgs != null) {
                    return this.illegal();
                }
                if (this.isMode(1) && !this.isMode(32) && this.peekToken((Predicate<Tokens.TokenKind>)Tokens.TokenKind.ARROW)) {
                    t = this.lambdaExpressionOrStatement(false, false, pos);
                } else {
                    t = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
                    block39: while (true) {
                        pos = this.token.pos;
                        List<JCTree.JCAnnotation> annos = this.typeAnnotationsOpt();
                        if (!annos.isEmpty() && this.token.kind != Tokens.TokenKind.LBRACKET && this.token.kind != Tokens.TokenKind.ELLIPSIS) {
                            return this.illegal(((JCTree.JCAnnotation)annos.head).pos);
                        }
                        switch (this.token.kind) {
                            case LBRACKET: {
                                this.nextToken();
                                if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                                    this.nextToken();
                                    t = this.bracketsOpt(t);
                                    t = this.toP(this.F.at(pos).TypeArray(t));
                                    if (annos.nonEmpty()) {
                                        t = this.toP(this.F.at(pos).AnnotatedType(annos, t));
                                    }
                                    t = this.bracketsSuffix(t);
                                    break block39;
                                }
                                if (this.isMode(1)) {
                                    this.selectExprMode();
                                    JCTree.JCExpression t1 = this.term();
                                    if (!annos.isEmpty()) {
                                        t = this.illegal(((JCTree.JCAnnotation)annos.head).pos);
                                    }
                                    t = this.to(this.F.at(pos).Indexed(t, t1));
                                }
                                this.accept(Tokens.TokenKind.RBRACKET);
                                break block39;
                            }
                            case LPAREN: {
                                if (this.isMode(1)) {
                                    this.selectExprMode();
                                    t = this.arguments(typeArgs, t);
                                    if (!annos.isEmpty()) {
                                        t = this.illegal(((JCTree.JCAnnotation)annos.head).pos);
                                    }
                                    typeArgs = null;
                                }
                                break block39;
                            }
                            case DOT: {
                                this.nextToken();
                                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && typeArgs != null) {
                                    return this.illegal();
                                }
                                int prevmode = this.mode;
                                this.setMode(this.mode & 0xFFFFFFFB);
                                typeArgs = this.typeArgumentsOpt(1);
                                this.setMode(prevmode);
                                if (this.isMode(1)) {
                                    switch (this.token.kind) {
                                        case CLASS: {
                                            if (typeArgs != null) {
                                                return this.illegal();
                                            }
                                            this.selectExprMode();
                                            t = this.to(this.F.at(pos).Select(t, this.names._class));
                                            this.nextToken();
                                            break block39;
                                        }
                                        case THIS: {
                                            if (typeArgs != null) {
                                                return this.illegal();
                                            }
                                            this.selectExprMode();
                                            t = this.to(this.F.at(pos).Select(t, this.names._this));
                                            this.nextToken();
                                            break block39;
                                        }
                                        case SUPER: {
                                            this.selectExprMode();
                                            t = this.to(this.F.at(pos).Select(t, this.names._super));
                                            t = this.superSuffix(typeArgs, t);
                                            typeArgs = null;
                                            break block39;
                                        }
                                        case NEW: {
                                            if (typeArgs != null) {
                                                return this.illegal();
                                            }
                                            this.selectExprMode();
                                            int pos1 = this.token.pos;
                                            this.nextToken();
                                            if (this.token.kind == Tokens.TokenKind.LT) {
                                                typeArgs = this.typeArguments(false);
                                            }
                                            t = this.innerCreator(pos1, typeArgs, t);
                                            typeArgs = null;
                                            break block39;
                                        }
                                    }
                                }
                                List<JCTree.JCAnnotation> tyannos = null;
                                if (this.isMode(2) && this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
                                    tyannos = this.typeAnnotationsOpt();
                                }
                                t = this.toP(this.F.at(pos).Select(t, this.ident()));
                                if (this.token.pos <= this.endPosTable.errorEndPos && this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
                                    if (typeArgs != null) {
                                        this.illegal();
                                    }
                                    return this.toP(t);
                                }
                                if (tyannos == null || !tyannos.nonEmpty()) continue block39;
                                t = this.toP(this.F.at(((JCTree.JCAnnotation)tyannos.head).pos).AnnotatedType(tyannos, t));
                                continue block39;
                            }
                            case ELLIPSIS: {
                                if (this.permitTypeAnnotationsPushBack) {
                                    this.typeAnnotationsPushedBack = annos;
                                    break block39;
                                }
                                if (annos.nonEmpty()) {
                                    this.illegal(((JCTree.JCAnnotation)annos.head).pos);
                                }
                                break block39;
                            }
                            case LT: {
                                if (!this.isMode(2) && this.isParameterizedTypePrefix()) {
                                    int pos1 = this.token.pos;
                                    this.accept(Tokens.TokenKind.LT);
                                    ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                                    args.append(this.typeArgument());
                                    while (this.token.kind == Tokens.TokenKind.COMMA) {
                                        this.nextToken();
                                        args.append(this.typeArgument());
                                    }
                                    this.accept(Tokens.TokenKind.GT);
                                    t = this.toP(this.F.at(pos1).TypeApply(t, args.toList()));
                                    while (this.token.kind == Tokens.TokenKind.DOT) {
                                        this.nextToken();
                                        this.selectTypeMode();
                                        t = this.toP(this.F.at(this.token.pos).Select(t, this.ident()));
                                        t = this.typeArgumentsOpt(t);
                                    }
                                    t = this.bracketsOpt(t);
                                    if (this.token.kind != Tokens.TokenKind.COLCOL) {
                                        t = this.illegal();
                                    }
                                    this.selectExprMode();
                                    return this.term3Rest(t, typeArgs);
                                }
                                break block39;
                            }
                        }
                        break;
                    }
                }
                if (typeArgs != null) {
                    this.illegal();
                }
                t = this.typeArgumentsOpt(t);
                break;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (typeArgs != null) {
                    this.illegal();
                }
                t = this.bracketsSuffix(this.bracketsOpt(this.basicType()));
                break;
            }
            case VOID: {
                if (typeArgs != null) {
                    this.illegal();
                }
                if (this.isMode(1)) {
                    this.nextToken();
                    if (this.token.kind == Tokens.TokenKind.DOT) {
                        JCTree.JCPrimitiveTypeTree ti = this.toP(this.F.at(pos).TypeIdent(TypeTag.VOID));
                        t = this.bracketsSuffix(ti);
                        break;
                    }
                    return this.illegal(pos);
                }
                JCTree.JCPrimitiveTypeTree ti = this.to(this.F.at(pos).TypeIdent(TypeTag.VOID));
                this.nextToken();
                return ti;
            }
            case SWITCH: {
                this.checkSourceLevel(Source.Feature.SWITCH_EXPRESSION);
                this.allowYieldStatement = true;
                int switchPos = this.token.pos;
                this.nextToken();
                JCTree.JCExpression selector = this.parExpression();
                this.accept(Tokens.TokenKind.LBRACE);
                ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
                block42: while (true) {
                    pos = this.token.pos;
                    switch (this.token.kind) {
                        case CASE: 
                        case DEFAULT: {
                            cases.appendList(this.switchExpressionStatementGroup());
                            continue block42;
                        }
                        case EOF: 
                        case RBRACE: {
                            JCTree.JCSwitchExpression e = this.to(this.F.at(switchPos).SwitchExpression(selector, cases.toList()));
                            e.bracePos = this.token.pos;
                            this.accept(Tokens.TokenKind.RBRACE);
                            return e;
                        }
                    }
                    this.nextToken();
                    this.syntaxError(pos, CompilerProperties.Errors.Expected3(Tokens.TokenKind.CASE, Tokens.TokenKind.DEFAULT, Tokens.TokenKind.RBRACE));
                }
            }
            default: {
                return this.illegal();
            }
        }
        return this.term3Rest(t, typeArgs);
    }

    private List<JCTree.JCCase> switchExpressionStatementGroup() {
        CaseTree.CaseKind kind;
        ListBuffer<JCTree.JCCase> caseExprs = new ListBuffer<JCTree.JCCase>();
        int casePos = this.token.pos;
        ListBuffer<JCTree.JCCaseLabel> pats = new ListBuffer<JCTree.JCCaseLabel>();
        if (this.token.kind == Tokens.TokenKind.DEFAULT) {
            this.nextToken();
            pats.append(this.toP(this.F.at(casePos).DefaultCaseLabel()));
        } else {
            this.accept(Tokens.TokenKind.CASE);
            boolean allowDefault = false;
            while (true) {
                JCTree.JCCaseLabel label = this.parseCaseLabel(allowDefault);
                pats.append(label);
                if (this.token.kind != Tokens.TokenKind.COMMA) break;
                this.checkSourceLevel(Source.Feature.SWITCH_MULTIPLE_CASE_LABELS);
                this.nextToken();
                allowDefault = TreeInfo.isNullCaseLabel(label);
            }
        }
        JCTree.JCExpression guard = this.parseGuard((JCTree.JCCaseLabel)pats.last());
        List<JCTree.JCStatement> stats = null;
        JCTree body = null;
        switch (this.token.kind) {
            case ARROW: {
                this.checkSourceLevel(Source.Feature.SWITCH_RULE);
                this.nextToken();
                if (this.token.kind == Tokens.TokenKind.THROW || this.token.kind == Tokens.TokenKind.LBRACE) {
                    stats = List.of(this.parseStatement());
                    body = (JCTree)stats.head;
                    kind = JCTree.JCCase.RULE;
                    break;
                }
                JCTree.JCExpression value = this.parseExpression();
                stats = List.of((JCTree.JCStatement)this.to(this.F.at(value).Yield(value)));
                body = value;
                kind = JCTree.JCCase.RULE;
                this.accept(Tokens.TokenKind.SEMI);
                break;
            }
            default: {
                this.accept(Tokens.TokenKind.COLON, tk -> CompilerProperties.Errors.Expected2(Tokens.TokenKind.COLON, Tokens.TokenKind.ARROW));
                stats = this.blockStatements();
                kind = JCTree.JCCase.STATEMENT;
            }
        }
        caseExprs.append(this.toP(this.F.at(casePos).Case(kind, pats.toList(), guard, stats, body)));
        return caseExprs.toList();
    }

    JCTree.JCExpression term3Rest(JCTree.JCExpression t, List<JCTree.JCExpression> typeArgs) {
        block21: {
            List<JCTree.JCAnnotation> annos;
            if (typeArgs != null) {
                this.illegal();
            }
            while (true) {
                int pos1 = this.token.pos;
                annos = this.typeAnnotationsOpt();
                if (this.token.kind == Tokens.TokenKind.LBRACKET) {
                    this.nextToken();
                    if (this.isMode(2)) {
                        int prevmode = this.mode;
                        this.selectTypeMode();
                        if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                            this.nextToken();
                            t = this.bracketsOpt(t);
                            t = this.toP(this.F.at(pos1).TypeArray(t));
                            if (this.token.kind == Tokens.TokenKind.COLCOL) {
                                this.selectExprMode();
                                continue;
                            }
                            if (annos.nonEmpty()) {
                                t = this.toP(this.F.at(pos1).AnnotatedType(annos, t));
                            }
                            return t;
                        }
                        this.setMode(prevmode);
                    }
                    if (this.isMode(1)) {
                        this.selectExprMode();
                        JCTree.JCExpression t1 = this.term();
                        t = this.to(this.F.at(pos1).Indexed(t, t1));
                    }
                    this.accept(Tokens.TokenKind.RBRACKET);
                    continue;
                }
                if (this.token.kind == Tokens.TokenKind.DOT) {
                    this.nextToken();
                    typeArgs = this.typeArgumentsOpt(1);
                    if (this.token.kind == Tokens.TokenKind.SUPER && this.isMode(1)) {
                        this.selectExprMode();
                        t = this.to(this.F.at(pos1).Select(t, this.names._super));
                        this.nextToken();
                        t = this.arguments(typeArgs, t);
                        typeArgs = null;
                        continue;
                    }
                    if (this.token.kind == Tokens.TokenKind.NEW && this.isMode(1)) {
                        if (typeArgs != null) {
                            return this.illegal();
                        }
                        this.selectExprMode();
                        int pos2 = this.token.pos;
                        this.nextToken();
                        if (this.token.kind == Tokens.TokenKind.LT) {
                            typeArgs = this.typeArguments(false);
                        }
                        t = this.innerCreator(pos2, typeArgs, t);
                        typeArgs = null;
                        continue;
                    }
                    List<JCTree.JCAnnotation> tyannos = null;
                    if (this.isMode(2) && this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
                        tyannos = this.typeAnnotationsOpt();
                    }
                    t = this.toP(this.F.at(pos1).Select(t, this.ident(true)));
                    if (this.token.pos > this.endPosTable.errorEndPos || this.token.kind != Tokens.TokenKind.MONKEYS_AT) {
                        if (tyannos != null && tyannos.nonEmpty()) {
                            t = this.toP(this.F.at(((JCTree.JCAnnotation)tyannos.head).pos).AnnotatedType(tyannos, t));
                        }
                        t = this.argumentsOpt(typeArgs, this.typeArgumentsOpt(t));
                        typeArgs = null;
                        continue;
                    }
                    break block21;
                }
                if (!this.isMode(1) || this.token.kind != Tokens.TokenKind.COLCOL) break;
                this.selectExprMode();
                if (typeArgs != null) {
                    return this.illegal();
                }
                this.accept(Tokens.TokenKind.COLCOL);
                t = this.memberReferenceSuffix(pos1, t);
            }
            if (!annos.isEmpty()) {
                if (this.permitTypeAnnotationsPushBack) {
                    this.typeAnnotationsPushedBack = annos;
                } else {
                    return this.illegal(((JCTree.JCAnnotation)annos.head).pos);
                }
            }
        }
        while ((this.token.kind == Tokens.TokenKind.PLUSPLUS || this.token.kind == Tokens.TokenKind.SUBSUB) && this.isMode(1)) {
            this.selectExprMode();
            t = this.to(this.F.at(this.token.pos).Unary(this.token.kind == Tokens.TokenKind.PLUSPLUS ? JCTree.Tag.POSTINC : JCTree.Tag.POSTDEC, t));
            this.nextToken();
        }
        return this.toP(t);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean isParameterizedTypePrefix() {
        int pos = 0;
        int depth = 0;
        Tokens.Token t = this.S.token(pos);
        while (true) {
            block0 : switch (t.kind) {
                case MONKEYS_AT: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case UNDERSCORE: 
                case IDENTIFIER: 
                case SUPER: 
                case LBRACKET: 
                case DOT: 
                case QUES: 
                case EXTENDS: 
                case RBRACKET: 
                case COMMA: {
                    break;
                }
                case LPAREN: {
                    int nesting = 0;
                    while (true) {
                        Tokens.TokenKind tk2 = this.S.token((int)pos).kind;
                        switch (tk2) {
                            case EOF: {
                                return false;
                            }
                            case LPAREN: {
                                ++nesting;
                                break;
                            }
                            case RPAREN: {
                                if (--nesting == 0) break block0;
                            }
                        }
                        ++pos;
                    }
                }
                case LT: {
                    ++depth;
                    break;
                }
                case GTGTGT: {
                    --depth;
                }
                case GTGT: {
                    --depth;
                }
                case GT: {
                    if (--depth != 0) break;
                    Tokens.TokenKind nextKind = this.S.token((int)(pos + 1)).kind;
                    if (nextKind == Tokens.TokenKind.DOT) return true;
                    if (nextKind == Tokens.TokenKind.LBRACKET) return true;
                    if (nextKind == Tokens.TokenKind.COLCOL) return true;
                    return false;
                }
                default: {
                    return false;
                }
            }
            t = this.S.token(++pos);
        }
    }

    ParensResult analyzeParens() {
        int depth = 0;
        boolean type = false;
        ParensResult defaultResult = ParensResult.PARENS;
        int lookahead = 0;
        while (true) {
            Tokens.TokenKind tk = this.S.token((int)lookahead).kind;
            switch (tk) {
                case COMMA: {
                    type = true;
                }
                case SUPER: 
                case DOT: 
                case EXTENDS: 
                case AMP: {
                    break;
                }
                case QUES: {
                    if (!this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.EXTENDS) && !this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.SUPER)) break;
                    type = true;
                    break;
                }
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: {
                    if (this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN)) {
                        return ParensResult.CAST;
                    }
                    if (!this.peekToken(lookahead, this.LAX_IDENTIFIER)) break;
                    return ParensResult.EXPLICIT_LAMBDA;
                }
                case LPAREN: {
                    if (lookahead != 0) {
                        return ParensResult.PARENS;
                    }
                    if (!this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN)) break;
                    return ParensResult.EXPLICIT_LAMBDA;
                }
                case RPAREN: {
                    if (type) {
                        return ParensResult.CAST;
                    }
                    switch (this.S.token((int)(lookahead + 1)).kind) {
                        case ENUM: 
                        case BYTE: 
                        case SHORT: 
                        case CHAR: 
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case BOOLEAN: 
                        case VOID: 
                        case UNDERSCORE: 
                        case IDENTIFIER: 
                        case SWITCH: 
                        case THIS: 
                        case SUPER: 
                        case NEW: 
                        case ASSERT: 
                        case INTLITERAL: 
                        case LONGLITERAL: 
                        case FLOATLITERAL: 
                        case DOUBLELITERAL: 
                        case CHARLITERAL: 
                        case STRINGLITERAL: 
                        case TRUE: 
                        case FALSE: 
                        case NULL: 
                        case LPAREN: 
                        case BANG: 
                        case TILDE: 
                        case STRINGFRAGMENT: {
                            return ParensResult.CAST;
                        }
                    }
                    return defaultResult;
                }
                case ENUM: 
                case UNDERSCORE: 
                case IDENTIFIER: 
                case ASSERT: {
                    if (this.peekToken(lookahead, this.LAX_IDENTIFIER)) {
                        return ParensResult.EXPLICIT_LAMBDA;
                    }
                    if (this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.ARROW)) {
                        return !this.isMode(32) ? ParensResult.IMPLICIT_LAMBDA : ParensResult.PARENS;
                    }
                    if (depth == 0 && this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.COMMA)) {
                        defaultResult = ParensResult.IMPLICIT_LAMBDA;
                    }
                    type = false;
                    break;
                }
                case FINAL: 
                case ELLIPSIS: {
                    return ParensResult.EXPLICIT_LAMBDA;
                }
                case MONKEYS_AT: {
                    type = true;
                    lookahead = this.skipAnnotation(lookahead);
                    break;
                }
                case LBRACKET: {
                    if (this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, this.LAX_IDENTIFIER)) {
                        return ParensResult.EXPLICIT_LAMBDA;
                    }
                    if (this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN) || this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.AMP)) {
                        return ParensResult.CAST;
                    }
                    if (this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET)) {
                        type = true;
                        ++lookahead;
                        break;
                    }
                    return ParensResult.PARENS;
                }
                case LT: {
                    ++depth;
                    break;
                }
                case GTGTGT: {
                    --depth;
                }
                case GTGT: {
                    --depth;
                }
                case GT: {
                    if (--depth == 0) {
                        if (this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN) || this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.AMP)) {
                            return ParensResult.CAST;
                        }
                        if (this.peekToken(lookahead, this.LAX_IDENTIFIER, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.COMMA) || this.peekToken(lookahead, this.LAX_IDENTIFIER, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RPAREN, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.ARROW) || this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.ELLIPSIS)) {
                            return ParensResult.EXPLICIT_LAMBDA;
                        }
                        type = true;
                        break;
                    }
                    if (depth >= 0) break;
                    return ParensResult.PARENS;
                }
                default: {
                    return defaultResult;
                }
            }
            ++lookahead;
        }
    }

    private int skipAnnotation(int lookahead) {
        ++lookahead;
        while (this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.DOT)) {
            lookahead += 2;
        }
        if (this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.LPAREN)) {
            ++lookahead;
            int nesting = 0;
            while (true) {
                Tokens.TokenKind tk2 = this.S.token((int)lookahead).kind;
                switch (tk2) {
                    case EOF: {
                        return lookahead;
                    }
                    case LPAREN: {
                        ++nesting;
                        break;
                    }
                    case RPAREN: {
                        if (--nesting != 0) break;
                        return lookahead;
                    }
                }
                ++lookahead;
            }
        }
        return lookahead;
    }

    JCTree.JCExpression lambdaExpressionOrStatement(boolean hasParens, boolean explicitParams, int pos) {
        List<JCTree.JCVariableDecl> params;
        List<JCTree.JCVariableDecl> list = params = explicitParams ? this.formalParameters(true, false) : this.implicitParameters(hasParens);
        if (explicitParams) {
            LambdaClassifier lambdaClassifier = new LambdaClassifier();
            for (JCTree.JCVariableDecl param : params) {
                Name restrictedTypeName;
                if (param.vartype != null && (restrictedTypeName = this.restrictedTypeName(param.vartype, false)) != null && param.vartype.hasTag(JCTree.Tag.TYPEARRAY)) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, param.pos, Source.Feature.VAR_SYNTAX_IMPLICIT_LAMBDAS.allowedInSource(this.source) ? CompilerProperties.Errors.RestrictedTypeNotAllowedArray(restrictedTypeName) : CompilerProperties.Errors.RestrictedTypeNotAllowedHere(restrictedTypeName));
                }
                lambdaClassifier.addParameter(param);
                if (lambdaClassifier.result() != LambdaParameterKind.ERROR) continue;
                break;
            }
            if (lambdaClassifier.diagFragment != null) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, pos, CompilerProperties.Errors.InvalidLambdaParameterDeclaration(lambdaClassifier.diagFragment));
            }
            for (JCTree.JCVariableDecl param : params) {
                if (param.vartype == null || this.restrictedTypeName(param.vartype, true) == null) continue;
                this.checkSourceLevel(param.pos, Source.Feature.VAR_SYNTAX_IMPLICIT_LAMBDAS);
                param.startPos = TreeInfo.getStartPos(param.vartype);
                param.vartype = null;
            }
        }
        return this.lambdaExpressionOrStatementRest(params, pos);
    }

    JCTree.JCExpression lambdaExpressionOrStatementRest(List<JCTree.JCVariableDecl> args, int pos) {
        this.accept(Tokens.TokenKind.ARROW);
        return this.token.kind == Tokens.TokenKind.LBRACE ? this.lambdaStatement(args, pos, this.token.pos) : this.lambdaExpression(args, pos);
    }

    JCTree.JCExpression lambdaStatement(List<JCTree.JCVariableDecl> args, int pos, int pos2) {
        JCTree.JCBlock block = this.block(pos2, 0L);
        return this.toP(this.F.at(pos).Lambda(args, block));
    }

    JCTree.JCExpression lambdaExpression(List<JCTree.JCVariableDecl> args, int pos) {
        JCTree.JCExpression expr = this.parseExpression();
        return this.toP(this.F.at(pos).Lambda(args, expr));
    }

    JCTree.JCExpression superSuffix(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        this.nextToken();
        if (this.token.kind == Tokens.TokenKind.LPAREN || typeArgs != null) {
            t = this.arguments(typeArgs, t);
        } else if (this.token.kind == Tokens.TokenKind.COLCOL) {
            if (typeArgs != null) {
                return this.illegal();
            }
            t = this.memberReferenceSuffix(t);
        } else {
            int pos = this.token.pos;
            this.accept(Tokens.TokenKind.DOT);
            typeArgs = this.token.kind == Tokens.TokenKind.LT ? this.typeArguments(false) : null;
            t = this.toP(this.F.at(pos).Select(t, this.ident()));
            t = this.argumentsOpt(typeArgs, t);
        }
        return t;
    }

    JCTree.JCPrimitiveTypeTree basicType() {
        JCTree.JCPrimitiveTypeTree t = this.to(this.F.at(this.token.pos).TypeIdent(JavacParser.typetag(this.token.kind)));
        this.nextToken();
        return t;
    }

    JCTree.JCExpression argumentsOpt(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        if (this.isMode(1) && this.token.kind == Tokens.TokenKind.LPAREN || typeArgs != null) {
            this.selectExprMode();
            return this.arguments(typeArgs, t);
        }
        return t;
    }

    List<JCTree.JCExpression> arguments() {
        ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind == Tokens.TokenKind.LPAREN) {
            this.nextToken();
            if (this.token.kind != Tokens.TokenKind.RPAREN) {
                args.append(this.parseExpression());
                while (this.token.kind == Tokens.TokenKind.COMMA) {
                    this.nextToken();
                    args.append(this.parseExpression());
                }
            }
            this.accept(Tokens.TokenKind.RPAREN, tk -> CompilerProperties.Errors.Expected2(Tokens.TokenKind.RPAREN, Tokens.TokenKind.COMMA));
        } else {
            this.syntaxError(this.token.pos, CompilerProperties.Errors.Expected(Tokens.TokenKind.LPAREN));
        }
        return args.toList();
    }

    JCTree.JCExpression arguments(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        int pos = this.token.pos;
        List<JCTree.JCExpression> args = this.arguments();
        JCTree.JCExpression mi = this.F.at(pos).Apply(typeArgs, t, args);
        if (t.hasTag(JCTree.Tag.IDENT) && this.isInvalidUnqualifiedMethodIdentifier(((JCTree.JCIdent)t).pos, ((JCTree.JCIdent)t).name)) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, t, CompilerProperties.Errors.InvalidYield);
            mi = this.F.Erroneous(List.of(mi));
        }
        return this.toP(mi);
    }

    boolean isInvalidUnqualifiedMethodIdentifier(int pos, Name name) {
        if (name == this.names.yield) {
            if (this.allowYieldStatement) {
                return true;
            }
            this.log.warning(pos, CompilerProperties.Warnings.InvalidYield);
        }
        return false;
    }

    JCTree.JCExpression typeArgumentsOpt(JCTree.JCExpression t) {
        if (this.token.kind == Tokens.TokenKind.LT && this.isMode(2) && !this.isMode(4)) {
            this.selectTypeMode();
            return this.typeArguments(t, false);
        }
        return t;
    }

    List<JCTree.JCExpression> typeArgumentsOpt() {
        return this.typeArgumentsOpt(2);
    }

    List<JCTree.JCExpression> typeArgumentsOpt(int useMode) {
        if (this.token.kind == Tokens.TokenKind.LT) {
            if (!this.isMode(useMode) || this.isMode(4)) {
                this.illegal();
            }
            this.setMode(useMode);
            return this.typeArguments(false);
        }
        return null;
    }

    List<JCTree.JCExpression> typeArguments(boolean diamondAllowed) {
        if (this.token.kind == Tokens.TokenKind.LT) {
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.GT && diamondAllowed) {
                this.setMode(this.mode | 0x10);
                this.nextToken();
                return List.nil();
            }
            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
            args.append(!this.isMode(1) ? this.typeArgument() : this.parseType());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                args.append(!this.isMode(1) ? this.typeArgument() : this.parseType());
            }
            switch (this.token.kind) {
                case GTGTEQ: 
                case GTGTGTEQ: 
                case GTGTGT: 
                case GTGT: 
                case GTEQ: {
                    this.token = this.S.split();
                    break;
                }
                case GT: {
                    this.nextToken();
                    break;
                }
                default: {
                    args.append(this.syntaxError(this.token.pos, CompilerProperties.Errors.Expected2(Tokens.TokenKind.GT, Tokens.TokenKind.COMMA)));
                }
            }
            return args.toList();
        }
        return List.of(this.syntaxError(this.token.pos, CompilerProperties.Errors.Expected(Tokens.TokenKind.LT)));
    }

    JCTree.JCExpression typeArgument() {
        JCTree.JCExpression result;
        List<JCTree.JCAnnotation> annotations = this.typeAnnotationsOpt();
        if (this.token.kind != Tokens.TokenKind.QUES) {
            return this.parseType(false, annotations);
        }
        int pos = this.token.pos;
        this.nextToken();
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            JCTree.TypeBoundKind t = this.to(this.F.at(pos).TypeBoundKind(BoundKind.EXTENDS));
            this.nextToken();
            JCTree.JCExpression bound = this.parseType();
            result = this.F.at(pos).Wildcard(t, bound);
        } else if (this.token.kind == Tokens.TokenKind.SUPER) {
            JCTree.TypeBoundKind t = this.to(this.F.at(pos).TypeBoundKind(BoundKind.SUPER));
            this.nextToken();
            JCTree.JCExpression bound = this.parseType();
            result = this.F.at(pos).Wildcard(t, bound);
        } else if (this.LAX_IDENTIFIER.test(this.token.kind)) {
            JCTree.TypeBoundKind t = this.F.at(-1).TypeBoundKind(BoundKind.UNBOUND);
            JCTree.JCExpression wc = this.toP(this.F.at(pos).Wildcard(t, null));
            JCTree.JCIdent id = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
            JCTree.JCErroneous err = this.F.at(pos).Erroneous(List.of(wc, id));
            this.reportSyntaxError(err, CompilerProperties.Errors.Expected3(Tokens.TokenKind.GT, Tokens.TokenKind.EXTENDS, Tokens.TokenKind.SUPER));
            result = err;
        } else {
            JCTree.TypeBoundKind t = this.toP(this.F.at(pos).TypeBoundKind(BoundKind.UNBOUND));
            result = this.toP(this.F.at(pos).Wildcard(t, null));
        }
        if (!annotations.isEmpty()) {
            result = this.toP(this.F.at(((JCTree.JCAnnotation)annotations.head).pos).AnnotatedType(annotations, result));
        }
        return result;
    }

    JCTree.JCTypeApply typeArguments(JCTree.JCExpression t, boolean diamondAllowed) {
        int pos = this.token.pos;
        List<JCTree.JCExpression> args = this.typeArguments(diamondAllowed);
        return this.toP(this.F.at(pos).TypeApply(t, args));
    }

    private JCTree.JCExpression bracketsOpt(JCTree.JCExpression t, List<JCTree.JCAnnotation> annotations) {
        List<JCTree.JCAnnotation> nextLevelAnnotations = this.typeAnnotationsOpt();
        if (this.token.kind == Tokens.TokenKind.LBRACKET) {
            int pos = this.token.pos;
            this.nextToken();
            t = this.bracketsOptCont(t, pos, nextLevelAnnotations);
        } else if (!nextLevelAnnotations.isEmpty()) {
            if (this.permitTypeAnnotationsPushBack) {
                this.typeAnnotationsPushedBack = nextLevelAnnotations;
            } else {
                return this.illegal(((JCTree.JCAnnotation)nextLevelAnnotations.head).pos);
            }
        }
        if (!annotations.isEmpty()) {
            t = this.toP(this.F.at(this.token.pos).AnnotatedType(annotations, t));
        }
        return t;
    }

    private JCTree.JCExpression bracketsOpt(JCTree.JCExpression t) {
        return this.bracketsOpt(t, List.nil());
    }

    private JCTree.JCExpression bracketsOptCont(JCTree.JCExpression t, int pos, List<JCTree.JCAnnotation> annotations) {
        this.accept(Tokens.TokenKind.RBRACKET);
        t = this.bracketsOpt(t);
        t = this.toP(this.F.at(pos).TypeArray(t));
        if (annotations.nonEmpty()) {
            t = this.toP(this.F.at(pos).AnnotatedType(annotations, t));
        }
        return t;
    }

    JCTree.JCExpression bracketsSuffix(JCTree.JCExpression t) {
        if (this.isMode(1) && this.token.kind == Tokens.TokenKind.DOT) {
            this.selectExprMode();
            int pos = this.token.pos;
            this.nextToken();
            this.accept(Tokens.TokenKind.CLASS);
            if (this.token.pos == this.endPosTable.errorEndPos) {
                Name name;
                if (this.LAX_IDENTIFIER.test(this.token.kind)) {
                    name = this.token.name();
                    this.nextToken();
                } else {
                    name = this.names.error;
                }
                t = this.F.at(pos).Erroneous(List.of(this.toP(this.F.at(pos).Select(t, name))));
            } else {
                JCTree.Tag tag = t.getTag();
                if (tag == JCTree.Tag.TYPEARRAY && TreeInfo.containsTypeAnnotation(t) || tag == JCTree.Tag.ANNOTATED_TYPE) {
                    this.syntaxError(this.token.pos, CompilerProperties.Errors.NoAnnotationsOnDotClass);
                }
                t = this.toP(this.F.at(pos).Select(t, this.names._class));
            }
        } else if (this.isMode(2)) {
            if (this.token.kind != Tokens.TokenKind.COLCOL) {
                this.selectTypeMode();
            }
        } else if (this.token.kind != Tokens.TokenKind.COLCOL) {
            this.syntaxError(this.token.pos, CompilerProperties.Errors.DotClassExpected);
        }
        return t;
    }

    JCTree.JCExpression memberReferenceSuffix(JCTree.JCExpression t) {
        int pos1 = this.token.pos;
        this.accept(Tokens.TokenKind.COLCOL);
        return this.memberReferenceSuffix(pos1, t);
    }

    JCTree.JCExpression memberReferenceSuffix(int pos1, JCTree.JCExpression t) {
        Name refName;
        MemberReferenceTree.ReferenceMode refMode;
        this.selectExprMode();
        List<JCTree.JCExpression> typeArgs = null;
        if (this.token.kind == Tokens.TokenKind.LT) {
            typeArgs = this.typeArguments(false);
        }
        if (this.token.kind == Tokens.TokenKind.NEW) {
            refMode = MemberReferenceTree.ReferenceMode.NEW;
            refName = this.names.init;
            this.nextToken();
        } else {
            refMode = MemberReferenceTree.ReferenceMode.INVOKE;
            refName = this.ident();
        }
        return this.toP(this.F.at(t.getStartPosition()).Reference(refMode, refName, t, typeArgs));
    }

    JCTree.JCExpression creator(int newpos, List<JCTree.JCExpression> typeArgs) {
        List<JCTree.JCAnnotation> newAnnotations = this.typeAnnotationsOpt();
        switch (this.token.kind) {
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (typeArgs != null) break;
                if (newAnnotations.isEmpty()) {
                    return this.arrayCreatorRest(newpos, this.basicType());
                }
                return this.arrayCreatorRest(newpos, this.toP(this.F.at(((JCTree.JCAnnotation)newAnnotations.head).pos).AnnotatedType(newAnnotations, this.basicType())));
            }
        }
        JCTree.JCExpression t = this.qualident(true);
        int prevmode = this.mode;
        this.selectTypeMode();
        boolean diamondFound = false;
        int lastTypeargsPos = -1;
        if (this.token.kind == Tokens.TokenKind.LT) {
            lastTypeargsPos = this.token.pos;
            t = this.typeArguments(t, true);
            diamondFound = this.isMode(16);
        }
        while (this.token.kind == Tokens.TokenKind.DOT) {
            if (diamondFound) {
                this.illegal();
            }
            int pos = this.token.pos;
            this.nextToken();
            List<JCTree.JCAnnotation> tyannos = this.typeAnnotationsOpt();
            t = this.toP(this.F.at(pos).Select(t, this.ident()));
            if (tyannos != null && tyannos.nonEmpty()) {
                t = this.toP(this.F.at(((JCTree.JCAnnotation)tyannos.head).pos).AnnotatedType(tyannos, t));
            }
            if (this.token.kind != Tokens.TokenKind.LT) continue;
            lastTypeargsPos = this.token.pos;
            t = this.typeArguments(t, true);
            diamondFound = this.isMode(16);
        }
        this.setMode(prevmode);
        if (this.token.kind == Tokens.TokenKind.LBRACKET || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            if (newAnnotations.nonEmpty()) {
                t = this.insertAnnotationsToMostInner(t, newAnnotations, false);
            }
            JCTree.JCExpression e = this.arrayCreatorRest(newpos, t);
            if (diamondFound) {
                this.reportSyntaxError(lastTypeargsPos, CompilerProperties.Errors.CannotCreateArrayWithDiamond);
                return this.toP(this.F.at(newpos).Erroneous(List.of(e)));
            }
            if (typeArgs != null) {
                int pos = newpos;
                if (!typeArgs.isEmpty() && ((JCTree.JCExpression)typeArgs.head).pos != -1) {
                    pos = ((JCTree.JCExpression)typeArgs.head).pos;
                }
                this.setErrorEndPos(this.S.prevToken().endPos);
                JCTree.JCErroneous err = this.F.at(pos).Erroneous(typeArgs.prepend(e));
                this.reportSyntaxError(err, CompilerProperties.Errors.CannotCreateArrayWithTypeArguments);
                return this.toP(err);
            }
            return e;
        }
        if (this.token.kind == Tokens.TokenKind.LPAREN) {
            if (newAnnotations.nonEmpty()) {
                t = this.insertAnnotationsToMostInner(t, newAnnotations, false);
            }
            return this.classCreatorRest(newpos, null, typeArgs, t);
        }
        this.setErrorEndPos(this.token.pos);
        this.reportSyntaxError(this.token.pos, CompilerProperties.Errors.Expected2(Tokens.TokenKind.LPAREN, Tokens.TokenKind.LBRACKET));
        t = this.toP(this.F.at(newpos).NewClass(null, typeArgs, t, List.nil(), null));
        return this.toP(this.F.at(newpos).Erroneous(List.of(t)));
    }

    JCTree.JCExpression innerCreator(int newpos, List<JCTree.JCExpression> typeArgs, JCTree.JCExpression encl) {
        List<JCTree.JCAnnotation> newAnnotations = this.typeAnnotationsOpt();
        JCTree.JCExpression t = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
        if (newAnnotations.nonEmpty()) {
            t = this.toP(this.F.at(((JCTree.JCAnnotation)newAnnotations.head).pos).AnnotatedType(newAnnotations, t));
        }
        if (this.token.kind == Tokens.TokenKind.LT) {
            int prevmode = this.mode;
            t = this.typeArguments(t, true);
            this.setMode(prevmode);
        }
        return this.classCreatorRest(newpos, encl, typeArgs, t);
    }

    JCTree.JCExpression arrayCreatorRest(int newpos, JCTree.JCExpression elemtype) {
        List<JCTree.JCAnnotation> annos = this.typeAnnotationsOpt();
        this.accept(Tokens.TokenKind.LBRACKET);
        if (this.token.kind == Tokens.TokenKind.RBRACKET) {
            this.accept(Tokens.TokenKind.RBRACKET);
            elemtype = this.bracketsOpt(elemtype, annos);
            if (this.token.kind == Tokens.TokenKind.LBRACE) {
                JCTree.JCNewArray na = (JCTree.JCNewArray)this.arrayInitializer(newpos, elemtype);
                if (annos.nonEmpty()) {
                    JCTree.JCAnnotatedType annotated = (JCTree.JCAnnotatedType)elemtype;
                    assert (annotated.annotations == annos);
                    na.annotations = annotated.annotations;
                    na.elemtype = annotated.underlyingType;
                }
                return na;
            }
            JCTree.JCExpression t = this.toP(this.F.at(newpos).NewArray(elemtype, List.nil(), null));
            return this.syntaxError(this.token.pos, List.of(t), CompilerProperties.Errors.ArrayDimensionMissing);
        }
        ListBuffer<JCTree.JCExpression> dims = new ListBuffer<JCTree.JCExpression>();
        ListBuffer<List<JCTree.JCAnnotation>> dimAnnotations = new ListBuffer<List<JCTree.JCAnnotation>>();
        dimAnnotations.append(annos);
        dims.append(this.parseExpression());
        this.accept(Tokens.TokenKind.RBRACKET);
        while (this.token.kind == Tokens.TokenKind.LBRACKET || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            List<JCTree.JCAnnotation> maybeDimAnnos = this.typeAnnotationsOpt();
            int pos = this.token.pos;
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.RBRACKET) {
                elemtype = this.bracketsOptCont(elemtype, pos, maybeDimAnnos);
                continue;
            }
            dimAnnotations.append(maybeDimAnnos);
            dims.append(this.parseExpression());
            this.accept(Tokens.TokenKind.RBRACKET);
        }
        List<JCTree.JCExpression> elems = null;
        int errpos = this.token.pos;
        if (this.token.kind == Tokens.TokenKind.LBRACE) {
            elems = this.arrayInitializerElements(newpos, elemtype);
        }
        JCTree.JCNewArray na = this.toP(this.F.at(newpos).NewArray(elemtype, dims.toList(), elems));
        na.dimAnnotations = dimAnnotations.toList();
        if (elems != null) {
            return this.syntaxError(errpos, List.of(na), CompilerProperties.Errors.IllegalArrayCreationBothDimensionAndInitialization);
        }
        return na;
    }

    JCTree.JCNewClass classCreatorRest(int newpos, JCTree.JCExpression encl, List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        List<JCTree.JCExpression> args = this.arguments();
        JCTree.JCClassDecl body = null;
        if (this.token.kind == Tokens.TokenKind.LBRACE) {
            this.ignoreDanglingComments();
            int pos = this.token.pos;
            List<JCTree> defs = this.classInterfaceOrRecordBody(this.names.empty, false, false);
            JCTree.JCModifiers mods = this.F.at(-1).Modifiers(0L);
            body = this.toP(this.F.at(pos).AnonymousClassDef(mods, defs));
        }
        return this.toP(this.F.at(newpos).NewClass(encl, typeArgs, t, args, body));
    }

    JCTree.JCExpression arrayInitializer(int newpos, JCTree.JCExpression t) {
        List<JCTree.JCExpression> elems = this.arrayInitializerElements(newpos, t);
        return this.toP(this.F.at(newpos).NewArray(t, List.nil(), elems));
    }

    List<JCTree.JCExpression> arrayInitializerElements(int newpos, JCTree.JCExpression t) {
        this.accept(Tokens.TokenKind.LBRACE);
        ListBuffer<JCTree.JCExpression> elems = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
        } else if (this.token.kind != Tokens.TokenKind.RBRACE) {
            elems.append(this.variableInitializer());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                if (this.token.kind == Tokens.TokenKind.RBRACE) break;
                elems.append(this.variableInitializer());
            }
        }
        this.accept(Tokens.TokenKind.RBRACE);
        return elems.toList();
    }

    public JCTree.JCExpression variableInitializer() {
        return this.token.kind == Tokens.TokenKind.LBRACE ? this.arrayInitializer(this.token.pos, null) : this.parseExpression();
    }

    JCTree.JCExpression parExpression() {
        int pos = this.token.pos;
        this.accept(Tokens.TokenKind.LPAREN);
        JCTree.JCExpression t = this.parseExpression();
        this.accept(Tokens.TokenKind.RPAREN);
        return this.toP(this.F.at(pos).Parens(t));
    }

    JCTree.JCBlock block(int pos, long flags) {
        this.accept(Tokens.TokenKind.LBRACE);
        this.ignoreDanglingComments();
        List<JCTree.JCStatement> stats = this.blockStatements();
        JCTree.JCBlock t = this.F.at(pos).Block(flags, stats);
        while (this.token.kind == Tokens.TokenKind.CASE || this.token.kind == Tokens.TokenKind.DEFAULT) {
            this.syntaxError(this.token.pos, CompilerProperties.Errors.Orphaned(this.token.kind));
            this.switchBlockStatementGroups();
        }
        t.bracePos = this.token.pos;
        this.accept(Tokens.TokenKind.RBRACE);
        return this.toP(t);
    }

    public JCTree.JCBlock block() {
        return this.block(this.token.pos, 0L);
    }

    List<JCTree.JCStatement> blockStatements() {
        int lastErrPos = -1;
        ListBuffer<JCTree.JCStatement> stats = new ListBuffer<JCTree.JCStatement>();
        while (true) {
            List<JCTree.JCStatement> stat = this.blockStatement();
            this.ignoreDanglingComments();
            if (stat.isEmpty()) {
                return stats.toList();
            }
            if (this.token.pos == lastErrPos) {
                return stats.toList();
            }
            if (this.token.pos <= this.endPosTable.errorEndPos) {
                this.skip(false, true, true, true);
                lastErrPos = this.token.pos;
            }
            stats.addAll((Collection<JCTree.JCStatement>)stat);
        }
    }

    JCTree.JCStatement parseStatementAsBlock() {
        int pos = this.token.pos;
        List<JCTree.JCStatement> stats = this.blockStatement();
        if (stats.isEmpty()) {
            JCTree.JCErroneous e = this.syntaxError(pos, CompilerProperties.Errors.IllegalStartOfStmt);
            return this.toP(this.F.at(pos).Exec(e));
        }
        JCTree.JCStatement first = (JCTree.JCStatement)stats.head;
        JCDiagnostic.Error error = null;
        switch (first.getTag()) {
            case CLASSDEF: {
                error = CompilerProperties.Errors.ClassNotAllowed;
                break;
            }
            case VARDEF: {
                error = CompilerProperties.Errors.VariableNotAllowed;
            }
        }
        if (error != null) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, first, error);
            List<JCTree.JCBlock> blist = List.of(this.F.at(first.pos).Block(0L, stats));
            return this.toP(this.F.at(pos).Exec(this.F.at(first.pos).Erroneous(blist)));
        }
        return first;
    }

    List<JCTree.JCStatement> blockStatement() {
        int pos = this.token.pos;
        switch (this.token.kind) {
            case EOF: 
            case RBRACE: 
            case CASE: 
            case DEFAULT: {
                return List.nil();
            }
            case SEMI: 
            case LBRACE: 
            case SYNCHRONIZED: 
            case IF: 
            case FOR: 
            case WHILE: 
            case DO: 
            case TRY: 
            case SWITCH: 
            case RETURN: 
            case THROW: 
            case BREAK: 
            case CONTINUE: 
            case ELSE: 
            case FINALLY: 
            case CATCH: 
            case ASSERT: {
                return List.of(this.parseSimpleStatement());
            }
            case FINAL: 
            case MONKEYS_AT: {
                Tokens.Comment dc = this.token.docComment();
                JCTree.JCModifiers mods = this.modifiersOpt();
                if (this.isDeclaration()) {
                    return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(mods, dc));
                }
                JCTree.JCExpression t = this.parseType(true);
                return this.localVariableDeclarations(mods, t, dc);
            }
            case ABSTRACT: 
            case STRICTFP: {
                Tokens.Comment dc = this.token.docComment();
                JCTree.JCModifiers mods = this.modifiersOpt();
                return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(mods, dc));
            }
            case CLASS: 
            case INTERFACE: {
                Tokens.Comment dc = this.token.docComment();
                return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(this.modifiersOpt(), dc));
            }
            case ENUM: {
                if (!this.allowRecords) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.LocalEnum);
                }
                Tokens.Comment dc = this.token.docComment();
                return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(this.modifiersOpt(), dc));
            }
            case IDENTIFIER: {
                if (this.token.name() == this.names.yield && this.allowYieldStatement) {
                    Tokens.Token next = this.S.token(1);
                    if (!(switch (next.kind) {
                        case Tokens.TokenKind.BYTE, Tokens.TokenKind.SHORT, Tokens.TokenKind.CHAR, Tokens.TokenKind.INT, Tokens.TokenKind.LONG, Tokens.TokenKind.FLOAT, Tokens.TokenKind.DOUBLE, Tokens.TokenKind.BOOLEAN, Tokens.TokenKind.VOID, Tokens.TokenKind.UNDERSCORE, Tokens.TokenKind.IDENTIFIER, Tokens.TokenKind.SWITCH, Tokens.TokenKind.THIS, Tokens.TokenKind.SUPER, Tokens.TokenKind.NEW, Tokens.TokenKind.INTLITERAL, Tokens.TokenKind.LONGLITERAL, Tokens.TokenKind.FLOATLITERAL, Tokens.TokenKind.DOUBLELITERAL, Tokens.TokenKind.CHARLITERAL, Tokens.TokenKind.STRINGLITERAL, Tokens.TokenKind.TRUE, Tokens.TokenKind.FALSE, Tokens.TokenKind.NULL, Tokens.TokenKind.PLUS, Tokens.TokenKind.SUB, Tokens.TokenKind.STRINGFRAGMENT -> true;
                        case Tokens.TokenKind.PLUSPLUS, Tokens.TokenKind.SUBSUB -> this.S.token((int)2).kind != Tokens.TokenKind.SEMI;
                        case Tokens.TokenKind.BANG, Tokens.TokenKind.TILDE -> this.S.token((int)1).kind != Tokens.TokenKind.SEMI;
                        case Tokens.TokenKind.LPAREN -> {
                            Tokens.Token l;
                            int lookahead = 2;
                            int balance = 1;
                            boolean hasComma = false;
                            boolean inTypeArgs = false;
                            while (true) {
                                l = this.S.token(lookahead);
                                if (l.kind == Tokens.TokenKind.EOF || balance == 0) break;
                                switch (l.kind) {
                                    case LPAREN: {
                                        ++balance;
                                        break;
                                    }
                                    case RPAREN: {
                                        --balance;
                                        break;
                                    }
                                    case COMMA: {
                                        if (balance != 1 || inTypeArgs) break;
                                        hasComma = true;
                                        break;
                                    }
                                    case LT: {
                                        inTypeArgs = true;
                                        break;
                                    }
                                    case GT: {
                                        inTypeArgs = false;
                                    }
                                }
                                ++lookahead;
                            }
                            yield !hasComma && lookahead != 3 || l.kind == Tokens.TokenKind.ARROW;
                        }
                        case Tokens.TokenKind.SEMI -> true;
                        default -> false;
                    })) break;
                    this.nextToken();
                    JCTree.JCExpression t = this.term(1);
                    this.accept(Tokens.TokenKind.SEMI);
                    return List.of((JCTree.JCStatement)this.toP(this.F.at(pos).Yield(t)));
                }
                if (this.isNonSealedClassStart(true)) {
                    this.log.error(this.token.pos, CompilerProperties.Errors.SealedOrNonSealedLocalClassesNotAllowed);
                    this.nextToken();
                    this.nextToken();
                    this.nextToken();
                    return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.token.docComment()));
                }
                if (!this.isSealedClassStart(true)) break;
                this.checkSourceLevel(Source.Feature.SEALED_CLASSES);
                this.log.error(this.token.pos, CompilerProperties.Errors.SealedOrNonSealedLocalClassesNotAllowed);
                this.nextToken();
                return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.token.docComment()));
            }
        }
        if (this.isValueModifier() && this.allowValueClasses) {
            this.checkSourceLevel(Source.Feature.VALUE_CLASSES);
            Tokens.Comment dc = this.token.docComment();
            return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(this.modifiersOpt(), dc));
        }
        Tokens.Comment dc = this.token.docComment();
        if (this.isRecordStart() && this.allowRecords) {
            return List.of(this.recordDeclaration(this.F.at(pos).Modifiers(0L), dc));
        }
        Tokens.Token prevToken = this.token;
        JCTree.JCExpression t = this.term(3);
        if (this.token.kind == Tokens.TokenKind.COLON && t.hasTag(JCTree.Tag.IDENT)) {
            this.nextToken();
            JCTree.JCStatement stat = this.parseStatementAsBlock();
            return List.of(this.F.at(pos).Labelled(prevToken.name(), stat));
        }
        if (this.wasTypeMode() && this.LAX_IDENTIFIER.test(this.token.kind)) {
            pos = this.token.pos;
            JCTree.JCModifiers mods = this.F.at(-1).Modifiers(0L);
            this.F.at(pos);
            return this.localVariableDeclarations(mods, t, dc);
        }
        t = this.checkExprStat(t);
        this.accept(Tokens.TokenKind.SEMI);
        JCTree.JCExpressionStatement expr = this.toP(this.F.at(pos).Exec(t));
        return List.of(expr);
    }

    private List<JCTree.JCStatement> localVariableDeclarations(JCTree.JCModifiers mods, JCTree.JCExpression type, Tokens.Comment dc) {
        if (dc != null) {
            this.saveDanglingDocComments(dc);
        }
        ListBuffer stats = this.variableDeclarators(mods, type, new ListBuffer(), true);
        this.accept(Tokens.TokenKind.SEMI);
        this.storeEnd((JCTree.JCStatement)stats.last(), this.S.prevToken().endPos);
        return stats.toList();
    }

    public JCTree.JCStatement parseSimpleStatement() {
        this.ignoreDanglingComments();
        int pos = this.token.pos;
        switch (this.token.kind) {
            case LBRACE: {
                return this.block();
            }
            case IF: {
                this.nextToken();
                JCTree.JCExpression cond = this.parExpression();
                JCTree.JCStatement thenpart = this.parseStatementAsBlock();
                JCTree.JCStatement elsepart = null;
                if (this.token.kind == Tokens.TokenKind.ELSE) {
                    this.nextToken();
                    elsepart = this.parseStatementAsBlock();
                }
                return this.F.at(pos).If(cond, thenpart, elsepart);
            }
            case FOR: {
                List<Object> inits;
                this.nextToken();
                this.accept(Tokens.TokenKind.LPAREN);
                List<Object> list = inits = this.token.kind == Tokens.TokenKind.SEMI ? List.nil() : this.forInit();
                if (inits.length() == 1 && ((JCTree.JCStatement)inits.head).hasTag(JCTree.Tag.VARDEF) && ((JCTree.JCVariableDecl)inits.head).init == null && this.token.kind == Tokens.TokenKind.COLON) {
                    JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)inits.head;
                    this.accept(Tokens.TokenKind.COLON);
                    JCTree.JCExpression expr = this.parseExpression();
                    this.accept(Tokens.TokenKind.RPAREN);
                    JCTree.JCStatement body = this.parseStatementAsBlock();
                    return this.F.at(pos).ForeachLoop(var, expr, body);
                }
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCExpression cond = this.token.kind == Tokens.TokenKind.SEMI ? null : this.parseExpression();
                this.accept(Tokens.TokenKind.SEMI);
                List<JCTree.JCExpressionStatement> steps = this.token.kind == Tokens.TokenKind.RPAREN ? List.nil() : this.forUpdate();
                this.accept(Tokens.TokenKind.RPAREN);
                JCTree.JCStatement body = this.parseStatementAsBlock();
                return this.F.at(pos).ForLoop(inits, cond, steps, body);
            }
            case WHILE: {
                this.nextToken();
                JCTree.JCExpression cond = this.parExpression();
                JCTree.JCStatement body = this.parseStatementAsBlock();
                return this.F.at(pos).WhileLoop(cond, body);
            }
            case DO: {
                this.nextToken();
                JCTree.JCStatement body = this.parseStatementAsBlock();
                this.accept(Tokens.TokenKind.WHILE);
                JCTree.JCExpression cond = this.parExpression();
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCDoWhileLoop t = this.toP(this.F.at(pos).DoLoop(body, cond));
                return t;
            }
            case TRY: {
                this.nextToken();
                List<Object> resources = List.nil();
                if (this.token.kind == Tokens.TokenKind.LPAREN) {
                    this.nextToken();
                    resources = this.resources();
                    this.accept(Tokens.TokenKind.RPAREN);
                }
                JCTree.JCBlock body = this.block();
                ListBuffer<JCTree.JCCatch> catchers = new ListBuffer<JCTree.JCCatch>();
                JCTree.JCBlock finalizer = null;
                if (this.token.kind == Tokens.TokenKind.CATCH || this.token.kind == Tokens.TokenKind.FINALLY) {
                    while (this.token.kind == Tokens.TokenKind.CATCH) {
                        catchers.append(this.catchClause());
                    }
                    if (this.token.kind == Tokens.TokenKind.FINALLY) {
                        this.nextToken();
                        finalizer = this.block();
                    }
                } else if (resources.isEmpty()) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, pos, CompilerProperties.Errors.TryWithoutCatchFinallyOrResourceDecls);
                }
                return this.F.at(pos).Try(resources, body, catchers.toList(), finalizer);
            }
            case SWITCH: {
                this.nextToken();
                JCTree.JCExpression selector = this.parExpression();
                this.accept(Tokens.TokenKind.LBRACE);
                List<JCTree.JCCase> cases = this.switchBlockStatementGroups();
                JCTree.JCSwitch t = this.to(this.F.at(pos).Switch(selector, cases));
                t.bracePos = this.token.endPos;
                this.accept(Tokens.TokenKind.RBRACE);
                return t;
            }
            case SYNCHRONIZED: {
                this.nextToken();
                JCTree.JCExpression lock = this.parExpression();
                JCTree.JCBlock body = this.block();
                return this.F.at(pos).Synchronized(lock, body);
            }
            case RETURN: {
                this.nextToken();
                JCTree.JCExpression result = this.token.kind == Tokens.TokenKind.SEMI ? null : this.parseExpression();
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCReturn t = this.toP(this.F.at(pos).Return(result));
                return t;
            }
            case THROW: {
                this.nextToken();
                JCTree.JCExpression exc = this.parseExpression();
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCThrow t = this.toP(this.F.at(pos).Throw(exc));
                return t;
            }
            case BREAK: {
                this.nextToken();
                Name label = this.LAX_IDENTIFIER.test(this.token.kind) ? this.ident() : null;
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCBreak t = this.toP(this.F.at(pos).Break(label));
                return t;
            }
            case CONTINUE: {
                this.nextToken();
                Name label = this.LAX_IDENTIFIER.test(this.token.kind) ? this.ident() : null;
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCContinue t = this.toP(this.F.at(pos).Continue(label));
                return t;
            }
            case SEMI: {
                this.nextToken();
                return this.toP(this.F.at(pos).Skip());
            }
            case ELSE: {
                int elsePos = this.token.pos;
                this.nextToken();
                return this.doRecover(elsePos, BasicErrorRecoveryAction.BLOCK_STMT, CompilerProperties.Errors.ElseWithoutIf);
            }
            case FINALLY: {
                int finallyPos = this.token.pos;
                this.nextToken();
                return this.doRecover(finallyPos, BasicErrorRecoveryAction.BLOCK_STMT, CompilerProperties.Errors.FinallyWithoutTry);
            }
            case CATCH: {
                return this.doRecover(this.token.pos, BasicErrorRecoveryAction.CATCH_CLAUSE, CompilerProperties.Errors.CatchWithoutTry);
            }
            case ASSERT: {
                this.nextToken();
                JCTree.JCExpression assertion = this.parseExpression();
                JCTree.JCExpression message = null;
                if (this.token.kind == Tokens.TokenKind.COLON) {
                    this.nextToken();
                    message = this.parseExpression();
                }
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCAssert t = this.toP(this.F.at(pos).Assert(assertion, message));
                return t;
            }
        }
        Assert.error();
        return null;
    }

    @Override
    public JCTree.JCStatement parseStatement() {
        return this.parseStatementAsBlock();
    }

    private JCTree.JCStatement doRecover(int startPos, ErrorRecoveryAction action, JCDiagnostic.Error errorKey) {
        int errPos = this.S.errPos();
        JCTree stm = action.doRecover(this);
        this.S.errPos(errPos);
        return this.toP(this.F.Exec(this.syntaxError(startPos, List.of(stm), errorKey)));
    }

    protected JCTree.JCCatch catchClause() {
        int pos = this.token.pos;
        this.accept(Tokens.TokenKind.CATCH);
        this.accept(Tokens.TokenKind.LPAREN);
        JCTree.JCModifiers mods = this.optFinal(0x200000000L);
        List<JCTree.JCExpression> catchTypes = this.catchTypes();
        JCTree.JCExpression paramType = catchTypes.size() > 1 ? (JCTree.JCExpression)this.toP(this.F.at(((JCTree.JCExpression)catchTypes.head).getStartPosition()).TypeUnion(catchTypes)) : (JCTree.JCExpression)catchTypes.head;
        JCTree.JCVariableDecl formal = this.variableDeclaratorId(mods, paramType, true, false, false);
        this.accept(Tokens.TokenKind.RPAREN);
        JCTree.JCBlock body = this.block();
        return this.F.at(pos).Catch(formal, body);
    }

    List<JCTree.JCExpression> catchTypes() {
        ListBuffer<JCTree.JCExpression> catchTypes = new ListBuffer<JCTree.JCExpression>();
        catchTypes.add(this.parseType());
        while (this.token.kind == Tokens.TokenKind.BAR) {
            this.nextToken();
            catchTypes.add(this.parseType());
        }
        return catchTypes.toList();
    }

    List<JCTree.JCCase> switchBlockStatementGroups() {
        ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
        block4: while (true) {
            int pos = this.token.pos;
            switch (this.token.kind) {
                case CASE: 
                case DEFAULT: {
                    cases.appendList(this.switchBlockStatementGroup());
                    continue block4;
                }
                case EOF: 
                case RBRACE: {
                    return cases.toList();
                }
            }
            this.nextToken();
            this.syntaxError(pos, CompilerProperties.Errors.Expected3(Tokens.TokenKind.CASE, Tokens.TokenKind.DEFAULT, Tokens.TokenKind.RBRACE));
        }
    }

    protected List<JCTree.JCCase> switchBlockStatementGroup() {
        int pos = this.token.pos;
        ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
        switch (this.token.kind) {
            case CASE: {
                List<JCTree.JCStatement> stats;
                CaseTree.CaseKind caseKind;
                this.nextToken();
                ListBuffer<JCTree.JCCaseLabel> pats = new ListBuffer<JCTree.JCCaseLabel>();
                boolean allowDefault = false;
                while (true) {
                    JCTree.JCCaseLabel label = this.parseCaseLabel(allowDefault);
                    pats.append(label);
                    if (this.token.kind != Tokens.TokenKind.COMMA) break;
                    this.nextToken();
                    this.checkSourceLevel(Source.Feature.SWITCH_MULTIPLE_CASE_LABELS);
                    allowDefault = TreeInfo.isNullCaseLabel(label);
                }
                JCTree.JCExpression guard = this.parseGuard((JCTree.JCCaseLabel)pats.last());
                JCTree body = null;
                if (this.token.kind == Tokens.TokenKind.ARROW) {
                    this.checkSourceLevel(Source.Feature.SWITCH_RULE);
                    this.accept(Tokens.TokenKind.ARROW);
                    caseKind = JCTree.JCCase.RULE;
                    JCTree.JCStatement statement = this.parseStatementAsBlock();
                    if (!(statement.hasTag(JCTree.Tag.EXEC) || statement.hasTag(JCTree.Tag.BLOCK) || statement.hasTag(JCTree.Tag.THROW))) {
                        this.log.error(statement.pos(), CompilerProperties.Errors.SwitchCaseUnexpectedStatement);
                    }
                    stats = List.of(statement);
                    body = (JCTree)stats.head;
                } else {
                    this.accept(Tokens.TokenKind.COLON, tk -> CompilerProperties.Errors.Expected2(Tokens.TokenKind.COLON, Tokens.TokenKind.ARROW));
                    caseKind = JCTree.JCCase.STATEMENT;
                    stats = this.blockStatements();
                }
                JCTree.JCCase c = this.F.at(pos).Case(caseKind, pats.toList(), guard, stats, body);
                if (stats.isEmpty()) {
                    this.storeEnd(c, this.S.prevToken().endPos);
                }
                return cases.append(c).toList();
            }
            case DEFAULT: {
                List<JCTree.JCStatement> stats;
                CaseTree.CaseKind caseKind;
                this.nextToken();
                JCTree.JCCaseLabel defaultPattern = this.toP(this.F.at(pos).DefaultCaseLabel());
                JCTree.JCExpression guard = this.parseGuard(defaultPattern);
                JCTree body = null;
                if (this.token.kind == Tokens.TokenKind.ARROW) {
                    this.checkSourceLevel(Source.Feature.SWITCH_RULE);
                    this.accept(Tokens.TokenKind.ARROW);
                    caseKind = JCTree.JCCase.RULE;
                    JCTree.JCStatement statement = this.parseStatementAsBlock();
                    if (!(statement.hasTag(JCTree.Tag.EXEC) || statement.hasTag(JCTree.Tag.BLOCK) || statement.hasTag(JCTree.Tag.THROW))) {
                        this.log.error(statement.pos(), CompilerProperties.Errors.SwitchCaseUnexpectedStatement);
                    }
                    stats = List.of(statement);
                    body = (JCTree)stats.head;
                } else {
                    this.accept(Tokens.TokenKind.COLON, tk -> CompilerProperties.Errors.Expected2(Tokens.TokenKind.COLON, Tokens.TokenKind.ARROW));
                    caseKind = JCTree.JCCase.STATEMENT;
                    stats = this.blockStatements();
                }
                JCTree.JCCase c = this.F.at(pos).Case(caseKind, List.of(defaultPattern), guard, stats, body);
                if (stats.isEmpty()) {
                    this.storeEnd(c, this.S.prevToken().endPos);
                }
                return cases.append(c).toList();
            }
        }
        throw new AssertionError((Object)"should not reach here");
    }

    private JCTree.JCCaseLabel parseCaseLabel(boolean allowDefault) {
        int patternPos = this.token.pos;
        if (this.token.kind == Tokens.TokenKind.DEFAULT) {
            this.checkSourceLevel(this.token.pos, Source.Feature.PATTERN_SWITCH);
            if (!allowDefault) {
                this.reportSyntaxError(new JCDiagnostic.SimpleDiagnosticPosition(this.token.pos), CompilerProperties.Errors.DefaultLabelNotAllowed);
            }
        } else {
            boolean pattern;
            JCTree.JCModifiers mods = this.optFinal(0L);
            boolean bl = pattern = mods.flags != 0L || mods.annotations.nonEmpty() || this.analyzePattern(0) == PatternResult.PATTERN;
            if (pattern) {
                this.checkSourceLevel(this.token.pos, Source.Feature.PATTERN_SWITCH);
                JCTree.JCPattern p = this.parsePattern(patternPos, mods, null, false, true);
                return this.toP(this.F.at(patternPos).PatternCaseLabel(p));
            }
            JCTree.JCExpression expr = this.term(33);
            return this.toP(this.F.at(patternPos).ConstantCaseLabel(expr));
        }
        this.nextToken();
        JCTree.JCCaseLabel label = this.toP(this.F.at(patternPos).DefaultCaseLabel());
        return label;
    }

    private JCTree.JCExpression parseGuard(JCTree.JCCaseLabel label) {
        JCTree.JCExpression guard = null;
        if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.when) {
            int pos = this.token.pos;
            this.nextToken();
            guard = this.term(33);
            if (!(label instanceof JCTree.JCPatternCaseLabel)) {
                guard = this.syntaxError(pos, List.of(guard), CompilerProperties.Errors.GuardNotAllowed);
            }
        }
        return guard;
    }

    PatternResult analyzePattern(int lookahead) {
        int typeDepth = 0;
        int parenDepth = 0;
        PatternResult pendingResult = PatternResult.EXPRESSION;
        while (true) {
            Tokens.TokenKind token = this.S.token((int)lookahead).kind;
            switch (token) {
                case ENUM: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: 
                case IDENTIFIER: 
                case ASSERT: {
                    if (typeDepth == 0 && this.peekToken(lookahead, this.LAX_IDENTIFIER)) {
                        if (parenDepth == 0) {
                            return PatternResult.PATTERN;
                        }
                        pendingResult = PatternResult.PATTERN;
                        break;
                    }
                    if (typeDepth != 0 || parenDepth != 0 || !this.peekToken(lookahead, (Tokens.TokenKind tk) -> tk == Tokens.TokenKind.ARROW || tk == Tokens.TokenKind.COMMA)) break;
                    return PatternResult.EXPRESSION;
                }
                case UNDERSCORE: {
                    if (typeDepth == 0 && this.peekToken(lookahead, (Tokens.TokenKind tk) -> tk == Tokens.TokenKind.RPAREN || tk == Tokens.TokenKind.COMMA)) {
                        return PatternResult.PATTERN;
                    }
                    if (typeDepth != 0 || !this.peekToken(lookahead, this.LAX_IDENTIFIER)) break;
                    if (parenDepth == 0) {
                        return PatternResult.PATTERN;
                    }
                    pendingResult = PatternResult.PATTERN;
                    break;
                }
                case SUPER: 
                case DOT: 
                case QUES: 
                case EXTENDS: 
                case COMMA: {
                    break;
                }
                case LT: {
                    ++typeDepth;
                    break;
                }
                case GTGTGT: {
                    --typeDepth;
                }
                case GTGT: {
                    --typeDepth;
                }
                case GT: {
                    if (--typeDepth == 0 && !this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.DOT)) {
                        return this.peekToken(lookahead, this.LAX_IDENTIFIER) || this.peekToken(lookahead, (Tokens.TokenKind tk) -> tk == Tokens.TokenKind.LPAREN) ? PatternResult.PATTERN : PatternResult.EXPRESSION;
                    }
                    if (typeDepth >= 0) break;
                    return PatternResult.EXPRESSION;
                }
                case MONKEYS_AT: {
                    lookahead = this.skipAnnotation(lookahead);
                    break;
                }
                case LBRACKET: {
                    if (this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET, this.LAX_IDENTIFIER)) {
                        return PatternResult.PATTERN;
                    }
                    if (this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.RBRACKET)) {
                        ++lookahead;
                        break;
                    }
                    return pendingResult;
                }
                case LPAREN: {
                    if (this.S.token((int)(lookahead + 1)).kind == Tokens.TokenKind.RPAREN) {
                        return parenDepth != 0 && this.S.token((int)(lookahead + 2)).kind == Tokens.TokenKind.ARROW ? PatternResult.EXPRESSION : PatternResult.PATTERN;
                    }
                    ++parenDepth;
                    break;
                }
                case RPAREN: {
                    if (--parenDepth != 0 || typeDepth != 0 || !this.peekToken(lookahead, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.IDENTIFIER) || this.S.token(lookahead + 1).name() != this.names.when) break;
                    return PatternResult.PATTERN;
                }
                case ARROW: {
                    return parenDepth > 0 ? PatternResult.EXPRESSION : pendingResult;
                }
                case FINAL: {
                    if (parenDepth > 0) {
                        return PatternResult.PATTERN;
                    }
                }
                default: {
                    return pendingResult;
                }
            }
            ++lookahead;
        }
    }

    <T extends ListBuffer<? super JCTree.JCExpressionStatement>> T moreStatementExpressions(int pos, JCTree.JCExpression first, T stats) {
        stats.append((JCTree.JCExpressionStatement)this.toP(this.F.at(pos).Exec(this.checkExprStat(first))));
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            pos = this.token.pos;
            JCTree.JCExpression t = this.parseExpression();
            stats.append((JCTree.JCExpressionStatement)this.toP(this.F.at(pos).Exec(this.checkExprStat(t))));
        }
        return stats;
    }

    List<JCTree.JCStatement> forInit() {
        ListBuffer stats = new ListBuffer();
        int pos = this.token.pos;
        if (this.token.kind == Tokens.TokenKind.FINAL || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            return this.variableDeclarators(this.optFinal(0L), this.parseType(true), stats, true).toList();
        }
        JCTree.JCExpression t = this.term(3);
        if (this.wasTypeMode() && this.LAX_IDENTIFIER.test(this.token.kind)) {
            return this.variableDeclarators(this.modifiersOpt(), t, stats, true).toList();
        }
        if (this.wasTypeMode() && this.token.kind == Tokens.TokenKind.COLON) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, pos, CompilerProperties.Errors.BadInitializer("for-loop"));
            return List.of(this.F.at(pos).VarDef(this.modifiersOpt(), this.names.error, t, null));
        }
        return this.moreStatementExpressions(pos, t, stats).toList();
    }

    List<JCTree.JCExpressionStatement> forUpdate() {
        return this.moreStatementExpressions(this.token.pos, this.parseExpression(), new ListBuffer()).toList();
    }

    protected List<JCTree.JCAnnotation> annotationsOpt(JCTree.Tag kind) {
        if (this.token.kind != Tokens.TokenKind.MONKEYS_AT) {
            return List.nil();
        }
        ListBuffer<JCTree.JCAnnotation> buf = new ListBuffer<JCTree.JCAnnotation>();
        int prevmode = this.mode;
        while (this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            int pos = this.token.pos;
            this.nextToken();
            buf.append(this.annotation(pos, kind));
        }
        this.setLastMode(this.mode);
        this.setMode(prevmode);
        List<JCTree.JCAnnotation> annotations = buf.toList();
        return annotations;
    }

    List<JCTree.JCAnnotation> typeAnnotationsOpt() {
        List<JCTree.JCAnnotation> annotations = this.annotationsOpt(JCTree.Tag.TYPE_ANNOTATION);
        return annotations;
    }

    protected JCTree.JCModifiers modifiersOpt() {
        return this.modifiersOpt(null);
    }

    protected JCTree.JCModifiers modifiersOpt(JCTree.JCModifiers partial) {
        int pos;
        long flags;
        ListBuffer<JCTree.JCAnnotation> annotations = new ListBuffer<JCTree.JCAnnotation>();
        if (partial == null) {
            flags = 0L;
            pos = this.token.pos;
        } else {
            flags = partial.flags;
            annotations.appendList(partial.annotations);
            pos = partial.pos;
        }
        if (this.token.deprecatedFlag()) {
            flags |= 0x20000L;
        }
        block21: while (true) {
            long flag;
            switch (this.token.kind) {
                case PRIVATE: {
                    flag = 2L;
                    break;
                }
                case PROTECTED: {
                    flag = 4L;
                    break;
                }
                case PUBLIC: {
                    flag = 1L;
                    break;
                }
                case STATIC: {
                    flag = 8L;
                    break;
                }
                case TRANSIENT: {
                    flag = 128L;
                    break;
                }
                case FINAL: {
                    flag = 16L;
                    break;
                }
                case ABSTRACT: {
                    flag = 1024L;
                    break;
                }
                case NATIVE: {
                    flag = 256L;
                    break;
                }
                case VOLATILE: {
                    flag = 64L;
                    break;
                }
                case SYNCHRONIZED: {
                    flag = 32L;
                    break;
                }
                case STRICTFP: {
                    flag = 2048L;
                    break;
                }
                case MONKEYS_AT: {
                    flag = 8192L;
                    break;
                }
                case DEFAULT: {
                    flag = 0x80000000000L;
                    break;
                }
                case ERROR: {
                    flag = 0L;
                    this.nextToken();
                    break;
                }
                case IDENTIFIER: {
                    if (this.isNonSealedClassStart(false)) {
                        flag = Long.MIN_VALUE;
                        this.nextToken();
                        this.nextToken();
                        break;
                    }
                    if (this.isSealedClassStart(false)) {
                        this.checkSourceLevel(Source.Feature.SEALED_CLASSES);
                        flag = 0x1000000000000L;
                        break;
                    }
                    if (!this.isValueModifier()) break block21;
                    this.checkSourceLevel(Source.Feature.VALUE_CLASSES);
                    flag = 0x100000L;
                    break;
                }
                default: {
                    break block21;
                }
            }
            if ((flags & flag) != 0L) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.RepeatedModifier);
            }
            int lastPos = this.token.pos;
            this.nextToken();
            if (flag == 8192L && this.token.kind != Tokens.TokenKind.INTERFACE) {
                JCTree.JCAnnotation ann = this.annotation(lastPos, JCTree.Tag.ANNOTATION);
                if (flags == 0L && annotations.isEmpty()) {
                    pos = ann.pos;
                }
                annotations.append(ann);
                flag = 0L;
            }
            flags |= flag;
        }
        switch (this.token.kind) {
            case ENUM: {
                flags |= 0x4000L;
                break;
            }
            case INTERFACE: {
                flags |= 0x200L;
                break;
            }
        }
        if ((flags & 0x8001080000102DFFL) == 0L && annotations.isEmpty()) {
            pos = -1;
        }
        JCTree.JCModifiers mods = this.F.at(pos).Modifiers(flags, annotations.toList());
        if (pos != -1) {
            this.storeEnd(mods, this.S.prevToken().endPos);
        }
        return mods;
    }

    JCTree.JCAnnotation annotation(int pos, JCTree.Tag kind) {
        JCTree.JCAnnotation ann;
        JCTree.JCExpression ident = this.qualident(false);
        List<JCTree.JCExpression> fieldValues = this.annotationFieldValuesOpt();
        if (kind == JCTree.Tag.ANNOTATION) {
            ann = this.F.at(pos).Annotation(ident, fieldValues);
        } else if (kind == JCTree.Tag.TYPE_ANNOTATION) {
            ann = this.F.at(pos).TypeAnnotation(ident, fieldValues);
        } else {
            throw new AssertionError((Object)("Unhandled annotation kind: " + String.valueOf((Object)kind)));
        }
        return this.toP(ann);
    }

    List<JCTree.JCExpression> annotationFieldValuesOpt() {
        return this.token.kind == Tokens.TokenKind.LPAREN ? this.annotationFieldValues() : List.nil();
    }

    List<JCTree.JCExpression> annotationFieldValues() {
        this.accept(Tokens.TokenKind.LPAREN);
        ListBuffer<JCTree.JCExpression> buf = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind != Tokens.TokenKind.RPAREN) {
            buf.append(this.annotationFieldValue());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                buf.append(this.annotationFieldValue());
            }
        }
        this.accept(Tokens.TokenKind.RPAREN);
        return buf.toList();
    }

    JCTree.JCExpression annotationFieldValue() {
        if (this.LAX_IDENTIFIER.test(this.token.kind)) {
            this.selectExprMode();
            JCTree.JCExpression t1 = this.term1();
            if (t1.hasTag(JCTree.Tag.IDENT) && this.token.kind == Tokens.TokenKind.EQ) {
                int pos = this.token.pos;
                this.accept(Tokens.TokenKind.EQ);
                JCTree.JCExpression v = this.annotationValue();
                return this.toP(this.F.at(pos).Assign(t1, v));
            }
            return t1;
        }
        return this.annotationValue();
    }

    JCTree.JCExpression annotationValue() {
        switch (this.token.kind) {
            case MONKEYS_AT: {
                int pos = this.token.pos;
                this.nextToken();
                return this.annotation(pos, JCTree.Tag.ANNOTATION);
            }
            case LBRACE: {
                int pos = this.token.pos;
                this.accept(Tokens.TokenKind.LBRACE);
                ListBuffer<JCTree.JCExpression> buf = new ListBuffer<JCTree.JCExpression>();
                if (this.token.kind == Tokens.TokenKind.COMMA) {
                    this.nextToken();
                } else if (this.token.kind != Tokens.TokenKind.RBRACE) {
                    buf.append(this.annotationValue());
                    while (this.token.kind == Tokens.TokenKind.COMMA) {
                        this.nextToken();
                        if (this.token.kind == Tokens.TokenKind.RBRACE) break;
                        buf.append(this.annotationValue());
                    }
                }
                this.accept(Tokens.TokenKind.RBRACE, tk -> CompilerProperties.Errors.AnnotationMissingElementValue);
                return this.toP(this.F.at(pos).NewArray(null, List.nil(), buf.toList()));
            }
        }
        this.selectExprMode();
        return this.term1();
    }

    public <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclarators(JCTree.JCModifiers mods, JCTree.JCExpression type, T vdefs, boolean localDecl) {
        return this.variableDeclaratorsRest(this.token.pos, mods, type, this.identOrUnderscore(), false, null, vdefs, localDecl);
    }

    protected <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclaratorsRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, boolean reqInit, Tokens.Comment dc, T vdefs, boolean localDecl) {
        JCTree.JCVariableDecl head = this.variableDeclaratorRest(pos, mods, type, name, reqInit, dc, localDecl, false);
        vdefs.append((JCTree.JCVariableDecl)head);
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.storeEnd((JCTree)vdefs.last(), this.token.endPos);
            this.nextToken();
            vdefs.append((JCTree.JCVariableDecl)this.variableDeclarator(mods, type, reqInit, dc, localDecl));
        }
        return vdefs;
    }

    JCTree.JCVariableDecl variableDeclarator(JCTree.JCModifiers mods, JCTree.JCExpression type, boolean reqInit, Tokens.Comment dc, boolean localDecl) {
        return this.variableDeclaratorRest(this.token.pos, mods, type, this.identOrUnderscore(), reqInit, dc, localDecl, true);
    }

    JCTree.JCVariableDecl variableDeclaratorRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, boolean reqInit, Tokens.Comment dc, boolean localDecl, boolean compound) {
        Name typeName;
        boolean declaredUsingVar = false;
        JCTree.JCExpression init = null;
        type = this.bracketsOpt(type);
        if (Source.Feature.UNNAMED_VARIABLES.allowedInSource(this.source) && name == this.names.underscore) {
            if (!localDecl) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, pos, CompilerProperties.Errors.UseOfUnderscoreNotAllowed);
            }
            name = this.names.empty;
        }
        this.saveDanglingDocComments(dc);
        if (this.token.kind == Tokens.TokenKind.EQ) {
            this.nextToken();
            init = this.variableInitializer();
        } else if (reqInit) {
            this.syntaxError(this.token.pos, CompilerProperties.Errors.Expected(Tokens.TokenKind.EQ));
        }
        if (Source.Feature.UNNAMED_VARIABLES.allowedInSource(this.source) && name == this.names.empty && localDecl && init == null && this.token.kind != Tokens.TokenKind.COLON) {
            this.syntaxError(this.token.pos, CompilerProperties.Errors.Expected(Tokens.TokenKind.EQ));
        }
        int startPos = -1;
        JCTree elemType = TreeInfo.innermostType(type, true);
        if (elemType.hasTag(JCTree.Tag.IDENT) && this.restrictedTypeNameStartingAtSource(typeName = ((JCTree.JCIdent)elemType).name, pos, !compound && localDecl) != null) {
            if (typeName != this.names.var) {
                this.reportSyntaxError(elemType.pos, CompilerProperties.Errors.RestrictedTypeNotAllowedHere(typeName));
            } else if (type.hasTag(JCTree.Tag.TYPEARRAY) && !compound) {
                this.reportSyntaxError(elemType.pos, CompilerProperties.Errors.RestrictedTypeNotAllowedArray(typeName));
            } else {
                declaredUsingVar = true;
                if (compound) {
                    this.reportSyntaxError(elemType.pos, CompilerProperties.Errors.RestrictedTypeNotAllowedCompound(typeName));
                }
                if ((startPos = TreeInfo.getStartPos(mods)) == -1) {
                    startPos = TreeInfo.getStartPos(type);
                }
                type = null;
            }
        }
        JCTree.JCVariableDecl result = this.toP(this.F.at(pos).VarDef(mods, name, type, init, declaredUsingVar));
        result.startPos = startPos;
        return this.attach(result, dc);
    }

    Name restrictedTypeName(JCTree.JCExpression e, boolean shouldWarn) {
        switch (e.getTag()) {
            case IDENT: {
                return this.restrictedTypeNameStartingAtSource(((JCTree.JCIdent)e).name, e.pos, shouldWarn) != null ? ((JCTree.JCIdent)e).name : null;
            }
            case TYPEARRAY: {
                return this.restrictedTypeName(((JCTree.JCArrayTypeTree)e).elemtype, shouldWarn);
            }
        }
        return null;
    }

    Source restrictedTypeNameStartingAtSource(Name name, int pos, boolean shouldWarn) {
        if (name == this.names.var) {
            if (Source.Feature.LOCAL_VARIABLE_TYPE_INFERENCE.allowedInSource(this.source)) {
                return Source.JDK10;
            }
            if (shouldWarn) {
                this.log.warning(pos, CompilerProperties.Warnings.RestrictedTypeNotAllowed(name, Source.JDK10));
            }
        }
        if (name == this.names.yield) {
            if (this.allowYieldStatement) {
                return Source.JDK14;
            }
            if (shouldWarn) {
                this.log.warning(pos, CompilerProperties.Warnings.RestrictedTypeNotAllowed(name, Source.JDK14));
            }
        }
        if (name == this.names.record) {
            if (this.allowRecords) {
                return Source.JDK14;
            }
            if (shouldWarn) {
                this.log.warning(pos, CompilerProperties.Warnings.RestrictedTypeNotAllowedPreview(name, Source.JDK14));
            }
        }
        if (name == this.names.value) {
            if (this.allowValueClasses) {
                return Source.JDK23;
            }
            if (shouldWarn) {
                this.log.warning(pos, CompilerProperties.Warnings.RestrictedTypeNotAllowedPreview(name, Source.JDK23));
            }
        }
        if (name == this.names.sealed) {
            if (this.allowSealedTypes) {
                return Source.JDK15;
            }
            if (shouldWarn) {
                this.log.warning(pos, CompilerProperties.Warnings.RestrictedTypeNotAllowedPreview(name, Source.JDK15));
            }
        }
        if (name == this.names.permits) {
            if (this.allowSealedTypes) {
                return Source.JDK15;
            }
            if (shouldWarn) {
                this.log.warning(pos, CompilerProperties.Warnings.RestrictedTypeNotAllowedPreview(name, Source.JDK15));
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    JCTree.JCVariableDecl variableDeclaratorId(JCTree.JCModifiers mods, JCTree.JCExpression type, boolean catchParameter, boolean lambdaParameter, boolean recordComponent) {
        boolean bl;
        Name name;
        int pos;
        block10: {
            block11: {
                pos = this.token.pos;
                if (!this.allowThisIdent && lambdaParameter && !this.LAX_IDENTIFIER.test(this.token.kind) && mods.flags == 0x200000000L && !mods.annotations.nonEmpty()) break block11;
                JCTree.JCExpression pn = this.token.kind == Tokens.TokenKind.UNDERSCORE && (catchParameter || lambdaParameter) ? (JCTree.JCExpression)this.toP(this.F.at(this.token.pos).Ident(this.identOrUnderscore())) : this.qualident(false);
                if (pn.hasTag(JCTree.Tag.IDENT) && ((JCTree.JCIdent)pn).name != this.names._this) {
                    name = ((JCTree.JCIdent)pn).name;
                    break block10;
                } else if (lambdaParameter && type == null) {
                    type = pn;
                    name = this.names.empty;
                    this.reportSyntaxError(pos, CompilerProperties.Errors.Expected(Tokens.TokenKind.IDENTIFIER));
                    break block10;
                } else {
                    if (!this.allowThisIdent) return this.toP(this.F.at(pos).ReceiverVarDef(mods, pn, type));
                    if ((mods.flags & 0x400000000L) != 0L) {
                        this.log.error(this.token.pos, CompilerProperties.Errors.VarargsAndReceiver);
                    }
                    if (this.token.kind == Tokens.TokenKind.LBRACKET) {
                        this.log.error(this.token.pos, CompilerProperties.Errors.ArrayAndReceiver);
                    }
                    if (!pn.hasTag(JCTree.Tag.SELECT)) return this.toP(this.F.at(pos).ReceiverVarDef(mods, pn, type));
                    if (((JCTree.JCFieldAccess)pn).name == this.names._this) return this.toP(this.F.at(pos).ReceiverVarDef(mods, pn, type));
                    this.log.error(this.token.pos, CompilerProperties.Errors.WrongReceiver);
                    return this.toP(this.F.at(pos).ReceiverVarDef(mods, pn, type));
                }
            }
            name = this.names.error;
        }
        if ((mods.flags & 0x400000000L) != 0L && this.token.kind == Tokens.TokenKind.LBRACKET) {
            this.log.error(this.token.pos, CompilerProperties.Errors.VarargsAndOldArraySyntax);
        }
        if (recordComponent && this.token.kind == Tokens.TokenKind.LBRACKET) {
            this.log.error(this.token.pos, CompilerProperties.Errors.RecordComponentAndOldArraySyntax);
        }
        type = this.bracketsOpt(type);
        if (Source.Feature.UNNAMED_VARIABLES.allowedInSource(this.source) && name == this.names.underscore) {
            name = this.names.empty;
        }
        TreeMaker treeMaker = this.F.at(pos);
        if (type != null && type.hasTag(JCTree.Tag.IDENT) && ((JCTree.JCIdent)type).name == this.names.var) {
            bl = true;
            return this.toP(treeMaker.VarDef(mods, name, type, null, bl));
        }
        bl = false;
        return this.toP(treeMaker.VarDef(mods, name, type, null, bl));
    }

    List<JCTree> resources() {
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        defs.append(this.resource());
        while (this.token.kind == Tokens.TokenKind.SEMI) {
            this.storeEnd((JCTree)defs.last(), this.token.endPos);
            int semiColonPos = this.token.pos;
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.RPAREN) break;
            defs.append(this.resource());
        }
        return defs.toList();
    }

    protected JCTree resource() {
        if (this.token.kind == Tokens.TokenKind.FINAL || this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            JCTree.JCModifiers mods = this.optFinal(0L);
            JCTree.JCExpression t = this.parseType(true);
            return this.variableDeclaratorRest(this.token.pos, mods, t, this.identOrUnderscore(), true, null, true, false);
        }
        JCTree.JCExpression t = this.term(3);
        if (this.wasTypeMode() && this.LAX_IDENTIFIER.test(this.token.kind)) {
            JCTree.JCModifiers mods = this.F.Modifiers(0L);
            return this.variableDeclaratorRest(this.token.pos, mods, t, this.identOrUnderscore(), true, null, true, false);
        }
        this.checkSourceLevel(Source.Feature.EFFECTIVELY_FINAL_VARIABLES_IN_TRY_WITH_RESOURCES);
        if (!t.hasTag(JCTree.Tag.IDENT) && !t.hasTag(JCTree.Tag.SELECT)) {
            this.log.error(t.pos(), CompilerProperties.Errors.TryWithResourcesExprNeedsVar);
        }
        return t;
    }

    @Override
    public JCTree.JCCompilationUnit parseCompilationUnit() {
        Tokens.Token firstToken = this.token;
        JCTree.JCModifiers mods = null;
        boolean consumedToplevelDoc = false;
        boolean seenImport = false;
        boolean seenPackage = false;
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        if (this.token.kind == Tokens.TokenKind.MONKEYS_AT) {
            mods = this.modifiersOpt();
        }
        if (this.token.kind == Tokens.TokenKind.PACKAGE) {
            int packagePos = this.token.pos;
            List<JCTree.JCAnnotation> annotations = List.nil();
            seenPackage = true;
            if (mods != null) {
                this.checkNoMods(mods.flags & 0xFFFFFFFFFFFDFFFFL);
                annotations = mods.annotations;
                mods = null;
            }
            this.nextToken();
            JCTree.JCExpression pid = this.qualident(false);
            this.accept(Tokens.TokenKind.SEMI);
            JCTree.JCPackageDecl pd = this.toP(this.F.at(packagePos).PackageDecl(annotations, pid));
            this.attach(pd, firstToken.docComment());
            consumedToplevelDoc = true;
            defs.append(pd);
            this.updateUnexpectedTopLevelDefinitionStartError(true);
        }
        boolean firstTypeDecl = true;
        boolean isImplicitClass = false;
        block0: while (this.token.kind != Tokens.TokenKind.EOF) {
            if (this.token.pos <= this.endPosTable.errorEndPos) {
                this.skip(firstTypeDecl, false, false, false);
                if (this.token.kind == Tokens.TokenKind.EOF) break;
            }
            ListBuffer<JCTree.JCSkip> semiList = new ListBuffer<JCTree.JCSkip>();
            while (firstTypeDecl && mods == null && this.token.kind == Tokens.TokenKind.SEMI) {
                int pos = this.token.pos;
                this.nextToken();
                semiList.append(this.toP(this.F.at(pos).Skip()));
                if (this.token.kind != Tokens.TokenKind.EOF) continue;
                break block0;
            }
            if (firstTypeDecl && mods == null && this.token.kind == Tokens.TokenKind.IMPORT) {
                if (!semiList.isEmpty()) {
                    if (this.source.compareTo(Source.JDK21) >= 0) {
                        this.reportSyntaxError(((JCTree)semiList.first()).pos, CompilerProperties.Errors.ExtraneousSemicolon);
                    } else {
                        this.log.warning(((JCTree)semiList.first()).pos, CompilerProperties.Warnings.ExtraneousSemicolon);
                    }
                }
                seenImport = true;
                defs.append(this.importDeclaration());
                continue;
            }
            Tokens.Comment docComment = this.token.docComment();
            if (firstTypeDecl && !seenImport && !seenPackage) {
                docComment = firstToken.docComment();
                consumedToplevelDoc = true;
            }
            if (mods != null || this.token.kind != Tokens.TokenKind.SEMI) {
                mods = this.modifiersOpt(mods);
            }
            if (firstTypeDecl && this.token.kind == Tokens.TokenKind.IDENTIFIER) {
                if (!semiList.isEmpty()) {
                    if (this.source.compareTo(Source.JDK21) >= 0) {
                        this.reportSyntaxError(((JCTree)semiList.first()).pos, CompilerProperties.Errors.ExtraneousSemicolon);
                    } else {
                        this.log.warning(((JCTree)semiList.first()).pos, CompilerProperties.Warnings.ExtraneousSemicolon);
                    }
                }
                ModuleTree.ModuleKind kind = ModuleTree.ModuleKind.STRONG;
                if (this.token.name() == this.names.open) {
                    kind = ModuleTree.ModuleKind.OPEN;
                    this.nextToken();
                }
                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.module) {
                    if (mods != null) {
                        this.checkNoMods(mods.flags & 0xFFFFFFFFFFFDFFFFL);
                    }
                    defs.append(this.moduleDecl(mods, kind, docComment));
                    consumedToplevelDoc = true;
                    break;
                }
                if (kind != ModuleTree.ModuleKind.STRONG) {
                    this.reportSyntaxError(this.token.pos, CompilerProperties.Errors.ExpectedModule);
                }
            }
            defs.appendList(semiList.toList());
            boolean isTopLevelMethodOrField = false;
            if (!this.isDeclaration(true)) {
                JCTree.JCModifiers finalMods = mods;
                VirtualParser speculative = new VirtualParser(this);
                List<JCTree> speculativeResult = speculative.topLevelMethodOrFieldDeclaration(finalMods, null);
                if (((JCTree)speculativeResult.head).hasTag(JCTree.Tag.METHODDEF) || ((JCTree)speculativeResult.head).hasTag(JCTree.Tag.VARDEF)) {
                    isTopLevelMethodOrField = true;
                }
            }
            if (isTopLevelMethodOrField) {
                this.checkSourceLevel(this.token.pos, Source.Feature.IMPLICIT_CLASSES);
                defs.appendList(this.topLevelMethodOrFieldDeclaration(mods, docComment));
                isImplicitClass = true;
            } else if (this.isDefiniteStatementStartToken()) {
                int startPos = this.token.pos;
                List<JCTree.JCStatement> statements = this.blockStatement();
                defs.append(this.syntaxError(startPos, statements, CompilerProperties.Errors.StatementNotExpected, true));
            } else {
                JCTree def = this.typeDeclaration(mods, docComment);
                if (def instanceof JCTree.JCExpressionStatement) {
                    JCTree.JCExpressionStatement statement = (JCTree.JCExpressionStatement)def;
                    def = statement.expr;
                }
                defs.append(def);
            }
            mods = null;
            firstTypeDecl = false;
        }
        List<JCTree> topLevelDefs = isImplicitClass ? this.constructImplicitClass(defs.toList(), this.S.prevToken().endPos) : defs.toList();
        JCTree.JCCompilationUnit toplevel = this.F.at(firstToken.pos).TopLevel(topLevelDefs);
        if (!consumedToplevelDoc) {
            this.attach(toplevel, firstToken.docComment());
        }
        if (defs.isEmpty()) {
            this.storeEnd(toplevel, this.S.prevToken().endPos);
        }
        if (this.keepDocComments) {
            toplevel.docComments = this.docComments;
        }
        if (this.keepLineMap) {
            toplevel.lineMap = this.S.getLineMap();
        }
        toplevel.endPositions = this.endPosTable;
        return toplevel;
    }

    private List<JCTree> constructImplicitClass(List<JCTree> origDefs, int endPos) {
        ListBuffer<JCTree> topDefs = new ListBuffer<JCTree>();
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        for (JCTree def : origDefs) {
            if (def.hasTag(JCTree.Tag.PACKAGEDEF)) {
                this.log.error(def.pos(), CompilerProperties.Errors.ImplicitClassShouldNotHavePackageDeclaration);
                continue;
            }
            if (def.hasTag(JCTree.Tag.IMPORT) || def.hasTag(JCTree.Tag.MODULEIMPORT)) {
                topDefs.append(def);
                continue;
            }
            if (def.hasTag(JCTree.Tag.SKIP)) continue;
            defs.append(def);
        }
        int primaryPos = this.getStartPos((JCTree)defs.first());
        String simplename = PathFileObject.getSimpleName(this.log.currentSourceFile());
        if (simplename.endsWith(".java")) {
            simplename = simplename.substring(0, simplename.length() - ".java".length());
        }
        if (!SourceVersion.isIdentifier(simplename) || SourceVersion.isKeyword(simplename)) {
            this.log.error(primaryPos, CompilerProperties.Errors.BadFileName(simplename));
        }
        Name name = this.names.fromString(simplename);
        JCTree.JCModifiers implicitMods = this.F.at(-1).Modifiers(524304L, List.nil());
        JCTree.JCClassDecl implicit = this.F.at(primaryPos).ClassDef(implicitMods, name, List.nil(), null, List.nil(), List.nil(), defs.toList());
        this.storeEnd(implicit, endPos);
        topDefs.append(implicit);
        return topDefs.toList();
    }

    JCTree.JCModuleDecl moduleDecl(JCTree.JCModifiers mods, ModuleTree.ModuleKind kind, Tokens.Comment dc) {
        int pos = this.token.pos;
        this.checkSourceLevel(Source.Feature.MODULES);
        this.nextToken();
        JCTree.JCExpression name = this.qualident(false);
        List<JCTree.JCDirective> directives = null;
        this.accept(Tokens.TokenKind.LBRACE);
        directives = this.moduleDirectiveList();
        this.accept(Tokens.TokenKind.RBRACE);
        int endPos = this.S.prevToken().endPos;
        this.accept(Tokens.TokenKind.EOF);
        JCTree.JCModuleDecl result = this.F.at(pos).ModuleDef(mods, kind, name, directives);
        this.storeEnd(result, endPos);
        return this.attach(result, dc);
    }

    List<JCTree.JCDirective> moduleDirectiveList() {
        ListBuffer<JCTree.JCDirective> defs = new ListBuffer<JCTree.JCDirective>();
        while (this.token.kind == Tokens.TokenKind.IDENTIFIER) {
            int pos = this.token.pos;
            if (this.token.name() == this.names.requires) {
                this.nextToken();
                boolean isTransitive = false;
                boolean isStaticPhase = false;
                block5: while (true) {
                    switch (this.token.kind) {
                        case IDENTIFIER: {
                            if (this.token.name() != this.names.transitive) break block5;
                            Tokens.Token t1 = this.S.token(1);
                            if (t1.kind == Tokens.TokenKind.SEMI || t1.kind == Tokens.TokenKind.DOT) break block5;
                            if (isTransitive) {
                                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.RepeatedModifier);
                            }
                            isTransitive = true;
                            break;
                        }
                        case STATIC: {
                            if (isStaticPhase) {
                                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.RepeatedModifier);
                            }
                            isStaticPhase = true;
                            break;
                        }
                        default: {
                            break block5;
                        }
                    }
                    this.nextToken();
                }
                JCTree.JCExpression moduleName = this.qualident(false);
                this.accept(Tokens.TokenKind.SEMI);
                defs.append(this.toP(this.F.at(pos).Requires(isTransitive, isStaticPhase, moduleName)));
                continue;
            }
            if (this.token.name() == this.names.exports || this.token.name() == this.names.opens) {
                boolean exports = this.token.name() == this.names.exports;
                this.nextToken();
                JCTree.JCExpression pkgName = this.qualident(false);
                List<JCTree.JCExpression> moduleNames = null;
                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.to) {
                    this.nextToken();
                    moduleNames = this.qualidentList(false);
                }
                this.accept(Tokens.TokenKind.SEMI);
                JCTree.JCDirective d = exports ? this.F.at(pos).Exports(pkgName, moduleNames) : this.F.at(pos).Opens(pkgName, moduleNames);
                defs.append(this.toP(d));
                continue;
            }
            if (this.token.name() == this.names.provides) {
                List<JCTree.JCExpression> implNames;
                this.nextToken();
                JCTree.JCExpression serviceName = this.qualident(false);
                if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.with) {
                    this.nextToken();
                    implNames = this.qualidentList(false);
                } else {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.ExpectedStr("'" + String.valueOf(this.names.with) + "'"));
                    implNames = List.nil();
                }
                this.accept(Tokens.TokenKind.SEMI);
                defs.append(this.toP(this.F.at(pos).Provides(serviceName, implNames)));
                continue;
            }
            if (this.token.name() == this.names.uses) {
                this.nextToken();
                JCTree.JCExpression service = this.qualident(false);
                this.accept(Tokens.TokenKind.SEMI);
                defs.append(this.toP(this.F.at(pos).Uses(service)));
                continue;
            }
            this.setErrorEndPos(pos);
            this.reportSyntaxError(pos, CompilerProperties.Errors.InvalidModuleDirective);
            break;
        }
        return defs.toList();
    }

    protected JCTree importDeclaration() {
        int pos = this.token.pos;
        this.nextToken();
        boolean importStatic = false;
        if (this.token.kind == Tokens.TokenKind.STATIC) {
            importStatic = true;
            this.nextToken();
        } else if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.module && this.peekToken((Predicate<Tokens.TokenKind>)Tokens.TokenKind.IDENTIFIER)) {
            this.checkSourceLevel(Source.Feature.MODULE_IMPORTS);
            this.nextToken();
            JCTree.JCExpression moduleName = this.qualident(false);
            this.accept(Tokens.TokenKind.SEMI);
            return this.toP(this.F.at(pos).ModuleImport(moduleName));
        }
        JCTree.JCExpression pid = this.toP(this.F.at(this.token.pos).Ident(this.ident()));
        do {
            int pos1 = this.token.pos;
            this.accept(Tokens.TokenKind.DOT);
            if (this.token.kind == Tokens.TokenKind.STAR) {
                pid = this.to(this.F.at(pos1).Select(pid, this.names.asterisk));
                this.nextToken();
                break;
            }
            pid = this.toP(this.F.at(pos1).Select(pid, this.ident()));
        } while (this.token.kind == Tokens.TokenKind.DOT);
        this.accept(Tokens.TokenKind.SEMI);
        return this.toP(this.F.at(pos).Import((JCTree.JCFieldAccess)pid, importStatic));
    }

    JCTree typeDeclaration(JCTree.JCModifiers mods, Tokens.Comment docComment) {
        int pos = this.token.pos;
        if (mods == null && this.token.kind == Tokens.TokenKind.SEMI) {
            this.nextToken();
            return this.toP(this.F.at(pos).Skip());
        }
        return this.classOrRecordOrInterfaceOrEnumDeclaration(this.modifiersOpt(mods), docComment);
    }

    protected JCTree.JCStatement classOrRecordOrInterfaceOrEnumDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) {
        List<JCTree> errs;
        if (this.token.kind == Tokens.TokenKind.CLASS) {
            return this.classDeclaration(mods, dc);
        }
        if (this.isRecordStart()) {
            return this.recordDeclaration(mods, dc);
        }
        if (this.token.kind == Tokens.TokenKind.INTERFACE) {
            return this.interfaceDeclaration(mods, dc);
        }
        if (this.token.kind == Tokens.TokenKind.ENUM) {
            return this.enumDeclaration(mods, dc);
        }
        int pos = this.token.pos;
        if (this.LAX_IDENTIFIER.test(this.token.kind)) {
            errs = List.of(mods, this.toP(this.F.at(pos).Ident(this.ident())));
            this.setErrorEndPos(this.token.pos);
        } else {
            errs = List.of(mods);
        }
        return this.toP(this.F.Exec(this.syntaxError(pos, errs, this.unexpectedTopLevelDefinitionStartError)));
    }

    protected JCTree.JCClassDecl classDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) {
        int pos = this.token.pos;
        this.accept(Tokens.TokenKind.CLASS);
        Name name = this.typeName();
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        JCTree.JCExpression extending = null;
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            this.nextToken();
            extending = this.parseType();
        }
        List<JCTree.JCExpression> implementing = List.nil();
        if (this.token.kind == Tokens.TokenKind.IMPLEMENTS) {
            this.nextToken();
            implementing = this.typeList();
        }
        List<JCTree.JCExpression> permitting = this.permitsClause(mods, "class");
        this.saveDanglingDocComments(dc);
        List<JCTree> defs = this.classInterfaceOrRecordBody(name, false, false);
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, typarams, extending, implementing, permitting, defs));
        return this.attach(result, dc);
    }

    protected JCTree.JCClassDecl recordDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) {
        int pos = this.token.pos;
        this.nextToken();
        mods.flags |= 0x2000000000000000L;
        Name name = this.typeName();
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        List<JCTree.JCVariableDecl> headerFields = this.formalParameters(false, true);
        List<JCTree.JCExpression> implementing = List.nil();
        if (this.token.kind == Tokens.TokenKind.IMPLEMENTS) {
            this.nextToken();
            implementing = this.typeList();
        }
        this.saveDanglingDocComments(dc);
        List<JCTree> defs = this.classInterfaceOrRecordBody(name, false, true);
        ArrayList<JCTree.JCVariableDecl> fields = new ArrayList<JCTree.JCVariableDecl>();
        for (JCTree.JCVariableDecl field : headerFields) {
            fields.add(field);
        }
        for (JCTree def : defs) {
            if (!def.hasTag(JCTree.Tag.METHODDEF)) continue;
            JCTree.JCMethodDecl methDef = (JCTree.JCMethodDecl)def;
            if (methDef.name != this.names.init || !methDef.params.isEmpty() || (methDef.mods.flags & 0x8000000000000L) == 0L) continue;
            ListBuffer<JCTree.JCVariableDecl> tmpParams = new ListBuffer<JCTree.JCVariableDecl>();
            for (JCTree.JCVariableDecl param : headerFields) {
                tmpParams.add(this.F.at(param).VarDef(this.F.Modifiers(0x201008000L | param.mods.flags & 0x400000000L, param.mods.annotations), param.name, param.vartype, null));
            }
            methDef.params = tmpParams.toList();
        }
        for (int i = fields.size() - 1; i >= 0; --i) {
            JCTree.JCVariableDecl field;
            field = (JCTree.JCVariableDecl)fields.get(i);
            defs = defs.prepend(field);
        }
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, typarams, null, implementing, defs));
        return this.attach(result, dc);
    }

    Name typeName() {
        int pos = this.token.pos;
        Name name = this.ident();
        Source source = this.restrictedTypeNameStartingAtSource(name, pos, true);
        if (source != null) {
            this.reportSyntaxError(pos, CompilerProperties.Errors.RestrictedTypeNotAllowed(name, source));
        }
        return name;
    }

    protected JCTree.JCClassDecl interfaceDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) {
        int pos = this.token.pos;
        this.accept(Tokens.TokenKind.INTERFACE);
        Name name = this.typeName();
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        List<JCTree.JCExpression> extending = List.nil();
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            this.nextToken();
            extending = this.typeList();
        }
        List<JCTree.JCExpression> permitting = this.permitsClause(mods, "interface");
        this.saveDanglingDocComments(dc);
        List<JCTree> defs = this.classInterfaceOrRecordBody(name, true, false);
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, typarams, null, extending, permitting, defs));
        return this.attach(result, dc);
    }

    List<JCTree.JCExpression> permitsClause(JCTree.JCModifiers mods, String classOrInterface) {
        if (this.allowSealedTypes && this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.permits) {
            this.checkSourceLevel(Source.Feature.SEALED_CLASSES);
            if ((mods.flags & 0x1000000000000L) == 0L) {
                this.log.error(this.token.pos, CompilerProperties.Errors.InvalidPermitsClause(CompilerProperties.Fragments.ClassIsNotSealed(classOrInterface)));
            }
            this.nextToken();
            return this.qualidentList(false);
        }
        return List.nil();
    }

    protected JCTree.JCClassDecl enumDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) {
        int pos = this.token.pos;
        this.accept(Tokens.TokenKind.ENUM);
        Name name = this.typeName();
        int typeNamePos = this.token.pos;
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt(true);
        if (typarams == null || !typarams.isEmpty()) {
            int errorPosition = typarams == null ? typeNamePos : ((JCTree.JCTypeParameter)typarams.head).pos;
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, errorPosition, CompilerProperties.Errors.EnumCantBeGeneric);
        }
        List<JCTree.JCExpression> implementing = List.nil();
        if (this.token.kind == Tokens.TokenKind.IMPLEMENTS) {
            this.nextToken();
            implementing = this.typeList();
        }
        this.saveDanglingDocComments(dc);
        List<JCTree> defs = this.enumBody(name);
        mods.flags |= 0x4000L;
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, List.nil(), null, implementing, defs));
        return this.attach(result, dc);
    }

    List<JCTree> enumBody(Name enumName) {
        this.accept(Tokens.TokenKind.LBRACE);
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        boolean wasSemi = false;
        boolean hasStructuralErrors = false;
        boolean wasError = false;
        if (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            if (this.token.kind == Tokens.TokenKind.SEMI) {
                wasSemi = true;
                this.nextToken();
            } else if (this.token.kind != Tokens.TokenKind.RBRACE) {
                this.reportSyntaxError(this.S.prevToken().endPos, CompilerProperties.Errors.Expected2(Tokens.TokenKind.RBRACE, Tokens.TokenKind.SEMI));
                wasError = true;
            }
        }
        while (this.token.kind != Tokens.TokenKind.RBRACE && this.token.kind != Tokens.TokenKind.EOF) {
            EnumeratorEstimate memberType;
            if (this.token.kind == Tokens.TokenKind.SEMI) {
                this.accept(Tokens.TokenKind.SEMI);
                wasSemi = true;
                if (this.token.kind == Tokens.TokenKind.RBRACE || this.token.kind == Tokens.TokenKind.EOF) break;
            }
            if ((memberType = this.estimateEnumeratorOrMember(enumName)) == EnumeratorEstimate.UNKNOWN) {
                EnumeratorEstimate enumeratorEstimate = memberType = wasSemi ? EnumeratorEstimate.MEMBER : EnumeratorEstimate.ENUMERATOR;
            }
            if (memberType == EnumeratorEstimate.ENUMERATOR) {
                wasError = false;
                if (wasSemi && !hasStructuralErrors) {
                    this.reportSyntaxError(this.token.pos, CompilerProperties.Errors.EnumConstantNotExpected);
                    hasStructuralErrors = true;
                }
                defs.append(this.enumeratorDeclaration(enumName));
                if (this.token.pos <= this.endPosTable.errorEndPos) {
                    this.skip(false, true, true, false);
                    continue;
                }
                if (this.token.kind == Tokens.TokenKind.RBRACE || this.token.kind == Tokens.TokenKind.SEMI || this.token.kind == Tokens.TokenKind.EOF) continue;
                if (this.token.kind == Tokens.TokenKind.COMMA) {
                    this.nextToken();
                    continue;
                }
                this.setErrorEndPos(this.token.pos);
                this.reportSyntaxError(this.S.prevToken().endPos, CompilerProperties.Errors.Expected3(Tokens.TokenKind.COMMA, Tokens.TokenKind.RBRACE, Tokens.TokenKind.SEMI));
                wasError = true;
                continue;
            }
            if (!(wasSemi || hasStructuralErrors || wasError)) {
                this.reportSyntaxError(this.token.pos, CompilerProperties.Errors.EnumConstantExpected);
                hasStructuralErrors = true;
            }
            wasError = false;
            defs.appendList(this.classOrInterfaceOrRecordBodyDeclaration(null, enumName, false, false));
            if (this.token.pos > this.endPosTable.errorEndPos) continue;
            this.skip(false, true, true, false);
        }
        this.accept(Tokens.TokenKind.RBRACE);
        return defs.toList();
    }

    private EnumeratorEstimate estimateEnumeratorOrMember(Name enumName) {
        boolean ident;
        boolean bl = ident = this.token.kind == Tokens.TokenKind.IDENTIFIER || this.token.kind == Tokens.TokenKind.UNDERSCORE;
        if (!(!ident || this.token.name() == enumName || this.allowRecords && this.isRecordStart())) {
            Tokens.Token next = this.S.token(1);
            switch (next.kind) {
                case SEMI: 
                case LBRACE: 
                case LPAREN: 
                case COMMA: {
                    return EnumeratorEstimate.ENUMERATOR;
                }
            }
        }
        switch (this.token.kind) {
            case IDENTIFIER: {
                if (this.allowRecords && this.isRecordStart()) {
                    return EnumeratorEstimate.MEMBER;
                }
            }
            case MONKEYS_AT: 
            case LT: 
            case UNDERSCORE: {
                return EnumeratorEstimate.UNKNOWN;
            }
        }
        return EnumeratorEstimate.MEMBER;
    }

    JCTree enumeratorDeclaration(Name enumName) {
        Tokens.Comment dc = this.token.docComment();
        int flags = 16409;
        if (this.token.deprecatedFlag()) {
            flags |= 0x20000;
        }
        int pos = this.token.pos;
        List<JCTree.JCAnnotation> annotations = this.annotationsOpt(JCTree.Tag.ANNOTATION);
        JCTree.JCModifiers mods = this.F.at(annotations.isEmpty() ? -1 : pos).Modifiers(flags, annotations);
        List<JCTree.JCExpression> typeArgs = this.typeArgumentsOpt();
        int identPos = this.token.pos;
        Name name = this.ident();
        int createPos = this.token.pos;
        this.saveDanglingDocComments(dc);
        List<Object> args = this.token.kind == Tokens.TokenKind.LPAREN ? this.arguments() : List.nil();
        JCTree.JCClassDecl body = null;
        if (this.token.kind == Tokens.TokenKind.LBRACE) {
            JCTree.JCModifiers mods1 = this.F.at(-1).Modifiers(16384L);
            List<JCTree> defs = this.classInterfaceOrRecordBody(this.names.empty, false, false);
            body = this.toP(this.F.at(identPos).AnonymousClassDef(mods1, defs));
        }
        if (args.isEmpty() && body == null) {
            createPos = identPos;
        }
        JCTree.JCIdent ident = this.F.at(identPos).Ident(enumName);
        JCTree.JCNewClass create = this.F.at(createPos).NewClass(null, typeArgs, ident, args, body);
        if (createPos != identPos) {
            this.storeEnd(create, this.S.prevToken().endPos);
        }
        ident = this.F.at(identPos).Ident(enumName);
        JCTree.JCVariableDecl result = this.toP(this.F.at(pos).VarDef(mods, name, ident, create));
        return this.attach(result, dc);
    }

    List<JCTree.JCExpression> typeList() {
        ListBuffer<JCTree.JCExpression> ts = new ListBuffer<JCTree.JCExpression>();
        ts.append(this.parseType());
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            ts.append(this.parseType());
        }
        return ts.toList();
    }

    List<JCTree> classInterfaceOrRecordBody(Name className, boolean isInterface, boolean isRecord) {
        this.accept(Tokens.TokenKind.LBRACE);
        if (this.token.pos <= this.endPosTable.errorEndPos) {
            this.skip(false, true, false, false);
            if (this.token.kind == Tokens.TokenKind.LBRACE) {
                this.nextToken();
            } else {
                return List.nil();
            }
        }
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        while (this.token.kind != Tokens.TokenKind.RBRACE && this.token.kind != Tokens.TokenKind.EOF) {
            defs.appendList(this.classOrInterfaceOrRecordBodyDeclaration(null, className, isInterface, isRecord));
            if (this.token.pos > this.endPosTable.errorEndPos) continue;
            this.skip(false, true, true, false);
        }
        this.accept(Tokens.TokenKind.RBRACE);
        return defs.toList();
    }

    protected List<JCTree> classOrInterfaceOrRecordBodyDeclaration(JCTree.JCModifiers mods, Name className, boolean isInterface, boolean isRecord) {
        if (this.token.kind == Tokens.TokenKind.SEMI) {
            this.nextToken();
            return List.nil();
        }
        Tokens.Comment dc = this.token.docComment();
        int pos = this.token.pos;
        mods = this.modifiersOpt(mods);
        if (this.isDeclaration()) {
            return List.of(this.classOrRecordOrInterfaceOrEnumDeclaration(mods, dc));
        }
        if (this.token.kind == Tokens.TokenKind.LBRACE && (mods.flags & 0xFFFL & 0xFFFFFFFFFFFFFFF7L) == 0L && mods.annotations.isEmpty()) {
            if (isInterface) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.InitializerNotAllowed);
            } else if (isRecord && (mods.flags & 8L) == 0L) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.InstanceInitializerNotAllowedInRecords);
            }
            this.ignoreDanglingComments();
            return List.of(this.block(pos, mods.flags));
        }
        if (this.isDefiniteStatementStartToken()) {
            int startPos = this.token.pos;
            List<JCTree.JCStatement> statements = this.blockStatement();
            return List.of(this.syntaxError(startPos, statements, CompilerProperties.Errors.StatementNotExpected));
        }
        return this.constructorOrMethodOrFieldDeclaration(mods, className, isInterface, isRecord, dc);
    }

    private List<JCTree> constructorOrMethodOrFieldDeclaration(JCTree.JCModifiers mods, Name className, boolean isInterface, boolean isRecord, Tokens.Comment dc) {
        List<Object> err;
        JCTree.JCExpression type;
        boolean isVoid;
        List<JCTree.JCAnnotation> annosAfterParams;
        int pos = this.token.pos;
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        if (typarams.nonEmpty() && mods.pos == -1) {
            mods.pos = pos;
            this.storeEnd(mods, pos);
        }
        if ((annosAfterParams = this.annotationsOpt(JCTree.Tag.ANNOTATION)).nonEmpty()) {
            mods.annotations = mods.annotations.appendList(annosAfterParams);
            if (mods.pos == -1) {
                mods.pos = ((JCTree.JCAnnotation)mods.annotations.head).pos;
            }
        }
        Tokens.Token tk = this.token;
        pos = this.token.pos;
        boolean bl = isVoid = this.token.kind == Tokens.TokenKind.VOID;
        if (isVoid) {
            type = this.to(this.F.at(pos).TypeIdent(TypeTag.VOID));
            this.nextToken();
        } else {
            type = this.unannotatedType(false);
        }
        if ((this.token.kind == Tokens.TokenKind.LPAREN && !isInterface || isRecord && this.token.kind == Tokens.TokenKind.LBRACE) && type.hasTag(JCTree.Tag.IDENT)) {
            if (isInterface || tk.name() != className) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, pos, CompilerProperties.Errors.InvalidMethDeclRetTypeReq);
            } else if (annosAfterParams.nonEmpty()) {
                this.illegal(((JCTree.JCAnnotation)annosAfterParams.head).pos);
            }
            if (isRecord && this.token.kind == Tokens.TokenKind.LBRACE) {
                mods.flags |= 0x8000000000000L;
            }
            return List.of(this.methodDeclaratorRest(pos, mods, null, this.names.init, typarams, isInterface, true, isRecord, dc));
        }
        if (isRecord && type.hasTag(JCTree.Tag.IDENT) && this.token.kind == Tokens.TokenKind.THROWS) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, this.token.pos, CompilerProperties.Errors.InvalidCanonicalConstructorInRecord(CompilerProperties.Fragments.Compact, className, CompilerProperties.Fragments.ThrowsClauseNotAllowedForCanonicalConstructor(CompilerProperties.Fragments.Compact)));
            this.skip(false, true, false, false);
            return List.of(this.methodDeclaratorRest(pos, mods, null, this.names.init, typarams, isInterface, true, isRecord, dc));
        }
        pos = this.token.pos;
        Name name = this.ident();
        if (this.token.kind == Tokens.TokenKind.LPAREN) {
            return List.of(this.methodDeclaratorRest(pos, mods, type, name, typarams, isInterface, isVoid, false, dc));
        }
        if (!isVoid && typarams.isEmpty()) {
            if (!isRecord || isRecord && (mods.flags & 8L) != 0L) {
                List<JCTree> defs = this.variableDeclaratorsRest(pos, mods, type, name, isInterface, dc, new ListBuffer(), false).toList();
                this.accept(Tokens.TokenKind.SEMI);
                this.storeEnd((JCTree)defs.last(), this.S.prevToken().endPos);
                return defs;
            }
            int errPos = pos;
            this.variableDeclaratorsRest(pos, mods, type, name, isInterface, dc, new ListBuffer(), false).toList();
            this.accept(Tokens.TokenKind.SEMI);
            return List.of(this.syntaxError(errPos, null, CompilerProperties.Errors.RecordCannotDeclareInstanceFields));
        }
        pos = this.token.pos;
        if (isVoid || typarams.nonEmpty()) {
            JCTree.JCMethodDecl m = this.toP(this.F.at(pos).MethodDef(mods, name, type, typarams, List.nil(), List.nil(), null, null));
            this.attach(m, dc);
            err = List.of(m);
        } else {
            err = List.nil();
        }
        return List.of(this.syntaxError(this.token.pos, err, CompilerProperties.Errors.Expected(Tokens.TokenKind.LPAREN)));
    }

    private List<JCTree> topLevelMethodOrFieldDeclaration(JCTree.JCModifiers mods, Tokens.Comment dc) throws AssertionError {
        JCTree.JCExpression type;
        boolean isVoid;
        List<JCTree.JCAnnotation> annosAfterParams;
        int pos = this.token.pos;
        dc = dc == null ? this.token.docComment() : dc;
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        if (typarams.nonEmpty() && mods.pos == -1) {
            mods.pos = pos;
            this.storeEnd(mods, pos);
        }
        if ((annosAfterParams = this.annotationsOpt(JCTree.Tag.ANNOTATION)).nonEmpty()) {
            mods.annotations = mods.annotations.appendList(annosAfterParams);
            if (mods.pos == -1) {
                mods.pos = ((JCTree.JCAnnotation)mods.annotations.head).pos;
            }
        }
        pos = this.token.pos;
        boolean bl = isVoid = this.token.kind == Tokens.TokenKind.VOID;
        if (isVoid) {
            type = this.to(this.F.at(pos).TypeIdent(TypeTag.VOID));
            this.nextToken();
        } else {
            type = this.unannotatedType(false);
        }
        if (this.token.kind == Tokens.TokenKind.IDENTIFIER) {
            pos = this.token.pos;
            Name name = this.ident();
            if (this.token.kind == Tokens.TokenKind.LPAREN) {
                return List.of(this.methodDeclaratorRest(pos, mods, type, name, typarams, false, isVoid, false, dc));
            }
            if (!isVoid && typarams.isEmpty() && (this.token.kind == Tokens.TokenKind.EQ || this.token.kind == Tokens.TokenKind.SEMI)) {
                List<JCTree> defs = this.variableDeclaratorsRest(pos, mods, type, name, false, dc, new ListBuffer(), false).toList();
                this.accept(Tokens.TokenKind.SEMI);
                this.storeEnd((JCTree)defs.last(), this.S.prevToken().endPos);
                return defs;
            }
        } else if (this.token.kind == Tokens.TokenKind.LPAREN && type.hasTag(JCTree.Tag.IDENT)) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, pos, CompilerProperties.Errors.InvalidMethDeclRetTypeReq);
            return List.of(this.methodDeclaratorRest(pos, mods, null, this.names.init, typarams, false, true, false, dc));
        }
        return List.of(this.F.Erroneous());
    }

    protected boolean isDeclaration() {
        return this.isDeclaration(this.allowRecords);
    }

    private boolean isDeclaration(boolean allowRecords) {
        return this.token.kind == Tokens.TokenKind.CLASS || this.token.kind == Tokens.TokenKind.INTERFACE || this.token.kind == Tokens.TokenKind.ENUM || this.isRecordStart() && allowRecords;
    }

    private boolean isDefiniteStatementStartToken() {
        return switch (this.token.kind) {
            case Tokens.TokenKind.IF, Tokens.TokenKind.FOR, Tokens.TokenKind.WHILE, Tokens.TokenKind.DO, Tokens.TokenKind.TRY, Tokens.TokenKind.SWITCH, Tokens.TokenKind.RETURN, Tokens.TokenKind.THROW, Tokens.TokenKind.BREAK, Tokens.TokenKind.CONTINUE, Tokens.TokenKind.ASSERT -> true;
            default -> false;
        };
    }

    protected boolean isRecordStart() {
        if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.record && this.peekToken((Predicate<Tokens.TokenKind>)Tokens.TokenKind.IDENTIFIER)) {
            this.checkSourceLevel(Source.Feature.RECORDS);
            return true;
        }
        return false;
    }

    protected boolean isNonSealedClassStart(boolean local) {
        if (this.isNonSealedIdentifier(this.token, 0)) {
            Tokens.Token next = this.S.token(3);
            return this.allowedAfterSealedOrNonSealed(next, local, true);
        }
        return false;
    }

    protected boolean isNonSealedIdentifier(Tokens.Token someToken, int lookAheadOffset) {
        if (someToken.name() == this.names.non && this.peekToken(lookAheadOffset, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.SUB, (Predicate<Tokens.TokenKind>)Tokens.TokenKind.IDENTIFIER)) {
            Tokens.Token tokenSub = this.S.token(lookAheadOffset + 1);
            Tokens.Token tokenSealed = this.S.token(lookAheadOffset + 2);
            if (someToken.endPos == tokenSub.pos && tokenSub.endPos == tokenSealed.pos && tokenSealed.name() == this.names.sealed) {
                this.checkSourceLevel(Source.Feature.SEALED_CLASSES);
                return true;
            }
        }
        return false;
    }

    protected boolean isValueModifier() {
        if (this.token.kind == Tokens.TokenKind.IDENTIFIER && this.token.name() == this.names.value) {
            boolean isValueModifier = false;
            Tokens.Token next = this.S.token(1);
            switch (next.kind) {
                case PUBLIC: 
                case FINAL: 
                case ABSTRACT: 
                case MONKEYS_AT: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case PRIVATE: 
                case PROTECTED: 
                case STATIC: 
                case TRANSIENT: 
                case NATIVE: 
                case VOLATILE: 
                case SYNCHRONIZED: 
                case STRICTFP: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: 
                case DEFAULT: {
                    isValueModifier = true;
                    break;
                }
                case IDENTIFIER: {
                    if (next.name() != this.names.record && next.name() != this.names.value && (this.mode & 1) == 0) break;
                    isValueModifier = true;
                }
            }
            if (isValueModifier) {
                this.checkSourceLevel(Source.Feature.VALUE_CLASSES);
                return true;
            }
        }
        return false;
    }

    protected boolean isSealedClassStart(boolean local) {
        Tokens.Token next;
        if (this.token.name() == this.names.sealed && this.allowedAfterSealedOrNonSealed(next = this.S.token(1), local, false)) {
            this.checkSourceLevel(Source.Feature.SEALED_CLASSES);
            return true;
        }
        return false;
    }

    private boolean allowedAfterSealedOrNonSealed(Tokens.Token next, boolean local, boolean currentIsNonSealed) {
        boolean bl;
        if (local) {
            switch (next.kind) {
                case MONKEYS_AT: {
                    Tokens.Token afterNext = this.S.token(2);
                    if (afterNext.kind != Tokens.TokenKind.INTERFACE || currentIsNonSealed) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case FINAL: 
                case ABSTRACT: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case STRICTFP: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        } else {
            switch (next.kind) {
                case MONKEYS_AT: {
                    Tokens.Token afterNext = this.S.token(2);
                    if (afterNext.kind != Tokens.TokenKind.INTERFACE || currentIsNonSealed) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case PUBLIC: 
                case FINAL: 
                case ABSTRACT: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case PRIVATE: 
                case PROTECTED: 
                case STATIC: 
                case STRICTFP: {
                    bl = true;
                    break;
                }
                case IDENTIFIER: {
                    if (this.isNonSealedIdentifier(next, currentIsNonSealed ? 3 : 1) || next.name() == this.names.sealed || this.allowValueClasses && next.name() == this.names.value) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JCTree methodDeclaratorRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, List<JCTree.JCTypeParameter> typarams, boolean isInterface, boolean isVoid, boolean isRecord, Tokens.Comment dc) {
        if (isInterface && (mods.flags & 2L) != 0L) {
            this.checkSourceLevel(Source.Feature.PRIVATE_INTERFACE_METHODS);
        }
        JCTree.JCVariableDecl prevReceiverParam = this.receiverParam;
        try {
            JCTree.JCExpression defaultValue;
            boolean unclosedParameterList;
            this.receiverParam = null;
            List<JCTree.JCVariableDecl> params = List.nil();
            List<JCTree.JCExpression> thrown = List.nil();
            if (!isRecord || name != this.names.init || this.token.kind == Tokens.TokenKind.LPAREN) {
                params = this.formalParameters();
                boolean bl = unclosedParameterList = this.token.pos == this.endPosTable.errorEndPos;
                if (!isVoid) {
                    type = this.bracketsOpt(type);
                }
                if (this.token.kind == Tokens.TokenKind.THROWS) {
                    this.nextToken();
                    thrown = this.qualidentList(true);
                }
            } else {
                unclosedParameterList = false;
            }
            this.saveDanglingDocComments(dc);
            JCTree.JCBlock body = null;
            if (this.token.kind == Tokens.TokenKind.LBRACE) {
                body = this.block();
                defaultValue = null;
            } else {
                boolean parseAsBlock;
                if (this.token.kind == Tokens.TokenKind.DEFAULT) {
                    this.accept(Tokens.TokenKind.DEFAULT);
                    defaultValue = this.annotationValue();
                    this.accept(Tokens.TokenKind.SEMI);
                } else {
                    defaultValue = null;
                    this.accept(Tokens.TokenKind.SEMI, tk -> CompilerProperties.Errors.Expected2(Tokens.TokenKind.LBRACE, Tokens.TokenKind.SEMI));
                }
                if (this.token.pos <= this.endPosTable.errorEndPos && (parseAsBlock = this.openingBraceMissing(unclosedParameterList))) {
                    body = this.block();
                }
            }
            JCTree.JCMethodDecl result = this.toP(this.F.at(pos).MethodDef(mods, name, type, typarams, this.receiverParam, params, thrown, body, defaultValue));
            JCTree.JCMethodDecl jCMethodDecl = this.attach(result, dc);
            return jCMethodDecl;
        }
        finally {
            this.receiverParam = prevReceiverParam;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean openingBraceMissing(boolean unclosedParameterList) {
        this.skip(false, true, !unclosedParameterList, !unclosedParameterList);
        if (this.token.kind == Tokens.TokenKind.LBRACE) {
            return true;
        }
        if (unclosedParameterList) {
            return false;
        }
        switch (this.token.kind) {
            case CASE: 
            case DEFAULT: 
            case IF: 
            case FOR: 
            case WHILE: 
            case DO: 
            case TRY: 
            case SWITCH: 
            case RETURN: 
            case THROW: 
            case BREAK: 
            case CONTINUE: 
            case ELSE: 
            case FINALLY: 
            case CATCH: 
            case THIS: 
            case SUPER: 
            case NEW: {
                return true;
            }
            case RBRACE: {
                int braceBalance = 1;
                VirtualParser.VirtualScanner virtualScanner = new VirtualParser.VirtualScanner(this.S);
                virtualScanner.nextToken();
                while (virtualScanner.token().kind != Tokens.TokenKind.EOF) {
                    switch (virtualScanner.token().kind) {
                        case LBRACE: {
                            ++braceBalance;
                            break;
                        }
                        case RBRACE: {
                            --braceBalance;
                        }
                    }
                    virtualScanner.nextToken();
                }
                if (braceBalance != 0) return false;
                return true;
            }
            default: {
                VirtualParser speculative = new VirtualParser(this);
                JCTree.JCBlock speculativeResult = speculative.block();
                if (speculativeResult.stats.isEmpty()) return false;
                JCTree.JCStatement last = speculativeResult.stats.last();
                if (!speculativeResult.stats.stream().allMatch(s -> s.hasTag(JCTree.Tag.VARDEF) || s.hasTag(JCTree.Tag.CLASSDEF) || s.hasTag(JCTree.Tag.BLOCK) || s == last)) return true;
                if (!(last instanceof JCTree.JCExpressionStatement)) return true;
                JCTree.JCExpressionStatement exprStatement = (JCTree.JCExpressionStatement)last;
                if (exprStatement.expr.hasTag(JCTree.Tag.ERRONEOUS)) return false;
                return true;
            }
        }
    }

    List<JCTree.JCExpression> qualidentList(boolean allowAnnos) {
        JCTree.JCExpression at;
        ListBuffer<JCTree.JCExpression> ts = new ListBuffer<JCTree.JCExpression>();
        List<Object> typeAnnos = allowAnnos ? this.typeAnnotationsOpt() : List.nil();
        JCTree.JCExpression qi = this.qualident(allowAnnos);
        if (!typeAnnos.isEmpty()) {
            at = this.insertAnnotationsToMostInner(qi, typeAnnos, false);
            ts.append(at);
        } else {
            ts.append(qi);
        }
        while (this.token.kind == Tokens.TokenKind.COMMA) {
            this.nextToken();
            typeAnnos = allowAnnos ? this.typeAnnotationsOpt() : List.nil();
            qi = this.qualident(allowAnnos);
            if (!typeAnnos.isEmpty()) {
                at = this.insertAnnotationsToMostInner(qi, typeAnnos, false);
                ts.append(at);
                continue;
            }
            ts.append(qi);
        }
        return ts.toList();
    }

    protected List<JCTree.JCTypeParameter> typeParametersOpt() {
        return this.typeParametersOpt(false);
    }

    protected List<JCTree.JCTypeParameter> typeParametersOpt(boolean parseEmpty) {
        if (this.token.kind == Tokens.TokenKind.LT) {
            ListBuffer<JCTree.JCTypeParameter> typarams = new ListBuffer<JCTree.JCTypeParameter>();
            this.nextToken();
            if (parseEmpty && this.token.kind == Tokens.TokenKind.GT) {
                this.accept(Tokens.TokenKind.GT);
                return null;
            }
            typarams.append(this.typeParameter());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                typarams.append(this.typeParameter());
            }
            this.accept(Tokens.TokenKind.GT);
            return typarams.toList();
        }
        return List.nil();
    }

    JCTree.JCTypeParameter typeParameter() {
        int pos = this.token.pos;
        List<JCTree.JCAnnotation> annos = this.typeAnnotationsOpt();
        Name name = this.typeName();
        ListBuffer<JCTree.JCExpression> bounds = new ListBuffer<JCTree.JCExpression>();
        if (this.token.kind == Tokens.TokenKind.EXTENDS) {
            this.nextToken();
            bounds.append(this.parseType());
            while (this.token.kind == Tokens.TokenKind.AMP) {
                this.nextToken();
                bounds.append(this.parseType());
            }
        }
        return this.toP(this.F.at(pos).TypeParameter(name, bounds.toList(), annos));
    }

    List<JCTree.JCVariableDecl> formalParameters() {
        return this.formalParameters(false, false);
    }

    List<JCTree.JCVariableDecl> formalParameters(boolean lambdaParameters, boolean recordComponents) {
        ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
        this.accept(Tokens.TokenKind.LPAREN);
        if (this.token.kind != Tokens.TokenKind.RPAREN) {
            this.allowThisIdent = !lambdaParameters && !recordComponents;
            JCTree.JCVariableDecl lastParam = this.formalParameter(lambdaParameters, recordComponents);
            if (lastParam.nameexpr != null) {
                this.receiverParam = lastParam;
            } else {
                params.append(lastParam);
            }
            this.allowThisIdent = false;
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                if ((lastParam.mods.flags & 0x400000000L) != 0L) {
                    this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, lastParam, CompilerProperties.Errors.VarargsMustBeLast);
                }
                this.nextToken();
                lastParam = this.formalParameter(lambdaParameters, recordComponents);
                params.append(lastParam);
            }
        }
        if (this.token.kind == Tokens.TokenKind.RPAREN) {
            this.nextToken();
        } else {
            this.setErrorEndPos(this.token.pos);
            this.reportSyntaxError(this.S.prevToken().endPos, CompilerProperties.Errors.Expected3(Tokens.TokenKind.COMMA, Tokens.TokenKind.RPAREN, Tokens.TokenKind.LBRACKET));
        }
        return params.toList();
    }

    List<JCTree.JCVariableDecl> implicitParameters(boolean hasParens) {
        if (hasParens) {
            this.accept(Tokens.TokenKind.LPAREN);
        }
        ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
        if (this.token.kind != Tokens.TokenKind.RPAREN && this.token.kind != Tokens.TokenKind.ARROW) {
            params.append(this.implicitParameter());
            while (this.token.kind == Tokens.TokenKind.COMMA) {
                this.nextToken();
                params.append(this.implicitParameter());
            }
        }
        if (hasParens) {
            this.accept(Tokens.TokenKind.RPAREN);
        }
        return params.toList();
    }

    JCTree.JCModifiers optFinal(long flags) {
        JCTree.JCModifiers mods = this.modifiersOpt();
        this.checkNoMods(mods.flags & 0xFFFFFFFFFFFDFFEFL);
        mods.flags |= flags;
        return mods;
    }

    private JCTree.JCExpression insertAnnotationsToMostInner(JCTree.JCExpression type, List<JCTree.JCAnnotation> annos, boolean createNewLevel) {
        int origEndPos = this.getEndPos(type);
        JCTree.JCExpression mostInnerType = type;
        JCTree.JCArrayTypeTree mostInnerArrayType = null;
        while (TreeInfo.typeIn(mostInnerType).hasTag(JCTree.Tag.TYPEARRAY)) {
            mostInnerArrayType = (JCTree.JCArrayTypeTree)TreeInfo.typeIn(mostInnerType);
            mostInnerType = mostInnerArrayType.elemtype;
        }
        if (createNewLevel) {
            mostInnerType = this.to(this.F.at(this.token.pos).TypeArray(mostInnerType));
            origEndPos = this.getEndPos(mostInnerType);
        }
        JCTree.JCExpression mostInnerTypeToReturn = mostInnerType;
        if (annos.nonEmpty()) {
            JCTree.JCExpression lastToModify = mostInnerType;
            while (TreeInfo.typeIn(mostInnerType).hasTag(JCTree.Tag.SELECT) || TreeInfo.typeIn(mostInnerType).hasTag(JCTree.Tag.TYPEAPPLY)) {
                while (TreeInfo.typeIn(mostInnerType).hasTag(JCTree.Tag.SELECT)) {
                    lastToModify = mostInnerType;
                    mostInnerType = ((JCTree.JCFieldAccess)TreeInfo.typeIn(mostInnerType)).getExpression();
                }
                while (TreeInfo.typeIn(mostInnerType).hasTag(JCTree.Tag.TYPEAPPLY)) {
                    lastToModify = mostInnerType;
                    mostInnerType = ((JCTree.JCTypeApply)TreeInfo.typeIn((JCTree.JCExpression)mostInnerType)).clazz;
                }
            }
            mostInnerType = this.F.at(((JCTree.JCAnnotation)annos.head).pos).AnnotatedType(annos, mostInnerType);
            if (TreeInfo.typeIn(lastToModify).hasTag(JCTree.Tag.TYPEAPPLY)) {
                ((JCTree.JCTypeApply)TreeInfo.typeIn((JCTree.JCExpression)lastToModify)).clazz = mostInnerType;
            } else if (TreeInfo.typeIn(lastToModify).hasTag(JCTree.Tag.SELECT)) {
                ((JCTree.JCFieldAccess)TreeInfo.typeIn((JCTree.JCExpression)lastToModify)).selected = mostInnerType;
            } else {
                mostInnerTypeToReturn = mostInnerType;
            }
        }
        if (mostInnerArrayType == null) {
            return mostInnerTypeToReturn;
        }
        mostInnerArrayType.elemtype = mostInnerTypeToReturn;
        return this.storeEnd(type, origEndPos);
    }

    protected JCTree.JCVariableDecl formalParameter(boolean lambdaParameter, boolean recordComponent) {
        JCTree.JCModifiers mods;
        JCTree.JCModifiers jCModifiers = mods = !recordComponent ? this.optFinal(0x200000000L) : this.modifiersOpt();
        if (recordComponent && mods.flags != 0L) {
            this.log.error(mods.pos, CompilerProperties.Errors.RecordCantDeclareFieldModifiers);
        }
        if (recordComponent) {
            mods.flags |= 0x2000000001000012L;
        }
        this.permitTypeAnnotationsPushBack = true;
        JCTree.JCExpression type = this.parseType(lambdaParameter);
        this.permitTypeAnnotationsPushBack = false;
        if (this.token.kind == Tokens.TokenKind.ELLIPSIS) {
            List<JCTree.JCAnnotation> varargsAnnos = this.typeAnnotationsPushedBack;
            this.typeAnnotationsPushedBack = List.nil();
            mods.flags |= 0x400000000L;
            type = this.insertAnnotationsToMostInner(type, varargsAnnos, true);
            this.nextToken();
        } else {
            if (this.typeAnnotationsPushedBack.nonEmpty()) {
                this.reportSyntaxError(((JCTree.JCAnnotation)this.typeAnnotationsPushedBack.head).pos, CompilerProperties.Errors.IllegalStartOfType);
            }
            this.typeAnnotationsPushedBack = List.nil();
        }
        return this.variableDeclaratorId(mods, type, false, lambdaParameter, recordComponent);
    }

    protected JCTree.JCVariableDecl implicitParameter() {
        JCTree.JCModifiers mods = this.F.at(this.token.pos).Modifiers(0x200000000L);
        return this.variableDeclaratorId(mods, null, false, true, false);
    }

    protected JCTree.JCExpression checkExprStat(JCTree.JCExpression t) {
        if (!TreeInfo.isExpressionStatement(t)) {
            JCTree.JCErroneous ret = this.F.at(t.pos).Erroneous(List.of(t));
            this.log.error(JCDiagnostic.DiagnosticFlag.SYNTAX, ret, CompilerProperties.Errors.NotStmt);
            return ret;
        }
        return t;
    }

    static int prec(Tokens.TokenKind token) {
        JCTree.Tag oc = JavacParser.optag(token);
        return oc != JCTree.Tag.NO_TAG ? TreeInfo.opPrec(oc) : -1;
    }

    static int earlier(int pos1, int pos2) {
        if (pos1 == -1) {
            return pos2;
        }
        if (pos2 == -1) {
            return pos1;
        }
        return pos1 < pos2 ? pos1 : pos2;
    }

    static JCTree.Tag optag(Tokens.TokenKind token) {
        switch (token) {
            case BARBAR: {
                return JCTree.Tag.OR;
            }
            case AMPAMP: {
                return JCTree.Tag.AND;
            }
            case BAR: {
                return JCTree.Tag.BITOR;
            }
            case BAREQ: {
                return JCTree.Tag.BITOR_ASG;
            }
            case CARET: {
                return JCTree.Tag.BITXOR;
            }
            case CARETEQ: {
                return JCTree.Tag.BITXOR_ASG;
            }
            case AMP: {
                return JCTree.Tag.BITAND;
            }
            case AMPEQ: {
                return JCTree.Tag.BITAND_ASG;
            }
            case EQEQ: {
                return JCTree.Tag.EQ;
            }
            case BANGEQ: {
                return JCTree.Tag.NE;
            }
            case LT: {
                return JCTree.Tag.LT;
            }
            case GT: {
                return JCTree.Tag.GT;
            }
            case LTEQ: {
                return JCTree.Tag.LE;
            }
            case GTEQ: {
                return JCTree.Tag.GE;
            }
            case LTLT: {
                return JCTree.Tag.SL;
            }
            case LTLTEQ: {
                return JCTree.Tag.SL_ASG;
            }
            case GTGT: {
                return JCTree.Tag.SR;
            }
            case GTGTEQ: {
                return JCTree.Tag.SR_ASG;
            }
            case GTGTGT: {
                return JCTree.Tag.USR;
            }
            case GTGTGTEQ: {
                return JCTree.Tag.USR_ASG;
            }
            case PLUS: {
                return JCTree.Tag.PLUS;
            }
            case PLUSEQ: {
                return JCTree.Tag.PLUS_ASG;
            }
            case SUB: {
                return JCTree.Tag.MINUS;
            }
            case SUBEQ: {
                return JCTree.Tag.MINUS_ASG;
            }
            case STAR: {
                return JCTree.Tag.MUL;
            }
            case STAREQ: {
                return JCTree.Tag.MUL_ASG;
            }
            case SLASH: {
                return JCTree.Tag.DIV;
            }
            case SLASHEQ: {
                return JCTree.Tag.DIV_ASG;
            }
            case PERCENT: {
                return JCTree.Tag.MOD;
            }
            case PERCENTEQ: {
                return JCTree.Tag.MOD_ASG;
            }
            case INSTANCEOF: {
                return JCTree.Tag.TYPETEST;
            }
        }
        return JCTree.Tag.NO_TAG;
    }

    static JCTree.Tag unoptag(Tokens.TokenKind token) {
        switch (token) {
            case PLUS: {
                return JCTree.Tag.POS;
            }
            case SUB: {
                return JCTree.Tag.NEG;
            }
            case BANG: {
                return JCTree.Tag.NOT;
            }
            case TILDE: {
                return JCTree.Tag.COMPL;
            }
            case PLUSPLUS: {
                return JCTree.Tag.PREINC;
            }
            case SUBSUB: {
                return JCTree.Tag.PREDEC;
            }
        }
        return JCTree.Tag.NO_TAG;
    }

    static TypeTag typetag(Tokens.TokenKind token) {
        switch (token) {
            case BYTE: {
                return TypeTag.BYTE;
            }
            case CHAR: {
                return TypeTag.CHAR;
            }
            case SHORT: {
                return TypeTag.SHORT;
            }
            case INT: {
                return TypeTag.INT;
            }
            case LONG: {
                return TypeTag.LONG;
            }
            case FLOAT: {
                return TypeTag.FLOAT;
            }
            case DOUBLE: {
                return TypeTag.DOUBLE;
            }
            case BOOLEAN: {
                return TypeTag.BOOLEAN;
            }
        }
        return TypeTag.NONE;
    }

    void checkSourceLevel(Source.Feature feature) {
        this.checkSourceLevel(this.token.pos, feature);
    }

    protected void checkSourceLevel(int pos, Source.Feature feature) {
        if (this.preview.isPreview(feature) && !this.preview.isEnabled()) {
            this.log.error(pos, this.preview.disabledError(feature));
        } else if (!feature.allowedInSource(this.source)) {
            this.log.error(pos, feature.error(this.source.name));
        } else if (this.preview.isPreview(feature)) {
            this.preview.warnPreview(pos, feature);
        }
    }

    private void updateUnexpectedTopLevelDefinitionStartError(boolean hasPackageDecl) {
        this.unexpectedTopLevelDefinitionStartError = this.parseModuleInfo ? CompilerProperties.Errors.ExpectedModuleOrOpen : (Source.Feature.IMPLICIT_CLASSES.allowedInSource(this.source) && !hasPackageDecl ? CompilerProperties.Errors.ClassMethodOrFieldExpected : (this.allowRecords ? CompilerProperties.Errors.Expected4(Tokens.TokenKind.CLASS, Tokens.TokenKind.INTERFACE, Tokens.TokenKind.ENUM, "record") : CompilerProperties.Errors.Expected3(Tokens.TokenKind.CLASS, Tokens.TokenKind.INTERFACE, Tokens.TokenKind.ENUM)));
    }

    protected static abstract class AbstractEndPosTable
    implements EndPosTable {
        public int errorEndPos = -1;

        protected AbstractEndPosTable() {
        }

        @Override
        public void setErrorEndPos(int errPos) {
            if (errPos > this.errorEndPos) {
                this.errorEndPos = errPos;
            }
        }
    }

    protected static class SimpleEndPosTable
    extends AbstractEndPosTable {
        private final IntHashTable endPosMap = new IntHashTable();

        protected SimpleEndPosTable() {
        }

        @Override
        public <T extends JCTree> T storeEnd(T tree, int endpos) {
            this.endPosMap.put(tree, Math.max(endpos, this.errorEndPos));
            return tree;
        }

        @Override
        public int getEndPos(JCTree tree) {
            int value = this.endPosMap.get(tree);
            return value == -1 ? -1 : value;
        }

        @Override
        public int replaceTree(JCTree oldTree, JCTree newTree) {
            int pos = this.endPosMap.remove(oldTree);
            if (pos != -1 && newTree != null) {
                this.storeEnd(newTree, pos);
            }
            return pos;
        }
    }

    protected static class MinimalEndPosTable
    extends SimpleEndPosTable {
        protected MinimalEndPosTable() {
        }

        @Override
        public <T extends JCTree> T storeEnd(T tree, int endpos) {
            switch (tree.getTag()) {
                case CLASSDEF: 
                case VARDEF: 
                case MODULEDEF: 
                case PACKAGEDEF: 
                case METHODDEF: {
                    break;
                }
                default: {
                    return tree;
                }
            }
            return super.storeEnd(tree, endpos);
        }
    }

    static enum ParensResult {
        CAST,
        EXPLICIT_LAMBDA,
        IMPLICIT_LAMBDA,
        PARENS;

    }

    class LambdaClassifier {
        LambdaParameterKind kind;
        JCDiagnostic.Fragment diagFragment;

        LambdaClassifier() {
        }

        void addParameter(JCTree.JCVariableDecl param) {
            Assert.check(param.vartype != null);
            if (param.name == JavacParser.this.names.error) {
                this.reduce(LambdaParameterKind.IMPLICIT);
            } else if (JavacParser.this.restrictedTypeName(param.vartype, false) != null) {
                this.reduce(LambdaParameterKind.VAR);
            } else {
                this.reduce(LambdaParameterKind.EXPLICIT);
            }
        }

        private void reduce(LambdaParameterKind newKind) {
            if (this.kind == null) {
                this.kind = newKind;
            } else if (this.kind != newKind && this.kind != LambdaParameterKind.ERROR) {
                LambdaParameterKind currentKind = this.kind;
                this.kind = LambdaParameterKind.ERROR;
                boolean varIndex = currentKind.index == LambdaParameterKind.VAR.index || newKind.index == LambdaParameterKind.VAR.index;
                this.diagFragment = Source.Feature.VAR_SYNTAX_IMPLICIT_LAMBDAS.allowedInSource(JavacParser.this.source) || !varIndex ? decisionTable[currentKind.index][newKind.index] : null;
            }
        }

        LambdaParameterKind result() {
            return this.kind;
        }
    }

    static enum LambdaParameterKind {
        VAR(0),
        EXPLICIT(1),
        IMPLICIT(2),
        ERROR(-1);

        private final int index;

        private LambdaParameterKind(int index) {
            this.index = index;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum BasicErrorRecoveryAction implements ErrorRecoveryAction
    {
        BLOCK_STMT{

            @Override
            public JCTree doRecover(JavacParser parser) {
                return parser.parseStatementAsBlock();
            }
        }
        ,
        CATCH_CLAUSE{

            @Override
            public JCTree doRecover(JavacParser parser) {
                return parser.catchClause();
            }
        };

    }

    static interface ErrorRecoveryAction {
        public JCTree doRecover(JavacParser var1);
    }

    private static enum PatternResult {
        EXPRESSION,
        PATTERN;

    }

    private static enum EnumeratorEstimate {
        ENUMERATOR,
        MEMBER,
        UNKNOWN;

    }
}

