/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.jvm.CRTFlags;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Position;
import java.util.HashMap;
import java.util.Map;

public class CRTable
implements CRTFlags {
    private final boolean crtDebug = false;
    private ListBuffer<CRTEntry> entries = new ListBuffer();
    private Map<Object, SourceRange> positions = new HashMap<Object, SourceRange>();
    private EndPosTable endPosTable;
    JCTree.JCMethodDecl methodTree;

    public CRTable(JCTree.JCMethodDecl tree, EndPosTable endPosTable) {
        this.methodTree = tree;
        this.endPosTable = endPosTable;
    }

    public void put(Object tree, int flags, int startPc, int endPc) {
        this.entries.append(new CRTEntry(tree, flags, startPc, endPc));
    }

    public int writeCRT(ByteBuffer databuf, Position.LineMap lineMap, Log log) {
        int crtEntries = 0;
        new SourceComputer().csp(this.methodTree);
        List<CRTEntry> l = this.entries.toList();
        while (l.nonEmpty()) {
            CRTEntry entry = (CRTEntry)l.head;
            if (entry.startPc != entry.endPc) {
                int endPos;
                int startPos;
                SourceRange pos = this.positions.get(entry.tree);
                Assert.checkNonNull(pos, "CRT: tree source positions are undefined");
                if (pos.startPos != -1 && pos.endPos != -1 && (startPos = this.encodePosition(pos.startPos, lineMap, log)) != -1 && (endPos = this.encodePosition(pos.endPos, lineMap, log)) != -1) {
                    databuf.appendChar(entry.startPc);
                    databuf.appendChar(entry.endPc - 1);
                    databuf.appendInt(startPos);
                    databuf.appendInt(endPos);
                    databuf.appendChar(entry.flags);
                    ++crtEntries;
                }
            }
            l = l.tail;
        }
        return crtEntries;
    }

    public int length() {
        return this.entries.length();
    }

    private String getTypes(int flags) {
        Object types = "";
        if ((flags & 1) != 0) {
            types = (String)types + " CRT_STATEMENT";
        }
        if ((flags & 2) != 0) {
            types = (String)types + " CRT_BLOCK";
        }
        if ((flags & 4) != 0) {
            types = (String)types + " CRT_ASSIGNMENT";
        }
        if ((flags & 8) != 0) {
            types = (String)types + " CRT_FLOW_CONTROLLER";
        }
        if ((flags & 0x10) != 0) {
            types = (String)types + " CRT_FLOW_TARGET";
        }
        if ((flags & 0x20) != 0) {
            types = (String)types + " CRT_INVOKE";
        }
        if ((flags & 0x40) != 0) {
            types = (String)types + " CRT_CREATE";
        }
        if ((flags & 0x80) != 0) {
            types = (String)types + " CRT_BRANCH_TRUE";
        }
        if ((flags & 0x100) != 0) {
            types = (String)types + " CRT_BRANCH_FALSE";
        }
        return types;
    }

    private int encodePosition(int pos, Position.LineMap lineMap, Log log) {
        int col;
        int line = lineMap.getLineNumber(pos);
        int new_pos = Position.encodePosition(line, col = lineMap.getColumnNumber(pos));
        if (new_pos == -1) {
            log.warning(pos, CompilerProperties.Warnings.PositionOverflow(line));
        }
        return new_pos;
    }

    static class CRTEntry {
        Object tree;
        int flags;
        int startPc;
        int endPc;

        CRTEntry(Object tree, int flags, int startPc, int endPc) {
            this.tree = tree;
            this.flags = flags;
            this.startPc = startPc;
            this.endPc = endPc;
        }
    }

    class SourceComputer
    extends JCTree.Visitor {
        SourceRange result;

        SourceComputer() {
        }

        public SourceRange csp(JCTree tree) {
            if (tree == null) {
                return null;
            }
            tree.accept(this);
            if (this.result != null) {
                CRTable.this.positions.put(tree, this.result);
            }
            return this.result;
        }

        public SourceRange csp(List<? extends JCTree> trees) {
            if (trees == null || !trees.nonEmpty()) {
                return null;
            }
            SourceRange list_sr = new SourceRange();
            List<JCTree> l = trees;
            while (l.nonEmpty()) {
                list_sr.mergeWith(this.csp((JCTree)l.head));
                l = l.tail;
            }
            CRTable.this.positions.put(trees, list_sr);
            return list_sr;
        }

        public SourceRange cspCases(List<JCTree.JCCase> trees) {
            if (trees == null || !trees.nonEmpty()) {
                return null;
            }
            SourceRange list_sr = new SourceRange();
            List<JCTree.JCCase> l = trees;
            while (l.nonEmpty()) {
                list_sr.mergeWith(this.csp((JCTree)l.head));
                l = l.tail;
            }
            CRTable.this.positions.put(trees, list_sr);
            return list_sr;
        }

        public SourceRange cspCatchers(List<JCTree.JCCatch> trees) {
            if (trees == null || !trees.nonEmpty()) {
                return null;
            }
            SourceRange list_sr = new SourceRange();
            List<JCTree.JCCatch> l = trees;
            while (l.nonEmpty()) {
                list_sr.mergeWith(this.csp((JCTree)l.head));
                l = l.tail;
            }
            CRTable.this.positions.put(trees, list_sr);
            return list_sr;
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            this.csp(tree.vartype);
            sr.mergeWith(this.csp(tree.init));
            this.result = sr;
        }

        @Override
        public void visitSkip(JCTree.JCSkip tree) {
            SourceRange sr;
            this.result = sr = new SourceRange(this.startPos(tree), this.startPos(tree));
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            this.csp(tree.stats);
            this.result = sr;
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.body));
            sr.mergeWith(this.csp(tree.cond));
            this.result = sr;
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.cond));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.init));
            sr.mergeWith(this.csp(tree.cond));
            sr.mergeWith(this.csp(tree.step));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.var));
            sr.mergeWith(this.csp(tree.expr));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.selector));
            sr.mergeWith(this.cspCases(tree.cases));
            this.result = sr;
        }

        @Override
        public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.selector));
            sr.mergeWith(this.cspCases(tree.cases));
            this.result = sr;
        }

        @Override
        public void visitCase(JCTree.JCCase tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.labels));
            sr.mergeWith(this.csp(tree.guard));
            sr.mergeWith(this.csp(tree.stats));
            this.result = sr;
        }

        @Override
        public void visitDefaultCaseLabel(JCTree.JCDefaultCaseLabel that) {
            this.result = null;
        }

        @Override
        public void visitConstantCaseLabel(JCTree.JCConstantCaseLabel tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.expr));
            this.result = sr;
        }

        @Override
        public void visitPatternCaseLabel(JCTree.JCPatternCaseLabel tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.pat));
            this.result = sr;
        }

        @Override
        public void visitSynchronized(JCTree.JCSynchronized tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.lock));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitTry(JCTree.JCTry tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.resources));
            sr.mergeWith(this.csp(tree.body));
            sr.mergeWith(this.cspCatchers(tree.catchers));
            sr.mergeWith(this.csp(tree.finalizer));
            this.result = sr;
        }

        @Override
        public void visitCatch(JCTree.JCCatch tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.param));
            sr.mergeWith(this.csp(tree.body));
            this.result = sr;
        }

        @Override
        public void visitConditional(JCTree.JCConditional tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.cond));
            sr.mergeWith(this.csp(tree.truepart));
            sr.mergeWith(this.csp(tree.falsepart));
            this.result = sr;
        }

        @Override
        public void visitIf(JCTree.JCIf tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.cond));
            sr.mergeWith(this.csp(tree.thenpart));
            sr.mergeWith(this.csp(tree.elsepart));
            this.result = sr;
        }

        @Override
        public void visitExec(JCTree.JCExpressionStatement tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.expr));
            this.result = sr;
        }

        @Override
        public void visitBreak(JCTree.JCBreak tree) {
            SourceRange sr;
            this.result = sr = new SourceRange(this.startPos(tree), this.endPos(tree));
        }

        @Override
        public void visitYield(JCTree.JCYield tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.value));
            this.result = sr;
        }

        @Override
        public void visitContinue(JCTree.JCContinue tree) {
            SourceRange sr;
            this.result = sr = new SourceRange(this.startPos(tree), this.endPos(tree));
        }

        @Override
        public void visitReturn(JCTree.JCReturn tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.expr));
            this.result = sr;
        }

        @Override
        public void visitThrow(JCTree.JCThrow tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.expr));
            this.result = sr;
        }

        @Override
        public void visitAssert(JCTree.JCAssert tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.cond));
            sr.mergeWith(this.csp(tree.detail));
            this.result = sr;
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.meth));
            sr.mergeWith(this.csp(tree.args));
            this.result = sr;
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.encl));
            sr.mergeWith(this.csp(tree.clazz));
            sr.mergeWith(this.csp(tree.args));
            sr.mergeWith(this.csp(tree.def));
            this.result = sr;
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.elemtype));
            sr.mergeWith(this.csp(tree.dims));
            sr.mergeWith(this.csp(tree.elems));
            this.result = sr;
        }

        @Override
        public void visitParens(JCTree.JCParens tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.expr));
            this.result = sr;
        }

        @Override
        public void visitAssign(JCTree.JCAssign tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.lhs));
            sr.mergeWith(this.csp(tree.rhs));
            this.result = sr;
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.lhs));
            sr.mergeWith(this.csp(tree.rhs));
            this.result = sr;
        }

        @Override
        public void visitUnary(JCTree.JCUnary tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.arg));
            this.result = sr;
        }

        @Override
        public void visitBinary(JCTree.JCBinary tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.lhs));
            sr.mergeWith(this.csp(tree.rhs));
            this.result = sr;
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.clazz));
            sr.mergeWith(this.csp(tree.expr));
            this.result = sr;
        }

        @Override
        public void visitTypeTest(JCTree.JCInstanceOf tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.expr));
            sr.mergeWith(this.csp(tree.pattern));
            this.result = sr;
        }

        @Override
        public void visitIndexed(JCTree.JCArrayAccess tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.indexed));
            sr.mergeWith(this.csp(tree.index));
            this.result = sr;
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.selected));
            this.result = sr;
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            SourceRange sr;
            this.result = sr = new SourceRange(this.startPos(tree), this.endPos(tree));
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral tree) {
            SourceRange sr;
            this.result = sr = new SourceRange(this.startPos(tree), this.endPos(tree));
        }

        @Override
        public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
            SourceRange sr;
            this.result = sr = new SourceRange(this.startPos(tree), this.endPos(tree));
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.elemtype));
            this.result = sr;
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.clazz));
            sr.mergeWith(this.csp(tree.arguments));
            this.result = sr;
        }

        @Override
        public void visitLetExpr(JCTree.LetExpr tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.defs));
            sr.mergeWith(this.csp(tree.expr));
            this.result = sr;
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.bounds));
            this.result = sr;
        }

        @Override
        public void visitTypeUnion(JCTree.JCTypeUnion tree) {
            SourceRange sr = new SourceRange(this.startPos(tree), this.endPos(tree));
            sr.mergeWith(this.csp(tree.alternatives));
            this.result = sr;
        }

        @Override
        public void visitWildcard(JCTree.JCWildcard tree) {
            this.result = null;
        }

        @Override
        public void visitErroneous(JCTree.JCErroneous tree) {
            this.result = null;
        }

        @Override
        public void visitTree(JCTree tree) {
            Assert.error();
        }

        public int startPos(JCTree tree) {
            if (tree == null) {
                return -1;
            }
            return TreeInfo.getStartPos(tree);
        }

        public int endPos(JCTree tree) {
            if (tree == null) {
                return -1;
            }
            return TreeInfo.getEndPos(tree, CRTable.this.endPosTable);
        }
    }

    static class SourceRange {
        int startPos;
        int endPos;

        SourceRange() {
            this.startPos = -1;
            this.endPos = -1;
        }

        SourceRange(int startPos, int endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }

        SourceRange mergeWith(SourceRange sr) {
            if (sr == null) {
                return this;
            }
            if (this.startPos == -1) {
                this.startPos = sr.startPos;
            } else if (sr.startPos != -1) {
                int n = this.startPos = this.startPos < sr.startPos ? this.startPos : sr.startPos;
            }
            if (this.endPos == -1) {
                this.endPos = sr.endPos;
            } else if (sr.endPos != -1) {
                this.endPos = this.endPos > sr.endPos ? this.endPos : sr.endPos;
            }
            return this;
        }
    }
}

