/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.RelativePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Normalizer;
import java.util.Objects;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

public abstract class PathFileObject
implements JavaFileObject {
    private static final FileSystem defaultFileSystem = FileSystems.getDefault();
    private static final boolean isMacOS = System.getProperty("os.name", "").contains("OS X");
    protected final BaseFileManager fileManager;
    protected final Path path;
    private boolean hasParents;

    static PathFileObject forDirectoryPath(BaseFileManager fileManager, Path path, Path userPackageRootDir, RelativePath relativePath) {
        return new DirectoryFileObject(fileManager, path, userPackageRootDir, relativePath);
    }

    public static PathFileObject forJarPath(BaseFileManager fileManager, Path path, Path userJarPath) {
        return new JarFileObject(fileManager, path, userJarPath);
    }

    public static PathFileObject forJRTPath(BaseFileManager fileManager, Path path) {
        return new JRTFileObject(fileManager, path);
    }

    static PathFileObject forSimplePath(BaseFileManager fileManager, Path path, Path userPath) {
        return new SimpleFileObject(fileManager, path, userPath);
    }

    protected PathFileObject(BaseFileManager fileManager, Path path) {
        this.fileManager = Objects.requireNonNull(fileManager);
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("directories not supported");
        }
        this.path = path;
    }

    abstract String inferBinaryName(Iterable<? extends Path> var1);

    abstract PathFileObject getSibling(String var1);

    boolean isJarFile() {
        return this instanceof JarFileObject;
    }

    public Path getPath() {
        return this.path;
    }

    public String getShortName() {
        return this.path.getFileName().toString();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return BaseFileManager.getKind(this.path);
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return this.isPathNameCompatible(this.path, simpleName, kind);
    }

    protected boolean isPathNameCompatible(Path p, String simpleName, JavaFileObject.Kind kind) {
        Objects.requireNonNull(simpleName);
        Objects.requireNonNull(kind);
        if (kind == JavaFileObject.Kind.OTHER && BaseFileManager.getKind(p) != kind) {
            return false;
        }
        String sn = simpleName + kind.extension;
        String pn = p.getFileName().toString();
        if (pn.equals(sn)) {
            return true;
        }
        if (p.getFileSystem() == defaultFileSystem) {
            String normName;
            if (isMacOS && Normalizer.isNormalized(pn, Normalizer.Form.NFD) && Normalizer.isNormalized(sn, Normalizer.Form.NFC) && (normName = Normalizer.normalize(pn, Normalizer.Form.NFC)).equals(sn)) {
                return true;
            }
            if (pn.equalsIgnoreCase(sn)) {
                try {
                    return p.toRealPath(LinkOption.NOFOLLOW_LINKS).getFileName().toString().equals(sn);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    @Override
    public URI toUri() {
        return this.path.toUri();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        this.fileManager.updateLastUsedTime();
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.fileManager.updateLastUsedTime();
        this.fileManager.flushCache(this);
        this.ensureParentDirectoriesExist();
        OutputStream output = Files.newOutputStream(this.path, new OpenOption[0]);
        this.fileManager.newOutputToPath(this.path);
        return output;
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        CharsetDecoder decoder = this.fileManager.getDecoder(this.fileManager.getEncodingName(), ignoreEncodingErrors);
        return new InputStreamReader(this.openInputStream(), decoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        CharBuffer cb = this.fileManager.getCachedContent(this);
        if (cb == null) {
            try (InputStream in = this.openInputStream();){
                ByteBuffer bb = this.fileManager.makeByteBuffer(in);
                JavaFileObject prev = this.fileManager.log.useSource(this);
                try {
                    cb = this.fileManager.decode(bb, ignoreEncodingErrors);
                }
                finally {
                    this.fileManager.log.useSource(prev);
                }
                this.fileManager.recycleByteBuffer(bb);
                if (!ignoreEncodingErrors) {
                    this.fileManager.cache(this, cb);
                }
            }
        }
        return cb;
    }

    @Override
    public Writer openWriter() throws IOException {
        this.fileManager.updateLastUsedTime();
        this.fileManager.flushCache(this);
        this.ensureParentDirectoriesExist();
        OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(this.path, new OpenOption[0]), this.fileManager.getEncodingName());
        this.fileManager.newOutputToPath(this.path);
        return writer;
    }

    @Override
    public long getLastModified() {
        try {
            return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public boolean delete() {
        try {
            Files.delete(this.path);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    boolean isSameFile(PathFileObject other) {
        return this.path.equals(other.path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof PathFileObject)) return false;
        PathFileObject pathFileObject = (PathFileObject)other;
        if (!this.path.equals(pathFileObject.path)) return false;
        return true;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.path) + "]";
    }

    private void ensureParentDirectoriesExist() throws IOException {
        if (!this.hasParents) {
            Path parent = this.path.getParent();
            if (parent != null && !Files.isDirectory(parent, new LinkOption[0])) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new IOException("could not create parent directories", e);
                }
            }
            this.hasParents = true;
        }
    }

    protected static String toBinaryName(RelativePath relativePath) {
        return PathFileObject.toBinaryName(relativePath.path, "/");
    }

    protected static String toBinaryName(Path relativePath) {
        return PathFileObject.toBinaryName(relativePath.toString(), relativePath.getFileSystem().getSeparator());
    }

    private static String toBinaryName(String relativePath, String sep) {
        return PathFileObject.removeExtension(relativePath).replace(sep, ".");
    }

    private static String removeExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(".");
        return lastDot == -1 ? fileName : fileName.substring(0, lastDot);
    }

    public static String getSimpleName(FileObject fo) {
        URI uri = fo.toUri();
        String s = uri.getSchemeSpecificPart();
        return s.substring(s.lastIndexOf("/") + 1);
    }

    private static class DirectoryFileObject
    extends PathFileObject {
        private final Path userPackageRootDir;
        private final RelativePath relativePath;

        private DirectoryFileObject(BaseFileManager fileManager, Path path, Path userPackageRootDir, RelativePath relativePath) {
            super(fileManager, path);
            this.userPackageRootDir = Objects.requireNonNull(userPackageRootDir);
            this.relativePath = relativePath;
        }

        @Override
        public String getName() {
            return this.relativePath.resolveAgainst(this.userPackageRootDir).toString();
        }

        @Override
        public String inferBinaryName(Iterable<? extends Path> paths) {
            return DirectoryFileObject.toBinaryName(this.relativePath);
        }

        @Override
        public String toString() {
            return "DirectoryFileObject[" + String.valueOf(this.userPackageRootDir) + ":" + this.relativePath.path + "]";
        }

        @Override
        PathFileObject getSibling(String baseName) {
            return new DirectoryFileObject(this.fileManager, this.path.resolveSibling(baseName), this.userPackageRootDir, new RelativePath.RelativeFile(this.relativePath.dirname(), baseName));
        }
    }

    private static class JarFileObject
    extends PathFileObject {
        private final Path userJarPath;

        private JarFileObject(BaseFileManager fileManager, Path path, Path userJarPath) {
            super(fileManager, path);
            this.userJarPath = userJarPath;
        }

        @Override
        public String getName() {
            return String.valueOf(this.userJarPath) + "(" + String.valueOf(this.path) + ")";
        }

        @Override
        public String inferBinaryName(Iterable<? extends Path> paths) {
            Path root = this.path.getFileSystem().getRootDirectories().iterator().next();
            return JarFileObject.toBinaryName(root.relativize(this.path));
        }

        @Override
        public String toString() {
            return "JarFileObject[" + String.valueOf(this.userJarPath) + ":" + String.valueOf(this.path) + "]";
        }

        @Override
        PathFileObject getSibling(String baseName) {
            return new JarFileObject(this.fileManager, this.path.resolveSibling(baseName), this.userJarPath);
        }
    }

    private static class JRTFileObject
    extends PathFileObject {
        private JRTFileObject(BaseFileManager fileManager, Path path) {
            super(fileManager, path);
        }

        @Override
        public String getName() {
            return this.path.toString();
        }

        @Override
        public String inferBinaryName(Iterable<? extends Path> paths) {
            return JRTFileObject.toBinaryName(this.path.subpath(2, this.path.getNameCount()));
        }

        @Override
        public String toString() {
            return "JRTFileObject[" + String.valueOf(this.path) + "]";
        }

        @Override
        PathFileObject getSibling(String baseName) {
            return new JRTFileObject(this.fileManager, this.path.resolveSibling(baseName));
        }
    }

    private static class SimpleFileObject
    extends PathFileObject {
        private final Path userPath;

        private SimpleFileObject(BaseFileManager fileManager, Path path, Path userPath) {
            super(fileManager, path);
            this.userPath = userPath;
        }

        @Override
        public String getName() {
            return this.userPath.toString();
        }

        @Override
        public String getShortName() {
            return this.userPath.getFileName().toString();
        }

        @Override
        public String inferBinaryName(Iterable<? extends Path> paths) {
            Path absPath = this.path.toAbsolutePath();
            for (Path path : paths) {
                Path ap = path.toAbsolutePath();
                if (!absPath.startsWith(ap)) continue;
                try {
                    Path rp = ap.relativize(absPath);
                    if (rp == null) continue;
                    return SimpleFileObject.toBinaryName(rp);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            return null;
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return BaseFileManager.getKind(this.userPath);
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            return this.isPathNameCompatible(this.userPath, simpleName, kind);
        }

        @Override
        public URI toUri() {
            return this.userPath.toUri().normalize();
        }

        @Override
        PathFileObject getSibling(String baseName) {
            return new SimpleFileObject(this.fileManager, this.path.resolveSibling(baseName), this.userPath.resolveSibling(baseName));
        }
    }

    public static class CannotCreateUriError
    extends Error {
        private static final long serialVersionUID = 9101708840997613546L;

        public CannotCreateUriError(String value, Throwable cause) {
            super(value, cause);
        }
    }
}

