/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.ModuleFinder;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.AttrRecover;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.InferenceContext;
import com.sun.tools.javac.comp.LocalProxyVarsGen;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.CompilerInternalException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.Iterators;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.lang.model.element.ElementVisitor;

public class Resolve {
    protected static final Context.Key<Resolve> resolveKey = new Context.Key();
    Names names;
    Log log;
    Symtab syms;
    Attr attr;
    AttrRecover attrRecover;
    DeferredAttr deferredAttr;
    Check chk;
    Infer infer;
    Preview preview;
    ClassFinder finder;
    ModuleFinder moduleFinder;
    Types types;
    JCDiagnostic.Factory diags;
    public final boolean allowModules;
    public final boolean allowRecords;
    private final boolean compactMethodDiags;
    private final boolean allowLocalVariableTypeInference;
    private final boolean allowYieldStatement;
    private final boolean allowPrivateMembersInPermitsClause;
    final EnumSet<VerboseResolutionMode> verboseResolutionMode;
    final boolean dumpMethodReferenceSearchResults;
    final boolean dumpStacktraceOnError;
    private final LocalProxyVarsGen localProxyVarsGen;
    Scope.WriteableScope polymorphicSignatureScope;
    private final SymbolNotFoundError varNotFound;
    private final SymbolNotFoundError methodNotFound;
    private final SymbolNotFoundError typeNotFound;
    private final ReferenceLookupResult referenceNotFound;
    Types.SimpleVisitor<Void, Env<AttrContext>> accessibilityChecker = new Types.SimpleVisitor<Void, Env<AttrContext>>(){

        void visit(List<Type> ts, Env<AttrContext> env) {
            for (Type t : ts) {
                this.visit(t, env);
            }
        }

        @Override
        public Void visitType(Type t, Env<AttrContext> env) {
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType t, Env<AttrContext> env) {
            this.visit(t.elemtype, env);
            return null;
        }

        @Override
        public Void visitClassType(Type.ClassType t, Env<AttrContext> env) {
            this.visit((List<Type>)t.getTypeArguments(), env);
            if (!Resolve.this.isAccessible(env, (Type)t, true)) {
                Resolve.this.accessBase(new AccessError(env, null, t.tsym), env.tree.pos(), env.enclClass.sym, t, t.tsym.name, true);
            }
            return null;
        }

        @Override
        public Void visitWildcardType(Type.WildcardType t, Env<AttrContext> env) {
            this.visit(t.type, env);
            return null;
        }

        @Override
        public Void visitMethodType(Type.MethodType t, Env<AttrContext> env) {
            this.visit((List<Type>)t.getParameterTypes(), env);
            this.visit(t.getReturnType(), env);
            this.visit((List<Type>)t.getThrownTypes(), env);
            return null;
        }
    };
    MethodCheck nilMethodCheck = new MethodCheck(){

        @Override
        public void argumentsAcceptable(Env<AttrContext> env, DeferredAttr.DeferredAttrContext deferredAttrContext, List<Type> argtypes, List<Type> formals, Warner warn) {
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> actuals) {
            return this;
        }
    };
    MethodCheck arityMethodCheck = new AbstractMethodCheck(){

        @Override
        void checkArg(JCDiagnostic.DiagnosticPosition pos, boolean varargs, Type actual, Type formal, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warn) {
        }

        public String toString() {
            return "arityMethodCheck";
        }
    };
    MethodCheck resolveMethodCheck = new AbstractMethodCheck(){

        @Override
        void checkArg(JCDiagnostic.DiagnosticPosition pos, boolean varargs, Type actual, Type formal, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warn) {
            Attr.ResultInfo mresult = this.methodCheckResult(varargs, formal, deferredAttrContext, warn);
            mresult.check(pos, actual);
        }

        @Override
        public void argumentsAcceptable(Env<AttrContext> env, DeferredAttr.DeferredAttrContext deferredAttrContext, List<Type> argtypes, List<Type> formals, Warner warn) {
            super.argumentsAcceptable(env, deferredAttrContext, argtypes, formals, warn);
            if (deferredAttrContext.phase.isVarargsRequired() && deferredAttrContext.mode == DeferredAttr.AttrMode.CHECK) {
                this.varargsAccessible(env, Resolve.this.types.elemtype(formals.last()), deferredAttrContext.inferenceContext);
            }
        }

        private void varargsAccessible(Env<AttrContext> env, Type t, InferenceContext inferenceContext) {
            if (inferenceContext.free(t)) {
                inferenceContext.addFreeTypeListener(List.of(t), solvedContext -> this.varargsAccessible(env, solvedContext.asInstType(t), solvedContext));
            } else if (!Resolve.this.isAccessible(env, Resolve.this.types.erasure(t))) {
                Symbol.ClassSymbol location = env.enclClass.sym;
                this.reportMC(env.tree, MethodCheckDiag.INACCESSIBLE_VARARGS, inferenceContext, t, Kinds.kindName(location), location);
            }
        }

        private Attr.ResultInfo methodCheckResult(final boolean varargsCheck, Type to, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner rsWarner) {
            MethodCheckContext checkContext = new MethodCheckContext(!deferredAttrContext.phase.isBoxingRequired(), deferredAttrContext, rsWarner){
                MethodCheckDiag methodDiag;
                {
                    super(strict, deferredAttrContext, rsWarner);
                    this.methodDiag = varargsCheck ? MethodCheckDiag.VARARG_MISMATCH : MethodCheckDiag.ARG_MISMATCH;
                }

                @Override
                public void report(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic details) {
                    this.reportMC(pos, this.methodDiag, this.deferredAttrContext.inferenceContext, details);
                }
            };
            return new MethodResultInfo(to, checkContext);
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> actuals) {
            return new MostSpecificCheck(actuals);
        }

        public String toString() {
            return "resolveMethodCheck";
        }
    };
    Warner noteWarner = new Warner();
    private final RecoveryLoadClass noRecovery = (env, name) -> null;
    private final RecoveryLoadClass doRecoveryLoadClass = new RecoveryLoadClass(){

        @Override
        public Symbol loadClass(Env<AttrContext> env, Name name) {
            List<Name> candidates = Convert.classCandidates(name);
            return Resolve.this.lookupInvisibleSymbol(env, name, n -> () -> Iterators.createCompoundIterator(candidates, c -> Resolve.this.syms.getClassesForName((Name)c).iterator()), (ms, n) -> {
                for (Name candidate : candidates) {
                    try {
                        return Resolve.this.finder.loadClass((Symbol.ModuleSymbol)ms, candidate);
                    }
                    catch (Symbol.CompletionFailure completionFailure) {
                    }
                }
                return null;
            }, sym -> sym.kind == Kinds.Kind.TYP, Resolve.this.typeNotFound);
        }
    };
    private final RecoveryLoadClass namedImportScopeRecovery = (env, name) -> {
        Scope.NamedImportScope importScope = env.toplevel.namedImportScope;
        Symbol existing = importScope.findFirst(Convert.shortName(name), sym -> sym.kind == Kinds.Kind.TYP && sym.flatName() == name);
        if (existing != null) {
            return new InvisibleSymbolError(env, true, existing);
        }
        return null;
    };
    private final RecoveryLoadClass starImportScopeRecovery = this.onDemandImportScopeRecovery(false);
    private final RecoveryLoadClass moduleImportScopeRecovery = this.onDemandImportScopeRecovery(true);
    LogResolveHelper basicLogResolveHelper = new LogResolveHelper(){

        @Override
        public boolean resolveDiagnosticNeeded(Type site, List<Type> argtypes, List<Type> typeargtypes) {
            return !site.isErroneous();
        }

        @Override
        public List<Type> getArgumentTypes(ResolveError errSym, Symbol accessedSym, Name name, List<Type> argtypes) {
            return argtypes;
        }
    };
    LogResolveHelper silentLogResolveHelper = new LogResolveHelper(){

        @Override
        public boolean resolveDiagnosticNeeded(Type site, List<Type> argtypes, List<Type> typeargtypes) {
            return false;
        }

        @Override
        public List<Type> getArgumentTypes(ResolveError errSym, Symbol accessedSym, Name name, List<Type> argtypes) {
            return argtypes;
        }
    };
    LogResolveHelper methodLogResolveHelper = new LogResolveHelper(){

        @Override
        public boolean resolveDiagnosticNeeded(Type site, List<Type> argtypes, List<Type> typeargtypes) {
            return !site.isErroneous() && !Type.isErroneous(argtypes) && (typeargtypes == null || !Type.isErroneous(typeargtypes));
        }

        @Override
        public List<Type> getArgumentTypes(ResolveError errSym, Symbol accessedSym, Name name, List<Type> argtypes) {
            return argtypes.map(new ResolveDeferredRecoveryMap(DeferredAttr.AttrMode.SPECULATIVE, accessedSym, Resolve.this.currentResolutionContext.step));
        }
    };
    ReferenceChooser basicReferenceChooser = new ReferenceChooser(){

        @Override
        ReferenceLookupResult boundResult(ReferenceLookupResult boundRes) {
            return !boundRes.isSuccess() || boundRes.hasKind(ReferenceLookupResult.StaticKind.NON_STATIC) ? boundRes : ReferenceLookupResult.error(new BadMethodReferenceError(boundRes.sym, false));
        }

        @Override
        ReferenceLookupResult unboundResult(ReferenceLookupResult boundRes, ReferenceLookupResult unboundRes) {
            if (boundRes.isSuccess() && boundRes.sym.isStatic() && (!unboundRes.isSuccess() || unboundRes.hasKind(ReferenceLookupResult.StaticKind.STATIC))) {
                return boundRes;
            }
            if (unboundRes.isSuccess() && !unboundRes.sym.isStatic() && (!boundRes.isSuccess() || boundRes.hasKind(ReferenceLookupResult.StaticKind.NON_STATIC))) {
                return unboundRes;
            }
            if (boundRes.isSuccess() && unboundRes.isSuccess()) {
                return ReferenceLookupResult.error(Resolve.this.ambiguityError(boundRes.sym, unboundRes.sym));
            }
            if (boundRes.isSuccess() || unboundRes.isSuccess()) {
                return ReferenceLookupResult.error(new BadMethodReferenceError(boundRes.isSuccess() ? boundRes.sym : unboundRes.sym, true));
            }
            return boundRes.canIgnore() && !unboundRes.canIgnore() ? unboundRes : boundRes;
        }
    };
    ReferenceChooser structuralReferenceChooser = new ReferenceChooser(){

        @Override
        ReferenceLookupResult boundResult(ReferenceLookupResult boundRes) {
            return !boundRes.isSuccess() || !boundRes.hasKind(ReferenceLookupResult.StaticKind.STATIC) ? boundRes : ReferenceLookupResult.error(new BadMethodReferenceError(boundRes.sym, false));
        }

        @Override
        ReferenceLookupResult unboundResult(ReferenceLookupResult boundRes, ReferenceLookupResult unboundRes) {
            if (boundRes.isSuccess() && !boundRes.hasKind(ReferenceLookupResult.StaticKind.NON_STATIC)) {
                return boundRes;
            }
            if (unboundRes.isSuccess() && !unboundRes.hasKind(ReferenceLookupResult.StaticKind.STATIC)) {
                return unboundRes;
            }
            if (boundRes.isSuccess() || unboundRes.isSuccess()) {
                return ReferenceLookupResult.error(new BadMethodReferenceError(boundRes.isSuccess() ? boundRes.sym : unboundRes.sym, true));
            }
            return boundRes.canIgnore() && !unboundRes.canIgnore() ? unboundRes : boundRes;
        }
    };
    private final Formattable.LocalizedString noArgs = new Formattable.LocalizedString("compiler.misc.no.args");
    final List<MethodResolutionPhase> methodResolutionSteps = List.of(MethodResolutionPhase.BASIC, MethodResolutionPhase.BOX, MethodResolutionPhase.VARARITY);
    MethodResolutionContext currentResolutionContext = null;

    protected Resolve(Context context) {
        context.put(resolveKey, this);
        this.syms = Symtab.instance(context);
        this.varNotFound = new SymbolNotFoundError(Kinds.Kind.ABSENT_VAR);
        this.methodNotFound = new SymbolNotFoundError(Kinds.Kind.ABSENT_MTH);
        this.typeNotFound = new SymbolNotFoundError(Kinds.Kind.ABSENT_TYP);
        this.referenceNotFound = ReferenceLookupResult.error(this.methodNotFound);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.attr = Attr.instance(context);
        this.attrRecover = AttrRecover.instance(context);
        this.deferredAttr = DeferredAttr.instance(context);
        this.chk = Check.instance(context);
        this.infer = Infer.instance(context);
        this.finder = ClassFinder.instance(context);
        this.moduleFinder = ModuleFinder.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.preview = Preview.instance(context);
        Source source = Source.instance(context);
        Options options = Options.instance(context);
        this.compactMethodDiags = options.isSet(Option.XDIAGS, "compact") || options.isUnset(Option.XDIAGS) && options.isUnset("rawDiagnostics");
        this.verboseResolutionMode = VerboseResolutionMode.getVerboseResolutionMode(options);
        Target target = Target.instance(context);
        this.allowLocalVariableTypeInference = Source.Feature.LOCAL_VARIABLE_TYPE_INFERENCE.allowedInSource(source);
        this.allowYieldStatement = Source.Feature.SWITCH_EXPRESSION.allowedInSource(source);
        this.allowPrivateMembersInPermitsClause = Source.Feature.PRIVATE_MEMBERS_IN_PERMITS_CLAUSE.allowedInSource(source);
        this.polymorphicSignatureScope = Scope.WriteableScope.create(this.syms.noSymbol);
        this.allowModules = Source.Feature.MODULES.allowedInSource(source);
        this.allowRecords = Source.Feature.RECORDS.allowedInSource(source);
        this.dumpMethodReferenceSearchResults = options.isSet("debug.dumpMethodReferenceSearchResults");
        this.dumpStacktraceOnError = options.isSet("dev") || options.isSet(Option.DOE);
        this.localProxyVarsGen = LocalProxyVarsGen.instance(context);
    }

    public static Resolve instance(Context context) {
        Resolve instance = context.get(resolveKey);
        if (instance == null) {
            instance = new Resolve(context);
        }
        return instance;
    }

    private static Symbol bestOf(Symbol s1, Symbol s2) {
        return s1.kind.betterThan(s2.kind) ? s1 : s2;
    }

    void reportVerboseResolutionDiagnostic(JCDiagnostic.DiagnosticPosition dpos, Name name, Type site, List<Type> argtypes, List<Type> typeargtypes, Symbol bestSoFar) {
        boolean success;
        boolean bl = success = !bestSoFar.kind.isResolutionError();
        if (success && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.SUCCESS)) {
            return;
        }
        if (!success && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.FAILURE)) {
            return;
        }
        if (bestSoFar.name == this.names.init && bestSoFar.owner == this.syms.objectType.tsym && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.OBJECT_INIT)) {
            return;
        }
        if (site == this.syms.predefClass.type && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.PREDEF)) {
            return;
        }
        if (this.currentResolutionContext.internalResolution && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.INTERNAL)) {
            return;
        }
        int pos = 0;
        int mostSpecificPos = -1;
        ListBuffer<JCDiagnostic> subDiags = new ListBuffer<JCDiagnostic>();
        for (MethodResolutionContext.Candidate c : this.currentResolutionContext.candidates) {
            if (this.currentResolutionContext.step != c.step || c.isApplicable() && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.APPLICABLE) || !c.isApplicable() && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.INAPPLICABLE)) continue;
            subDiags.append(c.isApplicable() ? this.getVerboseApplicableCandidateDiag(pos, c.sym, c.mtype) : this.getVerboseInapplicableCandidateDiag(pos, c.sym, c.details));
            if (c.sym == bestSoFar) {
                mostSpecificPos = pos;
            }
            ++pos;
        }
        String key = success ? "verbose.resolve.multi" : "verbose.resolve.multi.1";
        DeferredAttr deferredAttr = this.deferredAttr;
        Objects.requireNonNull(deferredAttr);
        List<Type> argtypes2 = argtypes.map(deferredAttr.new DeferredAttr.RecoveryDeferredTypeMap(DeferredAttr.AttrMode.SPECULATIVE, bestSoFar, this.currentResolutionContext.step));
        JCDiagnostic main = this.diags.note(this.log.currentSource(), dpos, key, new Object[]{name, site.tsym, mostSpecificPos, this.currentResolutionContext.step, this.methodArguments(argtypes2), this.methodArguments(typeargtypes)});
        JCDiagnostic.MultilineDiagnostic d = new JCDiagnostic.MultilineDiagnostic(main, subDiags.toList());
        this.log.report(d);
    }

    JCDiagnostic getVerboseApplicableCandidateDiag(int pos, Symbol sym, Type inst) {
        JCDiagnostic subDiag = null;
        if (sym.type.hasTag(TypeTag.FORALL)) {
            subDiag = this.diags.fragment(CompilerProperties.Fragments.PartialInstSig(inst));
        }
        String key = subDiag == null ? "applicable.method.found" : "applicable.method.found.1";
        return this.diags.fragment(key, pos, sym, subDiag);
    }

    JCDiagnostic getVerboseInapplicableCandidateDiag(int pos, Symbol sym, JCDiagnostic subDiag) {
        return this.diags.fragment(CompilerProperties.Fragments.NotApplicableMethodFound(pos, sym, subDiag));
    }

    protected static boolean isStatic(Env<AttrContext> env) {
        return env.outer != null && ((AttrContext)env.info).staticLevel > ((AttrContext)env.outer.info).staticLevel;
    }

    static boolean isInitializer(Env<AttrContext> env) {
        Symbol owner = ((AttrContext)env.info).scope.owner;
        return owner.isConstructor() || owner.owner.kind == Kinds.Kind.TYP && (owner.kind == Kinds.Kind.VAR || owner.kind == Kinds.Kind.MTH && (owner.flags() & 0x200000L) != 0L) && (owner.flags() & 8L) == 0L;
    }

    public boolean isAccessible(Env<AttrContext> env, Symbol.TypeSymbol c) {
        return this.isAccessible(env, c, false);
    }

    public boolean isAccessible(Env<AttrContext> env, Symbol.TypeSymbol c, boolean checkInner) {
        if (env.enclMethod != null && (env.enclMethod.mods.flags & 0x20000000L) != 0L) {
            return true;
        }
        if (((AttrContext)env.info).visitingServiceImplementation && env.toplevel.modle == c.packge().modle) {
            return true;
        }
        boolean isAccessible = false;
        switch ((short)(c.flags() & 7L)) {
            case 2: {
                isAccessible = env.enclClass.sym.outermostClass() == c.owner.outermostClass();
                break;
            }
            case 0: {
                isAccessible = env.toplevel.packge == c.owner || env.toplevel.packge == c.packge();
                break;
            }
            default: {
                isAccessible = true;
                break;
            }
            case 1: {
                if (this.allowModules) {
                    Symbol.ModuleSymbol currModule = env.toplevel.modle;
                    currModule.complete();
                    Symbol.PackageSymbol p = c.packge();
                    isAccessible = currModule == p.modle || currModule.visiblePackages.get(p.fullname) == p || p == this.syms.rootPackage || p.modle == this.syms.unnamedModule && currModule.readModules.contains(p.modle);
                    break;
                }
                isAccessible = true;
                break;
            }
            case 4: {
                boolean bl = isAccessible = env.toplevel.packge == c.owner || env.toplevel.packge == c.packge() || this.isInnerSubClass(env.enclClass.sym, c.owner) || ((AttrContext)env.info).allowProtectedAccess;
            }
        }
        return !checkInner || c.type.getEnclosingType() == Type.noType ? isAccessible : isAccessible && this.isAccessible(env, c.type.getEnclosingType(), checkInner);
    }

    private boolean isInnerSubClass(Symbol.ClassSymbol c, Symbol base) {
        while (c != null && !c.isSubClass(base, this.types)) {
            c = c.owner.enclClass();
        }
        return c != null;
    }

    boolean isAccessible(Env<AttrContext> env, Type t) {
        return this.isAccessible(env, t, false);
    }

    boolean isAccessible(Env<AttrContext> env, Type t, boolean checkInner) {
        if (t.hasTag(TypeTag.ARRAY)) {
            return this.isAccessible(env, this.types.cvarUpperBound(this.types.elemtype(t)));
        }
        if (t.isUnion()) {
            return StreamSupport.stream(((Type.UnionClassType)t).getAlternativeTypes().spliterator(), false).allMatch(alternative -> this.isAccessible(env, alternative.tsym, checkInner));
        }
        return this.isAccessible(env, t.tsym, checkInner);
    }

    public boolean isAccessible(Env<AttrContext> env, Type site, Symbol sym) {
        return this.isAccessible(env, site, sym, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessible(Env<AttrContext> env, Type site, Symbol sym, boolean checkInner) {
        if (sym.name == this.names.init && sym.owner != site.tsym) {
            return false;
        }
        if (env.enclMethod != null && (env.enclMethod.mods.flags & 0x20000000L) != 0L) {
            return true;
        }
        if (((AttrContext)env.info).visitingServiceImplementation && env.toplevel.modle == sym.packge().modle) {
            return true;
        }
        Symbol.ClassSymbol enclosingCsym = env.enclClass.sym;
        try {
            switch ((short)(sym.flags() & 7L)) {
                case 2: {
                    boolean bl = (env.enclClass.sym == sym.owner || env.enclClass.sym.outermostClass() == sym.owner.outermostClass() || this.privateMemberInPermitsClauseIfAllowed(env, sym)) && sym.isInheritedIn(site.tsym, this.types);
                    return bl;
                }
                case 0: {
                    boolean bl = (env.toplevel.packge == sym.owner.owner || env.toplevel.packge == sym.packge()) && this.isAccessible(env, site, checkInner) && sym.isInheritedIn(site.tsym, this.types) && this.notOverriddenIn(site, sym);
                    return bl;
                }
                case 4: {
                    boolean bl = (env.toplevel.packge == sym.owner.owner || env.toplevel.packge == sym.packge() || this.isProtectedAccessible(sym, env.enclClass.sym, site) || ((AttrContext)env.info).selectSuper && (sym.flags() & 8L) == 0L && sym.kind != Kinds.Kind.TYP) && this.isAccessible(env, site, checkInner) && this.notOverriddenIn(site, sym);
                    return bl;
                }
            }
            boolean bl = this.isAccessible(env, site, checkInner) && this.notOverriddenIn(site, sym);
            return bl;
        }
        finally {
            env.enclClass.sym = enclosingCsym;
        }
    }

    private boolean privateMemberInPermitsClauseIfAllowed(Env<AttrContext> env, Symbol sym) {
        return this.allowPrivateMembersInPermitsClause && ((AttrContext)env.info).isPermitsClause && ((JCTree.JCClassDecl)env.tree).sym.outermostClass() == sym.owner.outermostClass();
    }

    private boolean notOverriddenIn(Type site, Symbol sym) {
        if (sym.kind != Kinds.Kind.MTH || sym.isConstructor() || sym.isStatic()) {
            return true;
        }
        Symbol.MethodSymbol s2 = ((Symbol.MethodSymbol)sym).implementation(site.tsym, this.types, true);
        return s2 == null || s2 == sym || sym.owner == s2.owner || sym.owner.isInterface() && s2.owner == this.syms.objectType.tsym || !this.types.isSubSignature(this.types.memberType(site, s2), this.types.memberType(site, sym));
    }

    private boolean isProtectedAccessible(Symbol sym, Symbol.ClassSymbol c, Type site) {
        Type newSite;
        Type type = newSite = site.hasTag(TypeTag.TYPEVAR) ? site.getUpperBound() : site;
        while (c != null && (!c.isSubClass(sym.owner, this.types) || (c.flags() & 0x200L) != 0L || (sym.flags() & 8L) == 0L && sym.kind != Kinds.Kind.TYP && !newSite.tsym.isSubClass(c, this.types))) {
            c = c.owner.enclClass();
        }
        return c != null;
    }

    void checkAccessibleType(Env<AttrContext> env, Type t) {
        this.accessibilityChecker.visit(t, env);
    }

    Type rawInstantiate(Env<AttrContext> env, Type site, Symbol m, Attr.ResultInfo resultInfo, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, Warner warn) throws Infer.InferenceException {
        Type mt = this.types.memberType(site, m);
        List<Type> tvars = List.nil();
        if (typeargtypes == null) {
            typeargtypes = List.nil();
        }
        if (mt.hasTag(TypeTag.FORALL) || !typeargtypes.nonEmpty()) {
            if (mt.hasTag(TypeTag.FORALL) && typeargtypes.nonEmpty()) {
                pmt = (Type.ForAll)mt;
                if (typeargtypes.length() != pmt.tvars.length()) {
                    throw new InapplicableMethodException(this.diags.fragment(CompilerProperties.Fragments.WrongNumberTypeArgs(Integer.toString(pmt.tvars.length()))), this.dumpStacktraceOnError);
                }
                List<Type> formals = pmt.tvars;
                List<Type> actuals = typeargtypes;
                while (formals.nonEmpty() && actuals.nonEmpty()) {
                    List<Type> bounds = this.types.subst(this.types.getBounds((Type.TypeVar)formals.head), pmt.tvars, typeargtypes);
                    while (bounds.nonEmpty()) {
                        if (!this.types.isSubtypeUnchecked((Type)actuals.head, (Type)bounds.head, warn)) {
                            throw new InapplicableMethodException(this.diags.fragment(CompilerProperties.Fragments.ExplicitParamDoNotConformToBounds((Type)actuals.head, bounds)), this.dumpStacktraceOnError);
                        }
                        bounds = bounds.tail;
                    }
                    formals = formals.tail;
                    actuals = actuals.tail;
                }
                mt = this.types.subst(pmt.qtype, pmt.tvars, typeargtypes);
            } else if (mt.hasTag(TypeTag.FORALL)) {
                pmt = (Type.ForAll)mt;
                List<Type> tvars1 = this.types.newInstances(pmt.tvars);
                tvars = tvars.appendList(tvars1);
                mt = this.types.subst(pmt.qtype, pmt.tvars, tvars1);
            }
        }
        boolean instNeeded = tvars.tail != null;
        List<Type> l = argtypes;
        while (l.tail != null && !instNeeded) {
            if (((Type)l.head).hasTag(TypeTag.FORALL)) {
                instNeeded = true;
            }
            l = l.tail;
        }
        if (instNeeded) {
            return this.infer.instantiateMethod(env, tvars, (Type.MethodType)mt, resultInfo, (Symbol.MethodSymbol)m, argtypes, allowBoxing, useVarargs, this.currentResolutionContext, warn);
        }
        DeferredAttr.DeferredAttrContext dc = this.currentResolutionContext.deferredAttrContext(m, this.infer.emptyContext, resultInfo, warn);
        this.currentResolutionContext.methodCheck.argumentsAcceptable(env, dc, argtypes, mt.getParameterTypes(), warn);
        dc.complete();
        return mt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type checkMethod(Env<AttrContext> env, Type site, Symbol m, Attr.ResultInfo resultInfo, List<Type> argtypes, List<Type> typeargtypes, Warner warn) {
        MethodResolutionContext prevContext = this.currentResolutionContext;
        try {
            this.currentResolutionContext = new MethodResolutionContext();
            DeferredAttr.AttrMode attrMode = this.currentResolutionContext.attrMode = resultInfo.pt == Infer.anyPoly ? DeferredAttr.AttrMode.SPECULATIVE : DeferredAttr.AttrMode.CHECK;
            if (env.tree.hasTag(JCTree.Tag.REFERENCE)) {
                this.currentResolutionContext.methodCheck = new MethodReferenceCheck(resultInfo.checkContext.inferenceContext());
            }
            MethodResolutionPhase step = this.currentResolutionContext.step = ((AttrContext)env.info).pendingResolutionPhase;
            Type type = this.rawInstantiate(env, site, m, resultInfo, argtypes, typeargtypes, step.isBoxingRequired(), step.isVarargsRequired(), warn);
            return type;
        }
        finally {
            this.currentResolutionContext = prevContext;
        }
    }

    Type instantiate(Env<AttrContext> env, Type site, Symbol m, Attr.ResultInfo resultInfo, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, Warner warn) {
        try {
            return this.rawInstantiate(env, site, m, resultInfo, argtypes, typeargtypes, allowBoxing, useVarargs, warn);
        }
        catch (InapplicableMethodException ex) {
            return null;
        }
    }

    Symbol findField(Env<AttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Symbol sym;
        while (c.type.hasTag(TypeTag.TYPEVAR)) {
            c = c.type.getUpperBound().tsym;
        }
        Symbol bestSoFar = this.varNotFound;
        for (Symbol s : c.members().getSymbolsByName(name)) {
            if (s.kind != Kinds.Kind.VAR || (s.flags_field & 0x1000L) != 0L) continue;
            return this.isAccessible(env, site, s) ? s : new AccessError(env, site, s);
        }
        Type st = this.types.supertype(c.type);
        if (st != null && (st.hasTag(TypeTag.CLASS) || st.hasTag(TypeTag.TYPEVAR))) {
            sym = this.findField(env, site, name, st.tsym);
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
        }
        List<Type> l = this.types.interfaces(c.type);
        while (bestSoFar.kind != Kinds.Kind.AMBIGUOUS && l.nonEmpty()) {
            sym = this.findField(env, site, name, ((Type)l.head).tsym);
            bestSoFar = bestSoFar.exists() && sym.exists() && sym.owner != bestSoFar.owner ? new AmbiguityError(bestSoFar, sym) : Resolve.bestOf(bestSoFar, sym);
            l = l.tail;
        }
        return bestSoFar;
    }

    public Symbol.VarSymbol resolveInternalField(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, Name name) {
        Symbol sym = this.findField(env, site, name, site.tsym);
        if (sym.kind == Kinds.Kind.VAR) {
            return (Symbol.VarSymbol)sym;
        }
        throw new FatalError(this.diags.fragment(CompilerProperties.Fragments.FatalErrCantLocateField(name)));
    }

    Symbol findVar(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Name name) {
        Symbol sym;
        Symbol bestSoFar = this.varNotFound;
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            sym = null;
            for (Symbol s : ((AttrContext)env1.info).scope.getSymbolsByName(name)) {
                if (s.kind != Kinds.Kind.VAR || (s.flags_field & 0x1000L) != 0L) continue;
                sym = s;
                if (!staticOnly) break;
                return new StaticError(sym);
            }
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            if (sym == null) {
                sym = this.findField(env1, env1.enclClass.sym.type, name, env1.enclClass.sym);
            }
            if (sym.exists()) {
                if (sym.kind == Kinds.Kind.VAR && sym.owner.kind == Kinds.Kind.TYP && (sym.flags() & 8L) == 0L && staticOnly) {
                    return new StaticError(sym);
                }
                return sym;
            }
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        sym = this.findField(env, this.syms.predefClass.type, name, this.syms.predefClass);
        if (sym.exists()) {
            return sym;
        }
        if (bestSoFar.exists()) {
            return bestSoFar;
        }
        Symbol origin = null;
        for (Scope sc : new Scope[]{env.toplevel.namedImportScope, env.toplevel.starImportScope}) {
            for (Symbol currentSymbol : sc.getSymbolsByName(name)) {
                if (currentSymbol.kind != Kinds.Kind.VAR) continue;
                if (!bestSoFar.kind.isResolutionError() && currentSymbol.owner != bestSoFar.owner) {
                    return new AmbiguityError(bestSoFar, currentSymbol);
                }
                if (bestSoFar.kind.betterThan(Kinds.Kind.VAR)) continue;
                origin = sc.getOrigin((Symbol)currentSymbol).owner;
                bestSoFar = this.isAccessible(env, origin.type, currentSymbol) ? currentSymbol : new AccessError(env, origin.type, currentSymbol);
            }
            if (bestSoFar.exists()) break;
        }
        if (bestSoFar.kind == Kinds.Kind.VAR && bestSoFar.owner.type != origin.type) {
            return bestSoFar.clone(origin);
        }
        return bestSoFar;
    }

    Symbol selectBest(Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes, Symbol sym, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs) {
        if (sym.kind == Kinds.Kind.ERR || site.tsym != sym.owner && !sym.isInheritedIn(site.tsym, this.types) || !this.notOverriddenIn(site, sym)) {
            return bestSoFar;
        }
        if (useVarargs && (sym.flags() & 0x400000000L) == 0L) {
            return bestSoFar.kind.isResolutionError() ? new BadVarargsMethod((ResolveError)bestSoFar.baseSymbol()) : bestSoFar;
        }
        Assert.check(!sym.kind.isResolutionError());
        try {
            this.types.noWarnings.clear();
            Type mt = this.rawInstantiate(env, site, sym, null, argtypes, typeargtypes, allowBoxing, useVarargs, this.types.noWarnings);
            this.currentResolutionContext.addApplicableCandidate(sym, mt);
        }
        catch (InapplicableMethodException ex) {
            this.currentResolutionContext.addInapplicableCandidate(sym, ex.getDiagnostic());
            switch (bestSoFar.kind) {
                case ABSENT_MTH: {
                    return new InapplicableSymbolError(this.currentResolutionContext);
                }
                case HIDDEN: {
                    if (bestSoFar instanceof AccessError) {
                        AccessError accessError = (AccessError)bestSoFar;
                        this.currentResolutionContext.addInapplicableCandidate(accessError.sym, accessError.getDiagnostic(JCDiagnostic.DiagnosticType.FRAGMENT, null, null, site, null, argtypes, typeargtypes));
                    } else {
                        return bestSoFar;
                    }
                }
                case WRONG_MTH: {
                    bestSoFar = new InapplicableSymbolsError(this.currentResolutionContext);
                }
            }
            return bestSoFar;
        }
        if (!this.isAccessible(env, site, sym)) {
            AccessError curAccessError = new AccessError(env, site, sym);
            JCDiagnostic curDiagnostic = curAccessError.getDiagnostic(JCDiagnostic.DiagnosticType.FRAGMENT, null, null, site, null, argtypes, typeargtypes);
            if (bestSoFar.kind == Kinds.Kind.ABSENT_MTH) {
                bestSoFar = curAccessError;
            } else if (bestSoFar.kind == Kinds.Kind.WRONG_MTH) {
                this.currentResolutionContext.addInapplicableCandidate(sym, curDiagnostic);
                bestSoFar = new InapplicableSymbolsError(this.currentResolutionContext);
            } else if (bestSoFar.kind == Kinds.Kind.WRONG_MTHS) {
                this.currentResolutionContext.addInapplicableCandidate(sym, curDiagnostic);
            } else if (bestSoFar.kind == Kinds.Kind.HIDDEN && bestSoFar instanceof AccessError) {
                AccessError accessError = (AccessError)bestSoFar;
                this.currentResolutionContext.addInapplicableCandidate(accessError.sym, accessError.getDiagnostic(JCDiagnostic.DiagnosticType.FRAGMENT, null, null, site, null, argtypes, typeargtypes));
                this.currentResolutionContext.addInapplicableCandidate(sym, curDiagnostic);
                bestSoFar = new InapplicableSymbolsError(this.currentResolutionContext);
            }
            return bestSoFar;
        }
        return bestSoFar.kind.isResolutionError() && bestSoFar.kind != Kinds.Kind.AMBIGUOUS ? sym : this.mostSpecific(argtypes, sym, bestSoFar, env, site, useVarargs);
    }

    Symbol mostSpecific(List<Type> argtypes, Symbol m1, Symbol m2, Env<AttrContext> env, Type site, boolean useVarargs) {
        switch (m2.kind) {
            case MTH: {
                if (m1 == m2) {
                    return m1;
                }
                boolean m1SignatureMoreSpecific = this.signatureMoreSpecific(argtypes, env, site, m1, m2, useVarargs);
                boolean m2SignatureMoreSpecific = this.signatureMoreSpecific(argtypes, env, site, m2, m1, useVarargs);
                if (m1SignatureMoreSpecific && m2SignatureMoreSpecific) {
                    boolean m2Abstract;
                    Type mt2;
                    Type mt1 = this.types.memberType(site, m1);
                    if (!this.types.overrideEquivalent(mt1, mt2 = this.types.memberType(site, m2))) {
                        return this.ambiguityError(m1, m2);
                    }
                    if ((m1.flags() & 0x80000000L) != (m2.flags() & 0x80000000L)) {
                        return (m1.flags() & 0x80000000L) != 0L ? m2 : m1;
                    }
                    if (m1.baseSymbol() == m2.baseSymbol()) {
                        return m1;
                    }
                    Symbol.TypeSymbol m1Owner = (Symbol.TypeSymbol)m1.owner;
                    Symbol.TypeSymbol m2Owner = (Symbol.TypeSymbol)m2.owner;
                    if (m1Owner != m2Owner) {
                        if (this.types.asSuper(m1Owner.type, m2Owner) != null && ((m1.owner.flags_field & 0x200L) == 0L || (m2.owner.flags_field & 0x200L) != 0L) && m1.overrides(m2, m1Owner, this.types, false)) {
                            return m1;
                        }
                        if (this.types.asSuper(m2Owner.type, m1Owner) != null && ((m2.owner.flags_field & 0x200L) == 0L || (m1.owner.flags_field & 0x200L) != 0L) && m2.overrides(m1, m2Owner, this.types, false)) {
                            return m2;
                        }
                    }
                    boolean m1Abstract = (m1.flags() & 0x400L) != 0L;
                    boolean bl = m2Abstract = (m2.flags() & 0x400L) != 0L;
                    if (m1Abstract && !m2Abstract) {
                        return m2;
                    }
                    if (m2Abstract && !m1Abstract) {
                        return m1;
                    }
                    return this.ambiguityError(m1, m2);
                }
                if (m1SignatureMoreSpecific) {
                    return m1;
                }
                if (m2SignatureMoreSpecific) {
                    return m2;
                }
                return this.ambiguityError(m1, m2);
            }
            case AMBIGUOUS: {
                AmbiguityError e = (AmbiguityError)m2.baseSymbol();
                boolean m1MoreSpecificThanAnyAmbiguous = true;
                boolean allAmbiguousMoreSpecificThanM1 = true;
                for (Symbol s : e.ambiguousSyms) {
                    Symbol moreSpecific = this.mostSpecific(argtypes, m1, s, env, site, useVarargs);
                    m1MoreSpecificThanAnyAmbiguous &= moreSpecific == m1;
                    allAmbiguousMoreSpecificThanM1 &= moreSpecific == s;
                }
                if (m1MoreSpecificThanAnyAmbiguous) {
                    return m1;
                }
                if (!allAmbiguousMoreSpecificThanM1) {
                    e.addAmbiguousSymbol(m1);
                }
                return e;
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean signatureMoreSpecific(List<Type> actuals, Env<AttrContext> env, Type site, Symbol m1, Symbol m2, boolean useVarargs) {
        this.noteWarner.clear();
        int maxLength = Math.max(Math.max(m1.type.getParameterTypes().length(), actuals.length()), m2.type.getParameterTypes().length());
        MethodResolutionContext prevResolutionContext = this.currentResolutionContext;
        try {
            this.currentResolutionContext = new MethodResolutionContext();
            this.currentResolutionContext.step = prevResolutionContext.step;
            this.currentResolutionContext.methodCheck = prevResolutionContext.methodCheck.mostSpecificCheck(actuals);
            Type mst = this.instantiate(env, site, m2, null, this.adjustArgs(this.types.cvarLowerBounds(this.types.memberType(site, m1).getParameterTypes()), m1, maxLength, useVarargs), null, false, useVarargs, this.noteWarner);
            boolean bl = mst != null && !this.noteWarner.hasLint(Lint.LintCategory.UNCHECKED);
            return bl;
        }
        finally {
            this.currentResolutionContext = prevResolutionContext;
        }
    }

    List<Type> adjustArgs(List<Type> args, Symbol msym, int length, boolean allowVarargs) {
        if ((msym.flags() & 0x400000000L) != 0L && allowVarargs) {
            Type varargsElem = this.types.elemtype(args.last());
            if (varargsElem == null) {
                Assert.error("Bad varargs = " + String.valueOf(args.last()) + " " + String.valueOf(msym));
            }
            List<Type> newArgs = args.reverse().tail.prepend(varargsElem).reverse();
            while (newArgs.length() < length) {
                newArgs = newArgs.append(newArgs.last());
            }
            return newArgs;
        }
        return args;
    }

    Symbol ambiguityError(Symbol m1, Symbol m2) {
        if (((m1.flags() | m2.flags()) & 0x40000000000L) != 0L) {
            return (m1.flags() & 0x40000000000L) == 0L ? m1 : m2;
        }
        return new AmbiguityError(m1, m2);
    }

    Symbol findMethodInScope(Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, Scope sc, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs, boolean abstractok) {
        for (Symbol s : sc.getSymbolsByName(name, new LookupFilter(abstractok))) {
            bestSoFar = this.selectBest(env, site, argtypes, typeargtypes, s, bestSoFar, allowBoxing, useVarargs);
        }
        return bestSoFar;
    }

    Symbol findMethod(Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Symbol bestSoFar = this.methodNotFound;
        bestSoFar = this.findMethod(env, site, name, argtypes, typeargtypes, site.tsym.type, bestSoFar, allowBoxing, useVarargs);
        if (bestSoFar.kind == Kinds.Kind.AMBIGUOUS) {
            AmbiguityError a_err = (AmbiguityError)bestSoFar.baseSymbol();
            bestSoFar = a_err.mergeAbstracts(site);
        }
        return bestSoFar;
    }

    private Symbol findMethod(Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, Type intype, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs) {
        List[] itypes = new List[]{List.nil(), List.nil()};
        InterfaceLookupPhase iphase = InterfaceLookupPhase.ABSTRACT_OK;
        boolean isInterface = site.tsym.isInterface();
        for (Symbol.TypeSymbol typeSymbol : isInterface ? List.of(intype.tsym) : this.superclasses(intype)) {
            bestSoFar = this.findMethodInScope(env, site, name, argtypes, typeargtypes, typeSymbol.members(), bestSoFar, allowBoxing, useVarargs, true);
            if (name == this.names.init) {
                return bestSoFar;
            }
            if ((iphase = iphase == null ? null : iphase.update(typeSymbol, this)) == null) continue;
            for (Type itype : this.types.interfaces(typeSymbol.type)) {
                itypes[iphase.ordinal()] = this.types.union(this.types.closure(itype), itypes[iphase.ordinal()]);
            }
        }
        SymbolNotFoundError concrete = bestSoFar.kind.isValid() && (bestSoFar.flags() & 0x400L) == 0L ? bestSoFar : this.methodNotFound;
        for (InterfaceLookupPhase iphase2 : InterfaceLookupPhase.values()) {
            for (Type itype : itypes[iphase2.ordinal()]) {
                if (!itype.isInterface() || iphase2 == InterfaceLookupPhase.DEFAULT_OK && (itype.tsym.flags() & 0x80000000000L) == 0L || concrete == (bestSoFar = this.findMethodInScope(env, site, name, argtypes, typeargtypes, itype.tsym.members(), bestSoFar, allowBoxing, useVarargs, true)) || !concrete.kind.isValid() || !bestSoFar.kind.isValid() || !this.types.isSubSignature(concrete.type, bestSoFar.type)) continue;
                bestSoFar = concrete;
            }
        }
        if (isInterface && bestSoFar.kind.isResolutionError()) {
            bestSoFar = this.findMethodInScope(env, site, name, argtypes, typeargtypes, this.syms.objectType.tsym.members(), bestSoFar, allowBoxing, useVarargs, true);
            if (bestSoFar.kind.isValid()) {
                final Symbol symbol = bestSoFar;
                bestSoFar = new Symbol.MethodSymbol(bestSoFar.flags_field, bestSoFar.name, bestSoFar.type, intype.tsym){

                    @Override
                    public Symbol baseSymbol() {
                        return symbol;
                    }
                };
            }
        }
        return bestSoFar;
    }

    Iterable<Symbol.TypeSymbol> superclasses(final Type intype) {
        return () -> new Iterator<Symbol.TypeSymbol>(){
            List<Symbol.TypeSymbol> seen = List.nil();
            Symbol.TypeSymbol currentSym = this.symbolFor(intype);
            Symbol.TypeSymbol prevSym = null;

            @Override
            public boolean hasNext() {
                if (this.currentSym == Resolve.this.syms.noSymbol) {
                    this.currentSym = this.symbolFor(Resolve.this.types.supertype(this.prevSym.type));
                }
                return this.currentSym != null;
            }

            @Override
            public Symbol.TypeSymbol next() {
                this.prevSym = this.currentSym;
                this.currentSym = Resolve.this.syms.noSymbol;
                Assert.check(this.prevSym != null || this.prevSym != Resolve.this.syms.noSymbol);
                return this.prevSym;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            Symbol.TypeSymbol symbolFor(Type t) {
                if (!t.hasTag(TypeTag.CLASS) && !t.hasTag(TypeTag.TYPEVAR)) {
                    return null;
                }
                t = Resolve.this.types.skipTypeVars(t, false);
                if (this.seen.contains(t.tsym)) {
                    return null;
                }
                this.seen = this.seen.prepend(t.tsym);
                return t.tsym;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol findFun(Env<AttrContext> env, Name name, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Symbol origin;
        Symbol sym;
        Symbol bestSoFar = this.methodNotFound;
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            Assert.check(((AttrContext)env1.info).preferredTreeForDiagnostics == null);
            ((AttrContext)env1.info).preferredTreeForDiagnostics = env.tree;
            try {
                sym = this.findMethod(env1, env1.enclClass.sym.type, name, argtypes, typeargtypes, allowBoxing, useVarargs);
                if (sym.exists()) {
                    if (sym.kind == Kinds.Kind.MTH && sym.owner.kind == Kinds.Kind.TYP && (sym.flags() & 8L) == 0L && staticOnly) {
                        StaticError staticError = new StaticError(sym);
                        return staticError;
                    }
                    Symbol symbol = sym;
                    return symbol;
                }
                bestSoFar = Resolve.bestOf(bestSoFar, sym);
            }
            finally {
                ((AttrContext)env1.info).preferredTreeForDiagnostics = null;
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        sym = this.findMethod(env, this.syms.predefClass.type, name, argtypes, typeargtypes, allowBoxing, useVarargs);
        if (sym.exists()) {
            return sym;
        }
        for (Symbol currentSym : env.toplevel.namedImportScope.getSymbolsByName(name)) {
            origin = env.toplevel.namedImportScope.getOrigin((Symbol)currentSym).owner;
            if (currentSym.kind != Kinds.Kind.MTH) continue;
            if (currentSym.owner.type != origin.type) {
                currentSym = currentSym.clone(origin);
            }
            if (!this.isAccessible(env, origin.type, currentSym)) {
                currentSym = new AccessError(env, origin.type, currentSym);
            }
            bestSoFar = this.selectBest(env, origin.type, argtypes, typeargtypes, currentSym, bestSoFar, allowBoxing, useVarargs);
        }
        if (((Symbol)bestSoFar).exists()) {
            return bestSoFar;
        }
        for (Symbol currentSym : env.toplevel.starImportScope.getSymbolsByName(name)) {
            origin = env.toplevel.starImportScope.getOrigin((Symbol)currentSym).owner;
            if (currentSym.kind != Kinds.Kind.MTH) continue;
            if (currentSym.owner.type != origin.type) {
                currentSym = currentSym.clone(origin);
            }
            if (!this.isAccessible(env, origin.type, currentSym)) {
                currentSym = new AccessError(env, origin.type, currentSym);
            }
            bestSoFar = this.selectBest(env, origin.type, argtypes, typeargtypes, currentSym, bestSoFar, allowBoxing, useVarargs);
        }
        return bestSoFar;
    }

    Symbol loadClass(Env<AttrContext> env, Name name, RecoveryLoadClass recoveryLoadClass) {
        try {
            Symbol.ClassSymbol c = this.finder.loadClass(env.toplevel.modle, name);
            return this.isAccessible(env, c) ? c : new AccessError(env, null, c);
        }
        catch (ClassFinder.BadClassFile err) {
            return new BadClassFileError(err);
        }
        catch (Symbol.CompletionFailure ex) {
            Symbol candidate = recoveryLoadClass.loadClass(env, name);
            if (candidate != null) {
                return candidate;
            }
            return this.typeNotFound;
        }
    }

    private RecoveryLoadClass onDemandImportScopeRecovery(boolean moduleImportScope) {
        return (env, name) -> {
            Scope.StarImportScope importScope = moduleImportScope ? env.toplevel.moduleImportScope : env.toplevel.starImportScope;
            Symbol existing = importScope.findFirst(Convert.shortName(name), sym -> sym.kind == Kinds.Kind.TYP && sym.flatName() == name);
            if (existing != null) {
                try {
                    existing = this.finder.loadClass(existing.packge().modle, name);
                    return new InvisibleSymbolError(env, true, existing);
                }
                catch (Symbol.CompletionFailure completionFailure) {
                    // empty catch block
                }
            }
            return null;
        };
    }

    Symbol lookupPackage(Env<AttrContext> env, Name name) {
        Symbol.PackageSymbol pack = this.syms.lookupPackage(env.toplevel.modle, name);
        if (this.allowModules && this.isImportOnDemand(env, name) && pack.members().isEmpty()) {
            return this.lookupInvisibleSymbol(env, name, this.syms::getPackagesForName, this.syms::enterPackage, sym -> {
                sym.complete();
                return !sym.members().isEmpty();
            }, pack);
        }
        return pack;
    }

    private boolean isImportOnDemand(Env<AttrContext> env, Name name) {
        if (!env.tree.hasTag(JCTree.Tag.IMPORT)) {
            return false;
        }
        JCTree.JCFieldAccess qualid = ((JCTree.JCImport)env.tree).qualid;
        if (!qualid.hasTag(JCTree.Tag.SELECT)) {
            return false;
        }
        if (TreeInfo.name(qualid) != this.names.asterisk) {
            return false;
        }
        return TreeInfo.fullName(qualid.selected) == name;
    }

    private <S extends Symbol> Symbol lookupInvisibleSymbol(Env<AttrContext> env, Name name, Function<Name, Iterable<S>> get, BiFunction<Symbol.ModuleSymbol, Name, S> load, Predicate<S> validate, Symbol defaultResult) {
        Iterable<S> candidates = get.apply(name);
        for (Symbol sym : candidates) {
            if (!validate.test(sym)) continue;
            return this.createInvisibleSymbolError(env, sym);
        }
        HashSet<Symbol.ModuleSymbol> recoverableModules = new HashSet<Symbol.ModuleSymbol>(this.syms.getAllModules());
        recoverableModules.add(this.syms.unnamedModule);
        recoverableModules.remove(env.toplevel.modle);
        for (Symbol.ModuleSymbol ms : recoverableModules) {
            Symbol sym;
            if (ms.sourceLocation != null) continue;
            if (ms.classLocation == null) {
                ms = this.moduleFinder.findModule(ms);
            }
            if (ms.kind == Kinds.Kind.ERR || (sym = (Symbol)load.apply(ms, name)) == null || !validate.test(sym)) continue;
            return this.createInvisibleSymbolError(env, sym);
        }
        return defaultResult;
    }

    private Symbol createInvisibleSymbolError(Env<AttrContext> env, Symbol sym) {
        if (this.symbolPackageVisible(env, sym)) {
            return new AccessError(env, null, sym);
        }
        return new InvisibleSymbolError(env, false, sym);
    }

    private boolean symbolPackageVisible(Env<AttrContext> env, Symbol sym) {
        Symbol.ModuleSymbol envMod = env.toplevel.modle;
        Symbol.PackageSymbol symPack = sym.packge();
        return envMod == symPack.modle || envMod.visiblePackages.containsKey(symPack.fullname);
    }

    Symbol findImmediateMemberType(Env<AttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        for (Symbol sym : c.members().getSymbolsByName(name)) {
            if (sym.kind != Kinds.Kind.TYP) continue;
            return this.isAccessible(env, site, sym) ? sym : new AccessError(env, site, sym);
        }
        return this.typeNotFound;
    }

    Symbol findInheritedMemberType(Env<AttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        Type st = this.types.supertype(c.type);
        if (st != null && st.hasTag(TypeTag.CLASS)) {
            sym = this.findMemberType(env, site, name, st.tsym);
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
        }
        List<Type> l = this.types.interfaces(c.type);
        while (bestSoFar.kind != Kinds.Kind.AMBIGUOUS && l.nonEmpty()) {
            sym = this.findMemberType(env, site, name, ((Type)l.head).tsym);
            bestSoFar = !bestSoFar.kind.isResolutionError() && !sym.kind.isResolutionError() && sym.owner != bestSoFar.owner ? new AmbiguityError(bestSoFar, sym) : Resolve.bestOf(bestSoFar, sym);
            l = l.tail;
        }
        return bestSoFar;
    }

    Symbol findMemberType(Env<AttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Symbol sym = this.findImmediateMemberType(env, site, name, c);
        if (sym != this.typeNotFound) {
            return sym;
        }
        return this.findInheritedMemberType(env, site, name, c);
    }

    Symbol findGlobalType(Env<AttrContext> env, Scope scope, Name name, RecoveryLoadClass recoveryLoadClass) {
        Symbol bestSoFar = this.typeNotFound;
        for (Symbol s : scope.getSymbolsByName(name)) {
            Symbol sym = this.loadClass(env, s.flatName(), recoveryLoadClass);
            if (bestSoFar.kind == Kinds.Kind.TYP && sym.kind == Kinds.Kind.TYP && bestSoFar != sym) {
                return new AmbiguityError(bestSoFar, sym);
            }
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
        }
        return bestSoFar;
    }

    Symbol findTypeVar(Env<AttrContext> env, Name name, boolean staticOnly) {
        for (Symbol sym : ((AttrContext)env.info).scope.getSymbolsByName(name)) {
            if (sym.kind != Kinds.Kind.TYP) continue;
            if (sym.type.hasTag(TypeTag.TYPEVAR) && (staticOnly || Resolve.isStatic(env) && sym.owner.kind == Kinds.Kind.TYP)) {
                return new StaticError(sym);
            }
            return sym;
        }
        return this.typeNotFound;
    }

    Symbol findType(Env<AttrContext> env, Name name) {
        Symbol sym;
        if (name == this.names.empty) {
            return this.typeNotFound;
        }
        Symbol bestSoFar = this.typeNotFound;
        boolean staticOnly = false;
        Env<AttrContext> env1 = env;
        while (env1.outer != null) {
            JCTree.JCClassDecl encl;
            Symbol tyvar = this.findTypeVar(env1, name, staticOnly);
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            sym = this.findImmediateMemberType(env1, env1.enclClass.sym.type, name, env1.enclClass.sym);
            if (tyvar != this.typeNotFound && (env.baseClause || sym == this.typeNotFound || tyvar.kind == Kinds.Kind.TYP && tyvar.exists() && tyvar.owner.kind == Kinds.Kind.MTH)) {
                return tyvar;
            }
            if (sym == this.typeNotFound) {
                sym = this.findInheritedMemberType(env1, env1.enclClass.sym.type, name, env1.enclClass.sym);
            }
            if (staticOnly && sym.kind == Kinds.Kind.TYP && sym.type.hasTag(TypeTag.CLASS) && sym.type.getEnclosingType().hasTag(TypeTag.CLASS) && env1.enclClass.sym.type.isParameterized() && sym.type.getEnclosingType().isParameterized()) {
                return new StaticError(sym);
            }
            if (sym.exists()) {
                return sym;
            }
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
            JCTree.JCClassDecl jCClassDecl = encl = env1.baseClause ? (JCTree.JCClassDecl)env1.tree : env1.enclClass;
            if ((encl.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        if (!env.tree.hasTag(JCTree.Tag.IMPORT)) {
            sym = this.findGlobalType(env, env.toplevel.namedImportScope, name, this.namedImportScopeRecovery);
            if (sym.exists()) {
                return sym;
            }
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
            sym = this.findGlobalType(env, env.toplevel.toplevelScope, name, this.noRecovery);
            if (sym.exists()) {
                return sym;
            }
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
            sym = this.findGlobalType(env, env.toplevel.packge.members(), name, this.noRecovery);
            if (sym.exists()) {
                return sym;
            }
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
            sym = this.findGlobalType(env, env.toplevel.starImportScope, name, this.starImportScopeRecovery);
            if (sym.exists()) {
                return sym;
            }
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
            sym = this.findGlobalType(env, env.toplevel.moduleImportScope, name, this.moduleImportScopeRecovery);
            if (sym.exists()) {
                return sym;
            }
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
        }
        return bestSoFar;
    }

    Symbol findIdent(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Name name, Kinds.KindSelector kind) {
        try {
            return this.checkNonExistentType(this.checkRestrictedType(pos, this.findIdentInternal(pos, env, name, kind), name));
        }
        catch (ClassFinder.BadClassFile err) {
            return new BadClassFileError(err);
        }
        catch (Symbol.CompletionFailure cf) {
            this.chk.completionError(pos, cf);
            return this.typeNotFound;
        }
    }

    Symbol findIdentInternal(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Name name, Kinds.KindSelector kind) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        if (kind.contains(Kinds.KindSelector.VAL)) {
            sym = this.findVar(pos, env, name);
            if (sym.exists()) {
                return sym;
            }
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
        }
        if (kind.contains(Kinds.KindSelector.TYP)) {
            sym = this.findType(env, name);
            if (sym.exists()) {
                return sym;
            }
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
        }
        if (kind.contains(Kinds.KindSelector.PCK)) {
            return this.lookupPackage(env, name);
        }
        return bestSoFar;
    }

    Symbol findIdentInPackage(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol.TypeSymbol pck, Name name, Kinds.KindSelector kind) {
        return this.checkNonExistentType(this.checkRestrictedType(pos, this.findIdentInPackageInternal(env, pck, name, kind), name));
    }

    Symbol findIdentInPackageInternal(Env<AttrContext> env, Symbol.TypeSymbol pck, Name name, Kinds.KindSelector kind) {
        Name fullname = Symbol.TypeSymbol.formFullName(name, pck);
        Symbol bestSoFar = this.typeNotFound;
        if (kind.contains(Kinds.KindSelector.TYP)) {
            RecoveryLoadClass recoveryLoadClass = this.allowModules && !kind.contains(Kinds.KindSelector.PCK) && !pck.exists() && !((AttrContext)env.info).attributionMode.isSpeculative ? this.doRecoveryLoadClass : this.noRecovery;
            Symbol sym = this.loadClass(env, fullname, recoveryLoadClass);
            if (sym.exists()) {
                if (name == sym.name) {
                    return sym;
                }
            } else {
                bestSoFar = Resolve.bestOf(bestSoFar, sym);
            }
        }
        if (kind.contains(Kinds.KindSelector.PCK)) {
            return this.lookupPackage(env, fullname);
        }
        return bestSoFar;
    }

    Symbol findIdentInType(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, Name name, Kinds.KindSelector kind) {
        try {
            return this.checkNonExistentType(this.checkRestrictedType(pos, this.findIdentInTypeInternal(env, site, name, kind), name));
        }
        catch (ClassFinder.BadClassFile err) {
            return new BadClassFileError(err);
        }
        catch (Symbol.CompletionFailure cf) {
            this.chk.completionError(pos, cf);
            return this.typeNotFound;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Symbol checkNonExistentType(Symbol symbol) {
        Symbol symbol2;
        if (symbol instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)symbol;
            if (c.type.isErroneous() && c.classfile == null) {
                symbol2 = this.typeNotFound;
                return symbol2;
            }
        }
        symbol2 = symbol;
        return symbol2;
    }

    Symbol findIdentInTypeInternal(Env<AttrContext> env, Type site, Name name, Kinds.KindSelector kind) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        if (kind.contains(Kinds.KindSelector.VAL)) {
            sym = this.findField(env, site, name, site.tsym);
            if (sym.exists()) {
                return sym;
            }
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
        }
        if (kind.contains(Kinds.KindSelector.TYP)) {
            sym = this.findMemberType(env, site, name, site.tsym);
            if (sym.exists()) {
                return sym;
            }
            bestSoFar = Resolve.bestOf(bestSoFar, sym);
        }
        return bestSoFar;
    }

    private Symbol checkRestrictedType(JCDiagnostic.DiagnosticPosition pos, Symbol bestSoFar, Name name) {
        if (bestSoFar.kind == Kinds.Kind.TYP || bestSoFar.kind == Kinds.Kind.ABSENT_TYP) {
            if (this.allowLocalVariableTypeInference && name.equals(this.names.var)) {
                bestSoFar = new BadRestrictedTypeError(this.names.var);
            } else if (name.equals(this.names.yield)) {
                if (this.allowYieldStatement) {
                    bestSoFar = new BadRestrictedTypeError(this.names.yield);
                } else if (pos != null) {
                    this.log.warning(pos, CompilerProperties.Warnings.IllegalRefToRestrictedType(this.names.yield));
                }
            }
        }
        return bestSoFar;
    }

    Symbol accessInternal(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, boolean qualified, List<Type> argtypes, List<Type> typeargtypes, LogResolveHelper logResolveHelper) {
        ResolveError errSym;
        if (sym.kind.isResolutionError() && logResolveHelper.resolveDiagnosticNeeded(site, argtypes = logResolveHelper.getArgumentTypes(errSym = (ResolveError)sym.baseSymbol(), sym = errSym.access(name, qualified ? site.tsym : this.syms.noSymbol), name, argtypes), typeargtypes)) {
            this.logResolveError(errSym, pos, location, site, name, argtypes, typeargtypes);
        }
        return sym;
    }

    Symbol accessMethod(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, boolean qualified, List<Type> argtypes, List<Type> typeargtypes) {
        return this.accessInternal(sym, pos, location, site, name, qualified, argtypes, typeargtypes, this.methodLogResolveHelper);
    }

    Symbol accessMethod(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, boolean qualified, List<Type> argtypes, List<Type> typeargtypes) {
        return this.accessMethod(sym, pos, site.tsym, site, name, qualified, argtypes, typeargtypes);
    }

    Symbol accessBase(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, boolean qualified) {
        return this.accessInternal(sym, pos, location, site, name, qualified, List.nil(), null, this.basicLogResolveHelper);
    }

    Symbol accessBase(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, boolean qualified) {
        return this.accessBase(sym, pos, site.tsym, site, name, qualified);
    }

    void checkNonAbstract(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if ((sym.flags() & 0x400L) != 0L && (sym.flags() & 0x80000000000L) == 0L) {
            this.log.error(pos, CompilerProperties.Errors.AbstractCantBeAccessedDirectly(Kinds.kindName(sym), sym, sym.location()));
        }
    }

    Symbol resolveIdent(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Name name, Kinds.KindSelector kind) {
        return this.accessBase(this.findIdent(pos, env, name, kind), pos, env.enclClass.sym.type, name, false);
    }

    Symbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        return this.lookupMethod(env, pos, (Symbol)env.enclClass.sym, this.resolveMethodCheck, (LookupHelper)new BasicLookupHelper(name, env.enclClass.sym.type, (List)argtypes, (List)typeargtypes){

            @Override
            Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
                return Resolve.this.findFun(env, this.name, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired());
            }
        });
    }

    Symbol resolveQualifiedMethod(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        return this.resolveQualifiedMethod(pos, env, site.tsym, site, name, argtypes, typeargtypes);
    }

    Symbol resolveQualifiedMethod(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        return this.resolveQualifiedMethod(new MethodResolutionContext(), pos, env, location, site, name, argtypes, typeargtypes);
    }

    private Symbol resolveQualifiedMethod(MethodResolutionContext resolveContext, JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        return this.lookupMethod(env, pos, location, resolveContext, (LookupHelper)new BasicLookupHelper(name, site, (List)argtypes, (List)typeargtypes){

            @Override
            Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
                return Resolve.this.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired());
            }

            @Override
            Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, Symbol sym) {
                if (sym.kind.isResolutionError()) {
                    sym = super.access(env, pos, location, sym);
                } else {
                    Symbol.MethodSymbol msym = (Symbol.MethodSymbol)sym;
                    if ((msym.flags() & 0x400000000000L) != 0L) {
                        ((AttrContext)env.info).pendingResolutionPhase = MethodResolutionPhase.BASIC;
                        return Resolve.this.findPolymorphicSignatureInstance(env, sym, this.argtypes);
                    }
                }
                return sym;
            }
        });
    }

    Symbol findPolymorphicSignatureInstance(Env<AttrContext> env, Symbol spMethod, List<Type> argtypes) {
        Type mtype = this.infer.instantiatePolymorphicSignatureInstance(env, (Symbol.MethodSymbol)spMethod, this.currentResolutionContext, argtypes);
        return this.findPolymorphicSignatureInstance(spMethod, mtype);
    }

    Symbol findPolymorphicSignatureInstance(final Symbol spMethod, Type mtype) {
        for (Symbol sym : this.polymorphicSignatureScope.getSymbolsByName(spMethod.name)) {
            if (!this.types.isSameType(mtype, sym.type) || spMethod.owner != sym.owner) continue;
            return sym;
        }
        Type spReturnType = spMethod.asType().getReturnType();
        if (!this.types.isSameType(spReturnType, this.syms.objectType) && !this.types.isSameType(spReturnType, mtype.getReturnType())) {
            mtype = new Type.MethodType(mtype.getParameterTypes(), spReturnType, mtype.getThrownTypes(), this.syms.methodClass);
        }
        long flags = 0x2000000400L | spMethod.flags() & 0xFL;
        Symbol.MethodSymbol msym = new Symbol.MethodSymbol(flags, spMethod.name, mtype, spMethod.owner){

            @Override
            public Symbol baseSymbol() {
                return spMethod;
            }
        };
        if (!mtype.isErroneous()) {
            this.polymorphicSignatureScope.enter(msym);
        }
        return msym;
    }

    public Symbol.MethodSymbol resolveInternalMethod(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        MethodResolutionContext resolveContext = new MethodResolutionContext();
        resolveContext.internalResolution = true;
        Symbol sym = this.resolveQualifiedMethod(resolveContext, pos, env, site.tsym, site, name, argtypes, typeargtypes);
        if (sym.kind == Kinds.Kind.MTH) {
            return (Symbol.MethodSymbol)sym;
        }
        throw new FatalError(this.diags.fragment(CompilerProperties.Fragments.FatalErrCantLocateMeth(name)));
    }

    Symbol resolveConstructor(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        return this.resolveConstructor(new MethodResolutionContext(), pos, env, site, argtypes, typeargtypes);
    }

    private Symbol resolveConstructor(MethodResolutionContext resolveContext, final JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        return this.lookupMethod(env, pos, (Symbol)site.tsym, resolveContext, (LookupHelper)new BasicLookupHelper(this.names.init, site, argtypes, typeargtypes){

            @Override
            Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
                return Resolve.this.findConstructor(pos, env, this.site, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired());
            }
        });
    }

    public Symbol.MethodSymbol resolveInternalConstructor(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        MethodResolutionContext resolveContext = new MethodResolutionContext();
        resolveContext.internalResolution = true;
        Symbol sym = this.resolveConstructor(resolveContext, pos, env, site, argtypes, typeargtypes);
        if (sym.kind == Kinds.Kind.MTH) {
            return (Symbol.MethodSymbol)sym;
        }
        throw new FatalError(this.diags.fragment(CompilerProperties.Fragments.FatalErrCantLocateCtor(site)));
    }

    Symbol findConstructor(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Symbol sym = this.findMethod(env, site, this.names.init, argtypes, typeargtypes, allowBoxing, useVarargs);
        this.chk.checkDeprecated(pos, ((AttrContext)env.info).scope.owner, sym);
        this.chk.checkPreview(pos, ((AttrContext)env.info).scope.owner, sym);
        return sym;
    }

    Symbol resolveDiamond(final JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        return this.lookupMethod(env, pos, (Symbol)site.tsym, this.resolveMethodCheck, (LookupHelper)new BasicLookupHelper(this.names.init, site, argtypes, typeargtypes){

            @Override
            Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
                return Resolve.this.findDiamond(pos, env, this.site, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired());
            }

            @Override
            Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos2, Symbol location, Symbol sym) {
                if (sym.kind.isResolutionError()) {
                    if (sym.kind != Kinds.Kind.WRONG_MTH && sym.kind != Kinds.Kind.WRONG_MTHS) {
                        sym = super.access(env, pos2, location, sym);
                    } else {
                        sym = new DiamondError(sym, Resolve.this.currentResolutionContext);
                        sym = Resolve.this.accessMethod(sym, pos2, this.site, Resolve.this.names.init, true, this.argtypes, this.typeargtypes);
                        ((AttrContext)env.info).pendingResolutionPhase = Resolve.this.currentResolutionContext.step;
                    }
                }
                return sym;
            }
        });
    }

    private Symbol findDiamond(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Symbol sym = this.findDiamond(env, site, argtypes, typeargtypes, allowBoxing, useVarargs);
        this.chk.checkDeprecated(pos, ((AttrContext)env.info).scope.owner, sym);
        this.chk.checkPreview(pos, ((AttrContext)env.info).scope.owner, sym);
        return sym;
    }

    private Symbol findDiamond(Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Symbol bestSoFar = this.methodNotFound;
        Symbol.TypeSymbol tsym = site.tsym.isInterface() ? this.syms.objectType.tsym : site.tsym;
        for (final Symbol sym : tsym.members().getSymbolsByName(this.names.init)) {
            if (sym.kind != Kinds.Kind.MTH || (sym.flags_field & 0x1000L) != 0L) continue;
            List oldParams = sym.type.hasTag(TypeTag.FORALL) ? ((Type.ForAll)sym.type).tvars : List.nil();
            Type.ForAll constrType = new Type.ForAll(site.tsym.type.getTypeArguments().appendList(oldParams), this.types.createMethodTypeWithReturn(sym.type.asMethodType(), site));
            Symbol.MethodSymbol newConstr = new Symbol.MethodSymbol(sym.flags(), this.names.init, constrType, site.tsym){

                @Override
                public Symbol baseSymbol() {
                    return sym;
                }
            };
            bestSoFar = this.selectBest(env, site, argtypes, typeargtypes, newConstr, bestSoFar, allowBoxing, useVarargs);
        }
        return bestSoFar;
    }

    Symbol getMemberReference(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, JCTree.JCMemberReference referenceTree, Type site, Name name) {
        site = this.types.capture(site);
        ReferenceLookupHelper lookupHelper = this.makeReferenceLookupHelper(referenceTree, site, name, List.nil(), null, MethodResolutionPhase.VARARITY);
        Env<AttrContext> newEnv = env.dup(env.tree, ((AttrContext)env.info).dup());
        Symbol sym = this.lookupMethod(newEnv, env.tree.pos(), (Symbol)site.tsym, this.nilMethodCheck, (LookupHelper)lookupHelper);
        ((AttrContext)env.info).pendingResolutionPhase = ((AttrContext)newEnv.info).pendingResolutionPhase;
        return sym;
    }

    ReferenceLookupHelper makeReferenceLookupHelper(JCTree.JCMemberReference referenceTree, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
        if (!name.equals(this.names.init)) {
            return new MethodReferenceLookupHelper(referenceTree, name, site, argtypes, typeargtypes, maxPhase);
        }
        if (site.hasTag(TypeTag.ARRAY)) {
            return new ArrayConstructorReferenceLookupHelper(referenceTree, site, argtypes, typeargtypes, maxPhase);
        }
        return new ConstructorReferenceLookupHelper(referenceTree, site, argtypes, typeargtypes, maxPhase);
    }

    Pair<Symbol, ReferenceLookupHelper> resolveMemberReference(Env<AttrContext> env, JCTree.JCMemberReference referenceTree, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, Type descriptor, MethodCheck methodCheck, InferenceContext inferenceContext, ReferenceChooser referenceChooser) {
        Symbol.MethodSymbol msym;
        ReferenceLookupHelper boundLookupHelper = this.makeReferenceLookupHelper(referenceTree, site, name, argtypes, typeargtypes, MethodResolutionPhase.VARARITY);
        Env<AttrContext> boundEnv = env.dup(env.tree, ((AttrContext)env.info).dup());
        MethodResolutionContext boundSearchResolveContext = new MethodResolutionContext();
        boundSearchResolveContext.methodCheck = methodCheck;
        Symbol boundSym = this.lookupMethod(boundEnv, env.tree.pos(), (Symbol)site.tsym, boundSearchResolveContext, (LookupHelper)boundLookupHelper);
        boolean isStaticSelector = TreeInfo.isStaticSelector(referenceTree.expr, this.names);
        ReferenceLookupResult boundRes = new ReferenceLookupResult(boundSym, boundSearchResolveContext, isStaticSelector);
        if (this.dumpMethodReferenceSearchResults) {
            this.dumpMethodReferenceSearchResults(referenceTree, boundSearchResolveContext, boundSym, true);
        }
        Symbol unboundSym = this.methodNotFound;
        Env<AttrContext> unboundEnv = env.dup(env.tree, ((AttrContext)env.info).dup());
        ReferenceLookupHelper unboundLookupHelper = boundLookupHelper.unboundLookup(inferenceContext);
        ReferenceLookupResult unboundRes = this.referenceNotFound;
        if (unboundLookupHelper != null) {
            MethodResolutionContext unboundSearchResolveContext = new MethodResolutionContext();
            unboundSearchResolveContext.methodCheck = methodCheck;
            unboundSym = this.lookupMethod(unboundEnv, env.tree.pos(), (Symbol)site.tsym, unboundSearchResolveContext, (LookupHelper)unboundLookupHelper);
            unboundRes = new ReferenceLookupResult(unboundSym, unboundSearchResolveContext, isStaticSelector);
            if (this.dumpMethodReferenceSearchResults) {
                this.dumpMethodReferenceSearchResults(referenceTree, unboundSearchResolveContext, unboundSym, false);
            }
        }
        ReferenceLookupResult bestRes = referenceChooser.result(boundRes, unboundRes);
        Pair<Symbol, ReferenceLookupHelper> res = new Pair<Symbol, ReferenceLookupHelper>(bestRes.sym, bestRes == unboundRes ? unboundLookupHelper : boundLookupHelper);
        MethodResolutionPhase methodResolutionPhase = ((AttrContext)env.info).pendingResolutionPhase = bestRes == unboundRes ? ((AttrContext)unboundEnv.info).pendingResolutionPhase : ((AttrContext)boundEnv.info).pendingResolutionPhase;
        if (!((Symbol)res.fst).kind.isResolutionError() && ((msym = (Symbol.MethodSymbol)res.fst).flags() & 0x400000000000L) != 0L) {
            ((AttrContext)env.info).pendingResolutionPhase = MethodResolutionPhase.BASIC;
            res = new Pair<Symbol, ReferenceLookupHelper>(this.findPolymorphicSignatureInstance(msym, descriptor), (ReferenceLookupHelper)res.snd);
        }
        return res;
    }

    private void dumpMethodReferenceSearchResults(JCTree.JCMemberReference referenceTree, MethodResolutionContext resolutionContext, Symbol bestSoFar, boolean bound) {
        ListBuffer<JCDiagnostic> subDiags = new ListBuffer<JCDiagnostic>();
        int pos = 0;
        int mostSpecificPos = -1;
        for (MethodResolutionContext.Candidate c : resolutionContext.candidates) {
            if (resolutionContext.step != c.step || !c.isApplicable()) continue;
            JCDiagnostic subDiag = null;
            if (c.sym.type.hasTag(TypeTag.FORALL)) {
                subDiag = this.diags.fragment(CompilerProperties.Fragments.PartialInstSig(c.mtype));
            }
            String key = subDiag == null ? "applicable.method.found.2" : "applicable.method.found.3";
            subDiags.append(this.diags.fragment(key, pos, c.sym.isStatic() ? CompilerProperties.Fragments.Static : CompilerProperties.Fragments.NonStatic, c.sym, subDiag));
            if (c.sym == bestSoFar) {
                mostSpecificPos = pos;
            }
            ++pos;
        }
        JCDiagnostic main = this.diags.note(this.log.currentSource(), referenceTree, "method.ref.search.results.multi", bound ? CompilerProperties.Fragments.Bound : CompilerProperties.Fragments.Unbound, referenceTree.toString(), mostSpecificPos);
        JCDiagnostic.MultilineDiagnostic d = new JCDiagnostic.MultilineDiagnostic(main, subDiags.toList());
        this.log.report(d);
    }

    Symbol lookupMethod(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, MethodCheck methodCheck, LookupHelper lookupHelper) {
        MethodResolutionContext resolveContext = new MethodResolutionContext();
        resolveContext.methodCheck = methodCheck;
        return this.lookupMethod(env, pos, location, resolveContext, lookupHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol lookupMethod(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, MethodResolutionContext resolveContext, LookupHelper lookupHelper) {
        MethodResolutionContext prevResolutionContext = this.currentResolutionContext;
        try {
            Symbol bestSoFar = this.methodNotFound;
            this.currentResolutionContext = resolveContext;
            for (MethodResolutionPhase phase : this.methodResolutionSteps) {
                if (lookupHelper.shouldStop(bestSoFar, phase)) break;
                MethodResolutionPhase prevPhase = this.currentResolutionContext.step;
                SymbolNotFoundError prevBest = bestSoFar;
                this.currentResolutionContext.step = phase;
                Symbol sym = lookupHelper.lookup(env, phase);
                lookupHelper.debug(pos, sym);
                bestSoFar = phase.mergeResults(bestSoFar, sym);
                ((AttrContext)env.info).pendingResolutionPhase = prevBest == bestSoFar ? prevPhase : phase;
            }
            Symbol symbol = lookupHelper.access(env, pos, location, bestSoFar);
            return symbol;
        }
        finally {
            this.currentResolutionContext = prevResolutionContext;
        }
    }

    Symbol findSelfContaining(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol.TypeSymbol c, boolean isSuper) {
        Env<AttrContext> env1 = isSuper ? env.outer : env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            Symbol sym;
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            if (env1.enclClass.sym.isSubClass(c, this.types) && (sym = ((AttrContext)env1.info).scope.findFirst(this.names._this)) != null) {
                if (staticOnly) {
                    return new StaticError(sym);
                }
                return sym;
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        return this.varNotFound;
    }

    Symbol findLocalClassOwner(Env<AttrContext> env, Symbol.TypeSymbol c) {
        Symbol owner = c.owner;
        Assert.check(owner.kind == Kinds.Kind.MTH || owner.kind == Kinds.Kind.VAR);
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            if (((AttrContext)env1.info).scope.owner == owner) {
                return staticOnly ? new BadLocalClassCreation(c) : owner;
            }
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        return owner.kind == Kinds.Kind.MTH ? this.methodNotFound : this.varNotFound;
    }

    Symbol resolveSelf(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol.TypeSymbol c, JCTree.JCFieldAccess tree) {
        Name name = tree.name;
        Assert.check(name == this.names._this || name == this.names._super);
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            Symbol sym;
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            if (env1.enclClass.sym == c && (sym = ((AttrContext)env1.info).scope.findFirst(name)) != null) {
                if (staticOnly) {
                    sym = new StaticError(sym);
                }
                return this.accessBase(sym, pos, env.enclClass.sym.type, name, true);
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        if (c.isInterface() && name == this.names._super && !Resolve.isStatic(env) && this.types.isDirectSuperInterface(c, env.enclClass.sym)) {
            for (Type t : this.pruneInterfaces(env.enclClass.type)) {
                if (t.tsym != c) continue;
                ((AttrContext)env.info).defaultSuperCallSite = t;
                return new Symbol.VarSymbol(0L, this.names._super, this.types.asSuper(env.enclClass.type, c), env.enclClass.sym);
            }
            for (Type i : this.types.directSupertypes(env.enclClass.type)) {
                if (!i.tsym.isSubClass(c, this.types) || i.tsym == c) continue;
                this.log.error(pos, CompilerProperties.Errors.IllegalDefaultSuperCall((Symbol)c, CompilerProperties.Fragments.RedundantSupertype((Symbol)c, i)));
                return this.syms.errSymbol;
            }
            Assert.error();
        }
        this.log.error(pos, CompilerProperties.Errors.NotEnclClass(c));
        return this.syms.errSymbol;
    }

    private List<Type> pruneInterfaces(Type t) {
        ListBuffer<Type> result = new ListBuffer<Type>();
        for (Type t1 : this.types.interfaces(t)) {
            boolean shouldAdd = true;
            for (Type t2 : this.types.directSupertypes(t)) {
                if (t1 == t2 || t2.hasTag(TypeTag.ERROR) || !this.types.isSubtypeNoCapture(t2, t1)) continue;
                shouldAdd = false;
            }
            if (!shouldAdd) continue;
            result.append(t1);
        }
        return result.toList();
    }

    public void logAccessErrorInternal(Env<AttrContext> env, JCTree tree, Type type) {
        AccessError error = new AccessError(env, env.enclClass.type, type.tsym);
        this.logResolveError(error, tree.pos(), env.enclClass.sym, env.enclClass.type, null, null, null);
    }

    private void logResolveError(ResolveError error, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        JCDiagnostic d = error.getDiagnostic(JCDiagnostic.DiagnosticType.ERROR, pos, location, site, name, argtypes, typeargtypes);
        if (d != null) {
            d.setFlag(JCDiagnostic.DiagnosticFlag.RESOLVE_ERROR);
            this.log.report(d);
        }
    }

    public Object methodArguments(List<Type> argtypes) {
        if (argtypes == null || argtypes.isEmpty()) {
            return this.noArgs;
        }
        ListBuffer<Object> diagArgs = new ListBuffer<Object>();
        for (Type t : argtypes) {
            if (t.hasTag(TypeTag.DEFERRED)) {
                diagArgs.append(((DeferredAttr.DeferredType)t).tree);
                continue;
            }
            diagArgs.append(t);
        }
        return diagArgs;
    }

    boolean isSerializable(Type t) {
        try {
            this.syms.serializableType.complete();
        }
        catch (Symbol.CompletionFailure e) {
            return false;
        }
        return this.types.isSubtype(t, this.syms.serializableType);
    }

    JCDiagnostic inaccessiblePackageReason(Env<AttrContext> env, Symbol.PackageSymbol sym) {
        if (!env.toplevel.modle.readModules.contains(sym.modle)) {
            if (sym.modle != this.syms.unnamedModule) {
                if (env.toplevel.modle != this.syms.unnamedModule) {
                    return this.diags.fragment(CompilerProperties.Fragments.NotDefAccessDoesNotRead(env.toplevel.modle, sym, sym.modle));
                }
                return this.diags.fragment(CompilerProperties.Fragments.NotDefAccessDoesNotReadFromUnnamed(sym, sym.modle));
            }
            return this.diags.fragment(CompilerProperties.Fragments.NotDefAccessDoesNotReadUnnamed(sym, env.toplevel.modle));
        }
        if (sym.packge().modle.exports.stream().anyMatch(e -> e.packge == sym)) {
            if (env.toplevel.modle != this.syms.unnamedModule) {
                return this.diags.fragment(CompilerProperties.Fragments.NotDefAccessNotExportedToModule(sym, sym.modle, env.toplevel.modle));
            }
            return this.diags.fragment(CompilerProperties.Fragments.NotDefAccessNotExportedToModuleFromUnnamed(sym, sym.modle));
        }
        if (env.toplevel.modle != this.syms.unnamedModule) {
            return this.diags.fragment(CompilerProperties.Fragments.NotDefAccessNotExported(sym, sym.modle));
        }
        return this.diags.fragment(CompilerProperties.Fragments.NotDefAccessNotExportedFromUnnamed(sym, sym.modle));
    }

    static interface MethodCheck {
        public void argumentsAcceptable(Env<AttrContext> var1, DeferredAttr.DeferredAttrContext var2, List<Type> var3, List<Type> var4, Warner var5);

        public MethodCheck mostSpecificCheck(List<Type> var1);
    }

    public static interface RecoveryLoadClass {
        public Symbol loadClass(Env<AttrContext> var1, Name var2);
    }

    static interface LogResolveHelper {
        public boolean resolveDiagnosticNeeded(Type var1, List<Type> var2, List<Type> var3);

        public List<Type> getArgumentTypes(ResolveError var1, Symbol var2, Name var3, List<Type> var4);
    }

    abstract class ReferenceChooser {
        ReferenceChooser() {
        }

        ReferenceLookupResult result(ReferenceLookupResult boundRes, ReferenceLookupResult unboundRes) {
            return unboundRes != Resolve.this.referenceNotFound ? this.unboundResult(boundRes, unboundRes) : this.boundResult(boundRes);
        }

        abstract ReferenceLookupResult boundResult(ReferenceLookupResult var1);

        abstract ReferenceLookupResult unboundResult(ReferenceLookupResult var1, ReferenceLookupResult var2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum MethodResolutionPhase {
        BASIC(false, false),
        BOX(true, false),
        VARARITY(true, true){

            @Override
            public Symbol mergeResults(Symbol bestSoFar, Symbol sym) {
                Assert.check(bestSoFar.kind.isResolutionError() && bestSoFar.kind != Kinds.Kind.AMBIGUOUS);
                if (!sym.kind.isResolutionError()) {
                    return sym;
                }
                switch (bestSoFar.kind) {
                    case WRONG_MTH: 
                    case WRONG_MTHS: {
                        switch (sym.kind) {
                            case WRONG_MTH: {
                                return bestSoFar.kind == Kinds.Kind.WRONG_MTHS ? bestSoFar : sym;
                            }
                            case ABSENT_MTH: {
                                return bestSoFar;
                            }
                        }
                        return sym;
                    }
                }
                return bestSoFar;
            }
        };

        final boolean isBoxingRequired;
        final boolean isVarargsRequired;

        private MethodResolutionPhase(boolean isBoxingRequired, boolean isVarargsRequired) {
            this.isBoxingRequired = isBoxingRequired;
            this.isVarargsRequired = isVarargsRequired;
        }

        public boolean isBoxingRequired() {
            return this.isBoxingRequired;
        }

        public boolean isVarargsRequired() {
            return this.isVarargsRequired;
        }

        public Symbol mergeResults(Symbol prev, Symbol sym) {
            return sym;
        }
    }

    class MethodResolutionContext {
        private List<Candidate> candidates = List.nil();
        MethodResolutionPhase step = null;
        MethodCheck methodCheck;
        private boolean internalResolution;
        private DeferredAttr.AttrMode attrMode;

        MethodResolutionContext() {
            this.methodCheck = Resolve.this.resolveMethodCheck;
            this.internalResolution = false;
            this.attrMode = DeferredAttr.AttrMode.SPECULATIVE;
        }

        void addInapplicableCandidate(Symbol sym, JCDiagnostic details) {
            Candidate c = new Candidate(Resolve.this.currentResolutionContext.step, sym, details, null);
            this.candidates = this.candidates.append(c);
        }

        void addApplicableCandidate(Symbol sym, Type mtype) {
            Candidate c = new Candidate(Resolve.this.currentResolutionContext.step, sym, null, mtype);
            this.candidates = this.candidates.append(c);
        }

        DeferredAttr.DeferredAttrContext deferredAttrContext(Symbol sym, InferenceContext inferenceContext, Attr.ResultInfo pendingResult, Warner warn) {
            DeferredAttr.DeferredAttrContext parent = pendingResult == null ? Resolve.this.deferredAttr.emptyDeferredAttrContext : pendingResult.checkContext.deferredAttrContext();
            DeferredAttr deferredAttr = Resolve.this.deferredAttr;
            Objects.requireNonNull(deferredAttr);
            return deferredAttr.new DeferredAttr.DeferredAttrContext(this.attrMode, sym, this.step, inferenceContext, parent, warn);
        }

        DeferredAttr.AttrMode attrMode() {
            return this.attrMode;
        }

        class Candidate {
            final MethodResolutionPhase step;
            final Symbol sym;
            final JCDiagnostic details;
            final Type mtype;

            private Candidate(MethodResolutionPhase step, Symbol sym, JCDiagnostic details, Type mtype) {
                this.step = step;
                this.sym = sym;
                this.details = details;
                this.mtype = mtype;
            }

            boolean isApplicable() {
                return this.mtype != null;
            }
        }
    }

    class SymbolNotFoundError
    extends ResolveError {
        SymbolNotFoundError(Kinds.Kind kind) {
            this(kind, "symbol not found error");
        }

        SymbolNotFoundError(Kinds.Kind kind, String debugName) {
            super(kind, debugName);
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            argtypes = argtypes == null ? List.nil() : argtypes;
            List<Object> list = typeargtypes = typeargtypes == null ? List.nil() : typeargtypes;
            if (name == Resolve.this.names.error) {
                return null;
            }
            boolean hasLocation = false;
            if (location == null) {
                location = site.tsym;
            }
            if (!location.name.isEmpty()) {
                if (location.kind == Kinds.Kind.PCK && !site.tsym.exists() && location.name != Resolve.this.names.java) {
                    return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "doesnt.exist", location);
                }
                hasLocation = !location.name.equals(Resolve.this.names._this) && !location.name.equals(Resolve.this.names._super);
            }
            boolean isConstructor = name == Resolve.this.names.init;
            Kinds.KindName kindname = isConstructor ? Kinds.KindName.CONSTRUCTOR : this.kind.absentKind();
            Name idname = isConstructor ? site.tsym.name : name;
            String errKey = this.getErrorKey(kindname, typeargtypes.nonEmpty(), hasLocation);
            if (hasLocation) {
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, errKey, kindname, idname, typeargtypes, this.args(argtypes), this.getLocationDiag(location, site));
            }
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, errKey, kindname, idname, typeargtypes, this.args(argtypes));
        }

        private Object args(List<Type> args) {
            return args.isEmpty() ? args : Resolve.this.methodArguments(args);
        }

        private String getErrorKey(Kinds.KindName kindname, boolean hasTypeArgs, boolean hasLocation) {
            String key = "cant.resolve";
            Object suffix = hasLocation ? ".location" : "";
            switch (kindname) {
                case METHOD: 
                case CONSTRUCTOR: {
                    suffix = (String)suffix + ".args";
                    suffix = (String)suffix + (hasTypeArgs ? ".params" : "");
                }
            }
            return key + (String)suffix;
        }

        private JCDiagnostic getLocationDiag(Symbol location, Type site) {
            if (location.kind == Kinds.Kind.VAR) {
                return Resolve.this.diags.fragment(CompilerProperties.Fragments.Location1(Kinds.kindName(location), location, location.type));
            }
            return Resolve.this.diags.fragment(CompilerProperties.Fragments.Location(Kinds.typeKindName(site), site, null));
        }
    }

    static class ReferenceLookupResult {
        StaticKind staticKind;
        Symbol sym;

        ReferenceLookupResult(Symbol sym, MethodResolutionContext resolutionContext, boolean isStaticSelector) {
            this(sym, ReferenceLookupResult.staticKind(sym, resolutionContext, isStaticSelector));
        }

        private ReferenceLookupResult(Symbol sym, StaticKind staticKind) {
            this.staticKind = staticKind;
            this.sym = sym;
        }

        private static StaticKind staticKind(Symbol sym, MethodResolutionContext resolutionContext, boolean isStaticSelector) {
            if (sym.kind == Kinds.Kind.MTH && !isStaticSelector) {
                return StaticKind.from(sym);
            }
            if (sym.kind == Kinds.Kind.MTH || sym.kind == Kinds.Kind.AMBIGUOUS) {
                return resolutionContext.candidates.stream().filter(c -> c.isApplicable() && c.step == resolutionContext.step).map(c -> StaticKind.from(c.sym)).reduce(StaticKind::reduce).orElse(StaticKind.UNDEFINED);
            }
            return StaticKind.UNDEFINED;
        }

        boolean isSuccess() {
            return this.staticKind != StaticKind.UNDEFINED;
        }

        boolean hasKind(StaticKind sk) {
            return this.staticKind == sk;
        }

        boolean canIgnore() {
            switch (this.sym.kind) {
                case ABSENT_MTH: {
                    return true;
                }
                case WRONG_MTH: {
                    InapplicableSymbolError errSym = (InapplicableSymbolError)this.sym.baseSymbol();
                    return new MethodResolutionDiagHelper.Template(MethodCheckDiag.ARITY_MISMATCH.regex(), new MethodResolutionDiagHelper.Template[0]).matches(errSym.errCandidate().snd);
                }
                case WRONG_MTHS: {
                    InapplicableSymbolsError errSyms = (InapplicableSymbolsError)this.sym.baseSymbol();
                    return errSyms.filterCandidates(errSyms.mapCandidates()).isEmpty();
                }
            }
            return false;
        }

        static ReferenceLookupResult error(Symbol sym) {
            return new ReferenceLookupResult(sym, StaticKind.UNDEFINED);
        }

        static enum StaticKind {
            STATIC,
            NON_STATIC,
            BOTH,
            UNDEFINED;


            static StaticKind from(Symbol s) {
                return s.isStatic() ? STATIC : NON_STATIC;
            }

            static StaticKind reduce(StaticKind sk1, StaticKind sk2) {
                if (sk1 == UNDEFINED) {
                    return sk2;
                }
                if (sk2 == UNDEFINED) {
                    return sk1;
                }
                return sk1 == sk2 ? sk1 : BOTH;
            }
        }
    }

    static enum VerboseResolutionMode {
        SUCCESS("success"),
        FAILURE("failure"),
        APPLICABLE("applicable"),
        INAPPLICABLE("inapplicable"),
        DEFERRED_INST("deferred-inference"),
        PREDEF("predef"),
        OBJECT_INIT("object-init"),
        INTERNAL("internal");

        final String opt;

        private VerboseResolutionMode(String opt) {
            this.opt = opt;
        }

        static EnumSet<VerboseResolutionMode> getVerboseResolutionMode(Options opts) {
            String s = opts.get("debug.verboseResolution");
            EnumSet<VerboseResolutionMode> res = EnumSet.noneOf(VerboseResolutionMode.class);
            if (s == null) {
                return res;
            }
            if (s.contains("all")) {
                res = EnumSet.allOf(VerboseResolutionMode.class);
            }
            java.util.List<String> args = Arrays.asList(s.split(","));
            for (VerboseResolutionMode mode : VerboseResolutionMode.values()) {
                if (args.contains(mode.opt)) {
                    res.add(mode);
                    continue;
                }
                if (!args.contains("-" + mode.opt)) continue;
                res.remove((Object)mode);
            }
            return res;
        }
    }

    public static class InapplicableMethodException
    extends CompilerInternalException {
        private static final long serialVersionUID = 0L;
        transient JCDiagnostic diagnostic;

        InapplicableMethodException(JCDiagnostic diag, boolean dumpStackTraceOnError) {
            super(dumpStackTraceOnError);
            this.diagnostic = diag;
        }

        public JCDiagnostic getDiagnostic() {
            return this.diagnostic;
        }
    }

    class MethodReferenceCheck
    extends AbstractMethodCheck {
        InferenceContext pendingInferenceContext;

        MethodReferenceCheck(InferenceContext pendingInferenceContext) {
            this.pendingInferenceContext = pendingInferenceContext;
        }

        @Override
        void checkArg(JCDiagnostic.DiagnosticPosition pos, boolean varargs, Type actual, Type formal, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warn) {
            Attr.ResultInfo mresult = this.methodCheckResult(varargs, formal, deferredAttrContext, warn);
            mresult.check(pos, actual);
        }

        private Attr.ResultInfo methodCheckResult(final boolean varargsCheck, Type to, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner rsWarner) {
            MethodCheckContext checkContext = new MethodCheckContext(!deferredAttrContext.phase.isBoxingRequired(), deferredAttrContext, rsWarner){
                MethodCheckDiag methodDiag;
                {
                    super(strict, deferredAttrContext, rsWarner);
                    this.methodDiag = varargsCheck ? MethodCheckDiag.VARARG_MISMATCH : MethodCheckDiag.ARG_MISMATCH;
                }

                @Override
                public boolean compatible(Type found, Type req, Warner warn) {
                    if ((found = MethodReferenceCheck.this.pendingInferenceContext.asUndetVar(found)).hasTag(TypeTag.UNDETVAR) && req.isPrimitive()) {
                        req = Resolve.this.types.boxedClass((Type)req).type;
                    }
                    return super.compatible(found, req, warn);
                }

                @Override
                public void report(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic details) {
                    MethodReferenceCheck.this.reportMC(pos, this.methodDiag, this.deferredAttrContext.inferenceContext, details);
                }
            };
            return new MethodResultInfo(to, checkContext);
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> actuals) {
            return new MostSpecificCheck(actuals);
        }

        public String toString() {
            return "MethodReferenceCheck";
        }
    }

    class AccessError
    extends InvalidSymbolError {
        private Env<AttrContext> env;
        private Type site;

        AccessError(Env<AttrContext> env, Type site, Symbol sym) {
            super(Kinds.Kind.HIDDEN, sym, "access error");
            this.env = env;
            this.site = site;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            if (this.sym.name == Resolve.this.names.init && this.sym.owner != site.tsym) {
                return new SymbolNotFoundError(Kinds.Kind.ABSENT_MTH).getDiagnostic(dkind, pos, location, site, name, argtypes, typeargtypes);
            }
            if ((this.sym.flags() & 1L) != 0L || this.env != null && this.site != null && !Resolve.this.isAccessible(this.env, this.site)) {
                if (this.sym.owner.kind == Kinds.Kind.PCK) {
                    return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "not.def.access.package.cant.access", this.sym, this.sym.location(), Resolve.this.inaccessiblePackageReason(this.env, this.sym.packge()));
                }
                if (this.sym.packge() != Resolve.this.syms.rootPackage && !Resolve.this.symbolPackageVisible(this.env, this.sym)) {
                    return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "not.def.access.class.intf.cant.access.reason", this.sym, this.sym.location(), this.sym.location().packge(), Resolve.this.inaccessiblePackageReason(this.env, this.sym.packge()));
                }
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "not.def.access.class.intf.cant.access", this.sym, this.sym.location());
            }
            if ((this.sym.flags() & 6L) != 0L) {
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "report.access", this.sym, Flags.asFlagSet(this.sym.flags() & 6L), this.sym.location());
            }
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "not.def.public.cant.access", this.sym, this.sym.location());
        }

        private String toString(Type type) {
            StringBuilder sb = new StringBuilder();
            sb.append(type);
            if (type != null) {
                sb.append("[tsym:").append(type.tsym);
                if (type.tsym != null) {
                    sb.append("packge:").append(type.tsym.packge());
                }
                sb.append("]");
            }
            return sb.toString();
        }
    }

    class AmbiguityError
    extends ResolveError {
        List<Symbol> ambiguousSyms;

        @Override
        public boolean exists() {
            return true;
        }

        AmbiguityError(Symbol sym1, Symbol sym2) {
            super(Kinds.Kind.AMBIGUOUS, "ambiguity error");
            this.ambiguousSyms = List.nil();
            this.ambiguousSyms = this.flatten(sym2).appendList(this.flatten(sym1));
        }

        private List<Symbol> flatten(Symbol sym) {
            if (sym.kind == Kinds.Kind.AMBIGUOUS) {
                return ((AmbiguityError)sym.baseSymbol()).ambiguousSyms;
            }
            return List.of(sym);
        }

        AmbiguityError addAmbiguousSymbol(Symbol s) {
            this.ambiguousSyms = this.ambiguousSyms.prepend(s);
            return this;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            List<Symbol> diagSyms = this.ambiguousSyms.reverse();
            Symbol s1 = (Symbol)diagSyms.head;
            Symbol s2 = (Symbol)diagSyms.tail.head;
            Name sname = s1.name;
            if (sname == Resolve.this.names.init) {
                sname = s1.owner.name;
            }
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "ref.ambiguous", sname, Kinds.kindName(s1), s1, s1.location(site, Resolve.this.types), Kinds.kindName(s2), s2, s2.location(site, Resolve.this.types));
        }

        Symbol mergeAbstracts(Type site) {
            List<Symbol> ambiguousInOrder = this.ambiguousSyms.reverse();
            return Resolve.this.types.mergeAbstracts(ambiguousInOrder, site, true).orElse(this);
        }

        @Override
        protected Symbol access(Name name, Symbol.TypeSymbol location) {
            Symbol firstAmbiguity = this.ambiguousSyms.last();
            return firstAmbiguity.kind == Kinds.Kind.TYP ? Resolve.this.types.createErrorType((Name)name, (Symbol.TypeSymbol)location, (Type)firstAmbiguity.type).tsym : firstAmbiguity;
        }
    }

    class StaticError
    extends InvalidSymbolError {
        StaticError(Symbol sym) {
            this(sym, "static error");
        }

        StaticError(Symbol sym, String debugName) {
            super(Kinds.Kind.STATICERR, sym, debugName);
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            Symbol errSym = this.sym.kind == Kinds.Kind.TYP && this.sym.type.hasTag(TypeTag.CLASS) ? Resolve.this.types.erasure((Type)this.sym.type).tsym : this.sym;
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "non-static.cant.be.ref", Kinds.kindName(this.sym), errSym);
        }
    }

    class BadVarargsMethod
    extends ResolveError {
        ResolveError delegatedError;

        BadVarargsMethod(ResolveError delegatedError) {
            super(delegatedError.kind, "badVarargs");
            this.delegatedError = delegatedError;
        }

        @Override
        public Symbol baseSymbol() {
            return this.delegatedError.baseSymbol();
        }

        @Override
        protected Symbol access(Name name, Symbol.TypeSymbol location) {
            return this.delegatedError.access(name, location);
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            return this.delegatedError.getDiagnostic(dkind, pos, location, site, name, argtypes, typeargtypes);
        }
    }

    abstract class ResolveError
    extends Symbol {
        final String debugName;

        ResolveError(Kinds.Kind kind, String debugName) {
            super(kind, 0L, null, null, null);
            this.debugName = debugName;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            throw new AssertionError();
        }

        @Override
        public String toString() {
            return this.debugName;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        protected Symbol access(Name name, Symbol.TypeSymbol location) {
            return Resolve.this.types.createErrorType((Name)name, (Symbol.TypeSymbol)location, (Type)Resolve.this.syms.errSymbol.type).tsym;
        }

        abstract JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType var1, JCDiagnostic.DiagnosticPosition var2, Symbol var3, Type var4, Name var5, List<Type> var6, List<Type> var7);
    }

    class InapplicableSymbolError
    extends ResolveError {
        protected MethodResolutionContext resolveContext;

        InapplicableSymbolError(MethodResolutionContext context) {
            this(Kinds.Kind.WRONG_MTH, "inapplicable symbol error", context);
        }

        protected InapplicableSymbolError(Kinds.Kind kind, String debugName, MethodResolutionContext context) {
            super(kind, debugName);
            this.resolveContext = context;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            if (name == Resolve.this.names.error) {
                return null;
            }
            Pair<Symbol, JCDiagnostic> c = this.errCandidate();
            Symbol ws = ((Symbol)c.fst).asMemberOf(site, Resolve.this.types);
            UnaryOperator rewriter = Resolve.this.compactMethodDiags ? d -> MethodResolutionDiagHelper.rewrite(Resolve.this.diags, pos, Resolve.this.log.currentSource(), dkind, (JCDiagnostic)c.snd) : null;
            switch (((JCDiagnostic)c.snd).getCode()) {
                case "compiler.misc.wrong.number.type.args": 
                case "compiler.misc.explicit.param.do.not.conform.to.bounds": {
                    return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "cant.apply.symbol.noargs", rewriter, Kinds.kindName(ws), ws.name == Resolve.this.names.init ? ws.owner.name : ws.name, ws.owner.type, c.snd);
                }
            }
            if (ws.owner == Resolve.this.syms.arrayClass && ws.name == Resolve.this.names.init) {
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "cant.apply.array.ctor", rewriter, Resolve.this.methodArguments(ws.type.getParameterTypes()), Resolve.this.methodArguments(argtypes), c.snd);
            }
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "cant.apply.symbol", rewriter, Kinds.kindName(ws), ws.name == Resolve.this.names.init ? ws.owner.name : ws.name, Resolve.this.methodArguments(ws.type.getParameterTypes()), Resolve.this.methodArguments(argtypes), Kinds.kindName(ws.owner), ws.owner.type, c.snd);
        }

        @Override
        public Symbol access(Name name, Symbol.TypeSymbol location) {
            Pair<Symbol, JCDiagnostic> cand = this.errCandidate();
            Symbol.TypeSymbol errSymbol = Resolve.this.types.createErrorType((Name)name, (Symbol.TypeSymbol)location, (Type)(cand != null ? ((Symbol)cand.fst).type : Resolve.this.syms.errSymbol.type)).tsym;
            if (cand != null) {
                Resolve.this.attrRecover.wrongMethodSymbolCandidate(errSymbol, (Symbol)cand.fst, (JCDiagnostic)cand.snd);
            }
            return errSymbol;
        }

        protected Pair<Symbol, JCDiagnostic> errCandidate() {
            MethodResolutionContext.Candidate bestSoFar = null;
            for (MethodResolutionContext.Candidate c : this.resolveContext.candidates) {
                if (c.isApplicable()) continue;
                bestSoFar = c;
            }
            Assert.checkNonNull(bestSoFar);
            return new Pair<Symbol, JCDiagnostic>(bestSoFar.sym, bestSoFar.details);
        }
    }

    class InapplicableSymbolsError
    extends InapplicableSymbolError {
        InapplicableSymbolsError(MethodResolutionContext context) {
            super(Kinds.Kind.WRONG_MTHS, "inapplicable symbols", context);
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            boolean truncatedDiag;
            Map<Symbol, JCDiagnostic> filteredCandidates;
            Map<Symbol, JCDiagnostic> candidatesMap = this.mapCandidates();
            Map<Symbol, JCDiagnostic> map = filteredCandidates = Resolve.this.compactMethodDiags ? this.filterCandidates(candidatesMap) : this.mapCandidates();
            if (filteredCandidates.isEmpty()) {
                filteredCandidates = candidatesMap;
            }
            boolean bl = truncatedDiag = candidatesMap.size() != filteredCandidates.size();
            if (filteredCandidates.size() > 1) {
                JCDiagnostic err = Resolve.this.diags.create(dkind, null, truncatedDiag ? EnumSet.of(JCDiagnostic.DiagnosticFlag.COMPRESSED) : EnumSet.noneOf(JCDiagnostic.DiagnosticFlag.class), Resolve.this.log.currentSource(), pos, "cant.apply.symbols", name == Resolve.this.names.init ? Kinds.KindName.CONSTRUCTOR : this.kind.absentKind(), name == Resolve.this.names.init ? site.tsym.name : name, Resolve.this.methodArguments(argtypes));
                return new JCDiagnostic.MultilineDiagnostic(err, this.candidateDetails(filteredCandidates, site));
            }
            if (filteredCandidates.size() == 1) {
                Map.Entry<Symbol, JCDiagnostic> _e = filteredCandidates.entrySet().iterator().next();
                final Pair<Symbol, JCDiagnostic> p = new Pair<Symbol, JCDiagnostic>(_e.getKey(), _e.getValue());
                JCDiagnostic d = new InapplicableSymbolError(this.resolveContext){

                    @Override
                    protected Pair<Symbol, JCDiagnostic> errCandidate() {
                        return p;
                    }
                }.getDiagnostic(dkind, pos, location, site, name, argtypes, typeargtypes);
                if (truncatedDiag) {
                    d.setFlag(JCDiagnostic.DiagnosticFlag.COMPRESSED);
                }
                return d;
            }
            return new SymbolNotFoundError(Kinds.Kind.ABSENT_MTH).getDiagnostic(dkind, pos, location, site, name, argtypes, typeargtypes);
        }

        private Map<Symbol, JCDiagnostic> mapCandidates() {
            MostSpecificMap candidates = new MostSpecificMap();
            for (MethodResolutionContext.Candidate c : this.resolveContext.candidates) {
                if (c.isApplicable()) continue;
                candidates.put(c);
            }
            return candidates;
        }

        Map<Symbol, JCDiagnostic> filterCandidates(Map<Symbol, JCDiagnostic> candidatesMap) {
            LinkedHashMap<Symbol, JCDiagnostic> candidates = new LinkedHashMap<Symbol, JCDiagnostic>();
            for (Map.Entry<Symbol, JCDiagnostic> _entry : candidatesMap.entrySet()) {
                JCDiagnostic d = _entry.getValue();
                if (new MethodResolutionDiagHelper.Template(MethodCheckDiag.ARITY_MISMATCH.regex(), new MethodResolutionDiagHelper.Template[0]).matches(d)) continue;
                candidates.put(_entry.getKey(), d);
            }
            return candidates;
        }

        private List<JCDiagnostic> candidateDetails(Map<Symbol, JCDiagnostic> candidatesMap, Type site) {
            List<JCDiagnostic> details = List.nil();
            for (Map.Entry<Symbol, JCDiagnostic> _entry : candidatesMap.entrySet()) {
                Symbol sym = _entry.getKey();
                JCDiagnostic detailDiag = Resolve.this.diags.fragment(CompilerProperties.Fragments.InapplicableMethod(Kinds.kindName(sym), sym.location(site, Resolve.this.types), sym.asMemberOf(site, Resolve.this.types), _entry.getValue()));
                details = details.prepend(detailDiag);
            }
            return details;
        }

        @Override
        protected Pair<Symbol, JCDiagnostic> errCandidate() {
            Map<Symbol, JCDiagnostic> candidatesMap = this.mapCandidates();
            Map<Symbol, JCDiagnostic> filteredCandidates = this.filterCandidates(candidatesMap);
            if (filteredCandidates.size() == 1) {
                return Pair.of(filteredCandidates.keySet().iterator().next(), filteredCandidates.values().iterator().next());
            }
            return null;
        }

        private class MostSpecificMap
        extends LinkedHashMap<Symbol, JCDiagnostic> {
            private MostSpecificMap() {
            }

            private void put(MethodResolutionContext.Candidate c) {
                ListBuffer<Symbol> overridden = new ListBuffer<Symbol>();
                for (Symbol s : this.keySet()) {
                    if (s == c.sym) continue;
                    if (c.sym.overrides(s, (Symbol.TypeSymbol)s.owner, Resolve.this.types, false)) {
                        overridden.add(s);
                        continue;
                    }
                    if (!s.overrides(c.sym, (Symbol.TypeSymbol)c.sym.owner, Resolve.this.types, false)) continue;
                    return;
                }
                for (Symbol s : overridden) {
                    this.remove(s);
                }
                this.put(c.sym, c.details);
            }
        }
    }

    class LookupFilter
    implements Predicate<Symbol> {
        boolean abstractOk;

        LookupFilter(boolean abstractOk) {
            this.abstractOk = abstractOk;
        }

        @Override
        public boolean test(Symbol s) {
            long flags = s.flags();
            return s.kind == Kinds.Kind.MTH && (flags & 0x1000L) == 0L && (this.abstractOk || (flags & 0x80000000000L) != 0L || (flags & 0x400L) == 0L);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum InterfaceLookupPhase {
        ABSTRACT_OK{

            @Override
            InterfaceLookupPhase update(Symbol s, Resolve rs) {
                if ((s.flags() & 0x4600L) != 0L) {
                    return this;
                }
                return DEFAULT_OK;
            }
        }
        ,
        DEFAULT_OK{

            @Override
            InterfaceLookupPhase update(Symbol s, Resolve rs) {
                return this;
            }
        };


        abstract InterfaceLookupPhase update(Symbol var1, Resolve var2);
    }

    class BadClassFileError
    extends InvalidSymbolError {
        private final Symbol.CompletionFailure ex;

        public BadClassFileError(Symbol.CompletionFailure ex) {
            super(Kinds.Kind.HIDDEN, ex.sym, "BadClassFileError");
            this.name = this.sym.name;
            this.ex = ex;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            JCDiagnostic d = Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "cant.access", this.ex.sym, this.ex.getDetailValue());
            d.setFlag(JCDiagnostic.DiagnosticFlag.NON_DEFERRABLE);
            return d;
        }
    }

    class InvisibleSymbolError
    extends InvalidSymbolError {
        private final Env<AttrContext> env;
        private final boolean suppressError;

        InvisibleSymbolError(Env<AttrContext> env, boolean suppressError, Symbol sym) {
            super(Kinds.Kind.HIDDEN, sym, "invisible class error");
            this.env = env;
            this.suppressError = suppressError;
            this.name = sym.name;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            if (this.suppressError) {
                return null;
            }
            if (this.sym.kind == Kinds.Kind.PCK) {
                JCDiagnostic details = Resolve.this.inaccessiblePackageReason(this.env, this.sym.packge());
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "package.not.visible", this.sym, details);
            }
            JCDiagnostic details = Resolve.this.inaccessiblePackageReason(this.env, this.sym.packge());
            if (pos.getTree() != null) {
                Symbol o = this.sym;
                JCTree tree = pos.getTree();
                while (o.kind != Kinds.Kind.PCK && tree.hasTag(JCTree.Tag.SELECT)) {
                    o = o.owner;
                    tree = ((JCTree.JCFieldAccess)tree).selected;
                }
                if (o.kind == Kinds.Kind.PCK) {
                    pos = tree.pos();
                    return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "package.not.visible", o, details);
                }
            }
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "not.def.access.package.cant.access", this.sym, this.sym.packge(), details);
        }
    }

    class BadRestrictedTypeError
    extends ResolveError {
        private final Name typeName;

        BadRestrictedTypeError(Name typeName) {
            super(Kinds.Kind.BAD_RESTRICTED_TYPE, "bad var use");
            this.typeName = typeName;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "illegal.ref.to.restricted.type", this.typeName);
        }
    }

    abstract class LookupHelper {
        Name name;
        Type site;
        List<Type> argtypes;
        List<Type> typeargtypes;
        MethodResolutionPhase maxPhase;

        LookupHelper(Name name, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            this.name = name;
            this.site = site;
            this.argtypes = argtypes;
            this.typeargtypes = typeargtypes;
            this.maxPhase = maxPhase;
        }

        final boolean shouldStop(Symbol sym, MethodResolutionPhase phase) {
            return phase.ordinal() > this.maxPhase.ordinal() || !sym.kind.isResolutionError() || sym.kind == Kinds.Kind.AMBIGUOUS || sym.kind == Kinds.Kind.STATICERR;
        }

        abstract Symbol lookup(Env<AttrContext> var1, MethodResolutionPhase var2);

        void debug(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        }

        abstract Symbol access(Env<AttrContext> var1, JCDiagnostic.DiagnosticPosition var2, Symbol var3, Symbol var4);
    }

    abstract class ReferenceLookupHelper
    extends LookupHelper {
        JCTree.JCMemberReference referenceTree;

        ReferenceLookupHelper(JCTree.JCMemberReference referenceTree, Name name, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            super(name, site, argtypes, typeargtypes, maxPhase);
            this.referenceTree = referenceTree;
        }

        ReferenceLookupHelper unboundLookup(InferenceContext inferenceContext) {
            return null;
        }

        abstract JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol var1);

        @Override
        Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, Symbol sym) {
            return sym;
        }
    }

    class MethodReferenceLookupHelper
    extends ReferenceLookupHelper {
        Type originalSite;

        MethodReferenceLookupHelper(JCTree.JCMemberReference referenceTree, Name name, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            super(referenceTree, name, Resolve.this.types.skipTypeVars(site, true), argtypes, typeargtypes, maxPhase);
            this.originalSite = site;
        }

        @Override
        final Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
            return Resolve.this.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired());
        }

        @Override
        ReferenceLookupHelper unboundLookup(InferenceContext inferenceContext) {
            if (TreeInfo.isStaticSelector(this.referenceTree.expr, Resolve.this.names)) {
                if (this.argtypes.nonEmpty() && (((Type)this.argtypes.head).hasTag(TypeTag.NONE) || Resolve.this.types.isSubtypeUnchecked(inferenceContext.asUndetVar((Type)this.argtypes.head), this.originalSite))) {
                    return new UnboundMethodReferenceLookupHelper(this.referenceTree, this.name, this.originalSite, this.argtypes, this.typeargtypes, this.maxPhase);
                }
                return new ReferenceLookupHelper(this.referenceTree, this.name, this.site, this.argtypes, this.typeargtypes, this.maxPhase){

                    @Override
                    ReferenceLookupHelper unboundLookup(InferenceContext inferenceContext) {
                        return this;
                    }

                    @Override
                    Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
                        return Resolve.this.methodNotFound;
                    }

                    @Override
                    JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol sym) {
                        Assert.error();
                        return null;
                    }
                };
            }
            return super.unboundLookup(inferenceContext);
        }

        @Override
        JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol sym) {
            if (sym.isStatic()) {
                return JCTree.JCMemberReference.ReferenceKind.STATIC;
            }
            Name selName = TreeInfo.name(this.referenceTree.getQualifierExpression());
            return selName != null && selName == Resolve.this.names._super ? JCTree.JCMemberReference.ReferenceKind.SUPER : JCTree.JCMemberReference.ReferenceKind.BOUND;
        }

        @Override
        Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, Symbol sym) {
            if (this.originalSite.hasTag(TypeTag.TYPEVAR) && sym.kind == Kinds.Kind.MTH) {
                sym = (sym.flags() & 2L) != 0L ? new AccessError(env, this.site, sym) : sym;
                return Resolve.this.accessBase(sym, pos, location, this.originalSite, this.name, true);
            }
            return super.access(env, pos, location, sym);
        }
    }

    class ArrayConstructorReferenceLookupHelper
    extends ReferenceLookupHelper {
        ArrayConstructorReferenceLookupHelper(JCTree.JCMemberReference referenceTree, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            super(referenceTree, Resolve.this.names.init, site, argtypes, typeargtypes, maxPhase);
        }

        @Override
        protected Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
            Scope.WriteableScope sc = Scope.WriteableScope.create(Resolve.this.syms.arrayClass);
            Symbol.MethodSymbol arrayConstr = new Symbol.MethodSymbol(1L, this.name, null, this.site.tsym);
            arrayConstr.type = new Type.MethodType(List.of(Resolve.this.syms.intType), this.site, List.nil(), Resolve.this.syms.methodClass);
            sc.enter(arrayConstr);
            return Resolve.this.findMethodInScope(env, this.site, this.name, this.argtypes, this.typeargtypes, sc, Resolve.this.methodNotFound, phase.isBoxingRequired(), phase.isVarargsRequired(), false);
        }

        @Override
        JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol sym) {
            return JCTree.JCMemberReference.ReferenceKind.ARRAY_CTOR;
        }
    }

    class ConstructorReferenceLookupHelper
    extends ReferenceLookupHelper {
        boolean needsInference;

        ConstructorReferenceLookupHelper(JCTree.JCMemberReference referenceTree, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            super(referenceTree, Resolve.this.names.init, site, argtypes, typeargtypes, maxPhase);
            if (site.isRaw()) {
                this.site = new Type.ClassType(site.getEnclosingType(), !site.tsym.isInner() || !site.getEnclosingType().isRaw() ? site.tsym.type.getTypeArguments() : List.nil(), site.tsym, site.getMetadata());
                this.needsInference = true;
            }
        }

        @Override
        protected Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
            return this.needsInference ? Resolve.this.findDiamond(env, this.site, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired()) : Resolve.this.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired());
        }

        @Override
        JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol sym) {
            return this.site.getEnclosingType().hasTag(TypeTag.NONE) ? JCTree.JCMemberReference.ReferenceKind.TOPLEVEL : JCTree.JCMemberReference.ReferenceKind.IMPLICIT_INNER;
        }
    }

    class BadLocalClassCreation
    extends StaticError {
        BadLocalClassCreation(Symbol sym) {
            super(sym, "bad local class creation");
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "local.cant.be.inst.static", Kinds.kindName(this.sym), this.sym);
        }
    }

    static class MethodResolutionDiagHelper {
        static final Template skip = new Template("", new Template[0]){

            @Override
            boolean matches(Object d) {
                return true;
            }
        };
        static final Template argMismatchTemplate = new Template(MethodCheckDiag.ARG_MISMATCH.regex(), skip);
        static final Template inferArgMismatchTemplate = new Template(MethodCheckDiag.ARG_MISMATCH.regex(), new Template[]{skip, skip}){
            BiPredicate<Object, List<Type>> containsPredicate = (o, ts) -> {
                if (o instanceof Type) {
                    Type type = (Type)o;
                    return type.containsAny((List<Type>)ts);
                }
                if (o instanceof JCDiagnostic) {
                    JCDiagnostic diagnostic = (JCDiagnostic)o;
                    return this.containsAny(diagnostic, (List<Type>)ts);
                }
                return false;
            };

            @Override
            boolean matches(Object o) {
                if (!super.matches(o)) {
                    return false;
                }
                JCDiagnostic d = (JCDiagnostic)o;
                List tvars = (List)d.getArgs()[0];
                return !this.containsAny(d, tvars);
            }

            boolean containsAny(JCDiagnostic d, List<Type> ts) {
                return Stream.of(d.getArgs()).anyMatch(o -> this.containsPredicate.test(o, ts));
            }
        };
        static final Map<Template, DiagnosticRewriter> rewriters = new LinkedHashMap<Template, DiagnosticRewriter>();

        MethodResolutionDiagHelper() {
        }

        static JCDiagnostic rewrite(JCDiagnostic.Factory diags, JCDiagnostic.DiagnosticPosition pos, DiagnosticSource source, JCDiagnostic.DiagnosticType dkind, JCDiagnostic d) {
            for (Map.Entry<Template, DiagnosticRewriter> _entry : rewriters.entrySet()) {
                if (!_entry.getKey().matches(d)) continue;
                JCDiagnostic simpleDiag = _entry.getValue().rewriteDiagnostic(diags, pos, source, dkind, d);
                simpleDiag.setFlag(JCDiagnostic.DiagnosticFlag.COMPRESSED);
                return simpleDiag;
            }
            return null;
        }

        static {
            rewriters.put(argMismatchTemplate, new ArgMismatchRewriter(0));
            rewriters.put(inferArgMismatchTemplate, new ArgMismatchRewriter(1));
        }

        static class Template {
            String regex;
            Template[] subTemplates;

            Template(String key, Template ... subTemplates) {
                this.regex = key;
                this.subTemplates = subTemplates;
            }

            boolean matches(Object o) {
                JCDiagnostic d = (JCDiagnostic)o;
                Object[] args = d.getArgs();
                if (!d.getCode().matches(this.regex) || this.subTemplates.length != d.getArgs().length) {
                    return false;
                }
                for (int i = 0; i < args.length; ++i) {
                    if (this.subTemplates[i].matches(args[i])) continue;
                    return false;
                }
                return true;
            }
        }

        static interface DiagnosticRewriter {
            public JCDiagnostic rewriteDiagnostic(JCDiagnostic.Factory var1, JCDiagnostic.DiagnosticPosition var2, DiagnosticSource var3, JCDiagnostic.DiagnosticType var4, JCDiagnostic var5);
        }

        static class ArgMismatchRewriter
        implements DiagnosticRewriter {
            int causeIndex;

            public ArgMismatchRewriter(int causeIndex) {
                this.causeIndex = causeIndex;
            }

            @Override
            public JCDiagnostic rewriteDiagnostic(JCDiagnostic.Factory diags, JCDiagnostic.DiagnosticPosition preferredPos, DiagnosticSource preferredSource, JCDiagnostic.DiagnosticType preferredKind, JCDiagnostic d) {
                JCDiagnostic cause = (JCDiagnostic)d.getArgs()[this.causeIndex];
                JCDiagnostic.DiagnosticPosition pos = d.getDiagnosticPosition();
                if (pos == null) {
                    pos = preferredPos;
                }
                return diags.create(preferredKind, preferredSource, pos, "prob.found.req", cause);
            }
        }
    }

    class BadMethodReferenceError
    extends StaticError {
        boolean unboundLookup;

        public BadMethodReferenceError(Symbol sym, boolean unboundLookup) {
            super(sym, "bad method ref error");
            this.unboundLookup = unboundLookup;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            String key = !this.unboundLookup ? "bad.static.method.in.bound.lookup" : (this.sym.isStatic() ? "bad.static.method.in.unbound.lookup" : "bad.instance.method.in.unbound.lookup");
            return this.sym.kind.isResolutionError() ? ((ResolveError)this.sym).getDiagnostic(dkind, pos, location, site, name, argtypes, typeargtypes) : Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, key, Kinds.kindName(this.sym), this.sym);
        }
    }

    class RefBeforeCtorCalledError
    extends StaticError {
        RefBeforeCtorCalledError(Symbol sym) {
            super(sym, "prologue error");
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            Symbol errSym = this.sym.kind == Kinds.Kind.TYP && this.sym.type.hasTag(TypeTag.CLASS) ? Resolve.this.types.erasure((Type)this.sym.type).tsym : this.sym;
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "cant.ref.before.ctor.called", errSym);
        }
    }

    class DiamondError
    extends InapplicableSymbolError {
        Symbol sym;

        public DiamondError(Symbol sym, MethodResolutionContext context) {
            super(sym.kind, "diamondError", context);
            this.sym = sym;
        }

        JCDiagnostic getDetails() {
            return this.sym.kind == Kinds.Kind.WRONG_MTH ? (JCDiagnostic)((InapplicableSymbolError)this.sym.baseSymbol()).errCandidate().snd : null;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            JCDiagnostic simpleDiag;
            JCDiagnostic details = this.getDetails();
            if (details != null && Resolve.this.compactMethodDiags && (simpleDiag = MethodResolutionDiagHelper.rewrite(Resolve.this.diags, pos, Resolve.this.log.currentSource(), dkind, details)) != null) {
                return simpleDiag;
            }
            String key = details == null ? "cant.apply.diamond" : "cant.apply.diamond.1";
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, key, CompilerProperties.Fragments.Diamond(site.tsym), details);
        }
    }

    abstract class InvalidSymbolError
    extends ResolveError {
        Symbol sym;

        InvalidSymbolError(Kinds.Kind kind, Symbol sym, String debugName) {
            super(kind, debugName);
            this.sym = sym;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + " wrongSym=" + String.valueOf(this.sym);
        }

        @Override
        public Symbol access(Name name, Symbol.TypeSymbol location) {
            if (!this.sym.kind.isResolutionError() && this.sym.kind.matches(Kinds.KindSelector.TYP)) {
                return Resolve.this.types.createErrorType((Name)name, (Symbol.TypeSymbol)location, (Type)this.sym.type).tsym;
            }
            return this.sym;
        }
    }

    class UnboundMethodReferenceLookupHelper
    extends MethodReferenceLookupHelper {
        UnboundMethodReferenceLookupHelper(JCTree.JCMemberReference referenceTree, Name name, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            super(referenceTree, name, site, argtypes.tail, typeargtypes, maxPhase);
            if (site.isRaw() && !((Type)argtypes.head).hasTag(TypeTag.NONE)) {
                Type asSuperSite = Resolve.this.types.asSuper((Type)argtypes.head, site.tsym);
                this.site = Resolve.this.types.skipTypeVars(asSuperSite, true);
            }
        }

        @Override
        ReferenceLookupHelper unboundLookup(InferenceContext inferenceContext) {
            return this;
        }

        @Override
        JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol sym) {
            return JCTree.JCMemberReference.ReferenceKind.UNBOUND;
        }
    }

    abstract class BasicLookupHelper
    extends LookupHelper {
        BasicLookupHelper(Name name, Type site, List<Type> argtypes, List<Type> typeargtypes) {
            this(name, site, argtypes, typeargtypes, MethodResolutionPhase.VARARITY);
        }

        BasicLookupHelper(Name name, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            super(name, site, argtypes, typeargtypes, maxPhase);
        }

        @Override
        Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, Symbol sym) {
            if (sym.kind.isResolutionError()) {
                sym = Resolve.this.accessMethod(sym, pos, location, this.site, this.name, true, this.argtypes, this.typeargtypes);
            }
            return sym;
        }

        @Override
        void debug(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
            Resolve.this.reportVerboseResolutionDiagnostic(pos, this.name, this.site, this.argtypes, this.typeargtypes, sym);
        }
    }

    class ResolveDeferredRecoveryMap
    extends DeferredAttr.RecoveryDeferredTypeMap {
        public ResolveDeferredRecoveryMap(DeferredAttr.AttrMode mode, Symbol msym, MethodResolutionPhase step) {
            DeferredAttr deferredAttr = Resolve.this.deferredAttr;
            Objects.requireNonNull(deferredAttr);
            super(mode, msym, step);
        }

        @Override
        protected Type typeOf(DeferredAttr.DeferredType dt, Type pt) {
            Type res = super.typeOf(dt, pt);
            if (!res.isErroneous()) {
                switch (TreeInfo.skipParens(dt.tree).getTag()) {
                    case LAMBDA: 
                    case REFERENCE: {
                        return dt;
                    }
                    case CONDEXPR: {
                        return res == Type.recoveryType ? dt : res;
                    }
                }
            }
            return res;
        }
    }

    class MostSpecificCheck
    implements MethodCheck {
        List<Type> actuals;

        MostSpecificCheck(List<Type> actuals) {
            this.actuals = actuals;
        }

        @Override
        public void argumentsAcceptable(Env<AttrContext> env, DeferredAttr.DeferredAttrContext deferredAttrContext, List<Type> formals1, List<Type> formals2, Warner warn) {
            formals2 = Resolve.this.adjustArgs(formals2, deferredAttrContext.msym, formals1.length(), deferredAttrContext.phase.isVarargsRequired());
            while (formals2.nonEmpty()) {
                Attr.ResultInfo mresult = this.methodCheckResult((Type)formals2.head, deferredAttrContext, warn, (Type)this.actuals.head);
                mresult.check(null, (Type)formals1.head);
                formals1 = formals1.tail;
                formals2 = formals2.tail;
                this.actuals = this.actuals.isEmpty() ? this.actuals : this.actuals.tail;
            }
        }

        Attr.ResultInfo methodCheckResult(Type to, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner rsWarner, Type actual) {
            Attr attr = Resolve.this.attr;
            Objects.requireNonNull(attr);
            return attr.new Attr.ResultInfo(Kinds.KindSelector.VAL, to, new MostSpecificCheckContext(deferredAttrContext, rsWarner, actual));
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> actuals) {
            Assert.error("Cannot get here!");
            return null;
        }

        class MostSpecificCheckContext
        extends MethodCheckContext {
            Type actual;

            public MostSpecificCheckContext(DeferredAttr.DeferredAttrContext deferredAttrContext, Warner rsWarner, Type actual) {
                super(true, deferredAttrContext, rsWarner);
                this.actual = actual;
            }

            @Override
            public boolean compatible(Type found, Type req, Warner warn) {
                DeferredAttr.DeferredType dt;
                JCTree speculativeTree;
                if (this.unrelatedFunctionalInterfaces(found, req) && this.actual != null && this.actual.getTag() == TypeTag.DEFERRED && (speculativeTree = (dt = (DeferredAttr.DeferredType)this.actual).speculativeTree(this.deferredAttrContext)) != Resolve.this.deferredAttr.stuckTree) {
                    return this.functionalInterfaceMostSpecific(found, req, speculativeTree);
                }
                return this.compatibleBySubtyping(found, req);
            }

            private boolean compatibleBySubtyping(Type found, Type req) {
                if (!this.strict && found.isPrimitive() != req.isPrimitive()) {
                    found = found.isPrimitive() ? Resolve.this.types.boxedClass((Type)found).type : Resolve.this.types.unboxedType(found);
                }
                return Resolve.this.types.isSubtypeNoCapture(found, this.deferredAttrContext.inferenceContext.asUndetVar(req));
            }

            private boolean unrelatedFunctionalInterfaces(Type t, Type s) {
                return Resolve.this.types.isFunctionalInterface(t.tsym) && Resolve.this.types.isFunctionalInterface(s.tsym) && this.unrelatedInterfaces(t, s);
            }

            private boolean unrelatedInterfaces(Type t, Type s) {
                if (t.isCompound()) {
                    for (Type ti : Resolve.this.types.interfaces(t)) {
                        if (this.unrelatedInterfaces(ti, s)) continue;
                        return false;
                    }
                    return true;
                }
                if (s.isCompound()) {
                    for (Type si : Resolve.this.types.interfaces(s)) {
                        if (this.unrelatedInterfaces(t, si)) continue;
                        return false;
                    }
                    return true;
                }
                return Resolve.this.types.asSuper(t, s.tsym) == null && Resolve.this.types.asSuper(s, t.tsym) == null;
            }

            private boolean functionalInterfaceMostSpecific(Type t, Type s, JCTree tree) {
                Type sDesc;
                Type tDescNoCapture;
                Type tDesc;
                try {
                    tDesc = Resolve.this.types.findDescriptorType(Resolve.this.types.capture(t));
                    tDescNoCapture = Resolve.this.types.findDescriptorType(t);
                    sDesc = Resolve.this.types.findDescriptorType(s);
                }
                catch (Types.FunctionDescriptorLookupError ex) {
                    return false;
                }
                List<Type> tTypeParams = tDesc.getTypeArguments();
                List<Type> tTypeParamsNoCapture = tDescNoCapture.getTypeArguments();
                List<Type> sTypeParams = sDesc.getTypeArguments();
                if (tDesc.hasTag(TypeTag.FORALL) && !Resolve.this.types.hasSameBounds((Type.ForAll)tDesc, (Type.ForAll)tDescNoCapture)) {
                    return false;
                }
                List<Type> tIter = tTypeParams;
                List<Type> sIter = sTypeParams;
                while (tIter.nonEmpty() && sIter.nonEmpty()) {
                    Type tBound = ((Type)tIter.head).getUpperBound();
                    Type sBound = Resolve.this.types.subst(((Type)sIter.head).getUpperBound(), sTypeParams, tTypeParams);
                    if (tBound.containsAny(tTypeParams) && this.inferenceContext().free(sBound)) {
                        return false;
                    }
                    if (!Resolve.this.types.isSameType(tBound, this.inferenceContext().asUndetVar(sBound))) {
                        return false;
                    }
                    tIter = tIter.tail;
                    sIter = sIter.tail;
                }
                if (!tIter.isEmpty() || !sIter.isEmpty()) {
                    return false;
                }
                List<Type> tParams = tDesc.getParameterTypes();
                List<Type> tParamsNoCapture = tDescNoCapture.getParameterTypes();
                List<Type> sParams = sDesc.getParameterTypes();
                while (tParams.nonEmpty() && tParamsNoCapture.nonEmpty() && sParams.nonEmpty()) {
                    Type tParam = (Type)tParams.head;
                    Type tParamNoCapture = Resolve.this.types.subst((Type)tParamsNoCapture.head, tTypeParamsNoCapture, tTypeParams);
                    Type sParam = Resolve.this.types.subst((Type)sParams.head, sTypeParams, tTypeParams);
                    if (tParam.containsAny(tTypeParams) && this.inferenceContext().free(sParam)) {
                        return false;
                    }
                    if (!Resolve.this.types.isSubtype(this.inferenceContext().asUndetVar(sParam), tParam)) {
                        return false;
                    }
                    if (!Resolve.this.types.isSameType(tParamNoCapture, this.inferenceContext().asUndetVar(sParam))) {
                        return false;
                    }
                    tParams = tParams.tail;
                    tParamsNoCapture = tParamsNoCapture.tail;
                    sParams = sParams.tail;
                }
                if (!(tParams.isEmpty() && tParamsNoCapture.isEmpty() && sParams.isEmpty())) {
                    return false;
                }
                Type tRet = tDesc.getReturnType();
                Type sRet = Resolve.this.types.subst(sDesc.getReturnType(), sTypeParams, tTypeParams);
                if (tRet.containsAny(tTypeParams) && this.inferenceContext().free(sRet)) {
                    return false;
                }
                MostSpecificFunctionReturnChecker msc = new MostSpecificFunctionReturnChecker(tRet, sRet);
                msc.scan(tree);
                return msc.result;
            }

            class MostSpecificFunctionReturnChecker
            extends DeferredAttr.PolyScanner {
                final Type tRet;
                final Type sRet;
                boolean result;

                MostSpecificFunctionReturnChecker(Type tRet, Type sRet) {
                    this.tRet = tRet;
                    this.sRet = sRet;
                    this.result = true;
                }

                @Override
                void skip(JCTree tree) {
                    this.result = false;
                }

                @Override
                public void visitConditional(JCTree.JCConditional tree) {
                    this.scan(this.asExpr(tree.truepart));
                    this.scan(this.asExpr(tree.falsepart));
                }

                @Override
                public void visitReference(JCTree.JCMemberReference tree) {
                    if (!this.sRet.hasTag(TypeTag.VOID)) {
                        if (this.tRet.hasTag(TypeTag.VOID)) {
                            this.result = false;
                        } else if (this.tRet.isPrimitive() != this.sRet.isPrimitive()) {
                            boolean retValIsPrimitive = tree.refPolyKind == JCTree.JCPolyExpression.PolyKind.STANDALONE && tree.sym.type.getReturnType().isPrimitive();
                            this.result &= retValIsPrimitive == this.tRet.isPrimitive() && retValIsPrimitive != this.sRet.isPrimitive();
                        } else {
                            this.result &= MostSpecificCheckContext.this.compatibleBySubtyping(this.tRet, this.sRet);
                        }
                    }
                }

                @Override
                public void visitParens(JCTree.JCParens tree) {
                    this.scan(this.asExpr(tree.expr));
                }

                @Override
                public void visitLambda(JCTree.JCLambda tree) {
                    if (!this.sRet.hasTag(TypeTag.VOID)) {
                        if (this.tRet.hasTag(TypeTag.VOID)) {
                            this.result = false;
                        } else {
                            List<JCTree.JCExpression> lambdaResults = this.lambdaResults(tree);
                            if (!lambdaResults.isEmpty() && MostSpecificCheckContext.this.unrelatedFunctionalInterfaces(this.tRet, this.sRet)) {
                                for (JCTree.JCExpression expr : lambdaResults) {
                                    this.result &= MostSpecificCheckContext.this.functionalInterfaceMostSpecific(this.tRet, this.sRet, expr);
                                }
                            } else if (!lambdaResults.isEmpty() && this.tRet.isPrimitive() != this.sRet.isPrimitive()) {
                                for (JCTree.JCExpression expr : lambdaResults) {
                                    boolean retValIsPrimitive = expr.isStandalone() && expr.type.isPrimitive();
                                    this.result &= retValIsPrimitive == this.tRet.isPrimitive() && retValIsPrimitive != this.sRet.isPrimitive();
                                }
                            } else {
                                this.result &= MostSpecificCheckContext.this.compatibleBySubtyping(this.tRet, this.sRet);
                            }
                        }
                    }
                }

                private List<JCTree.JCExpression> lambdaResults(JCTree.JCLambda lambda) {
                    if (lambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                        return List.of(this.asExpr((JCTree.JCExpression)lambda.body));
                    }
                    final ListBuffer buffer = new ListBuffer();
                    DeferredAttr.LambdaReturnScanner lambdaScanner = new DeferredAttr.LambdaReturnScanner(){

                        @Override
                        public void visitReturn(JCTree.JCReturn tree) {
                            if (tree.expr != null) {
                                buffer.append(MostSpecificFunctionReturnChecker.this.asExpr(tree.expr));
                            }
                        }
                    };
                    lambdaScanner.scan(lambda.body);
                    return buffer.toList();
                }

                private JCTree.JCExpression asExpr(JCTree.JCExpression expr) {
                    JCTree speculativeTree;
                    if (expr.type.hasTag(TypeTag.DEFERRED) && (speculativeTree = ((DeferredAttr.DeferredType)expr.type).speculativeTree(MostSpecificCheckContext.this.deferredAttrContext)) != Resolve.this.deferredAttr.stuckTree) {
                        expr = (JCTree.JCExpression)speculativeTree;
                    }
                    return expr;
                }
            }
        }
    }

    class MethodResultInfo
    extends Attr.ResultInfo {
        public MethodResultInfo(Type pt, Check.CheckContext checkContext) {
            Attr attr = Resolve.this.attr;
            Objects.requireNonNull(attr);
            super(Kinds.KindSelector.VAL, pt, checkContext);
        }

        @Override
        protected Type check(JCDiagnostic.DiagnosticPosition pos, Type found) {
            if (found.hasTag(TypeTag.DEFERRED)) {
                DeferredAttr.DeferredType dt = (DeferredAttr.DeferredType)found;
                return dt.check(this);
            }
            Type uResult = this.U(found);
            Type capturedType = pos == null || pos.getTree() == null ? Resolve.this.types.capture(uResult) : this.checkContext.inferenceContext().cachedCapture(pos.getTree(), uResult, true);
            return super.check(pos, Resolve.this.chk.checkNonVoid(pos, capturedType));
        }

        private Type U(Type found) {
            return found == this.pt ? found : Resolve.this.types.cvarUpperBound(found);
        }

        @Override
        protected MethodResultInfo dup(Type newPt) {
            return new MethodResultInfo(newPt, this.checkContext);
        }

        @Override
        protected Attr.ResultInfo dup(Check.CheckContext newContext) {
            return new MethodResultInfo(this.pt, newContext);
        }

        @Override
        protected Attr.ResultInfo dup(Type newPt, Check.CheckContext newContext) {
            return new MethodResultInfo(newPt, newContext);
        }
    }

    abstract class MethodCheckContext
    implements Check.CheckContext {
        boolean strict;
        DeferredAttr.DeferredAttrContext deferredAttrContext;
        Warner rsWarner;

        public MethodCheckContext(boolean strict, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner rsWarner) {
            this.strict = strict;
            this.deferredAttrContext = deferredAttrContext;
            this.rsWarner = rsWarner;
        }

        @Override
        public boolean compatible(Type found, Type req, Warner warn) {
            InferenceContext inferenceContext = this.deferredAttrContext.inferenceContext;
            return this.strict ? Resolve.this.types.isSubtypeUnchecked(inferenceContext.asUndetVar(found), inferenceContext.asUndetVar(req), warn) : Resolve.this.types.isConvertible(inferenceContext.asUndetVar(found), inferenceContext.asUndetVar(req), warn);
        }

        @Override
        public void report(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic details) {
            throw new InapplicableMethodException(details, Resolve.this.dumpStacktraceOnError);
        }

        @Override
        public Warner checkWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
            return this.rsWarner;
        }

        @Override
        public InferenceContext inferenceContext() {
            return this.deferredAttrContext.inferenceContext;
        }

        @Override
        public DeferredAttr.DeferredAttrContext deferredAttrContext() {
            return this.deferredAttrContext;
        }

        public String toString() {
            return "MethodCheckContext";
        }
    }

    abstract class AbstractMethodCheck
    implements MethodCheck {
        private SharedInapplicableMethodException methodCheckFailure;

        AbstractMethodCheck() {
        }

        @Override
        public void argumentsAcceptable(Env<AttrContext> env, DeferredAttr.DeferredAttrContext deferredAttrContext, List<Type> argtypes, List<Type> formals, Warner warn) {
            Type varargsFormal;
            boolean useVarargs = deferredAttrContext.phase.isVarargsRequired();
            JCTree callTree = this.treeForDiagnostics(env);
            List<JCTree.JCExpression> trees = TreeInfo.args(callTree);
            InferenceContext inferenceContext = deferredAttrContext.inferenceContext;
            Type type = varargsFormal = useVarargs ? formals.last() : null;
            if (varargsFormal == null && argtypes.size() != formals.size()) {
                this.reportMC(callTree, MethodCheckDiag.ARITY_MISMATCH, inferenceContext, new Object[0]);
            }
            while (argtypes.nonEmpty() && formals.head != varargsFormal) {
                JCDiagnostic.DiagnosticPosition pos = trees != null ? (JCDiagnostic.DiagnosticPosition)trees.head : null;
                this.checkArg(pos, false, (Type)argtypes.head, (Type)formals.head, deferredAttrContext, warn);
                argtypes = argtypes.tail;
                formals = formals.tail;
                trees = trees != null ? trees.tail : trees;
            }
            if (formals.head != varargsFormal) {
                this.reportMC(callTree, MethodCheckDiag.ARITY_MISMATCH, inferenceContext, new Object[0]);
            }
            if (useVarargs) {
                Type elt = Resolve.this.types.elemtype(varargsFormal);
                while (argtypes.nonEmpty()) {
                    JCDiagnostic.DiagnosticPosition pos = trees != null ? (JCDiagnostic.DiagnosticPosition)trees.head : null;
                    this.checkArg(pos, true, (Type)argtypes.head, elt, deferredAttrContext, warn);
                    argtypes = argtypes.tail;
                    trees = trees != null ? trees.tail : trees;
                }
            }
        }

        private JCTree treeForDiagnostics(Env<AttrContext> env) {
            return ((AttrContext)env.info).preferredTreeForDiagnostics != null ? ((AttrContext)env.info).preferredTreeForDiagnostics : env.tree;
        }

        abstract void checkArg(JCDiagnostic.DiagnosticPosition var1, boolean var2, Type var3, Type var4, DeferredAttr.DeferredAttrContext var5, Warner var6);

        protected void reportMC(JCDiagnostic.DiagnosticPosition pos, MethodCheckDiag diag, InferenceContext inferenceContext, Object ... args) {
            boolean inferDiag;
            boolean bl = inferDiag = inferenceContext != Resolve.this.infer.emptyContext;
            if (inferDiag && !diag.inferKey.equals(diag.basicKey)) {
                Object[] args2 = new Object[args.length + 1];
                System.arraycopy(args, 0, args2, 1, args.length);
                args2[0] = inferenceContext.inferenceVars();
                args = args2;
            }
            String key = inferDiag ? diag.inferKey : diag.basicKey;
            throw inferDiag ? Resolve.this.infer.error(Resolve.this.diags.create(JCDiagnostic.DiagnosticType.FRAGMENT, Resolve.this.log.currentSource(), pos, key, args)) : this.getMethodCheckFailure().setMessage(Resolve.this.diags.create(JCDiagnostic.DiagnosticType.FRAGMENT, Resolve.this.log.currentSource(), pos, key, args));
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> actuals) {
            return Resolve.this.nilMethodCheck;
        }

        private SharedInapplicableMethodException getMethodCheckFailure() {
            return this.methodCheckFailure == null ? (this.methodCheckFailure = new SharedInapplicableMethodException()) : this.methodCheckFailure;
        }

        class SharedInapplicableMethodException
        extends InapplicableMethodException {
            private static final long serialVersionUID = 0L;

            SharedInapplicableMethodException() {
                super(null, Resolve.this.dumpStacktraceOnError);
            }

            SharedInapplicableMethodException setMessage(JCDiagnostic details) {
                this.diagnostic = details;
                return this;
            }
        }
    }

    static enum MethodCheckDiag {
        ARITY_MISMATCH("arg.length.mismatch", "infer.arg.length.mismatch"),
        ARG_MISMATCH("no.conforming.assignment.exists", "infer.no.conforming.assignment.exists"),
        VARARG_MISMATCH("varargs.argument.mismatch", "infer.varargs.argument.mismatch"),
        INACCESSIBLE_VARARGS("inaccessible.varargs.type", "inaccessible.varargs.type");

        final String basicKey;
        final String inferKey;

        private MethodCheckDiag(String basicKey, String inferKey) {
            this.basicKey = basicKey;
            this.inferKey = inferKey;
        }

        String regex() {
            return String.format("([a-z]*\\.)*(%s|%s)", this.basicKey, this.inferKey);
        }
    }
}

