/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.UnsetFieldsInfo;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LocalProxyVarsGen
extends TreeTranslator {
    protected static final Context.Key<LocalProxyVarsGen> valueInitializersKey = new Context.Key();
    private final Types types;
    private final Names names;
    private final Symtab syms;
    private final Target target;
    private TreeMaker make;
    private final UnsetFieldsInfo unsetFieldsInfo;
    private Symbol.ClassSymbol currentClass = null;
    private java.util.List<JCTree.JCVariableDecl> instanceFields;
    private Map<JCTree.JCMethodDecl, Set<Symbol>> fieldsReadInPrologue = new HashMap<JCTree.JCMethodDecl, Set<Symbol>>();
    private final boolean noLocalProxyVars;

    public static LocalProxyVarsGen instance(Context context) {
        LocalProxyVarsGen instance = context.get(valueInitializersKey);
        if (instance == null) {
            instance = new LocalProxyVarsGen(context);
        }
        return instance;
    }

    protected LocalProxyVarsGen(Context context) {
        context.put(valueInitializersKey, this);
        this.make = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.target = Target.instance(context);
        this.unsetFieldsInfo = UnsetFieldsInfo.instance(context);
        Options options = Options.instance(context);
        this.noLocalProxyVars = options.isSet("noLocalProxyVars");
    }

    public void addFieldReadInPrologue(JCTree.JCMethodDecl constructor, Symbol sym) {
        Assert.checkNonNull(sym, "parameter 'sym' is null");
        Set fieldSet = this.fieldsReadInPrologue.getOrDefault(constructor, new HashSet());
        fieldSet.add(sym);
        this.fieldsReadInPrologue.put(constructor, fieldSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree translateTopLevelClass(JCTree cdef, TreeMaker make) {
        if (!this.noLocalProxyVars) {
            try {
                this.make = make;
                JCTree jCTree = this.translate(cdef);
                return jCTree;
            }
            finally {
                this.make = null;
            }
        }
        return cdef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        Symbol.ClassSymbol prevCurrentClass = this.currentClass;
        java.util.List<JCTree.JCVariableDecl> prevInstanceFields = this.instanceFields;
        try {
            this.currentClass = tree.sym;
            this.instanceFields = tree.defs.stream().filter(t -> t.hasTag(JCTree.Tag.VARDEF)).map(t -> (JCTree.JCVariableDecl)t).filter(vd -> !vd.sym.isStatic()).collect(List.collector());
            super.visitClassDef(tree);
        }
        finally {
            this.currentClass = prevCurrentClass;
            this.instanceFields = prevInstanceFields;
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        if (this.fieldsReadInPrologue.get(tree) != null) {
            Set<Symbol> fieldSet = this.fieldsReadInPrologue.get(tree);
            ArrayList<JCTree.JCVariableDecl> fieldsRead = new ArrayList<JCTree.JCVariableDecl>();
            for (JCTree.JCVariableDecl field : this.instanceFields) {
                if (!fieldSet.contains(field.sym)) continue;
                fieldsRead.add(field);
            }
            this.addLocalProxiesFor(tree, fieldsRead);
            this.fieldsReadInPrologue.remove(tree);
        }
        super.visitMethodDef(tree);
    }

    void addLocalProxiesFor(JCTree.JCMethodDecl constructor, java.util.List<JCTree.JCVariableDecl> fields) {
        ListBuffer<JCTree.JCVariableDecl> localDeclarations = new ListBuffer<JCTree.JCVariableDecl>();
        LinkedHashMap<Symbol, Symbol> fieldToLocalMap = new LinkedHashMap<Symbol, Symbol>();
        for (JCTree.JCVariableDecl fieldDecl : fields) {
            long flags = 4096L;
            Symbol.VarSymbol proxy = new Symbol.VarSymbol(flags, this.newLocalName(fieldDecl.name.toString()), fieldDecl.sym.erasure(this.types), constructor.sym);
            fieldToLocalMap.put(fieldDecl.sym, proxy);
            Object initializer = fieldDecl.init;
            if (initializer == null && !fieldDecl.sym.isFinal() && !fieldDecl.sym.isStrict()) {
                initializer = fieldDecl.vartype.type.isPrimitive() ? this.make.at(constructor.pos).Literal(0) : this.make.at(constructor.pos).Literal(TypeTag.BOT, null).setType(this.syms.botType);
            }
            JCTree.JCVariableDecl localDecl = this.make.at(constructor.pos).VarDef(proxy, (JCTree.JCExpression)initializer);
            localDecl.vartype = fieldDecl.vartype;
            localDeclarations = localDeclarations.append(localDecl);
        }
        FieldRewriter fieldRewriter = new FieldRewriter(constructor, fieldToLocalMap);
        ListBuffer<JCTree.JCStatement> newBody = new ListBuffer<JCTree.JCStatement>();
        for (JCTree.JCStatement jCStatement : constructor.body.stats) {
            newBody = newBody.append(fieldRewriter.translate(jCStatement));
        }
        localDeclarations.addAll((Collection<JCTree.JCVariableDecl>)newBody);
        ListBuffer<JCTree.JCStatement> assigmentsBeforeSuper = new ListBuffer<JCTree.JCStatement>();
        for (Symbol vsym : fieldToLocalMap.keySet()) {
            Symbol local = (Symbol)fieldToLocalMap.get(vsym);
            assigmentsBeforeSuper.append(this.make.at(constructor.pos()).Assignment(vsym, this.make.at(constructor.pos()).Ident(local)));
        }
        constructor.body.stats = localDeclarations.toList();
        JCTree.JCMethodInvocation jCMethodInvocation = TreeInfo.findConstructorCall(constructor);
        if (jCMethodInvocation.args.isEmpty()) {
            TreeInfo.mapSuperCalls(constructor.body, supercall -> this.make.Block(0L, assigmentsBeforeSuper.toList().append((JCTree.JCExpressionStatement)supercall)));
        } else {
            int argPosition = 0;
            ListBuffer<JCTree.JCVariableDecl> superArgsProxies = new ListBuffer<JCTree.JCVariableDecl>();
            for (JCTree.JCExpression arg : jCMethodInvocation.args) {
                long flags = 4112L;
                Symbol.VarSymbol proxyForArgSym = new Symbol.VarSymbol(flags, this.newLocalName("" + argPosition), this.types.erasure(arg.type), constructor.sym);
                JCTree.JCVariableDecl proxyForArgDecl = this.make.at(constructor.pos).VarDef(proxyForArgSym, arg);
                superArgsProxies = superArgsProxies.append(proxyForArgDecl);
                ++argPosition;
            }
            List superArgsProxiesList = superArgsProxies.toList();
            ListBuffer<JCTree.JCExpression> newArgs = new ListBuffer<JCTree.JCExpression>();
            for (JCTree.JCStatement jCStatement : superArgsProxies) {
                newArgs.add(this.make.at(jCStatement.pos).Ident((JCTree.JCVariableDecl)jCStatement));
            }
            jCMethodInvocation.args = newArgs.toList();
            TreeInfo.mapSuperCalls(constructor.body, supercall -> this.make.Block(0L, superArgsProxiesList.appendList(assigmentsBeforeSuper.toList()).append((JCTree.JCExpressionStatement)supercall)));
        }
    }

    private Name newLocalName(String name) {
        return this.names.fromString("local" + this.target.syntheticNameChar() + name);
    }

    class FieldRewriter
    extends TreeTranslator {
        JCTree.JCMethodDecl md;
        Map<Symbol, Symbol> fieldToLocalMap;
        boolean ctorPrologue = true;

        public FieldRewriter(JCTree.JCMethodDecl md, Map<Symbol, Symbol> fieldToLocalMap) {
            this.md = md;
            this.fieldToLocalMap = fieldToLocalMap;
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            this.result = this.ctorPrologue && this.fieldToLocalMap.get(tree.sym) != null ? LocalProxyVarsGen.this.make.at(this.md).Ident(this.fieldToLocalMap.get(tree.sym)) : tree;
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            super.visitSelect(tree);
            this.result = this.ctorPrologue && this.fieldToLocalMap.get(tree.sym) != null ? LocalProxyVarsGen.this.make.at(this.md).Ident(this.fieldToLocalMap.get(tree.sym)) : tree;
        }

        @Override
        public void visitAssign(JCTree.JCAssign tree) {
            JCTree.JCExpression previousLHS = tree.lhs;
            super.visitAssign(tree);
            if (this.ctorPrologue && previousLHS != tree.lhs) {
                LocalProxyVarsGen.this.unsetFieldsInfo.removeUnsetFieldInfo(LocalProxyVarsGen.this.currentClass, tree);
            }
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            super.visitApply(tree);
            if (TreeInfo.isConstructorCall(tree)) {
                this.ctorPrologue = false;
            }
        }
    }
}

