/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class ArgumentAttr
extends JCTree.Visitor {
    protected static final Context.Key<ArgumentAttr> methodAttrKey = new Context.Key();
    private final DeferredAttr deferredAttr;
    private final JCDiagnostic.Factory diags;
    private final Attr attr;
    private final Symtab syms;
    private final Log log;
    private Env<AttrContext> env;
    Type result;
    Map<UniquePos, ArgumentType<?>> argumentTypeCache = new LinkedHashMap();

    public static ArgumentAttr instance(Context context) {
        ArgumentAttr instance = context.get(methodAttrKey);
        if (instance == null) {
            instance = new ArgumentAttr(context);
        }
        return instance;
    }

    protected ArgumentAttr(Context context) {
        context.put(methodAttrKey, this);
        this.deferredAttr = DeferredAttr.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.attr = Attr.instance(context);
        this.syms = Symtab.instance(context);
        this.log = Log.instance(context);
    }

    void setResult(JCTree.JCExpression tree, Type type) {
        this.result = type;
        if (((AttrContext)this.env.info).attributionMode == DeferredAttr.AttributionMode.SPECULATIVE) {
            tree.type = this.result;
        }
    }

    Type checkSpeculative(JCTree expr, Attr.ResultInfo resultInfo) {
        return this.checkSpeculative(expr, expr.type, resultInfo);
    }

    Type checkSpeculative(JCDiagnostic.DiagnosticPosition pos, Type t, Attr.ResultInfo resultInfo) {
        if (t.hasTag(TypeTag.DEFERRED)) {
            return ((DeferredAttr.DeferredType)t).check(resultInfo);
        }
        return resultInfo.check(pos, t);
    }

    LocalCacheContext withLocalCacheContext() {
        return new LocalCacheContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type attribArg(JCTree tree, Env<AttrContext> env) {
        Env<AttrContext> prevEnv = this.env;
        try {
            this.env = env;
            tree.accept(this);
            Type type = this.result;
            return type;
        }
        finally {
            this.env = prevEnv;
        }
    }

    @Override
    public void visitTree(JCTree that) {
        that.accept(this.attr);
        this.result = this.attr.result;
    }

    <T extends JCTree.JCExpression, Z extends ArgumentType<T>> void processArg(T that, Function<T, Z> argumentTypeFactory) {
        final UniquePos pos = new UniquePos(that);
        this.processArg(that, () -> {
            Attr attr = this.attr;
            Objects.requireNonNull(attr);
            JCTree.JCExpression speculativeTree = (JCTree.JCExpression)this.deferredAttr.attribSpeculative(that, this.env, new Attr.MethodAttrInfo(attr){

                @Override
                protected boolean needsArgumentAttr(JCTree tree) {
                    return !new UniquePos(tree).equals(pos);
                }
            });
            return (ArgumentType)argumentTypeFactory.apply(speculativeTree);
        });
    }

    <T extends JCTree.JCExpression, Z extends ArgumentType<T>> void processArg(T that, Supplier<Z> argumentTypeFactory) {
        UniquePos pos = new UniquePos(that);
        ArgumentType<?> cached = this.argumentTypeCache.get(pos);
        if (cached != null) {
            this.setResult(that, cached.dup(that, this.env));
        } else {
            ArgumentType res = (ArgumentType)argumentTypeFactory.get();
            this.argumentTypeCache.put(pos, res);
            this.setResult(that, res);
        }
    }

    @Override
    public void visitParens(JCTree.JCParens that) {
        this.processArg(that, (T speculativeTree) -> new ParensType(that, this.env, (JCTree.JCParens)speculativeTree));
    }

    @Override
    public void visitConditional(JCTree.JCConditional that) {
        this.processArg(that, (T speculativeTree) -> new ConditionalType(that, this.env, (JCTree.JCConditional)speculativeTree));
    }

    @Override
    public void visitSwitchExpression(JCTree.JCSwitchExpression that) {
        this.processArg(that, (T speculativeTree) -> new SwitchExpressionType(that, this.env, (JCTree.JCSwitchExpression)speculativeTree));
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        Env<AttrContext> localEnv = this.env.dup(tree);
        JCTree.JCExpression exprTree = (JCTree.JCExpression)this.deferredAttr.attribSpeculative(tree.getQualifierExpression(), localEnv, this.attr.memberReferenceQualifierResult(tree), this.withLocalCacheContext());
        JCTree.JCMemberReference mref2 = new TreeCopier(this.attr.make).copy(tree);
        mref2.expr = exprTree;
        Symbol lhsSym = TreeInfo.symbol(exprTree);
        ((AttrContext)localEnv.info).selectSuper = lhsSym != null && lhsSym.name == lhsSym.name.table.names._super;
        Symbol res = this.attr.rs.getMemberReference(tree, localEnv, mref2, exprTree.type, tree.name);
        if (!res.kind.isResolutionError()) {
            tree.sym = res;
        }
        if (res.kind.isResolutionTargetError()) {
            tree.setOverloadKind(JCTree.JCMemberReference.OverloadKind.ERROR);
        } else if (res.type != null && res.type.hasTag(TypeTag.FORALL) || (res.flags() & 0x400000000L) != 0L || TreeInfo.isStaticSelector(exprTree, tree.name.table.names) && exprTree.type.isRaw() && !exprTree.type.hasTag(TypeTag.ARRAY)) {
            tree.setOverloadKind(JCTree.JCMemberReference.OverloadKind.OVERLOADED);
        } else {
            tree.setOverloadKind(JCTree.JCMemberReference.OverloadKind.UNOVERLOADED);
        }
        DeferredAttr deferredAttr = this.deferredAttr;
        Objects.requireNonNull(deferredAttr);
        this.setResult(tree, new DeferredAttr.DeferredType(deferredAttr, tree, this.env));
    }

    @Override
    public void visitLambda(JCTree.JCLambda that) {
        if (that.paramKind == JCTree.JCLambda.ParameterKind.EXPLICIT) {
            this.processArg(that, () -> {
                JCTree.JCLambda speculativeLambda = this.deferredAttr.attribSpeculativeLambda(that, this.env, this.attr.methodAttrInfo);
                return new ExplicitLambdaType(that, this.env, speculativeLambda);
            });
        } else {
            DeferredAttr deferredAttr = this.deferredAttr;
            Objects.requireNonNull(deferredAttr);
            this.setResult(that, new DeferredAttr.DeferredType(deferredAttr, that, this.env));
        }
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation that) {
        if (((List)that.getTypeArguments()).isEmpty()) {
            this.processArg(that, (T speculativeTree) -> new ResolvedMethodType(that, this.env, (JCTree.JCMethodInvocation)speculativeTree));
        } else {
            this.setResult(that, this.attr.attribTree(that, this.env, this.attr.unknownExprInfo));
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass that) {
        if (TreeInfo.isDiamond(that)) {
            this.processArg(that, (T speculativeTree) -> new ResolvedConstructorType(that, this.env, (JCTree.JCNewClass)speculativeTree));
        } else {
            this.setResult(that, this.attr.attribTree(that, this.env, this.attr.unknownExprInfo));
        }
    }

    class LocalCacheContext {
        Map<UniquePos, ArgumentType<?>> prevCache;

        public LocalCacheContext() {
            this.prevCache = ArgumentAttr.this.argumentTypeCache;
            ArgumentAttr.this.argumentTypeCache = new HashMap();
        }

        public void leave() {
            ArgumentAttr.this.argumentTypeCache = this.prevCache;
        }
    }

    class UniquePos {
        int pos;
        DiagnosticSource source;

        UniquePos(JCTree tree) {
            this.pos = tree.pos;
            this.source = ArgumentAttr.this.log.currentSource();
        }

        public int hashCode() {
            return this.pos << 16 + this.source.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof UniquePos)) return false;
            UniquePos uniquePos = (UniquePos)obj;
            if (this.pos != uniquePos.pos) return false;
            if (this.source != uniquePos.source) return false;
            return true;
        }

        public String toString() {
            return this.source.getFile().getName() + " @ " + this.source.getLineNumber(this.pos);
        }
    }

    static abstract class ArgumentType<T extends JCTree.JCExpression>
    extends DeferredAttr.DeferredType {
        T speculativeTree;
        Map<Attr.ResultInfo, Type> speculativeTypes;
        final /* synthetic */ ArgumentAttr this$0;

        public ArgumentType(JCTree.JCExpression tree, Env<AttrContext> env, T speculativeTree, Map<Attr.ResultInfo, Type> speculativeTypes) {
            this.this$0 = this$0;
            DeferredAttr deferredAttr = this$0.deferredAttr;
            Objects.requireNonNull(deferredAttr);
            super(deferredAttr, tree, env);
            this.speculativeTree = speculativeTree;
            this.speculativeTypes = speculativeTypes;
        }

        @Override
        public final Type complete(Attr.ResultInfo resultInfo, DeferredAttr.DeferredAttrContext deferredAttrContext) {
            if (deferredAttrContext.mode == DeferredAttr.AttrMode.SPECULATIVE) {
                Type t = resultInfo.pt == Type.recoveryType ? super.complete(resultInfo, deferredAttrContext) : this.overloadCheck(resultInfo, deferredAttrContext);
                this.speculativeTypes.put(resultInfo, t);
                return t;
            }
            if (!((AttrContext)this.env.info).attributionMode.isSpeculative) {
                this.this$0.argumentTypeCache.remove(this.this$0.new UniquePos(this.tree));
            }
            return super.complete(resultInfo, deferredAttrContext);
        }

        @Override
        Type speculativeType(Symbol msym, Resolve.MethodResolutionPhase phase) {
            if (this.notPertinentToApplicability.contains(msym)) {
                return super.speculativeType(msym, phase);
            }
            for (Map.Entry<Attr.ResultInfo, Type> _entry : this.speculativeTypes.entrySet()) {
                DeferredAttr.DeferredAttrContext deferredAttrContext = _entry.getKey().checkContext.deferredAttrContext();
                if (deferredAttrContext.phase != phase || deferredAttrContext.msym != msym) continue;
                return _entry.getValue();
            }
            return Type.noType;
        }

        @Override
        JCTree speculativeTree(DeferredAttr.DeferredAttrContext deferredAttrContext) {
            return this.notPertinentToApplicability.contains(deferredAttrContext.msym) ? super.speculativeTree(deferredAttrContext) : this.speculativeTree;
        }

        abstract Type overloadCheck(Attr.ResultInfo var1, DeferredAttr.DeferredAttrContext var2);

        abstract ArgumentType<T> dup(T var1, Env<AttrContext> var2);
    }

    class ResolvedConstructorType
    extends ResolvedMemberType<JCTree.JCNewClass> {
        public ResolvedConstructorType(JCTree.JCExpression tree, Env<AttrContext> env, JCTree.JCNewClass speculativeTree) {
            this(tree, env, speculativeTree, new HashMap<Attr.ResultInfo, Type>());
        }

        public ResolvedConstructorType(JCTree.JCExpression tree, Env<AttrContext> env, JCTree.JCNewClass speculativeTree, Map<Attr.ResultInfo, Type> speculativeTypes) {
            super(ArgumentAttr.this, tree, env, (JCTree.JCExpression)speculativeTree, speculativeTypes);
        }

        @Override
        Attr.ResultInfo resultInfo(Attr.ResultInfo resultInfo) {
            return resultInfo.dup(ArgumentAttr.this.attr.diamondContext((JCTree.JCNewClass)this.speculativeTree, ((JCTree.JCNewClass)this.speculativeTree).clazz.type.tsym, resultInfo.checkContext));
        }

        @Override
        Type methodType() {
            return ((JCTree.JCNewClass)this.speculativeTree).constructorType != null ? ((JCTree.JCNewClass)this.speculativeTree).constructorType.baseType() : ArgumentAttr.this.syms.errType;
        }

        @Override
        ArgumentType<JCTree.JCNewClass> dup(JCTree.JCNewClass tree, Env<AttrContext> env) {
            return new ResolvedConstructorType(tree, env, (JCTree.JCNewClass)this.speculativeTree, this.speculativeTypes);
        }
    }

    class ResolvedMethodType
    extends ResolvedMemberType<JCTree.JCMethodInvocation> {
        public ResolvedMethodType(JCTree.JCExpression tree, Env<AttrContext> env, JCTree.JCMethodInvocation speculativeTree) {
            this(tree, env, speculativeTree, new HashMap<Attr.ResultInfo, Type>());
        }

        public ResolvedMethodType(JCTree.JCExpression tree, Env<AttrContext> env, JCTree.JCMethodInvocation speculativeTree, Map<Attr.ResultInfo, Type> speculativeTypes) {
            super(ArgumentAttr.this, tree, env, (JCTree.JCExpression)speculativeTree, speculativeTypes);
        }

        @Override
        Attr.ResultInfo resultInfo(Attr.ResultInfo resultInfo) {
            return resultInfo;
        }

        @Override
        Type methodType() {
            return ((JCTree.JCMethodInvocation)this.speculativeTree).meth.type;
        }

        @Override
        ArgumentType<JCTree.JCMethodInvocation> dup(JCTree.JCMethodInvocation tree, Env<AttrContext> env) {
            return new ResolvedMethodType(tree, env, (JCTree.JCMethodInvocation)this.speculativeTree, this.speculativeTypes);
        }
    }

    class ExplicitLambdaType
    extends ArgumentType<JCTree.JCLambda> {
        Optional<List<Type>> argtypes;
        Optional<List<JCTree.JCReturn>> returnExpressions;

        ExplicitLambdaType(JCTree.JCLambda originalLambda, Env<AttrContext> env, JCTree.JCLambda speculativeLambda) {
            this(originalLambda, env, speculativeLambda, new HashMap<Attr.ResultInfo, Type>());
        }

        ExplicitLambdaType(JCTree.JCLambda originalLambda, Env<AttrContext> env, JCTree.JCLambda speculativeLambda, Map<Attr.ResultInfo, Type> speculativeTypes) {
            super(ArgumentAttr.this, (JCTree.JCExpression)originalLambda, env, (JCTree.JCExpression)speculativeLambda, speculativeTypes);
            this.argtypes = Optional.empty();
            this.returnExpressions = Optional.empty();
        }

        List<Type> argtypes() {
            return this.argtypes.orElseGet(() -> {
                List<Type> res = TreeInfo.types(((JCTree.JCLambda)this.speculativeTree).params);
                this.argtypes = Optional.of(res);
                return res;
            });
        }

        List<JCTree.JCReturn> returnExpressions() {
            return this.returnExpressions.orElseGet(() -> {
                final ListBuffer buf = new ListBuffer();
                new DeferredAttr.LambdaReturnScanner(){

                    @Override
                    public void visitReturn(JCTree.JCReturn tree) {
                        buf.add(tree);
                    }
                }.scan(((JCTree.JCLambda)this.speculativeTree).body);
                List res = buf.toList();
                this.returnExpressions = Optional.of(res);
                return res;
            });
        }

        @Override
        Type overloadCheck(Attr.ResultInfo resultInfo, DeferredAttr.DeferredAttrContext deferredAttrContext) {
            try {
                Attr.TargetInfo targetInfo = ArgumentAttr.this.attr.getTargetInfo((JCTree.JCPolyExpression)this.speculativeTree, resultInfo, this.argtypes());
                Type lambdaType = targetInfo.descriptor;
                Type currentTarget = targetInfo.target;
                this.checkLambdaCompatible(lambdaType, resultInfo);
                return currentTarget;
            }
            catch (Types.FunctionDescriptorLookupError ex) {
                resultInfo.checkContext.report(null, ex.getDiagnostic());
                return null;
            }
        }

        private void checkLambdaCompatible(Type descriptor, Attr.ResultInfo resultInfo) {
            Check.CheckContext checkContext = resultInfo.checkContext;
            Attr.ResultInfo bodyResultInfo = ArgumentAttr.this.attr.lambdaBodyResult((JCTree.JCLambda)this.speculativeTree, descriptor, resultInfo);
            switch (((JCTree.JCLambda)this.speculativeTree).getBodyKind()) {
                case EXPRESSION: {
                    ArgumentAttr.this.checkSpeculative(((JCTree.JCLambda)this.speculativeTree).body, ((JCTree.JCLambda)this.speculativeTree).body.type, bodyResultInfo);
                    break;
                }
                case STATEMENT: {
                    for (JCTree.JCReturn ret : this.returnExpressions()) {
                        this.checkReturnInStatementLambda(ret, bodyResultInfo);
                    }
                    break;
                }
            }
            ArgumentAttr.this.attr.checkLambdaCompatible((JCTree.JCLambda)this.speculativeTree, descriptor, checkContext);
        }

        void checkReturnInStatementLambda(JCTree.JCReturn ret, Attr.ResultInfo resultInfo) {
            if (resultInfo.pt.hasTag(TypeTag.VOID) && ret.expr != null) {
                resultInfo.checkContext.report(((JCTree.JCLambda)this.speculativeTree).pos(), ArgumentAttr.this.diags.fragment("unexpected.ret.val", new Object[0]));
            } else if (!resultInfo.pt.hasTag(TypeTag.VOID)) {
                if (ret.expr == null) {
                    resultInfo.checkContext.report(((JCTree.JCLambda)this.speculativeTree).pos(), ArgumentAttr.this.diags.fragment("missing.ret.val", new Object[0]));
                }
                ArgumentAttr.this.checkSpeculative(ret.expr, ret.expr.type, resultInfo);
            }
        }

        Type getReturnType(JCTree.JCReturn ret) {
            if (ret.expr == null) {
                return ArgumentAttr.this.syms.voidType;
            }
            return ret.expr.type;
        }

        @Override
        ArgumentType<JCTree.JCLambda> dup(JCTree.JCLambda tree, Env<AttrContext> env) {
            return new ExplicitLambdaType(tree, env, (JCTree.JCLambda)this.speculativeTree, this.speculativeTypes);
        }
    }

    class SwitchExpressionType
    extends ArgumentType<JCTree.JCSwitchExpression> {
        Optional<List<JCTree.JCYield>> yieldExpressions;

        SwitchExpressionType(JCTree.JCExpression tree, Env<AttrContext> env, JCTree.JCSwitchExpression speculativeCond) {
            this(tree, env, speculativeCond, new HashMap<Attr.ResultInfo, Type>());
        }

        SwitchExpressionType(JCTree.JCExpression tree, Env<AttrContext> env, JCTree.JCSwitchExpression speculativeCond, Map<Attr.ResultInfo, Type> speculativeTypes) {
            super(ArgumentAttr.this, tree, env, (JCTree.JCExpression)speculativeCond, speculativeTypes);
            this.yieldExpressions = Optional.empty();
        }

        @Override
        Type overloadCheck(Attr.ResultInfo resultInfo, DeferredAttr.DeferredAttrContext deferredAttrContext) {
            Attr.ResultInfo localInfo = resultInfo.dup(ArgumentAttr.this.attr.conditionalContext(resultInfo.checkContext));
            if (resultInfo.pt.hasTag(TypeTag.VOID)) {
                resultInfo.checkContext.report(this.tree, ArgumentAttr.this.attr.diags.fragment(CompilerProperties.Fragments.SwitchExpressionTargetCantBeVoid));
                return ArgumentAttr.this.attr.types.createErrorType(resultInfo.pt);
            }
            for (JCTree.JCYield brk : this.yieldExpressions()) {
                ArgumentAttr.this.checkSpeculative(brk.value, brk.value.type, resultInfo);
            }
            return localInfo.pt;
        }

        List<JCTree.JCYield> yieldExpressions() {
            return this.yieldExpressions.orElseGet(() -> {
                final ListBuffer buf = new ListBuffer();
                new DeferredAttr.SwitchExpressionScanner(){

                    @Override
                    public void visitYield(JCTree.JCYield tree) {
                        if (tree.target == SwitchExpressionType.this.speculativeTree) {
                            buf.add(tree);
                        }
                        super.visitYield(tree);
                    }
                }.scan(((JCTree.JCSwitchExpression)this.speculativeTree).cases);
                List res = buf.toList();
                this.yieldExpressions = Optional.of(res);
                return res;
            });
        }

        @Override
        ArgumentType<JCTree.JCSwitchExpression> dup(JCTree.JCSwitchExpression tree, Env<AttrContext> env) {
            return new SwitchExpressionType(tree, env, (JCTree.JCSwitchExpression)this.speculativeTree, this.speculativeTypes);
        }
    }

    class ConditionalType
    extends ArgumentType<JCTree.JCConditional> {
        ConditionalType(JCTree.JCExpression tree, Env<AttrContext> env, JCTree.JCConditional speculativeCond) {
            this(tree, env, speculativeCond, new HashMap<Attr.ResultInfo, Type>());
        }

        ConditionalType(JCTree.JCExpression tree, Env<AttrContext> env, JCTree.JCConditional speculativeCond, Map<Attr.ResultInfo, Type> speculativeTypes) {
            super(ArgumentAttr.this, tree, env, (JCTree.JCExpression)speculativeCond, speculativeTypes);
        }

        @Override
        Type overloadCheck(Attr.ResultInfo resultInfo, DeferredAttr.DeferredAttrContext deferredAttrContext) {
            Attr.ResultInfo localInfo = resultInfo.dup(ArgumentAttr.this.attr.conditionalContext(resultInfo.checkContext));
            if (((JCTree.JCConditional)this.speculativeTree).isStandalone()) {
                return localInfo.check(this.speculativeTree, ((JCTree.JCConditional)this.speculativeTree).type);
            }
            if (resultInfo.pt.hasTag(TypeTag.VOID)) {
                resultInfo.checkContext.report(this.tree, ArgumentAttr.this.attr.diags.fragment(CompilerProperties.Fragments.ConditionalTargetCantBeVoid));
                return ArgumentAttr.this.attr.types.createErrorType(resultInfo.pt);
            }
            ArgumentAttr.this.checkSpeculative(((JCTree.JCConditional)this.speculativeTree).truepart, localInfo);
            ArgumentAttr.this.checkSpeculative(((JCTree.JCConditional)this.speculativeTree).falsepart, localInfo);
            return localInfo.pt;
        }

        @Override
        ArgumentType<JCTree.JCConditional> dup(JCTree.JCConditional tree, Env<AttrContext> env) {
            return new ConditionalType(tree, env, (JCTree.JCConditional)this.speculativeTree, this.speculativeTypes);
        }
    }

    class ParensType
    extends ArgumentType<JCTree.JCParens> {
        ParensType(JCTree.JCExpression tree, Env<AttrContext> env, JCTree.JCParens speculativeParens) {
            this(tree, env, speculativeParens, new HashMap<Attr.ResultInfo, Type>());
        }

        ParensType(JCTree.JCExpression tree, Env<AttrContext> env, JCTree.JCParens speculativeParens, Map<Attr.ResultInfo, Type> speculativeTypes) {
            super(ArgumentAttr.this, tree, env, (JCTree.JCExpression)speculativeParens, speculativeTypes);
        }

        @Override
        Type overloadCheck(Attr.ResultInfo resultInfo, DeferredAttr.DeferredAttrContext deferredAttrContext) {
            return ArgumentAttr.this.checkSpeculative(((JCTree.JCParens)this.speculativeTree).expr, resultInfo);
        }

        @Override
        ArgumentType<JCTree.JCParens> dup(JCTree.JCParens tree, Env<AttrContext> env) {
            return new ParensType(tree, env, (JCTree.JCParens)this.speculativeTree, this.speculativeTypes);
        }
    }

    static abstract class ResolvedMemberType<E extends JCTree.JCExpression>
    extends ArgumentType<E> {
        final /* synthetic */ ArgumentAttr this$0;

        public ResolvedMemberType(JCTree.JCExpression tree, Env<AttrContext> env, E speculativeMethod, Map<Attr.ResultInfo, Type> speculativeTypes) {
            this.this$0 = this$0;
            super((ArgumentAttr)this$0, tree, env, speculativeMethod, speculativeTypes);
        }

        @Override
        Type overloadCheck(Attr.ResultInfo resultInfo, DeferredAttr.DeferredAttrContext deferredAttrContext) {
            Type mtype = this.methodType();
            Attr.ResultInfo localInfo = this.resultInfo(resultInfo);
            Type t = mtype != null && mtype.hasTag(TypeTag.METHOD) && mtype.isPartial() ? ((Infer.PartiallyInferredMethodType)mtype).check(localInfo) : localInfo.check(this.tree.pos(), this.speculativeTree.type);
            this.speculativeTypes.put(localInfo, t);
            return t;
        }

        abstract Attr.ResultInfo resultInfo(Attr.ResultInfo var1);

        abstract Type methodType();
    }
}

