/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.ArgumentAttr;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;

public class Analyzer {
    protected static final Context.Key<Analyzer> analyzerKey = new Context.Key();
    final Types types;
    final Log log;
    final Attr attr;
    final DeferredAttr deferredAttr;
    final ArgumentAttr argumentAttr;
    final TreeMaker make;
    final AnalyzerCopier copier;
    private final boolean allowDiamondWithAnonymousClassCreation;
    final EnumSet<AnalyzerMode> analyzerModes;
    StatementAnalyzer<JCTree, JCTree>[] analyzers = new StatementAnalyzer[]{new DiamondInitializer(), new LambdaAnalyzer(), new RedundantTypeArgAnalyzer(), new RedundantLocalVarTypeAnalyzer(), new RedundantLocalVarTypeAnalyzerForEach()};
    DeferredAnalysisHelper flushDeferredHelper = new DeferredAnalysisHelper(){

        @Override
        public void queue(RewritingContext rewriting) {
        }

        @Override
        public void flush(Env<AttrContext> flushEnv) {
        }
    };
    DeferredAnalysisHelper queueDeferredHelper;
    DeferredAnalysisHelper deferredAnalysisHelper = this.queueDeferredHelper = new DeferredAnalysisHelper(){
        Map<Symbol.ClassSymbol, Queue<RewritingContext>> Q = new HashMap<Symbol.ClassSymbol, Queue<RewritingContext>>();

        @Override
        public void queue(RewritingContext rewriting) {
            Queue s = this.Q.computeIfAbsent(rewriting.env.enclClass.sym.outermostClass(), k -> new ArrayDeque());
            s.add(rewriting);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush(Env<AttrContext> flushEnv) {
            if (!this.Q.isEmpty()) {
                DeferredAnalysisHelper prevHelper = Analyzer.this.deferredAnalysisHelper;
                try {
                    Analyzer.this.deferredAnalysisHelper = Analyzer.this.flushDeferredHelper;
                    Queue<RewritingContext> rewritings = this.Q.get(flushEnv.enclClass.sym.outermostClass());
                    while (rewritings != null && !rewritings.isEmpty()) {
                        Analyzer.this.doAnalysis(rewritings.remove());
                    }
                }
                finally {
                    Analyzer.this.deferredAnalysisHelper = prevHelper;
                }
            }
        }
    };

    public static Analyzer instance(Context context) {
        Analyzer instance = context.get(analyzerKey);
        if (instance == null) {
            instance = new Analyzer(context);
        }
        return instance;
    }

    protected Analyzer(Context context) {
        context.put(analyzerKey, this);
        this.types = Types.instance(context);
        this.log = Log.instance(context);
        this.attr = Attr.instance(context);
        this.deferredAttr = DeferredAttr.instance(context);
        this.argumentAttr = ArgumentAttr.instance(context);
        this.make = TreeMaker.instance(context);
        this.copier = new AnalyzerCopier();
        Options options = Options.instance(context);
        String findOpt = options.get("find");
        Source source = Source.instance(context);
        this.allowDiamondWithAnonymousClassCreation = Source.Feature.DIAMOND_WITH_ANONYMOUS_CLASS_CREATION.allowedInSource(source);
        this.analyzerModes = AnalyzerMode.getAnalyzerModes(findOpt, source);
    }

    Env<AttrContext> copyEnvIfNeeded(JCTree tree, Env<AttrContext> env) {
        if (!this.analyzerModes.isEmpty() && !((AttrContext)env.info).attributionMode.isSpeculative && TreeInfo.isStatement(tree) && !tree.hasTag(JCTree.Tag.LABELLED)) {
            Attr.ResultInfo resultInfo;
            Env<AttrContext> analyzeEnv = env.dup(env.tree, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dupUnshared(((AttrContext)env.info).scope.owner)));
            AttrContext attrContext = (AttrContext)analyzeEnv.info;
            if (((AttrContext)analyzeEnv.info).returnResult != null) {
                Attr attr = this.attr;
                Objects.requireNonNull(attr);
                resultInfo = new Attr.ResultInfo(attr, ((AttrContext)analyzeEnv.info).returnResult.pkind, ((AttrContext)analyzeEnv.info).returnResult.pt);
            } else {
                resultInfo = null;
            }
            attrContext.returnResult = resultInfo;
            return analyzeEnv;
        }
        return null;
    }

    void analyzeIfNeeded(JCTree tree, Env<AttrContext> env) {
        if (env != null) {
            JCTree.JCStatement stmt = (JCTree.JCStatement)tree;
            this.analyze(stmt, env);
        }
    }

    protected void analyze(JCTree.JCStatement statement, Env<AttrContext> env) {
        StatementScanner statementScanner = new StatementScanner(statement, env);
        statementScanner.scan();
        if (!statementScanner.rewritings.isEmpty()) {
            for (RewritingContext rewriting : statementScanner.rewritings) {
                this.deferredAnalysisHelper.queue(rewriting);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doAnalysis(RewritingContext rewriting) {
        DiagnosticSource prevSource = this.log.currentSource();
        ArgumentAttr.LocalCacheContext localCacheContext = this.argumentAttr.withLocalCacheContext();
        try {
            this.log.useSource(rewriting.env.toplevel.getSourceFile());
            JCTree.JCStatement treeToAnalyze = (JCTree.JCStatement)rewriting.originalTree;
            JCTree wrappedTree = null;
            if (((AttrContext)rewriting.env.info).scope.owner.kind == Kinds.Kind.TYP) {
                treeToAnalyze = this.make.at(-1).Block(4096L, List.of((JCTree.JCStatement)rewriting.originalTree));
                wrappedTree = rewriting.originalTree;
            }
            this.deferredAttr.attribSpeculative(treeToAnalyze, rewriting.env, this.attr.statInfo, new TreeRewriter(rewriting, wrappedTree), () -> rewriting.diagHandler(), DeferredAttr.AttributionMode.ANALYZER, this.argumentAttr.withLocalCacheContext());
            rewriting.analyzer.process(rewriting.oldTree, rewriting.replacement, rewriting.erroneous);
        }
        catch (Throwable ex) {
            Assert.error("Analyzer error when processing: " + String.valueOf(rewriting.originalTree) + ":" + ex.toString() + "\n" + Arrays.stream(ex.getStackTrace()).map(se -> se.toString()).collect(Collectors.joining("\n")));
        }
        finally {
            this.log.useSource(prevSource.getFile());
            localCacheContext.leave();
        }
    }

    public void flush(Env<AttrContext> flushEnv) {
        this.deferredAnalysisHelper.flush(flushEnv);
    }

    abstract class StatementAnalyzer<S extends JCTree, T extends JCTree> {
        AnalyzerMode mode;
        JCTree.Tag tag;

        StatementAnalyzer(AnalyzerMode mode, JCTree.Tag tag) {
            this.mode = mode;
            this.tag = tag;
        }

        boolean isEnabled() {
            return Analyzer.this.analyzerModes.contains((Object)this.mode);
        }

        abstract boolean match(S var1);

        abstract List<T> rewrite(S var1);

        abstract void process(S var1, T var2, boolean var3);
    }

    class DiamondInitializer
    extends StatementAnalyzer<JCTree.JCNewClass, JCTree.JCNewClass> {
        DiamondInitializer() {
            super(AnalyzerMode.DIAMOND, JCTree.Tag.NEWCLASS);
        }

        @Override
        boolean match(JCTree.JCNewClass tree) {
            return tree.clazz.hasTag(JCTree.Tag.TYPEAPPLY) && !TreeInfo.isDiamond(tree) && (tree.def == null || Analyzer.this.allowDiamondWithAnonymousClassCreation);
        }

        @Override
        List<JCTree.JCNewClass> rewrite(JCTree.JCNewClass oldTree) {
            if (oldTree.clazz.hasTag(JCTree.Tag.TYPEAPPLY) && !oldTree.type.isErroneous()) {
                JCTree.JCNewClass nc = Analyzer.this.copier.copy(oldTree);
                ((JCTree.JCTypeApply)nc.clazz).arguments = List.nil();
                return List.of(nc);
            }
            return List.of(oldTree);
        }

        @Override
        void process(JCTree.JCNewClass oldTree, JCTree.JCNewClass newTree, boolean hasErrors) {
            if (!hasErrors) {
                List<Type> explicitArgs;
                List<Type> inferredArgs;
                if (oldTree.def != null) {
                    inferredArgs = newTree.def.implementing.nonEmpty() ? newTree.def.implementing.get((int)0).type.getTypeArguments() : newTree.def.extending.type.getTypeArguments();
                    explicitArgs = oldTree.def.implementing.nonEmpty() ? oldTree.def.implementing.get((int)0).type.getTypeArguments() : oldTree.def.extending.type.getTypeArguments();
                } else {
                    inferredArgs = newTree.type.getTypeArguments();
                    explicitArgs = oldTree.type.getTypeArguments();
                }
                for (Type t : inferredArgs) {
                    if (!Analyzer.this.types.isSameType(t, (Type)explicitArgs.head)) {
                        return;
                    }
                    explicitArgs = explicitArgs.tail;
                }
                Analyzer.this.log.warning(oldTree.clazz, CompilerProperties.Warnings.DiamondRedundantArgs);
            }
        }
    }

    class LambdaAnalyzer
    extends StatementAnalyzer<JCTree.JCNewClass, JCTree.JCLambda> {
        LambdaAnalyzer() {
            super(AnalyzerMode.LAMBDA, JCTree.Tag.NEWCLASS);
        }

        @Override
        boolean match(JCTree.JCNewClass tree) {
            Type clazztype = tree.clazz.type;
            return tree.def != null && clazztype.hasTag(TypeTag.CLASS) && Analyzer.this.types.isFunctionalInterface(clazztype.tsym) && this.decls(tree.def).length() == 1;
        }

        private List<JCTree> decls(JCTree.JCClassDecl decl) {
            ListBuffer<JCTree> decls = new ListBuffer<JCTree>();
            for (JCTree t : decl.defs) {
                if (t.hasTag(JCTree.Tag.METHODDEF)) {
                    JCTree.JCMethodDecl md = (JCTree.JCMethodDecl)t;
                    if ((md.getModifiers().flags & 0x1000000000L) != 0L) continue;
                    decls.add(md);
                    continue;
                }
                decls.add(t);
            }
            return decls.toList();
        }

        @Override
        List<JCTree.JCLambda> rewrite(JCTree.JCNewClass oldTree) {
            JCTree.JCMethodDecl md = (JCTree.JCMethodDecl)Analyzer.this.copier.copy((JCTree)this.decls((JCTree.JCClassDecl)oldTree.def).head);
            List<JCTree.JCVariableDecl> params = md.params;
            JCTree.JCBlock body = md.body;
            JCTree.JCLambda newTree = Analyzer.this.make.at(oldTree).Lambda(params, body);
            return List.of(newTree);
        }

        @Override
        void process(JCTree.JCNewClass oldTree, JCTree.JCLambda newTree, boolean hasErrors) {
            if (!hasErrors) {
                Analyzer.this.log.warning(oldTree.def, CompilerProperties.Warnings.PotentialLambdaFound);
            }
        }
    }

    class RedundantTypeArgAnalyzer
    extends StatementAnalyzer<JCTree.JCMethodInvocation, JCTree.JCMethodInvocation> {
        RedundantTypeArgAnalyzer() {
            super(AnalyzerMode.METHOD, JCTree.Tag.APPLY);
        }

        @Override
        boolean match(JCTree.JCMethodInvocation tree) {
            return tree.typeargs != null && tree.typeargs.nonEmpty();
        }

        @Override
        List<JCTree.JCMethodInvocation> rewrite(JCTree.JCMethodInvocation oldTree) {
            JCTree.JCMethodInvocation app = Analyzer.this.copier.copy(oldTree);
            app.typeargs = List.nil();
            return List.of(app);
        }

        @Override
        void process(JCTree.JCMethodInvocation oldTree, JCTree.JCMethodInvocation newTree, boolean hasErrors) {
            if (!hasErrors) {
                Analyzer.this.log.warning(oldTree, CompilerProperties.Warnings.MethodRedundantTypeargs);
            }
        }
    }

    class RedundantLocalVarTypeAnalyzer
    extends RedundantLocalVarTypeAnalyzerBase<JCTree.JCVariableDecl> {
        RedundantLocalVarTypeAnalyzer() {
            super(JCTree.Tag.VARDEF);
        }

        @Override
        boolean match(JCTree.JCVariableDecl tree) {
            return tree.sym.owner.kind == Kinds.Kind.MTH && tree.init != null && !tree.declaredUsingVar() && Analyzer.this.attr.canInferLocalVarType(tree) == null;
        }

        @Override
        List<JCTree.JCVariableDecl> rewrite(JCTree.JCVariableDecl oldTree) {
            return List.of(this.rewriteVarType(oldTree));
        }

        @Override
        void process(JCTree.JCVariableDecl oldTree, JCTree.JCVariableDecl newTree, boolean hasErrors) {
            this.processVar(oldTree, newTree, hasErrors);
        }
    }

    class RedundantLocalVarTypeAnalyzerForEach
    extends RedundantLocalVarTypeAnalyzerBase<JCTree.JCEnhancedForLoop> {
        RedundantLocalVarTypeAnalyzerForEach() {
            super(JCTree.Tag.FOREACHLOOP);
        }

        @Override
        boolean match(JCTree.JCEnhancedForLoop tree) {
            return !tree.var.declaredUsingVar();
        }

        @Override
        List<JCTree.JCEnhancedForLoop> rewrite(JCTree.JCEnhancedForLoop oldTree) {
            JCTree.JCEnhancedForLoop newTree = Analyzer.this.copier.copy(oldTree);
            newTree.var = this.rewriteVarType(oldTree.var);
            newTree.body = Analyzer.this.make.at(oldTree.body).Block(0L, List.nil());
            return List.of(newTree);
        }

        @Override
        void process(JCTree.JCEnhancedForLoop oldTree, JCTree.JCEnhancedForLoop newTree, boolean hasErrors) {
            this.processVar(oldTree.var, newTree.var, hasErrors);
        }
    }

    static interface DeferredAnalysisHelper {
        public void queue(RewritingContext var1);

        public void flush(Env<AttrContext> var1);
    }

    class AnalyzerCopier
    extends TreeCopier<Void> {
        public AnalyzerCopier() {
            super(Analyzer.this.make);
        }

        @Override
        public JCTree visitLambdaExpression(LambdaExpressionTree node, Void _unused) {
            JCTree.JCLambda oldLambda = (JCTree.JCLambda)node;
            JCTree.JCLambda newLambda = (JCTree.JCLambda)super.visitLambdaExpression(node, _unused);
            if (oldLambda.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT) {
                newLambda.paramKind = JCTree.JCLambda.ParameterKind.IMPLICIT;
                newLambda.params.forEach(p -> {
                    p.vartype = null;
                });
            }
            return newLambda;
        }

        @Override
        public JCTree visitNewClass(NewClassTree node, Void aVoid) {
            JCTree.JCNewClass oldNewClazz = (JCTree.JCNewClass)node;
            JCTree.JCNewClass newNewClazz = (JCTree.JCNewClass)super.visitNewClass(node, aVoid);
            if (!oldNewClazz.args.isEmpty() && ((JCTree.JCExpression)oldNewClazz.args.head).hasTag(JCTree.Tag.NULLCHK)) {
                newNewClazz.encl = ((JCTree.JCUnary)newNewClazz.args.head).arg;
                newNewClazz.args = newNewClazz.args.tail;
            }
            return newNewClazz;
        }
    }

    static enum AnalyzerMode {
        DIAMOND("diamond"),
        LAMBDA("lambda"),
        METHOD("method"),
        LOCAL("local", Source.Feature.LOCAL_VARIABLE_TYPE_INFERENCE);

        final String opt;
        final Source.Feature feature;

        private AnalyzerMode(String opt) {
            this(opt, null);
        }

        private AnalyzerMode(String opt, Source.Feature feature) {
            this.opt = opt;
            this.feature = feature;
        }

        static EnumSet<AnalyzerMode> getAnalyzerModes(String opt, Source source) {
            if (opt == null) {
                return EnumSet.noneOf(AnalyzerMode.class);
            }
            List<String> modes = List.from(opt.split(","));
            EnumSet<AnalyzerMode> res = EnumSet.noneOf(AnalyzerMode.class);
            if (modes.contains("all")) {
                res = EnumSet.allOf(AnalyzerMode.class);
            }
            for (AnalyzerMode mode : AnalyzerMode.values()) {
                if (modes.contains("-" + mode.opt) || mode.feature != null && !mode.feature.allowedInSource(source)) {
                    res.remove((Object)mode);
                    continue;
                }
                if (!modes.contains(mode.opt)) continue;
                res.add(mode);
            }
            return res;
        }
    }

    class StatementScanner
    extends TreeScanner {
        ListBuffer<RewritingContext> rewritings = new ListBuffer();
        JCTree originalTree;
        Env<AttrContext> env;

        StatementScanner(JCTree originalTree, Env<AttrContext> env) {
            this.originalTree = originalTree;
            this.env = Analyzer.this.attr.copyEnv(env);
        }

        public void scan() {
            this.scan(this.originalTree);
        }

        @Override
        public void scan(JCTree tree) {
            if (tree != null) {
                for (StatementAnalyzer<JCTree, JCTree> analyzer : Analyzer.this.analyzers) {
                    if (!analyzer.isEnabled() || !tree.hasTag(analyzer.tag) || !analyzer.match(tree)) continue;
                    for (JCTree t : analyzer.rewrite(tree)) {
                        this.rewritings.add(new RewritingContext(this.originalTree, tree, t, analyzer, this.env));
                    }
                    break;
                }
            }
            super.scan(tree);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch tree) {
            this.scan(tree.getExpression());
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop tree) {
            this.scan(tree.getCondition());
            this.scan((List<? extends JCTree>)tree.getUpdate());
        }

        @Override
        public void visitTry(JCTree.JCTry tree) {
            this.scan(tree.getBlock());
            this.scan((List<? extends JCTree>)tree.getCatches());
            this.scan(tree.getFinallyBlock());
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
            this.scan(tree.getExpression());
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop tree) {
            this.scan(tree.getCondition());
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
            this.scan(tree.getCondition());
        }

        @Override
        public void visitIf(JCTree.JCIf tree) {
            this.scan(tree.getCondition());
        }
    }

    class RewritingContext {
        JCTree originalTree;
        JCTree oldTree;
        JCTree replacement;
        boolean erroneous;
        Env<AttrContext> env;
        StatementAnalyzer<JCTree, JCTree> analyzer;

        RewritingContext(JCTree originalTree, JCTree oldTree, JCTree replacement, StatementAnalyzer<JCTree, JCTree> analyzer, Env<AttrContext> env) {
            this.originalTree = originalTree;
            this.oldTree = oldTree;
            this.replacement = replacement;
            this.analyzer = analyzer;
            this.env = Analyzer.this.attr.copyEnv(env);
            if (originalTree.hasTag(JCTree.Tag.VARDEF)) {
                ((AttrContext)this.env.info).scope.remove(((JCTree.JCVariableDecl)originalTree).sym);
            }
        }

        Log.DeferredDiagnosticHandler diagHandler() {
            Log log = Analyzer.this.log;
            Objects.requireNonNull(log);
            return new Log.DeferredDiagnosticHandler(log, d -> {
                if (d.getType() == JCDiagnostic.DiagnosticType.ERROR) {
                    this.erroneous = true;
                }
                return true;
            }, false);
        }
    }

    class TreeRewriter
    extends AnalyzerCopier {
        RewritingContext rewriting;
        JCTree wrappedTree;

        TreeRewriter(RewritingContext rewriting, JCTree wrappedTree) {
            this.rewriting = rewriting;
            this.wrappedTree = wrappedTree;
        }

        @Override
        public <Z extends JCTree> Z copy(Z tree, Void _unused) {
            Object newTree = super.copy(tree, null);
            if (tree != null && tree == this.rewriting.oldTree) {
                Assert.checkNonNull(this.rewriting.replacement);
                newTree = this.rewriting.replacement;
            }
            return newTree;
        }

        @Override
        public JCTree visitVariable(VariableTree node, Void p) {
            Object result = super.visitVariable(node, p);
            if (node == this.wrappedTree) {
                ((JCTree.JCVariableDecl)result).mods.flags &= 0x10L;
            }
            return result;
        }
    }

    abstract class RedundantLocalVarTypeAnalyzerBase<X extends JCTree.JCStatement>
    extends StatementAnalyzer<X, X> {
        RedundantLocalVarTypeAnalyzerBase(JCTree.Tag tag) {
            super(AnalyzerMode.LOCAL, tag);
        }

        JCTree.JCVariableDecl rewriteVarType(JCTree.JCVariableDecl oldTree) {
            JCTree.JCVariableDecl newTree = Analyzer.this.copier.copy(oldTree);
            newTree.vartype = null;
            return newTree;
        }

        void processVar(JCTree.JCVariableDecl oldTree, JCTree.JCVariableDecl newTree, boolean hasErrors) {
            if (!hasErrors && Analyzer.this.types.isSameType(oldTree.type, newTree.type)) {
                Analyzer.this.log.warning(oldTree, CompilerProperties.Warnings.LocalRedundantType);
            }
        }
    }
}

