/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.SourceVersion;

public enum Source {
    JDK1_2("1.2"),
    JDK1_3("1.3"),
    JDK1_4("1.4"),
    JDK5("5"),
    JDK6("6"),
    JDK7("7"),
    JDK8("8"),
    JDK9("9"),
    JDK10("10"),
    JDK11("11"),
    JDK12("12"),
    JDK13("13"),
    JDK14("14"),
    JDK15("15"),
    JDK16("16"),
    JDK17("17"),
    JDK18("18"),
    JDK19("19"),
    JDK20("20"),
    JDK21("21"),
    JDK22("22"),
    JDK23("23"),
    JDK24("24"),
    JDK25("25"),
    JDK26("26");

    private static final Context.Key<Source> sourceKey;
    public final String name;
    private static final Map<String, Source> tab;
    public static final Source MIN;
    private static final Source MAX;
    public static final Source DEFAULT;

    public static Source instance(Context context) {
        Source instance = context.get(sourceKey);
        if (instance == null) {
            Options options = Options.instance(context);
            String sourceString = options.get(Option.SOURCE);
            if (sourceString != null) {
                instance = Source.lookup(sourceString);
            }
            if (instance == null) {
                instance = DEFAULT;
            }
            context.put(sourceKey, instance);
        }
        return instance;
    }

    private Source(String name) {
        this.name = name;
    }

    public static Source lookup(String name) {
        return tab.get(name);
    }

    public boolean isSupported() {
        return this.compareTo(MIN) >= 0;
    }

    public static boolean isSupported(Feature feature, int majorVersion) {
        Source source = null;
        for (Target target : Target.values()) {
            if (majorVersion != target.majorVersion) continue;
            source = Source.lookup(target.name);
        }
        if (source != null) {
            return feature.allowedInSource(source);
        }
        return false;
    }

    public Target requiredTarget() {
        return switch (this.ordinal()) {
            case 24 -> Target.JDK1_26;
            case 23 -> Target.JDK1_25;
            case 22 -> Target.JDK1_24;
            case 21 -> Target.JDK1_23;
            case 20 -> Target.JDK1_22;
            case 19 -> Target.JDK1_21;
            case 18 -> Target.JDK1_20;
            case 17 -> Target.JDK1_19;
            case 16 -> Target.JDK1_18;
            case 15 -> Target.JDK1_17;
            case 14 -> Target.JDK1_16;
            case 13 -> Target.JDK1_15;
            case 12 -> Target.JDK1_14;
            case 11 -> Target.JDK1_13;
            case 10 -> Target.JDK1_12;
            case 9 -> Target.JDK1_11;
            case 8 -> Target.JDK1_10;
            case 7 -> Target.JDK1_9;
            case 6 -> Target.JDK1_8;
            case 5 -> Target.JDK1_7;
            case 4 -> Target.JDK1_6;
            case 3 -> Target.JDK1_5;
            case 2 -> Target.JDK1_4;
            default -> Target.JDK1_1;
        };
    }

    public static SourceVersion toSourceVersion(Source source) {
        return switch (source.ordinal()) {
            case 0 -> SourceVersion.RELEASE_2;
            case 1 -> SourceVersion.RELEASE_3;
            case 2 -> SourceVersion.RELEASE_4;
            case 3 -> SourceVersion.RELEASE_5;
            case 4 -> SourceVersion.RELEASE_6;
            case 5 -> SourceVersion.RELEASE_7;
            case 6 -> SourceVersion.RELEASE_8;
            case 7 -> SourceVersion.RELEASE_9;
            case 8 -> SourceVersion.RELEASE_10;
            case 9 -> SourceVersion.RELEASE_11;
            case 10 -> SourceVersion.RELEASE_12;
            case 11 -> SourceVersion.RELEASE_13;
            case 12 -> SourceVersion.RELEASE_14;
            case 13 -> SourceVersion.RELEASE_15;
            case 14 -> SourceVersion.RELEASE_16;
            case 15 -> SourceVersion.RELEASE_17;
            case 16 -> SourceVersion.RELEASE_18;
            case 17 -> SourceVersion.RELEASE_19;
            case 18 -> SourceVersion.RELEASE_20;
            case 19 -> SourceVersion.RELEASE_21;
            case 20 -> SourceVersion.RELEASE_22;
            case 21 -> SourceVersion.RELEASE_23;
            case 22 -> SourceVersion.RELEASE_24;
            case 23 -> SourceVersion.RELEASE_25;
            case 24 -> SourceVersion.RELEASE_26;
            default -> null;
        };
    }

    static {
        sourceKey = new Context.Key();
        tab = new HashMap<String, Source>();
        for (Source s : Source.values()) {
            tab.put(s.name, s);
        }
        tab.put("1.5", JDK5);
        tab.put("1.6", JDK6);
        tab.put("1.7", JDK7);
        tab.put("1.8", JDK8);
        tab.put("1.9", JDK9);
        tab.put("1.10", JDK10);
        MIN = JDK8;
        DEFAULT = MAX = Source.values()[Source.values().length - 1];
    }

    public static enum Feature {
        MODULES(JDK9, CompilerProperties.Fragments.FeatureModules, DiagKind.PLURAL),
        EFFECTIVELY_FINAL_VARIABLES_IN_TRY_WITH_RESOURCES(JDK9, CompilerProperties.Fragments.FeatureVarInTryWithResources, DiagKind.PLURAL),
        DEPRECATION_ON_IMPORT(MIN, JDK8),
        PRIVATE_SAFE_VARARGS(JDK9),
        DIAMOND_WITH_ANONYMOUS_CLASS_CREATION(JDK9, CompilerProperties.Fragments.FeatureDiamondAndAnonClass, DiagKind.NORMAL),
        UNDERSCORE_IDENTIFIER(MIN, JDK8),
        PRIVATE_INTERFACE_METHODS(JDK9, CompilerProperties.Fragments.FeaturePrivateIntfMethods, DiagKind.PLURAL),
        LOCAL_VARIABLE_TYPE_INFERENCE(JDK10),
        VAR_SYNTAX_IMPLICIT_LAMBDAS(JDK11, CompilerProperties.Fragments.FeatureVarSyntaxInImplicitLambda, DiagKind.PLURAL),
        IMPORT_ON_DEMAND_OBSERVABLE_PACKAGES(JDK1_2, JDK8),
        SWITCH_MULTIPLE_CASE_LABELS(JDK14, CompilerProperties.Fragments.FeatureMultipleCaseLabels, DiagKind.PLURAL),
        SWITCH_RULE(JDK14, CompilerProperties.Fragments.FeatureSwitchRules, DiagKind.PLURAL),
        SWITCH_EXPRESSION(JDK14, CompilerProperties.Fragments.FeatureSwitchExpressions, DiagKind.PLURAL),
        NO_TARGET_ANNOTATION_APPLICABILITY(JDK14),
        TEXT_BLOCKS(JDK15, CompilerProperties.Fragments.FeatureTextBlocks, DiagKind.PLURAL),
        PATTERN_MATCHING_IN_INSTANCEOF(JDK16, CompilerProperties.Fragments.FeaturePatternMatchingInstanceof, DiagKind.NORMAL),
        REIFIABLE_TYPES_INSTANCEOF(JDK16, CompilerProperties.Fragments.FeatureReifiableTypesInstanceof, DiagKind.PLURAL),
        RECORDS(JDK16, CompilerProperties.Fragments.FeatureRecords, DiagKind.PLURAL),
        SEALED_CLASSES(JDK17, CompilerProperties.Fragments.FeatureSealedClasses, DiagKind.PLURAL),
        CASE_NULL(JDK21, CompilerProperties.Fragments.FeatureCaseNull, DiagKind.NORMAL),
        PATTERN_SWITCH(JDK21, CompilerProperties.Fragments.FeaturePatternSwitch, DiagKind.PLURAL),
        REDUNDANT_STRICTFP(JDK17),
        UNCONDITIONAL_PATTERN_IN_INSTANCEOF(JDK21, CompilerProperties.Fragments.FeatureUnconditionalPatternsInInstanceof, DiagKind.PLURAL),
        RECORD_PATTERNS(JDK21, CompilerProperties.Fragments.FeatureDeconstructionPatterns, DiagKind.PLURAL),
        IMPLICIT_CLASSES(JDK25, CompilerProperties.Fragments.FeatureImplicitClasses, DiagKind.PLURAL),
        WARN_ON_ILLEGAL_UTF8(MIN, JDK21),
        UNNAMED_VARIABLES(JDK22, CompilerProperties.Fragments.FeatureUnnamedVariables, DiagKind.PLURAL),
        PRIMITIVE_PATTERNS(JDK23, CompilerProperties.Fragments.FeaturePrimitivePatterns, DiagKind.PLURAL),
        VALUE_CLASSES(JDK22, CompilerProperties.Fragments.FeatureValueClasses, DiagKind.PLURAL),
        FLEXIBLE_CONSTRUCTORS(JDK25, CompilerProperties.Fragments.FeatureFlexibleConstructors, DiagKind.NORMAL),
        MODULE_IMPORTS(JDK25, CompilerProperties.Fragments.FeatureModuleImports, DiagKind.PLURAL),
        JAVA_BASE_TRANSITIVE(JDK25, CompilerProperties.Fragments.FeatureJavaBaseTransitive, DiagKind.PLURAL),
        PRIVATE_MEMBERS_IN_PERMITS_CLAUSE(JDK19),
        ERASE_POLY_SIG_RETURN_TYPE(JDK24);

        private final Source minLevel;
        private final Source maxLevel;
        private final JCDiagnostic.Fragment optFragment;
        private final DiagKind optKind;

        private Feature(Source minLevel) {
            this(minLevel, null, null);
        }

        private Feature(Source minLevel, JCDiagnostic.Fragment optFragment, DiagKind optKind) {
            this(minLevel, MAX, optFragment, optKind);
        }

        private Feature(Source minLevel, Source maxLevel) {
            this(minLevel, maxLevel, null, null);
        }

        private Feature(Source minLevel, Source maxLevel, JCDiagnostic.Fragment optFragment, DiagKind optKind) {
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
            this.optFragment = optFragment;
            this.optKind = optKind;
        }

        public boolean allowedInSource(Source source) {
            return source.compareTo(this.minLevel) >= 0 && source.compareTo(this.maxLevel) <= 0;
        }

        public boolean isPlural() {
            Assert.checkNonNull(this.optKind);
            return this.optKind == DiagKind.PLURAL;
        }

        public JCDiagnostic.Fragment nameFragment() {
            Assert.checkNonNull(this.optFragment);
            return this.optFragment;
        }

        public JCDiagnostic.Fragment fragment(String sourceName) {
            Assert.checkNonNull(this.optFragment);
            return this.optKind == DiagKind.NORMAL ? CompilerProperties.Fragments.FeatureNotSupportedInSource(this.optFragment, sourceName, this.minLevel.name) : CompilerProperties.Fragments.FeatureNotSupportedInSourcePlural(this.optFragment, sourceName, this.minLevel.name);
        }

        public JCDiagnostic.Error error(String sourceName) {
            Assert.checkNonNull(this.optFragment);
            return this.optKind == DiagKind.NORMAL ? CompilerProperties.Errors.FeatureNotSupportedInSource(this.optFragment, sourceName, this.minLevel.name) : CompilerProperties.Errors.FeatureNotSupportedInSourcePlural(this.optFragment, sourceName, this.minLevel.name);
        }

        static enum DiagKind {
            NORMAL,
            PLURAL;

        }
    }
}

