/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.tools.JavaFileObject;

public class LintMapper {
    private static final Context.Key<LintMapper> CONTEXT_KEY = new Context.Key();
    private final Map<JavaFileObject, FileInfo> fileInfoMap = new HashMap<JavaFileObject, FileInfo>();
    private final Context context;
    private Lint rootLint;

    public static LintMapper instance(Context context) {
        LintMapper instance = context.get(CONTEXT_KEY);
        if (instance == null) {
            instance = new LintMapper(context);
        }
        return instance;
    }

    protected LintMapper(Context context) {
        context.put(CONTEXT_KEY, this);
        this.context = context;
    }

    private void initializeIfNeeded() {
        if (this.rootLint == null) {
            this.rootLint = Lint.instance(this.context);
        }
    }

    public boolean isKnown(JavaFileObject sourceFile) {
        return this.fileInfoMap.containsKey(sourceFile);
    }

    public Optional<Lint> lintAt(JavaFileObject sourceFile, JCDiagnostic.DiagnosticPosition pos) {
        this.initializeIfNeeded();
        return Optional.of(sourceFile).map(this.fileInfoMap::get).flatMap(fileInfo -> fileInfo.lintAt(pos));
    }

    public void calculateLints(JavaFileObject sourceFile, JCTree tree, EndPosTable endPositions) {
        Assert.check(this.rootLint != null);
        this.fileInfoMap.get(sourceFile).afterAttr(tree, endPositions);
    }

    public void clear() {
        this.fileInfoMap.clear();
    }

    public void startParsingFile(JavaFileObject sourceFile) {
        this.initializeIfNeeded();
        this.fileInfoMap.put(sourceFile, null);
    }

    public void finishParsingFile(JCTree.JCCompilationUnit tree) {
        Assert.check(this.rootLint != null);
        this.fileInfoMap.put(tree.sourcefile, new FileInfo(this.rootLint, tree));
    }

    private static class FileInfo {
        final LintRange rootRange;
        final List<Span> unmappedDecls = new ArrayList<Span>();

        FileInfo(Lint rootLint, JCTree.JCCompilationUnit tree) {
            this.rootRange = new LintRange(rootLint);
            tree.defs.stream().filter(this::isTopLevelDecl).map(decl -> new Span((JCTree)decl, tree.endPositions)).forEach(this.unmappedDecls::add);
        }

        void afterAttr(JCTree tree, EndPosTable endPositions) {
            Iterator<Span> i = this.unmappedDecls.iterator();
            while (i.hasNext()) {
                if (!i.next().contains(tree.pos())) continue;
                this.rootRange.populateSubtree(tree, endPositions);
                i.remove();
                return;
            }
            throw new AssertionError((Object)"top-level declaration not found");
        }

        Optional<Lint> lintAt(JCDiagnostic.DiagnosticPosition pos) {
            boolean mapped = this.unmappedDecls.stream().noneMatch(span -> span.contains(pos));
            return mapped ? Optional.of(this.rootRange.bestMatch((JCDiagnostic.DiagnosticPosition)pos).lint) : Optional.empty();
        }

        boolean isTopLevelDecl(JCTree tree) {
            return tree.getTag() == JCTree.Tag.MODULEDEF || tree.getTag() == JCTree.Tag.PACKAGEDEF || tree.getTag() == JCTree.Tag.CLASSDEF;
        }
    }

    private record LintRange(Span span, Lint lint, List<LintRange> children) {
        LintRange(Lint rootLint) {
            this(Span.MAXIMAL, rootLint, new ArrayList<LintRange>());
        }

        LintRange(JCTree tree, EndPosTable endPositions, Lint lint) {
            this(new Span(tree, endPositions), lint, new ArrayList<LintRange>());
        }

        LintRange bestMatch(JCDiagnostic.DiagnosticPosition pos) {
            return this.children.stream().map(child -> child.bestMatch(pos)).filter(Objects::nonNull).reduce((a, b) -> a.span.contains(b.span) ? b : a).orElseGet(() -> this.span.contains(pos) ? this : null);
        }

        void populateSubtree(JCTree tree, final EndPosTable endPositions) {
            new TreeScanner(){
                private LintRange currentNode;
                {
                    this.currentNode = this;
                }

                @Override
                public void visitModuleDef(JCTree.JCModuleDecl tree) {
                    this.scanDecl(tree, tree.sym, x$0 -> super.visitModuleDef((JCTree.JCModuleDecl)x$0));
                }

                @Override
                public void visitPackageDef(JCTree.JCPackageDecl tree) {
                    this.scanDecl(tree, tree.packge, x$0 -> super.visitPackageDef((JCTree.JCPackageDecl)x$0));
                }

                @Override
                public void visitClassDef(JCTree.JCClassDecl tree) {
                    this.scanDecl(tree, tree.sym, x$0 -> super.visitClassDef((JCTree.JCClassDecl)x$0));
                }

                @Override
                public void visitMethodDef(JCTree.JCMethodDecl tree) {
                    this.scanDecl(tree, tree.sym, x$0 -> super.visitMethodDef((JCTree.JCMethodDecl)x$0));
                }

                @Override
                public void visitVarDef(JCTree.JCVariableDecl tree) {
                    this.scanDecl(tree, tree.sym, x$0 -> super.visitVarDef((JCTree.JCVariableDecl)x$0));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private <T extends JCTree> void scanDecl(T tree, Symbol symbol, Consumer<? super T> recursor) {
                    if (symbol == null) {
                        recursor.accept(tree);
                        return;
                    }
                    Lint newLint = this.currentNode.lint.augment(symbol);
                    if (newLint == this.currentNode.lint) {
                        recursor.accept(tree);
                        return;
                    }
                    LintRange previousNode = this.currentNode;
                    this.currentNode = new LintRange(tree, endPositions, newLint);
                    previousNode.children.add(this.currentNode);
                    try {
                        recursor.accept(tree);
                    }
                    finally {
                        this.currentNode = previousNode;
                    }
                }
            }.scan(tree);
        }
    }

    private record Span(int startPos, int endPos) {
        static final Span MAXIMAL = new Span(Integer.MIN_VALUE, Integer.MAX_VALUE);

        Span(JCTree tree, EndPosTable endPositions) {
            this(TreeInfo.getStartPos(tree), TreeInfo.getEndPos(tree, endPositions));
        }

        boolean contains(JCDiagnostic.DiagnosticPosition pos) {
            int offset = pos.getLintPosition();
            return offset == this.startPos || offset > this.startPos && offset < this.endPos;
        }

        boolean contains(Span that) {
            return this.startPos <= that.startPos && this.endPos >= that.endPos;
        }
    }
}

