/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class Lint {
    protected static final Context.Key<Lint> lintKey = new Context.Key();
    private final Context context;
    private final Options options;
    private final Log log;
    private Symtab syms;
    private Names names;
    private EnumSet<LintCategory> values;
    private EnumSet<LintCategory> suppressedValues;
    private static final Map<String, LintCategory> map = new LinkedHashMap<String, LintCategory>(40);

    public static Lint instance(Context context) {
        Lint instance = context.get(lintKey);
        if (instance == null) {
            instance = new Lint(context);
        }
        return instance;
    }

    public Lint augment(Symbol sym) {
        EnumSet<LintCategory> suppressions = this.suppressionsFrom(sym);
        if (!suppressions.isEmpty()) {
            Lint lint = new Lint(this);
            lint.values.removeAll(suppressions);
            lint.suppressedValues.addAll(suppressions);
            return lint;
        }
        return this;
    }

    public Lint enable(LintCategory ... lc) {
        Lint l = new Lint(this);
        l.values.addAll(Arrays.asList(lc));
        l.suppressedValues.removeAll(Arrays.asList(lc));
        return l;
    }

    public Lint suppress(LintCategory ... lc) {
        Lint l = new Lint(this);
        l.values.removeAll(Arrays.asList(lc));
        l.suppressedValues.addAll(Arrays.asList(lc));
        return l;
    }

    protected Lint(Context context) {
        this.context = context;
        context.put(lintKey, this);
        this.options = Options.instance(context);
        this.log = Log.instance(context);
    }

    protected Lint(Lint other) {
        other.initializeRootIfNeeded();
        this.context = other.context;
        this.options = other.options;
        this.log = other.log;
        this.syms = other.syms;
        this.names = other.names;
        this.values = other.values.clone();
        this.suppressedValues = other.suppressedValues.clone();
    }

    private void initializeRootIfNeeded() {
        if (this.values != null) {
            return;
        }
        if (this.options.isSet(Option.XLINT) || this.options.isSet(Option.XLINT_CUSTOM, "all")) {
            this.values = EnumSet.allOf(LintCategory.class);
        } else if (this.options.isSet(Option.XLINT_CUSTOM, "none")) {
            this.values = LintCategory.newEmptySet();
        } else {
            this.values = LintCategory.newEmptySet();
            Source source = Source.instance(this.context);
            if (source.compareTo(Source.JDK9) >= 0) {
                this.values.add(LintCategory.DEP_ANN);
            }
            if (Source.Feature.REDUNDANT_STRICTFP.allowedInSource(source)) {
                this.values.add(LintCategory.STRICTFP);
            }
            this.values.add(LintCategory.REQUIRES_TRANSITIVE_AUTOMATIC);
            this.values.add(LintCategory.OPENS);
            this.values.add(LintCategory.MODULE);
            this.values.add(LintCategory.REMOVAL);
            if (!this.options.isSet(Option.PREVIEW)) {
                this.values.add(LintCategory.PREVIEW);
            }
            this.values.add(LintCategory.IDENTITY);
            this.values.add(LintCategory.INCUBATING);
        }
        for (LintCategory lc : LintCategory.values()) {
            if (this.options.isLintExplicitlyEnabled(lc)) {
                this.values.add(lc);
                continue;
            }
            if (!this.options.isLintExplicitlyDisabled(lc)) continue;
            this.values.remove((Object)lc);
        }
        this.suppressedValues = LintCategory.newEmptySet();
    }

    public String toString() {
        this.initializeRootIfNeeded();
        return "Lint:[enable" + String.valueOf(this.values) + ",suppress" + String.valueOf(this.suppressedValues) + "]";
    }

    public boolean isEnabled(LintCategory lc) {
        this.initializeRootIfNeeded();
        return this.values.contains((Object)lc);
    }

    public boolean isSuppressed(LintCategory lc) {
        this.initializeRootIfNeeded();
        return this.suppressedValues.contains((Object)lc);
    }

    public EnumSet<LintCategory> suppressionsFrom(Symbol symbol) {
        EnumSet<LintCategory> suppressions = this.suppressionsFrom(symbol.getDeclarationAttributes().stream());
        if (symbol.isDeprecated() && symbol.isDeprecatableViaAnnotation()) {
            suppressions.add(LintCategory.DEPRECATION);
        }
        return suppressions;
    }

    private EnumSet<LintCategory> suppressionsFrom(Stream<Attribute.Compound> attributes) {
        this.initializeSymbolsIfNeeded();
        EnumSet<LintCategory> result = LintCategory.newEmptySet();
        attributes.filter(attribute -> attribute.type.tsym == this.syms.suppressWarningsType.tsym).map(this::suppressionsFrom).forEach(result::addAll);
        return result;
    }

    private EnumSet<LintCategory> suppressionsFrom(Attribute.Compound suppressWarnings) {
        EnumSet<LintCategory> result = LintCategory.newEmptySet();
        Attribute[] attributeArray = suppressWarnings.member(this.names.value);
        if (attributeArray instanceof Attribute.Array) {
            Attribute.Array values = (Attribute.Array)attributeArray;
            for (Attribute value : values.values) {
                Optional.of(value).filter(val -> val instanceof Attribute.Constant).map(val -> (String)((Attribute.Constant)val).value).flatMap(LintCategory::get).filter(lc -> lc.annotationSuppression).ifPresent(result::add);
            }
        }
        return result;
    }

    private void initializeSymbolsIfNeeded() {
        if (this.syms == null) {
            this.syms = Symtab.instance(this.context);
            this.names = Names.instance(this.context);
        }
    }

    public static enum LintCategory {
        AUXILIARYCLASS("auxiliaryclass"),
        CAST("cast"),
        CLASSFILE("classfile", false, new String[0]),
        DANGLING_DOC_COMMENTS("dangling-doc-comments"),
        DEPRECATION("deprecation"),
        DEP_ANN("dep-ann"),
        DIVZERO("divzero"),
        EMPTY("empty"),
        EXPORTS("exports"),
        FALLTHROUGH("fallthrough"),
        FINALLY("finally"),
        IDENTITY("identity", true, "synchronization"),
        INCUBATING("incubating", false, new String[0]),
        INITIALIZATION("initialization"),
        LOSSY_CONVERSIONS("lossy-conversions"),
        MISSING_EXPLICIT_CTOR("missing-explicit-ctor"),
        MODULE("module"),
        MIGRATION("migration"),
        OPENS("opens"),
        OPTIONS("options", false, new String[0]),
        OUTPUT_FILE_CLASH("output-file-clash", false, new String[0]),
        OVERLOADS("overloads"),
        OVERRIDES("overrides"),
        PATH("path", false, new String[0]),
        PROCESSING("processing"),
        RAW("rawtypes"),
        REMOVAL("removal"),
        REQUIRES_AUTOMATIC("requires-automatic"),
        REQUIRES_TRANSITIVE_AUTOMATIC("requires-transitive-automatic"),
        SERIAL("serial"),
        STATIC("static"),
        STRICTFP("strictfp"),
        TEXT_BLOCKS("text-blocks"),
        THIS_ESCAPE("this-escape"),
        TRY("try"),
        UNCHECKED("unchecked"),
        VARARGS("varargs"),
        PREVIEW("preview"),
        RESTRICTED("restricted");

        public final String option;
        public final List<String> optionList;
        public final boolean annotationSuppression;

        private LintCategory(String option) {
            this(option, true, new String[0]);
        }

        private LintCategory(String option, boolean annotationSuppression, String ... aliases) {
            this.option = option;
            this.annotationSuppression = annotationSuppression;
            ArrayList<String> optionList = new ArrayList<String>(1 + aliases.length);
            optionList.add(option);
            Collections.addAll(optionList, aliases);
            this.optionList = Collections.unmodifiableList(optionList);
            this.optionList.forEach(ident -> map.put((String)ident, this));
        }

        public static Optional<LintCategory> get(String option) {
            return Optional.ofNullable(map.get(option));
        }

        public static Set<String> options() {
            return Collections.unmodifiableSet(map.keySet());
        }

        public static EnumSet<LintCategory> newEmptySet() {
            return EnumSet.noneOf(LintCategory.class);
        }
    }
}

