/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.DeferredCompletionFailureHandler;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.PropagatedException;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class JavacTaskImpl
extends BasicJavacTask {
    private final Arguments args;
    private JavaCompiler compiler;
    private JavaFileManager fileManager;
    private DeferredCompletionFailureHandler dcfh;
    private Locale locale;
    private Map<JavaFileObject, JCTree.JCCompilationUnit> notYetEntered;
    private ListBuffer<Env<AttrContext>> genList;
    private final AtomicBoolean used = new AtomicBoolean();
    private Iterable<? extends Processor> processors;
    private ListBuffer<String> addModules = new ListBuffer();
    private boolean parsed = false;

    protected JavacTaskImpl(Context context) {
        super(context, true);
        this.args = Arguments.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.dcfh = DeferredCompletionFailureHandler.instance(context);
        this.dcfh.setHandler(this.dcfh.userCodeHandler);
    }

    @Override
    public Boolean call() {
        return this.doCall().isOK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Main.Result doCall() {
        try {
            Pair<Main.Result, Throwable> result = this.invocationHelper(() -> {
                this.prepareCompiler(false);
                if (this.compiler.errorCount() > 0) {
                    return Main.Result.ERROR;
                }
                this.compiler.compile(this.args.getFileObjects(), this.args.getClassNames(), this.processors, this.addModules);
                return this.compiler.errorCount() > 0 ? Main.Result.ERROR : Main.Result.OK;
            });
            if (result.snd == null) {
                Main.Result result2 = (Main.Result)((Object)result.fst);
                return result2;
            }
            Main.Result result3 = result.snd instanceof FatalError ? Main.Result.SYSERR : Main.Result.ABNORMAL;
            return result3;
        }
        finally {
            try {
                this.cleanup();
            }
            catch (ClientCodeException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    @Override
    public void addModules(Iterable<String> moduleNames) {
        Objects.requireNonNull(moduleNames);
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        for (String m : moduleNames) {
            Objects.requireNonNull(m);
            this.addModules.add(m);
        }
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> processors) {
        Objects.requireNonNull(processors);
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.processors = processors;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Pair<T, Throwable> invocationHelper(Callable<T> c) {
        DeferredCompletionFailureHandler.Handler prevDeferredHandler = this.dcfh.setHandler(this.dcfh.javacCodeHandler);
        try {
            Pair<T, Object> pair = new Pair<T, Object>(c.call(), null);
            return pair;
        }
        catch (FatalError ex) {
            Log log = Log.instance(this.context);
            Options options = Options.instance(this.context);
            log.printRawLines(ex.getMessage());
            if (ex.getCause() != null && options.isSet("dev")) {
                ex.getCause().printStackTrace(log.getWriter(Log.WriterKind.NOTICE));
            }
            Pair<Object, FatalError> pair = new Pair<Object, FatalError>(null, ex);
            return pair;
        }
        catch (AnnotationProcessingError | ClientCodeException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (PropagatedException e) {
            throw e.getCause();
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Error | Exception ex) {
            if (this.compiler == null || this.compiler.errorCount() == 0 || Options.instance(this.context).isSet("dev")) {
                Log log = Log.instance(this.context);
                log.printLines(Log.PrefixKind.JAVAC, "msg.bug", JavaCompiler.version());
                ex.printStackTrace(log.getWriter(Log.WriterKind.NOTICE));
            }
            Pair<Object, Throwable> pair = new Pair<Object, Throwable>(null, ex);
            return pair;
        }
        finally {
            this.dcfh.setHandler(prevDeferredHandler);
        }
    }

    private void prepareCompiler(boolean forParse) {
        if (this.used.getAndSet(true)) {
            if (this.compiler == null) {
                throw new PropagatedException(new IllegalStateException());
            }
        } else {
            this.args.validate();
            this.context.put(Locale.class, this.locale);
            JavacMessages messages = this.context.get(JavacMessages.messagesKey);
            if (messages != null && !messages.getCurrentLocale().equals(this.locale)) {
                messages.setCurrentLocale(this.locale);
            }
            this.initPlugins(this.args.getPluginOpts());
            this.initDocLint(this.args.getDocLintOpts());
            this.compiler = JavaCompiler.instance(this.context);
            this.compiler.keepComments = true;
            this.compiler.genEndPos = true;
            this.notYetEntered = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();
            if (forParse) {
                this.compiler.initProcessAnnotations(this.processors, this.args.getFileObjects(), this.args.getClassNames());
                for (JavaFileObject file : this.args.getFileObjects()) {
                    this.notYetEntered.put(file, null);
                }
                this.genList = new ListBuffer();
            }
        }
    }

    <T> String toString(Iterable<T> items, String sep) {
        String currSep = "";
        StringBuilder sb = new StringBuilder();
        for (T item : items) {
            sb.append(currSep);
            sb.append(item.toString());
            currSep = sep;
        }
        return sb.toString();
    }

    void cleanup() {
        JavaFileManager javaFileManager;
        if (this.compiler != null) {
            this.compiler.close();
        }
        if ((javaFileManager = this.fileManager) instanceof BaseFileManager) {
            BaseFileManager baseFileManager = (BaseFileManager)javaFileManager;
            if (baseFileManager.autoClose) {
                try {
                    this.fileManager.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.compiler = null;
        this.context = null;
        this.notYetEntered = null;
    }

    @Override
    public Iterable<? extends CompilationUnitTree> parse() {
        Pair<Iterable, Throwable> result = this.invocationHelper(this::parseInternal);
        if (result.snd == null) {
            return (Iterable)result.fst;
        }
        throw new IllegalStateException((Throwable)result.snd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<? extends CompilationUnitTree> parseInternal() {
        try {
            this.prepareCompiler(true);
            List<JCTree.JCCompilationUnit> units = this.compiler.parseFiles(this.args.getFileObjects());
            for (JCTree.JCCompilationUnit unit : units) {
                JavaFileObject file = unit.getSourceFile();
                if (!this.notYetEntered.containsKey(file)) continue;
                this.notYetEntered.put(file, unit);
            }
            List<JCTree.JCCompilationUnit> list = units;
            return list;
        }
        finally {
            this.parsed = true;
            if (this.compiler != null && this.compiler.log != null) {
                this.compiler.log.flush();
            }
        }
    }

    public Iterable<? extends Element> enter() {
        return this.enter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends Element> enter(Iterable<? extends CompilationUnitTree> trees) {
        if (trees == null && this.notYetEntered != null && this.notYetEntered.isEmpty()) {
            return List.nil();
        }
        boolean wasInitialized = this.compiler != null;
        this.prepareCompiler(true);
        ListBuffer<JCTree.JCCompilationUnit> roots = null;
        if (trees == null) {
            if (this.notYetEntered.size() > 0) {
                if (!this.parsed) {
                    this.parseInternal();
                }
                for (JavaFileObject javaFileObject : this.args.getFileObjects()) {
                    JCTree.JCCompilationUnit unit = this.notYetEntered.remove(javaFileObject);
                    if (unit == null) continue;
                    if (roots == null) {
                        roots = new ListBuffer();
                    }
                    roots.append(unit);
                }
                this.notYetEntered.clear();
            }
        } else {
            for (CompilationUnitTree compilationUnitTree : trees) {
                if (compilationUnitTree instanceof JCTree.JCCompilationUnit) {
                    JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
                    if (roots == null) {
                        roots = new ListBuffer<JCTree.JCCompilationUnit>();
                    }
                    roots.append(compilationUnit);
                    this.notYetEntered.remove(compilationUnitTree.getSourceFile());
                    continue;
                }
                throw new IllegalArgumentException(compilationUnitTree.toString());
            }
        }
        if (roots == null) {
            if (trees == null && !wasInitialized) {
                this.compiler.initModules(List.nil());
            }
            return List.nil();
        }
        List<JCTree.JCCompilationUnit> units = this.compiler.initModules(roots.toList());
        try {
            units = this.compiler.enterTrees(units);
            if (this.notYetEntered.isEmpty()) {
                this.compiler.processAnnotations(units);
            }
            ListBuffer<Symbol.TypeSymbol> listBuffer = new ListBuffer<Symbol.TypeSymbol>();
            for (JCTree.JCCompilationUnit unit : units) {
                boolean isPkgInfo = unit.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
                if (isPkgInfo) {
                    listBuffer.append(unit.packge);
                    continue;
                }
                for (JCTree node : unit.defs) {
                    if (node.hasTag(JCTree.Tag.CLASSDEF)) {
                        JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)node;
                        if (cdef.sym == null) continue;
                        listBuffer.append(cdef.sym);
                        continue;
                    }
                    if (!node.hasTag(JCTree.Tag.MODULEDEF)) continue;
                    JCTree.JCModuleDecl mdef = (JCTree.JCModuleDecl)node;
                    if (mdef.sym == null) continue;
                    listBuffer.append(mdef.sym);
                }
            }
            List list = listBuffer.toList();
            return list;
        }
        finally {
            this.compiler.log.flush();
        }
    }

    @Override
    public Iterable<? extends Element> analyze() {
        Pair<Iterable, Throwable> result = this.invocationHelper(() -> this.analyze(null));
        if (result.snd == null) {
            return (Iterable)result.fst;
        }
        throw new IllegalStateException((Throwable)result.snd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends Element> analyze(Iterable<? extends Element> classes) {
        this.enter(null);
        final ListBuffer<Element> results = new ListBuffer<Element>();
        try {
            if (classes == null) {
                this.handleFlowResults(this.compiler.warn(this.compiler.flow(this.compiler.attribute(this.compiler.todo))), results);
            } else {
                Filter f = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.handleFlowResults(JavacTaskImpl.this.compiler.warn(JavacTaskImpl.this.compiler.flow(JavacTaskImpl.this.compiler.attribute(env))), results);
                    }
                };
                f.run(this.compiler.todo, classes);
            }
        }
        finally {
            this.compiler.log.reportOutstandingWarnings();
            this.compiler.log.flush();
        }
        return results;
    }

    private void handleFlowResults(Queue<Env<AttrContext>> queue, ListBuffer<Element> elems) {
        for (Env env : queue) {
            switch (env.tree.getTag()) {
                case CLASSDEF: {
                    JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)env.tree;
                    if (cdef.sym == null) break;
                    elems.append(cdef.sym);
                    break;
                }
                case MODULEDEF: {
                    JCTree.JCModuleDecl mod = (JCTree.JCModuleDecl)env.tree;
                    if (mod.sym == null) break;
                    elems.append(mod.sym);
                    break;
                }
                case PACKAGEDEF: {
                    JCTree.JCCompilationUnit unit = env.toplevel;
                    if (unit.packge == null) break;
                    elems.append(unit.packge);
                }
            }
        }
        this.genList.addAll((Collection<Env<AttrContext>>)queue);
    }

    @Override
    public Iterable<? extends JavaFileObject> generate() {
        Pair<Iterable, Throwable> result = this.invocationHelper(() -> this.generate(null));
        if (result.snd == null) {
            return (Iterable)result.fst;
        }
        throw new IllegalStateException((Throwable)result.snd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends JavaFileObject> generate(Iterable<? extends Element> classes) {
        final ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        try {
            this.analyze(null);
            if (classes == null) {
                this.compiler.generate(this.compiler.desugar(this.genList), results);
                this.genList.clear();
            } else {
                Filter f = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.compiler.generate(JavacTaskImpl.this.compiler.desugar(ListBuffer.of(env)), results);
                    }
                };
                f.run(this.genList, classes);
            }
            if (this.genList.isEmpty()) {
                this.compiler.reportDeferredDiagnostics();
                this.cleanup();
            }
        }
        finally {
            if (this.compiler != null) {
                this.compiler.log.reportOutstandingWarnings();
                this.compiler.log.flush();
            }
        }
        return results;
    }

    public void ensureEntered() {
        this.args.allowEmpty();
        this.enter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type parseType(String expr, TypeElement scope) {
        if (expr == null || expr.equals("")) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject prev = this.compiler.log.useSource(null);
        ParserFactory parserFactory = ParserFactory.instance(this.context);
        Attr attr = Attr.instance(this.context);
        try {
            CharBuffer buf = CharBuffer.wrap((expr + "\u0000").toCharArray(), 0, expr.length());
            JavacParser parser = parserFactory.newParser(buf, false, false, false);
            JCTree.JCExpression tree = parser.parseType();
            Type type = attr.attribType((JCTree)tree, (Symbol.TypeSymbol)((Object)scope));
            return type;
        }
        finally {
            this.compiler.log.useSource(prev);
        }
    }

    abstract class Filter {
        Filter() {
        }

        void run(Queue<Env<AttrContext>> list, Iterable<? extends Element> elements) {
            HashSet<Element> set = new HashSet<Element>();
            for (Element element : elements) {
                set.add(element);
            }
            ListBuffer<Env<AttrContext>> defer = new ListBuffer<Env<AttrContext>>();
            while (list.peek() != null) {
                Env<AttrContext> env = list.remove();
                Symbol.TypeSymbol test = null;
                if (env.tree.hasTag(JCTree.Tag.MODULEDEF)) {
                    test = ((JCTree.JCModuleDecl)env.tree).sym;
                } else if (env.tree.hasTag(JCTree.Tag.PACKAGEDEF)) {
                    test = env.toplevel.packge;
                } else {
                    Symbol.ClassSymbol csym = env.enclClass.sym;
                    if (csym != null) {
                        test = csym.outermostClass();
                    }
                }
                if (test != null && set.contains(test)) {
                    this.process(env);
                    continue;
                }
                defer = defer.append(env);
            }
            list.addAll(defer);
        }

        abstract void process(Env<AttrContext> var1);
    }
}

