/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class ElementFilter {
    private static final Set<ElementKind> CONSTRUCTOR_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.CONSTRUCTOR));
    private static final Set<ElementKind> FIELD_KINDS = Collections.unmodifiableSet(EnumSet.of(ElementKind.FIELD, ElementKind.ENUM_CONSTANT));
    private static final Set<ElementKind> METHOD_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.METHOD));
    private static final Set<ElementKind> PACKAGE_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.PACKAGE));
    private static final Set<ElementKind> MODULE_KIND = Collections.unmodifiableSet(EnumSet.of(ElementKind.MODULE));
    private static final Set<ElementKind> TYPE_KINDS = Collections.unmodifiableSet(EnumSet.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.RECORD, ElementKind.ANNOTATION_TYPE));
    private static final Set<ElementKind> RECORD_COMPONENT_KIND = Set.of(ElementKind.RECORD_COMPONENT);

    private ElementFilter() {
    }

    public static List<VariableElement> fieldsIn(Iterable<? extends Element> elements) {
        return ElementFilter.listFilter(elements, FIELD_KINDS, VariableElement.class);
    }

    public static Set<VariableElement> fieldsIn(Set<? extends Element> elements) {
        return ElementFilter.setFilter(elements, FIELD_KINDS, VariableElement.class);
    }

    public static List<RecordComponentElement> recordComponentsIn(Iterable<? extends Element> elements) {
        return ElementFilter.listFilter(elements, RECORD_COMPONENT_KIND, RecordComponentElement.class);
    }

    public static Set<RecordComponentElement> recordComponentsIn(Set<? extends Element> elements) {
        return ElementFilter.setFilter(elements, RECORD_COMPONENT_KIND, RecordComponentElement.class);
    }

    public static List<ExecutableElement> constructorsIn(Iterable<? extends Element> elements) {
        return ElementFilter.listFilter(elements, CONSTRUCTOR_KIND, ExecutableElement.class);
    }

    public static Set<ExecutableElement> constructorsIn(Set<? extends Element> elements) {
        return ElementFilter.setFilter(elements, CONSTRUCTOR_KIND, ExecutableElement.class);
    }

    public static List<ExecutableElement> methodsIn(Iterable<? extends Element> elements) {
        return ElementFilter.listFilter(elements, METHOD_KIND, ExecutableElement.class);
    }

    public static Set<ExecutableElement> methodsIn(Set<? extends Element> elements) {
        return ElementFilter.setFilter(elements, METHOD_KIND, ExecutableElement.class);
    }

    public static List<TypeElement> typesIn(Iterable<? extends Element> elements) {
        return ElementFilter.listFilter(elements, TYPE_KINDS, TypeElement.class);
    }

    public static Set<TypeElement> typesIn(Set<? extends Element> elements) {
        return ElementFilter.setFilter(elements, TYPE_KINDS, TypeElement.class);
    }

    public static List<PackageElement> packagesIn(Iterable<? extends Element> elements) {
        return ElementFilter.listFilter(elements, PACKAGE_KIND, PackageElement.class);
    }

    public static Set<PackageElement> packagesIn(Set<? extends Element> elements) {
        return ElementFilter.setFilter(elements, PACKAGE_KIND, PackageElement.class);
    }

    public static List<ModuleElement> modulesIn(Iterable<? extends Element> elements) {
        return ElementFilter.listFilter(elements, MODULE_KIND, ModuleElement.class);
    }

    public static Set<ModuleElement> modulesIn(Set<? extends Element> elements) {
        return ElementFilter.setFilter(elements, MODULE_KIND, ModuleElement.class);
    }

    private static <E extends Element> List<E> listFilter(Iterable<? extends Element> elements, Set<ElementKind> targetKinds, Class<E> clazz) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Element element : elements) {
            if (!targetKinds.contains((Object)element.getKind())) continue;
            list.add((Element)clazz.cast(element));
        }
        return list;
    }

    private static <E extends Element> Set<E> setFilter(Set<? extends Element> elements, Set<ElementKind> targetKinds, Class<E> clazz) {
        LinkedHashSet<Element> set = new LinkedHashSet<Element>();
        for (Element element : elements) {
            if (!targetKinds.contains((Object)element.getKind())) continue;
            set.add((Element)clazz.cast(element));
        }
        return set;
    }

    public static List<ModuleElement.ExportsDirective> exportsIn(Iterable<? extends ModuleElement.Directive> directives) {
        return ElementFilter.listFilter(directives, ModuleElement.DirectiveKind.EXPORTS, ModuleElement.ExportsDirective.class);
    }

    public static List<ModuleElement.OpensDirective> opensIn(Iterable<? extends ModuleElement.Directive> directives) {
        return ElementFilter.listFilter(directives, ModuleElement.DirectiveKind.OPENS, ModuleElement.OpensDirective.class);
    }

    public static List<ModuleElement.ProvidesDirective> providesIn(Iterable<? extends ModuleElement.Directive> directives) {
        return ElementFilter.listFilter(directives, ModuleElement.DirectiveKind.PROVIDES, ModuleElement.ProvidesDirective.class);
    }

    public static List<ModuleElement.RequiresDirective> requiresIn(Iterable<? extends ModuleElement.Directive> directives) {
        return ElementFilter.listFilter(directives, ModuleElement.DirectiveKind.REQUIRES, ModuleElement.RequiresDirective.class);
    }

    public static List<ModuleElement.UsesDirective> usesIn(Iterable<? extends ModuleElement.Directive> directives) {
        return ElementFilter.listFilter(directives, ModuleElement.DirectiveKind.USES, ModuleElement.UsesDirective.class);
    }

    private static <D extends ModuleElement.Directive> List<D> listFilter(Iterable<? extends ModuleElement.Directive> directives, ModuleElement.DirectiveKind directiveKind, Class<D> clazz) {
        ArrayList<ModuleElement.Directive> list = new ArrayList<ModuleElement.Directive>();
        for (ModuleElement.Directive directive : directives) {
            if (directive.getKind() != directiveKind) continue;
            list.add((ModuleElement.Directive)clazz.cast(directive));
        }
        return list;
    }
}

